/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.report;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * Summary of each type of service charge or additional charge.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getStartTimestamp startTimestamp}</li>
 * <li>{@link #getType type}</li>
 * <li>{@link #getAmount amount}</li>
 * <li>{@link #getAmountCollected amountCollected}</li>
 * <li>{@link #getNumOrders numOrders}</li>
 * <li>{@link #getName name}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class ChargeSummary extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * Beginning of the time period for this summary.
   */
  public java.lang.Long getStartTimestamp() {
    return genClient.cacheGet(CacheKey.startTimestamp);
  }

  /**
   * The type of additional charge.
   */
  public java.lang.String getType() {
    return genClient.cacheGet(CacheKey.type);
  }

  /**
   * Amount of service charge owed and amount of additional charge paid minus the amount of all charges refunded, excluding any amount of service charge refunded that was later repaid.
   */
  public java.lang.Long getAmount() {
    return genClient.cacheGet(CacheKey.amount);
  }

  /**
   * Amount of all charges paid minus the amount of all charges refunded, excluding any amount of service charge refunded that was later repaid.
   */
  public java.lang.Long getAmountCollected() {
    return genClient.cacheGet(CacheKey.amountCollected);
  }

  /**
   * Number of orders that the charges apply to.
   */
  public java.lang.Integer getNumOrders() {
    return genClient.cacheGet(CacheKey.numOrders);
  }

  /**
   * Used for identifying the name of the order fee as set by the merchant.
   */
  public java.lang.String getName() {
    return genClient.cacheGet(CacheKey.name);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    startTimestamp
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    type
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    amount
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    amountCollected
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    numOrders
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Integer.class)),
    name
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<ChargeSummary> genClient;

  /**
   * Constructs a new empty instance.
   */
  public ChargeSummary() {
    genClient = new GenericClient<ChargeSummary>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected ChargeSummary(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public ChargeSummary(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public ChargeSummary(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public ChargeSummary(ChargeSummary src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
  }

  /** Checks whether the 'startTimestamp' field is set and is not null */
  public boolean isNotNullStartTimestamp() {
    return genClient.cacheValueIsNotNull(CacheKey.startTimestamp);
  }

  /** Checks whether the 'type' field is set and is not null */
  public boolean isNotNullType() {
    return genClient.cacheValueIsNotNull(CacheKey.type);
  }

  /** Checks whether the 'amount' field is set and is not null */
  public boolean isNotNullAmount() {
    return genClient.cacheValueIsNotNull(CacheKey.amount);
  }

  /** Checks whether the 'amountCollected' field is set and is not null */
  public boolean isNotNullAmountCollected() {
    return genClient.cacheValueIsNotNull(CacheKey.amountCollected);
  }

  /** Checks whether the 'numOrders' field is set and is not null */
  public boolean isNotNullNumOrders() {
    return genClient.cacheValueIsNotNull(CacheKey.numOrders);
  }

  /** Checks whether the 'name' field is set and is not null */
  public boolean isNotNullName() {
    return genClient.cacheValueIsNotNull(CacheKey.name);
  }



  /** Checks whether the 'startTimestamp' field has been set, however the value could be null */
  public boolean hasStartTimestamp() {
    return genClient.cacheHasKey(CacheKey.startTimestamp);
  }

  /** Checks whether the 'type' field has been set, however the value could be null */
  public boolean hasType() {
    return genClient.cacheHasKey(CacheKey.type);
  }

  /** Checks whether the 'amount' field has been set, however the value could be null */
  public boolean hasAmount() {
    return genClient.cacheHasKey(CacheKey.amount);
  }

  /** Checks whether the 'amountCollected' field has been set, however the value could be null */
  public boolean hasAmountCollected() {
    return genClient.cacheHasKey(CacheKey.amountCollected);
  }

  /** Checks whether the 'numOrders' field has been set, however the value could be null */
  public boolean hasNumOrders() {
    return genClient.cacheHasKey(CacheKey.numOrders);
  }

  /** Checks whether the 'name' field has been set, however the value could be null */
  public boolean hasName() {
    return genClient.cacheHasKey(CacheKey.name);
  }


  /**
   * Sets the field 'startTimestamp'.
   */
  public ChargeSummary setStartTimestamp(java.lang.Long startTimestamp) {
    return genClient.setOther(startTimestamp, CacheKey.startTimestamp);
  }

  /**
   * Sets the field 'type'.
   */
  public ChargeSummary setType(java.lang.String type) {
    return genClient.setOther(type, CacheKey.type);
  }

  /**
   * Sets the field 'amount'.
   */
  public ChargeSummary setAmount(java.lang.Long amount) {
    return genClient.setOther(amount, CacheKey.amount);
  }

  /**
   * Sets the field 'amountCollected'.
   */
  public ChargeSummary setAmountCollected(java.lang.Long amountCollected) {
    return genClient.setOther(amountCollected, CacheKey.amountCollected);
  }

  /**
   * Sets the field 'numOrders'.
   */
  public ChargeSummary setNumOrders(java.lang.Integer numOrders) {
    return genClient.setOther(numOrders, CacheKey.numOrders);
  }

  /**
   * Sets the field 'name'.
   */
  public ChargeSummary setName(java.lang.String name) {
    return genClient.setOther(name, CacheKey.name);
  }


  /** Clears the 'startTimestamp' field, the 'has' method for this field will now return false */
  public void clearStartTimestamp() {
    genClient.clear(CacheKey.startTimestamp);
  }
  /** Clears the 'type' field, the 'has' method for this field will now return false */
  public void clearType() {
    genClient.clear(CacheKey.type);
  }
  /** Clears the 'amount' field, the 'has' method for this field will now return false */
  public void clearAmount() {
    genClient.clear(CacheKey.amount);
  }
  /** Clears the 'amountCollected' field, the 'has' method for this field will now return false */
  public void clearAmountCollected() {
    genClient.clear(CacheKey.amountCollected);
  }
  /** Clears the 'numOrders' field, the 'has' method for this field will now return false */
  public void clearNumOrders() {
    genClient.clear(CacheKey.numOrders);
  }
  /** Clears the 'name' field, the 'has' method for this field will now return false */
  public void clearName() {
    genClient.clear(CacheKey.name);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public ChargeSummary copyChanges() {
    ChargeSummary copy = new ChargeSummary();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(ChargeSummary src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new ChargeSummary(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<ChargeSummary> CREATOR = new android.os.Parcelable.Creator<ChargeSummary>() {
    @Override
    public ChargeSummary createFromParcel(android.os.Parcel in) {
      ChargeSummary instance = new ChargeSummary(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public ChargeSummary[] newArray(int size) {
      return new ChargeSummary[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<ChargeSummary> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<ChargeSummary>() {
    public Class<ChargeSummary> getCreatedClass() {
      return ChargeSummary.class;
    }

    @Override
    public ChargeSummary create(org.json.JSONObject jsonObject) {
      return new ChargeSummary(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean STARTTIMESTAMP_IS_REQUIRED = false;
    public static final boolean TYPE_IS_REQUIRED = false;
    public static final boolean AMOUNT_IS_REQUIRED = false;
    public static final boolean AMOUNTCOLLECTED_IS_REQUIRED = false;
    public static final boolean NUMORDERS_IS_REQUIRED = false;
    public static final boolean NAME_IS_REQUIRED = false;
  }

}
