/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.report;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * Each instance of this represents a summary of cash sales, cash back tendered, cash removed and cash added to a device.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getDevice device}</li>
 * <li>{@link #getCashSalesAmount cashSalesAmount}</li>
 * <li>{@link #getCashPaymentAmount cashPaymentAmount}</li>
 * <li>{@link #getCashRefundedAmount cashRefundedAmount}</li>
 * <li>{@link #getCashBackAmount cashBackAmount}</li>
 * <li>{@link #getCashAddedAmount cashAddedAmount}</li>
 * <li>{@link #getCashRemovedAmount cashRemovedAmount}</li>
 * <li>{@link #getNet net}</li>
 * <li>{@link #getNetTips netTips}</li>
 * <li>{@link #getExpectedDeposit expectedDeposit}</li>
 * <li>{@link #getQuantity quantity}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class DeviceCashSummaryRow extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * The device that this summary is for. For the total row, this field will be null. A 128-bit UUID, not a normal base-13 Clover ID.
   */
  public com.clover.sdk.v3.device.Device getDevice() {
    return genClient.cacheGet(CacheKey.device);
  }

  /**
   * Cash payments minus cash refunded minus cash credited. A legacy field which does not represent Cash Sales in the Cash Deposit widget.
   */
  public java.lang.Long getCashSalesAmount() {
    return genClient.cacheGet(CacheKey.cashSalesAmount);
  }

  /**
   * The sum of all payment amounts paid with cash. Does not include tips. Does include tax and service charge. This gets mapped to Cash Sales in the Cash Deposit widget.
   */
  public java.lang.Long getCashPaymentAmount() {
    return genClient.cacheGet(CacheKey.cashPaymentAmount);
  }

  /**
   * The sum of all cash refunds and credits.
   */
  public java.lang.Long getCashRefundedAmount() {
    return genClient.cacheGet(CacheKey.cashRefundedAmount);
  }

  /**
   * The sum of all amounts transmitted as a cash back event. Should be the sum of all money given to customers as cash back on a debit card for merchants with Cash Log app.
   */
  public java.lang.Long getCashBackAmount() {
    return genClient.cacheGet(CacheKey.cashBackAmount);
  }

  /**
   * The sum of all amounts transmitted as a cash added event. Should be the sum of all money manually added to a cash drawer separate from a transaction by an employee for merchants with Cash Log app.
   */
  public java.lang.Long getCashAddedAmount() {
    return genClient.cacheGet(CacheKey.cashAddedAmount);
  }

  /**
   * The sum of all amounts transmitted as a cash removed event. Should be the sum of all money manually removed from a cash drawer separate from a transaction by an employee for merchants with Cash Log app.
   */
  public java.lang.Long getCashRemovedAmount() {
    return genClient.cacheGet(CacheKey.cashRemovedAmount);
  }

  /**
   * Cash sales plus cash added minus cash removed minus cash back. This is called Amount Collected in Cash Deposit Widget.
   */
  public java.lang.Long getNet() {
    return genClient.cacheGet(CacheKey.net);
  }

  /**
   * Net of tips for the reporting period as an estimate how much tips would have been paid in cash to the employees. Reported as a negative number.
   */
  public java.lang.Long getNetTips() {
    return genClient.cacheGet(CacheKey.netTips);
  }

  /**
   * Net minus tips.
   */
  public java.lang.Long getExpectedDeposit() {
    return genClient.cacheGet(CacheKey.expectedDeposit);
  }

  /**
   * Count of how many relevant cash activities appeared in the period.
   */
  public java.lang.Integer getQuantity() {
    return genClient.cacheGet(CacheKey.quantity);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    device
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.device.Device.JSON_CREATOR)),
    cashSalesAmount
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    cashPaymentAmount
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    cashRefundedAmount
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    cashBackAmount
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    cashAddedAmount
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    cashRemovedAmount
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    net
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    netTips
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    expectedDeposit
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    quantity
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Integer.class)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<DeviceCashSummaryRow> genClient;

  /**
   * Constructs a new empty instance.
   */
  public DeviceCashSummaryRow() {
    genClient = new GenericClient<DeviceCashSummaryRow>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected DeviceCashSummaryRow(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public DeviceCashSummaryRow(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public DeviceCashSummaryRow(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public DeviceCashSummaryRow(DeviceCashSummaryRow src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
  }

  /** Checks whether the 'device' field is set and is not null */
  public boolean isNotNullDevice() {
    return genClient.cacheValueIsNotNull(CacheKey.device);
  }

  /** Checks whether the 'cashSalesAmount' field is set and is not null */
  public boolean isNotNullCashSalesAmount() {
    return genClient.cacheValueIsNotNull(CacheKey.cashSalesAmount);
  }

  /** Checks whether the 'cashPaymentAmount' field is set and is not null */
  public boolean isNotNullCashPaymentAmount() {
    return genClient.cacheValueIsNotNull(CacheKey.cashPaymentAmount);
  }

  /** Checks whether the 'cashRefundedAmount' field is set and is not null */
  public boolean isNotNullCashRefundedAmount() {
    return genClient.cacheValueIsNotNull(CacheKey.cashRefundedAmount);
  }

  /** Checks whether the 'cashBackAmount' field is set and is not null */
  public boolean isNotNullCashBackAmount() {
    return genClient.cacheValueIsNotNull(CacheKey.cashBackAmount);
  }

  /** Checks whether the 'cashAddedAmount' field is set and is not null */
  public boolean isNotNullCashAddedAmount() {
    return genClient.cacheValueIsNotNull(CacheKey.cashAddedAmount);
  }

  /** Checks whether the 'cashRemovedAmount' field is set and is not null */
  public boolean isNotNullCashRemovedAmount() {
    return genClient.cacheValueIsNotNull(CacheKey.cashRemovedAmount);
  }

  /** Checks whether the 'net' field is set and is not null */
  public boolean isNotNullNet() {
    return genClient.cacheValueIsNotNull(CacheKey.net);
  }

  /** Checks whether the 'netTips' field is set and is not null */
  public boolean isNotNullNetTips() {
    return genClient.cacheValueIsNotNull(CacheKey.netTips);
  }

  /** Checks whether the 'expectedDeposit' field is set and is not null */
  public boolean isNotNullExpectedDeposit() {
    return genClient.cacheValueIsNotNull(CacheKey.expectedDeposit);
  }

  /** Checks whether the 'quantity' field is set and is not null */
  public boolean isNotNullQuantity() {
    return genClient.cacheValueIsNotNull(CacheKey.quantity);
  }



  /** Checks whether the 'device' field has been set, however the value could be null */
  public boolean hasDevice() {
    return genClient.cacheHasKey(CacheKey.device);
  }

  /** Checks whether the 'cashSalesAmount' field has been set, however the value could be null */
  public boolean hasCashSalesAmount() {
    return genClient.cacheHasKey(CacheKey.cashSalesAmount);
  }

  /** Checks whether the 'cashPaymentAmount' field has been set, however the value could be null */
  public boolean hasCashPaymentAmount() {
    return genClient.cacheHasKey(CacheKey.cashPaymentAmount);
  }

  /** Checks whether the 'cashRefundedAmount' field has been set, however the value could be null */
  public boolean hasCashRefundedAmount() {
    return genClient.cacheHasKey(CacheKey.cashRefundedAmount);
  }

  /** Checks whether the 'cashBackAmount' field has been set, however the value could be null */
  public boolean hasCashBackAmount() {
    return genClient.cacheHasKey(CacheKey.cashBackAmount);
  }

  /** Checks whether the 'cashAddedAmount' field has been set, however the value could be null */
  public boolean hasCashAddedAmount() {
    return genClient.cacheHasKey(CacheKey.cashAddedAmount);
  }

  /** Checks whether the 'cashRemovedAmount' field has been set, however the value could be null */
  public boolean hasCashRemovedAmount() {
    return genClient.cacheHasKey(CacheKey.cashRemovedAmount);
  }

  /** Checks whether the 'net' field has been set, however the value could be null */
  public boolean hasNet() {
    return genClient.cacheHasKey(CacheKey.net);
  }

  /** Checks whether the 'netTips' field has been set, however the value could be null */
  public boolean hasNetTips() {
    return genClient.cacheHasKey(CacheKey.netTips);
  }

  /** Checks whether the 'expectedDeposit' field has been set, however the value could be null */
  public boolean hasExpectedDeposit() {
    return genClient.cacheHasKey(CacheKey.expectedDeposit);
  }

  /** Checks whether the 'quantity' field has been set, however the value could be null */
  public boolean hasQuantity() {
    return genClient.cacheHasKey(CacheKey.quantity);
  }


  /**
   * Sets the field 'device'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public DeviceCashSummaryRow setDevice(com.clover.sdk.v3.device.Device device) {
    return genClient.setRecord(device, CacheKey.device);
  }

  /**
   * Sets the field 'cashSalesAmount'.
   */
  public DeviceCashSummaryRow setCashSalesAmount(java.lang.Long cashSalesAmount) {
    return genClient.setOther(cashSalesAmount, CacheKey.cashSalesAmount);
  }

  /**
   * Sets the field 'cashPaymentAmount'.
   */
  public DeviceCashSummaryRow setCashPaymentAmount(java.lang.Long cashPaymentAmount) {
    return genClient.setOther(cashPaymentAmount, CacheKey.cashPaymentAmount);
  }

  /**
   * Sets the field 'cashRefundedAmount'.
   */
  public DeviceCashSummaryRow setCashRefundedAmount(java.lang.Long cashRefundedAmount) {
    return genClient.setOther(cashRefundedAmount, CacheKey.cashRefundedAmount);
  }

  /**
   * Sets the field 'cashBackAmount'.
   */
  public DeviceCashSummaryRow setCashBackAmount(java.lang.Long cashBackAmount) {
    return genClient.setOther(cashBackAmount, CacheKey.cashBackAmount);
  }

  /**
   * Sets the field 'cashAddedAmount'.
   */
  public DeviceCashSummaryRow setCashAddedAmount(java.lang.Long cashAddedAmount) {
    return genClient.setOther(cashAddedAmount, CacheKey.cashAddedAmount);
  }

  /**
   * Sets the field 'cashRemovedAmount'.
   */
  public DeviceCashSummaryRow setCashRemovedAmount(java.lang.Long cashRemovedAmount) {
    return genClient.setOther(cashRemovedAmount, CacheKey.cashRemovedAmount);
  }

  /**
   * Sets the field 'net'.
   */
  public DeviceCashSummaryRow setNet(java.lang.Long net) {
    return genClient.setOther(net, CacheKey.net);
  }

  /**
   * Sets the field 'netTips'.
   */
  public DeviceCashSummaryRow setNetTips(java.lang.Long netTips) {
    return genClient.setOther(netTips, CacheKey.netTips);
  }

  /**
   * Sets the field 'expectedDeposit'.
   */
  public DeviceCashSummaryRow setExpectedDeposit(java.lang.Long expectedDeposit) {
    return genClient.setOther(expectedDeposit, CacheKey.expectedDeposit);
  }

  /**
   * Sets the field 'quantity'.
   */
  public DeviceCashSummaryRow setQuantity(java.lang.Integer quantity) {
    return genClient.setOther(quantity, CacheKey.quantity);
  }


  /** Clears the 'device' field, the 'has' method for this field will now return false */
  public void clearDevice() {
    genClient.clear(CacheKey.device);
  }
  /** Clears the 'cashSalesAmount' field, the 'has' method for this field will now return false */
  public void clearCashSalesAmount() {
    genClient.clear(CacheKey.cashSalesAmount);
  }
  /** Clears the 'cashPaymentAmount' field, the 'has' method for this field will now return false */
  public void clearCashPaymentAmount() {
    genClient.clear(CacheKey.cashPaymentAmount);
  }
  /** Clears the 'cashRefundedAmount' field, the 'has' method for this field will now return false */
  public void clearCashRefundedAmount() {
    genClient.clear(CacheKey.cashRefundedAmount);
  }
  /** Clears the 'cashBackAmount' field, the 'has' method for this field will now return false */
  public void clearCashBackAmount() {
    genClient.clear(CacheKey.cashBackAmount);
  }
  /** Clears the 'cashAddedAmount' field, the 'has' method for this field will now return false */
  public void clearCashAddedAmount() {
    genClient.clear(CacheKey.cashAddedAmount);
  }
  /** Clears the 'cashRemovedAmount' field, the 'has' method for this field will now return false */
  public void clearCashRemovedAmount() {
    genClient.clear(CacheKey.cashRemovedAmount);
  }
  /** Clears the 'net' field, the 'has' method for this field will now return false */
  public void clearNet() {
    genClient.clear(CacheKey.net);
  }
  /** Clears the 'netTips' field, the 'has' method for this field will now return false */
  public void clearNetTips() {
    genClient.clear(CacheKey.netTips);
  }
  /** Clears the 'expectedDeposit' field, the 'has' method for this field will now return false */
  public void clearExpectedDeposit() {
    genClient.clear(CacheKey.expectedDeposit);
  }
  /** Clears the 'quantity' field, the 'has' method for this field will now return false */
  public void clearQuantity() {
    genClient.clear(CacheKey.quantity);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public DeviceCashSummaryRow copyChanges() {
    DeviceCashSummaryRow copy = new DeviceCashSummaryRow();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(DeviceCashSummaryRow src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new DeviceCashSummaryRow(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<DeviceCashSummaryRow> CREATOR = new android.os.Parcelable.Creator<DeviceCashSummaryRow>() {
    @Override
    public DeviceCashSummaryRow createFromParcel(android.os.Parcel in) {
      DeviceCashSummaryRow instance = new DeviceCashSummaryRow(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public DeviceCashSummaryRow[] newArray(int size) {
      return new DeviceCashSummaryRow[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<DeviceCashSummaryRow> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<DeviceCashSummaryRow>() {
    public Class<DeviceCashSummaryRow> getCreatedClass() {
      return DeviceCashSummaryRow.class;
    }

    @Override
    public DeviceCashSummaryRow create(org.json.JSONObject jsonObject) {
      return new DeviceCashSummaryRow(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean DEVICE_IS_REQUIRED = false;
    public static final boolean CASHSALESAMOUNT_IS_REQUIRED = false;
    public static final boolean CASHPAYMENTAMOUNT_IS_REQUIRED = false;
    public static final boolean CASHREFUNDEDAMOUNT_IS_REQUIRED = false;
    public static final boolean CASHBACKAMOUNT_IS_REQUIRED = false;
    public static final boolean CASHADDEDAMOUNT_IS_REQUIRED = false;
    public static final boolean CASHREMOVEDAMOUNT_IS_REQUIRED = false;
    public static final boolean NET_IS_REQUIRED = false;
    public static final boolean NETTIPS_IS_REQUIRED = false;
    public static final boolean EXPECTEDDEPOSIT_IS_REQUIRED = false;
    public static final boolean QUANTITY_IS_REQUIRED = false;
  }

}
