/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.report;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * For showing summary of Dynamic Currency Conversion (DCC)
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getLocalTotal localTotal}</li>
 * <li>{@link #getForeignTotal foreignTotal}</li>
 * <li>{@link #getForeignCurrencyCode foreignCurrencyCode}</li>
 * <li>{@link #getForeignCurrencyDisplayName foreignCurrencyDisplayName}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class DynamicCurrencyConversionSummaryRow extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  public com.clover.sdk.v3.report.ReportPaymentsV2Row getLocalTotal() {
    return genClient.cacheGet(CacheKey.localTotal);
  }

  public com.clover.sdk.v3.report.ReportPaymentsV2Row getForeignTotal() {
    return genClient.cacheGet(CacheKey.foreignTotal);
  }

  /**
   * Foreign currency code, like GBP or USD
   */
  public java.lang.String getForeignCurrencyCode() {
    return genClient.cacheGet(CacheKey.foreignCurrencyCode);
  }

  /**
   * Foreign currency full name, like British Pound Sterling
   */
  public java.lang.String getForeignCurrencyDisplayName() {
    return genClient.cacheGet(CacheKey.foreignCurrencyDisplayName);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    localTotal
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.report.ReportPaymentsV2Row.JSON_CREATOR)),
    foreignTotal
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.report.ReportPaymentsV2Row.JSON_CREATOR)),
    foreignCurrencyCode
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    foreignCurrencyDisplayName
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<DynamicCurrencyConversionSummaryRow> genClient;

  /**
   * Constructs a new empty instance.
   */
  public DynamicCurrencyConversionSummaryRow() {
    genClient = new GenericClient<DynamicCurrencyConversionSummaryRow>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected DynamicCurrencyConversionSummaryRow(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public DynamicCurrencyConversionSummaryRow(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public DynamicCurrencyConversionSummaryRow(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public DynamicCurrencyConversionSummaryRow(DynamicCurrencyConversionSummaryRow src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {

    genClient.validateLength(CacheKey.foreignCurrencyCode, getForeignCurrencyCode(), 3);
  }

  /** Checks whether the 'localTotal' field is set and is not null */
  public boolean isNotNullLocalTotal() {
    return genClient.cacheValueIsNotNull(CacheKey.localTotal);
  }

  /** Checks whether the 'foreignTotal' field is set and is not null */
  public boolean isNotNullForeignTotal() {
    return genClient.cacheValueIsNotNull(CacheKey.foreignTotal);
  }

  /** Checks whether the 'foreignCurrencyCode' field is set and is not null */
  public boolean isNotNullForeignCurrencyCode() {
    return genClient.cacheValueIsNotNull(CacheKey.foreignCurrencyCode);
  }

  /** Checks whether the 'foreignCurrencyDisplayName' field is set and is not null */
  public boolean isNotNullForeignCurrencyDisplayName() {
    return genClient.cacheValueIsNotNull(CacheKey.foreignCurrencyDisplayName);
  }



  /** Checks whether the 'localTotal' field has been set, however the value could be null */
  public boolean hasLocalTotal() {
    return genClient.cacheHasKey(CacheKey.localTotal);
  }

  /** Checks whether the 'foreignTotal' field has been set, however the value could be null */
  public boolean hasForeignTotal() {
    return genClient.cacheHasKey(CacheKey.foreignTotal);
  }

  /** Checks whether the 'foreignCurrencyCode' field has been set, however the value could be null */
  public boolean hasForeignCurrencyCode() {
    return genClient.cacheHasKey(CacheKey.foreignCurrencyCode);
  }

  /** Checks whether the 'foreignCurrencyDisplayName' field has been set, however the value could be null */
  public boolean hasForeignCurrencyDisplayName() {
    return genClient.cacheHasKey(CacheKey.foreignCurrencyDisplayName);
  }


  /**
   * Sets the field 'localTotal'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public DynamicCurrencyConversionSummaryRow setLocalTotal(com.clover.sdk.v3.report.ReportPaymentsV2Row localTotal) {
    return genClient.setRecord(localTotal, CacheKey.localTotal);
  }

  /**
   * Sets the field 'foreignTotal'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public DynamicCurrencyConversionSummaryRow setForeignTotal(com.clover.sdk.v3.report.ReportPaymentsV2Row foreignTotal) {
    return genClient.setRecord(foreignTotal, CacheKey.foreignTotal);
  }

  /**
   * Sets the field 'foreignCurrencyCode'.
   */
  public DynamicCurrencyConversionSummaryRow setForeignCurrencyCode(java.lang.String foreignCurrencyCode) {
    return genClient.setOther(foreignCurrencyCode, CacheKey.foreignCurrencyCode);
  }

  /**
   * Sets the field 'foreignCurrencyDisplayName'.
   */
  public DynamicCurrencyConversionSummaryRow setForeignCurrencyDisplayName(java.lang.String foreignCurrencyDisplayName) {
    return genClient.setOther(foreignCurrencyDisplayName, CacheKey.foreignCurrencyDisplayName);
  }


  /** Clears the 'localTotal' field, the 'has' method for this field will now return false */
  public void clearLocalTotal() {
    genClient.clear(CacheKey.localTotal);
  }
  /** Clears the 'foreignTotal' field, the 'has' method for this field will now return false */
  public void clearForeignTotal() {
    genClient.clear(CacheKey.foreignTotal);
  }
  /** Clears the 'foreignCurrencyCode' field, the 'has' method for this field will now return false */
  public void clearForeignCurrencyCode() {
    genClient.clear(CacheKey.foreignCurrencyCode);
  }
  /** Clears the 'foreignCurrencyDisplayName' field, the 'has' method for this field will now return false */
  public void clearForeignCurrencyDisplayName() {
    genClient.clear(CacheKey.foreignCurrencyDisplayName);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public DynamicCurrencyConversionSummaryRow copyChanges() {
    DynamicCurrencyConversionSummaryRow copy = new DynamicCurrencyConversionSummaryRow();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(DynamicCurrencyConversionSummaryRow src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new DynamicCurrencyConversionSummaryRow(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<DynamicCurrencyConversionSummaryRow> CREATOR = new android.os.Parcelable.Creator<DynamicCurrencyConversionSummaryRow>() {
    @Override
    public DynamicCurrencyConversionSummaryRow createFromParcel(android.os.Parcel in) {
      DynamicCurrencyConversionSummaryRow instance = new DynamicCurrencyConversionSummaryRow(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public DynamicCurrencyConversionSummaryRow[] newArray(int size) {
      return new DynamicCurrencyConversionSummaryRow[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<DynamicCurrencyConversionSummaryRow> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<DynamicCurrencyConversionSummaryRow>() {
    public Class<DynamicCurrencyConversionSummaryRow> getCreatedClass() {
      return DynamicCurrencyConversionSummaryRow.class;
    }

    @Override
    public DynamicCurrencyConversionSummaryRow create(org.json.JSONObject jsonObject) {
      return new DynamicCurrencyConversionSummaryRow(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean LOCALTOTAL_IS_REQUIRED = false;
    public static final boolean FOREIGNTOTAL_IS_REQUIRED = false;
    public static final boolean FOREIGNCURRENCYCODE_IS_REQUIRED = false;
    public static final long FOREIGNCURRENCYCODE_MAX_LEN = 3;
    public static final boolean FOREIGNCURRENCYDISPLAYNAME_IS_REQUIRED = false;
  }

}
