/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.report;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getTotal total}</li>
 * <li>{@link #getEmployeeSummaries employeeSummaries}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class EmployeeSalesSummariesTotal extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * The summary of all the employee sales
   */
  public com.clover.sdk.v3.report.SalesSummary getTotal() {
    return genClient.cacheGet(CacheKey.total);
  }

  /**
   * Summary of sales of each employee
   */
  public java.util.List<com.clover.sdk.v3.report.EmployeeSummaries> getEmployeeSummaries() {
    return genClient.cacheGet(CacheKey.employeeSummaries);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    total
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.report.SalesSummary.JSON_CREATOR)),
    employeeSummaries
        (com.clover.sdk.extractors.RecordListExtractionStrategy.instance(com.clover.sdk.v3.report.EmployeeSummaries.JSON_CREATOR)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<EmployeeSalesSummariesTotal> genClient;

  /**
   * Constructs a new empty instance.
   */
  public EmployeeSalesSummariesTotal() {
    genClient = new GenericClient<EmployeeSalesSummariesTotal>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected EmployeeSalesSummariesTotal(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public EmployeeSalesSummariesTotal(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public EmployeeSalesSummariesTotal(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public EmployeeSalesSummariesTotal(EmployeeSalesSummariesTotal src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
  }

  /** Checks whether the 'total' field is set and is not null */
  public boolean isNotNullTotal() {
    return genClient.cacheValueIsNotNull(CacheKey.total);
  }

  /** Checks whether the 'employeeSummaries' field is set and is not null */
  public boolean isNotNullEmployeeSummaries() {
    return genClient.cacheValueIsNotNull(CacheKey.employeeSummaries);
  }

  /** Checks whether the 'employeeSummaries' field is set and is not null and is not empty */
  public boolean isNotEmptyEmployeeSummaries() { return isNotNullEmployeeSummaries() && !getEmployeeSummaries().isEmpty(); }



  /** Checks whether the 'total' field has been set, however the value could be null */
  public boolean hasTotal() {
    return genClient.cacheHasKey(CacheKey.total);
  }

  /** Checks whether the 'employeeSummaries' field has been set, however the value could be null */
  public boolean hasEmployeeSummaries() {
    return genClient.cacheHasKey(CacheKey.employeeSummaries);
  }


  /**
   * Sets the field 'total'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public EmployeeSalesSummariesTotal setTotal(com.clover.sdk.v3.report.SalesSummary total) {
    return genClient.setRecord(total, CacheKey.total);
  }

  /**
   * Sets the field 'employeeSummaries'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public EmployeeSalesSummariesTotal setEmployeeSummaries(java.util.List<com.clover.sdk.v3.report.EmployeeSummaries> employeeSummaries) {
    return genClient.setArrayRecord(employeeSummaries, CacheKey.employeeSummaries);
  }


  /** Clears the 'total' field, the 'has' method for this field will now return false */
  public void clearTotal() {
    genClient.clear(CacheKey.total);
  }
  /** Clears the 'employeeSummaries' field, the 'has' method for this field will now return false */
  public void clearEmployeeSummaries() {
    genClient.clear(CacheKey.employeeSummaries);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public EmployeeSalesSummariesTotal copyChanges() {
    EmployeeSalesSummariesTotal copy = new EmployeeSalesSummariesTotal();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(EmployeeSalesSummariesTotal src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new EmployeeSalesSummariesTotal(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<EmployeeSalesSummariesTotal> CREATOR = new android.os.Parcelable.Creator<EmployeeSalesSummariesTotal>() {
    @Override
    public EmployeeSalesSummariesTotal createFromParcel(android.os.Parcel in) {
      EmployeeSalesSummariesTotal instance = new EmployeeSalesSummariesTotal(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public EmployeeSalesSummariesTotal[] newArray(int size) {
      return new EmployeeSalesSummariesTotal[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<EmployeeSalesSummariesTotal> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<EmployeeSalesSummariesTotal>() {
    public Class<EmployeeSalesSummariesTotal> getCreatedClass() {
      return EmployeeSalesSummariesTotal.class;
    }

    @Override
    public EmployeeSalesSummariesTotal create(org.json.JSONObject jsonObject) {
      return new EmployeeSalesSummariesTotal(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean TOTAL_IS_REQUIRED = false;
    public static final boolean EMPLOYEESUMMARIES_IS_REQUIRED = false;
  }

}
