/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.report;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getId id}</li>
 * <li>{@link #getEmployee employee}</li>
 * <li>{@link #getLocationDetails locationDetails}</li>
 * <li>{@link #getSummary summary}</li>
 * <li>{@link #getEmployeeLabelSummaries employeeLabelSummaries}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class EmployeeSummaries extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  public java.lang.String getId() {
    return genClient.cacheGet(CacheKey.id);
  }

  /**
   * Contains information about the employee other than number of transactions and total amount collected such as name and uuid
   */
  public com.clover.sdk.v3.employees.Employee getEmployee() {
    return genClient.cacheGet(CacheKey.employee);
  }

  /**
   * Number of locations where the employee is at across open, closed, and total locations (ML purposes only)
   */
  public com.clover.sdk.v3.report.LocationBreakdown getLocationDetails() {
    return genClient.cacheGet(CacheKey.locationDetails);
  }

  /**
   * Contains all the summaries for this employee
   */
  public com.clover.sdk.v3.report.EachEmployeeSummary getSummary() {
    return genClient.cacheGet(CacheKey.summary);
  }

  /**
   * Summary of sales of items with 'Show in Reporting?' flag set for the label.
   */
  public java.util.List<com.clover.sdk.v3.report.LabelSummaryRow> getEmployeeLabelSummaries() {
    return genClient.cacheGet(CacheKey.employeeLabelSummaries);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    id
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    employee
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.employees.Employee.JSON_CREATOR)),
    locationDetails
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.report.LocationBreakdown.JSON_CREATOR)),
    summary
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.report.EachEmployeeSummary.JSON_CREATOR)),
    employeeLabelSummaries
        (com.clover.sdk.extractors.RecordListExtractionStrategy.instance(com.clover.sdk.v3.report.LabelSummaryRow.JSON_CREATOR)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<EmployeeSummaries> genClient;

  /**
   * Constructs a new empty instance.
   */
  public EmployeeSummaries() {
    genClient = new GenericClient<EmployeeSummaries>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected EmployeeSummaries(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public EmployeeSummaries(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public EmployeeSummaries(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public EmployeeSummaries(EmployeeSummaries src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
  }

  /** Checks whether the 'id' field is set and is not null */
  public boolean isNotNullId() {
    return genClient.cacheValueIsNotNull(CacheKey.id);
  }

  /** Checks whether the 'employee' field is set and is not null */
  public boolean isNotNullEmployee() {
    return genClient.cacheValueIsNotNull(CacheKey.employee);
  }

  /** Checks whether the 'locationDetails' field is set and is not null */
  public boolean isNotNullLocationDetails() {
    return genClient.cacheValueIsNotNull(CacheKey.locationDetails);
  }

  /** Checks whether the 'summary' field is set and is not null */
  public boolean isNotNullSummary() {
    return genClient.cacheValueIsNotNull(CacheKey.summary);
  }

  /** Checks whether the 'employeeLabelSummaries' field is set and is not null */
  public boolean isNotNullEmployeeLabelSummaries() {
    return genClient.cacheValueIsNotNull(CacheKey.employeeLabelSummaries);
  }

  /** Checks whether the 'employeeLabelSummaries' field is set and is not null and is not empty */
  public boolean isNotEmptyEmployeeLabelSummaries() { return isNotNullEmployeeLabelSummaries() && !getEmployeeLabelSummaries().isEmpty(); }



  /** Checks whether the 'id' field has been set, however the value could be null */
  public boolean hasId() {
    return genClient.cacheHasKey(CacheKey.id);
  }

  /** Checks whether the 'employee' field has been set, however the value could be null */
  public boolean hasEmployee() {
    return genClient.cacheHasKey(CacheKey.employee);
  }

  /** Checks whether the 'locationDetails' field has been set, however the value could be null */
  public boolean hasLocationDetails() {
    return genClient.cacheHasKey(CacheKey.locationDetails);
  }

  /** Checks whether the 'summary' field has been set, however the value could be null */
  public boolean hasSummary() {
    return genClient.cacheHasKey(CacheKey.summary);
  }

  /** Checks whether the 'employeeLabelSummaries' field has been set, however the value could be null */
  public boolean hasEmployeeLabelSummaries() {
    return genClient.cacheHasKey(CacheKey.employeeLabelSummaries);
  }


  /**
   * Sets the field 'id'.
   */
  public EmployeeSummaries setId(java.lang.String id) {
    return genClient.setOther(id, CacheKey.id);
  }

  /**
   * Sets the field 'employee'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public EmployeeSummaries setEmployee(com.clover.sdk.v3.employees.Employee employee) {
    return genClient.setRecord(employee, CacheKey.employee);
  }

  /**
   * Sets the field 'locationDetails'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public EmployeeSummaries setLocationDetails(com.clover.sdk.v3.report.LocationBreakdown locationDetails) {
    return genClient.setRecord(locationDetails, CacheKey.locationDetails);
  }

  /**
   * Sets the field 'summary'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public EmployeeSummaries setSummary(com.clover.sdk.v3.report.EachEmployeeSummary summary) {
    return genClient.setRecord(summary, CacheKey.summary);
  }

  /**
   * Sets the field 'employeeLabelSummaries'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public EmployeeSummaries setEmployeeLabelSummaries(java.util.List<com.clover.sdk.v3.report.LabelSummaryRow> employeeLabelSummaries) {
    return genClient.setArrayRecord(employeeLabelSummaries, CacheKey.employeeLabelSummaries);
  }


  /** Clears the 'id' field, the 'has' method for this field will now return false */
  public void clearId() {
    genClient.clear(CacheKey.id);
  }
  /** Clears the 'employee' field, the 'has' method for this field will now return false */
  public void clearEmployee() {
    genClient.clear(CacheKey.employee);
  }
  /** Clears the 'locationDetails' field, the 'has' method for this field will now return false */
  public void clearLocationDetails() {
    genClient.clear(CacheKey.locationDetails);
  }
  /** Clears the 'summary' field, the 'has' method for this field will now return false */
  public void clearSummary() {
    genClient.clear(CacheKey.summary);
  }
  /** Clears the 'employeeLabelSummaries' field, the 'has' method for this field will now return false */
  public void clearEmployeeLabelSummaries() {
    genClient.clear(CacheKey.employeeLabelSummaries);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public EmployeeSummaries copyChanges() {
    EmployeeSummaries copy = new EmployeeSummaries();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(EmployeeSummaries src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new EmployeeSummaries(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<EmployeeSummaries> CREATOR = new android.os.Parcelable.Creator<EmployeeSummaries>() {
    @Override
    public EmployeeSummaries createFromParcel(android.os.Parcel in) {
      EmployeeSummaries instance = new EmployeeSummaries(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public EmployeeSummaries[] newArray(int size) {
      return new EmployeeSummaries[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<EmployeeSummaries> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<EmployeeSummaries>() {
    public Class<EmployeeSummaries> getCreatedClass() {
      return EmployeeSummaries.class;
    }

    @Override
    public EmployeeSummaries create(org.json.JSONObject jsonObject) {
      return new EmployeeSummaries(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean ID_IS_REQUIRED = false;
    public static final boolean EMPLOYEE_IS_REQUIRED = false;
    public static final boolean LOCATIONDETAILS_IS_REQUIRED = false;
    public static final boolean SUMMARY_IS_REQUIRED = false;
    public static final boolean EMPLOYEELABELSUMMARIES_IS_REQUIRED = false;
  }

}
