/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.report;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getSummaryObject summaryObject}</li>
 * <li>{@link #getTotals totals}</li>
 * <li>{@link #getSummaryGroup summaryGroup}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class EmployeeSummaryLite extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * Contains information about the employee other than number of transactions and total amount collected such as name and uuid
   */
  public com.clover.sdk.v3.employees.Employee getSummaryObject() {
    return genClient.cacheGet(CacheKey.summaryObject);
  }

  /**
   * Contains total number of transactions and total amount collected for this employee
   */
  public com.clover.sdk.v3.report.SalesSummaryLite getTotals() {
    return genClient.cacheGet(CacheKey.totals);
  }

  /**
   * Contains Summary objects for payments, refunds, credits
   */
  public com.clover.sdk.v3.report.SummaryGroup getSummaryGroup() {
    return genClient.cacheGet(CacheKey.summaryGroup);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    summaryObject
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.employees.Employee.JSON_CREATOR)),
    totals
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.report.SalesSummaryLite.JSON_CREATOR)),
    summaryGroup
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.report.SummaryGroup.JSON_CREATOR)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<EmployeeSummaryLite> genClient;

  /**
   * Constructs a new empty instance.
   */
  public EmployeeSummaryLite() {
    genClient = new GenericClient<EmployeeSummaryLite>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected EmployeeSummaryLite(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public EmployeeSummaryLite(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public EmployeeSummaryLite(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public EmployeeSummaryLite(EmployeeSummaryLite src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
  }

  /** Checks whether the 'summaryObject' field is set and is not null */
  public boolean isNotNullSummaryObject() {
    return genClient.cacheValueIsNotNull(CacheKey.summaryObject);
  }

  /** Checks whether the 'totals' field is set and is not null */
  public boolean isNotNullTotals() {
    return genClient.cacheValueIsNotNull(CacheKey.totals);
  }

  /** Checks whether the 'summaryGroup' field is set and is not null */
  public boolean isNotNullSummaryGroup() {
    return genClient.cacheValueIsNotNull(CacheKey.summaryGroup);
  }



  /** Checks whether the 'summaryObject' field has been set, however the value could be null */
  public boolean hasSummaryObject() {
    return genClient.cacheHasKey(CacheKey.summaryObject);
  }

  /** Checks whether the 'totals' field has been set, however the value could be null */
  public boolean hasTotals() {
    return genClient.cacheHasKey(CacheKey.totals);
  }

  /** Checks whether the 'summaryGroup' field has been set, however the value could be null */
  public boolean hasSummaryGroup() {
    return genClient.cacheHasKey(CacheKey.summaryGroup);
  }


  /**
   * Sets the field 'summaryObject'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public EmployeeSummaryLite setSummaryObject(com.clover.sdk.v3.employees.Employee summaryObject) {
    return genClient.setRecord(summaryObject, CacheKey.summaryObject);
  }

  /**
   * Sets the field 'totals'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public EmployeeSummaryLite setTotals(com.clover.sdk.v3.report.SalesSummaryLite totals) {
    return genClient.setRecord(totals, CacheKey.totals);
  }

  /**
   * Sets the field 'summaryGroup'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public EmployeeSummaryLite setSummaryGroup(com.clover.sdk.v3.report.SummaryGroup summaryGroup) {
    return genClient.setRecord(summaryGroup, CacheKey.summaryGroup);
  }


  /** Clears the 'summaryObject' field, the 'has' method for this field will now return false */
  public void clearSummaryObject() {
    genClient.clear(CacheKey.summaryObject);
  }
  /** Clears the 'totals' field, the 'has' method for this field will now return false */
  public void clearTotals() {
    genClient.clear(CacheKey.totals);
  }
  /** Clears the 'summaryGroup' field, the 'has' method for this field will now return false */
  public void clearSummaryGroup() {
    genClient.clear(CacheKey.summaryGroup);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public EmployeeSummaryLite copyChanges() {
    EmployeeSummaryLite copy = new EmployeeSummaryLite();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(EmployeeSummaryLite src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new EmployeeSummaryLite(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<EmployeeSummaryLite> CREATOR = new android.os.Parcelable.Creator<EmployeeSummaryLite>() {
    @Override
    public EmployeeSummaryLite createFromParcel(android.os.Parcel in) {
      EmployeeSummaryLite instance = new EmployeeSummaryLite(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public EmployeeSummaryLite[] newArray(int size) {
      return new EmployeeSummaryLite[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<EmployeeSummaryLite> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<EmployeeSummaryLite>() {
    public Class<EmployeeSummaryLite> getCreatedClass() {
      return EmployeeSummaryLite.class;
    }

    @Override
    public EmployeeSummaryLite create(org.json.JSONObject jsonObject) {
      return new EmployeeSummaryLite(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean SUMMARYOBJECT_IS_REQUIRED = false;
    public static final boolean TOTALS_IS_REQUIRED = false;
    public static final boolean SUMMARYGROUP_IS_REQUIRED = false;
  }

}
