/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.report;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * Summary of sales of items that have a label which has the 'Show in Reporting?' flag set
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getRows rows}</li>
 * <li>{@link #getWarnings warnings}</li>
 * <li>{@link #getTotal total}</li>
 * <li>{@link #getMajorLabelsExist majorLabelsExist}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class LabelSummarySection extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * Summary of sales of items that have a label which has the 'Show in Reporting?' flag set
   */
  public java.util.List<com.clover.sdk.v3.report.LabelSummaryRow> getRows() {
    return genClient.cacheGet(CacheKey.rows);
  }

  /**
   * List of warnings related to the items in this section, like perhaps an item appears under more than one label.
   */
  public java.util.List<java.lang.String> getWarnings() {
    return genClient.cacheGet(CacheKey.warnings);
  }

  /**
   * The sum of the above rows
   */
  public com.clover.sdk.v3.report.LabelSummaryRow getTotal() {
    return genClient.cacheGet(CacheKey.total);
  }

  /**
   * Whether the merchant has any labels marked 'Show in Reporting?'
   */
  public java.lang.Boolean getMajorLabelsExist() {
    return genClient.cacheGet(CacheKey.majorLabelsExist);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    rows
        (com.clover.sdk.extractors.RecordListExtractionStrategy.instance(com.clover.sdk.v3.report.LabelSummaryRow.JSON_CREATOR)),
    warnings
        (com.clover.sdk.extractors.BasicListExtractionStrategy.instance(java.lang.String.class)),
    total
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.report.LabelSummaryRow.JSON_CREATOR)),
    majorLabelsExist
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<LabelSummarySection> genClient;

  /**
   * Constructs a new empty instance.
   */
  public LabelSummarySection() {
    genClient = new GenericClient<LabelSummarySection>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected LabelSummarySection(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public LabelSummarySection(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public LabelSummarySection(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public LabelSummarySection(LabelSummarySection src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
  }

  /** Checks whether the 'rows' field is set and is not null */
  public boolean isNotNullRows() {
    return genClient.cacheValueIsNotNull(CacheKey.rows);
  }

  /** Checks whether the 'rows' field is set and is not null and is not empty */
  public boolean isNotEmptyRows() { return isNotNullRows() && !getRows().isEmpty(); }

  /** Checks whether the 'warnings' field is set and is not null */
  public boolean isNotNullWarnings() {
    return genClient.cacheValueIsNotNull(CacheKey.warnings);
  }

  /** Checks whether the 'warnings' field is set and is not null and is not empty */
  public boolean isNotEmptyWarnings() { return isNotNullWarnings() && !getWarnings().isEmpty(); }

  /** Checks whether the 'total' field is set and is not null */
  public boolean isNotNullTotal() {
    return genClient.cacheValueIsNotNull(CacheKey.total);
  }

  /** Checks whether the 'majorLabelsExist' field is set and is not null */
  public boolean isNotNullMajorLabelsExist() {
    return genClient.cacheValueIsNotNull(CacheKey.majorLabelsExist);
  }



  /** Checks whether the 'rows' field has been set, however the value could be null */
  public boolean hasRows() {
    return genClient.cacheHasKey(CacheKey.rows);
  }

  /** Checks whether the 'warnings' field has been set, however the value could be null */
  public boolean hasWarnings() {
    return genClient.cacheHasKey(CacheKey.warnings);
  }

  /** Checks whether the 'total' field has been set, however the value could be null */
  public boolean hasTotal() {
    return genClient.cacheHasKey(CacheKey.total);
  }

  /** Checks whether the 'majorLabelsExist' field has been set, however the value could be null */
  public boolean hasMajorLabelsExist() {
    return genClient.cacheHasKey(CacheKey.majorLabelsExist);
  }


  /**
   * Sets the field 'rows'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public LabelSummarySection setRows(java.util.List<com.clover.sdk.v3.report.LabelSummaryRow> rows) {
    return genClient.setArrayRecord(rows, CacheKey.rows);
  }

  /**
   * Sets the field 'warnings'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public LabelSummarySection setWarnings(java.util.List<java.lang.String> warnings) {
    return genClient.setArrayOther(warnings, CacheKey.warnings);
  }

  /**
   * Sets the field 'total'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public LabelSummarySection setTotal(com.clover.sdk.v3.report.LabelSummaryRow total) {
    return genClient.setRecord(total, CacheKey.total);
  }

  /**
   * Sets the field 'majorLabelsExist'.
   */
  public LabelSummarySection setMajorLabelsExist(java.lang.Boolean majorLabelsExist) {
    return genClient.setOther(majorLabelsExist, CacheKey.majorLabelsExist);
  }


  /** Clears the 'rows' field, the 'has' method for this field will now return false */
  public void clearRows() {
    genClient.clear(CacheKey.rows);
  }
  /** Clears the 'warnings' field, the 'has' method for this field will now return false */
  public void clearWarnings() {
    genClient.clear(CacheKey.warnings);
  }
  /** Clears the 'total' field, the 'has' method for this field will now return false */
  public void clearTotal() {
    genClient.clear(CacheKey.total);
  }
  /** Clears the 'majorLabelsExist' field, the 'has' method for this field will now return false */
  public void clearMajorLabelsExist() {
    genClient.clear(CacheKey.majorLabelsExist);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public LabelSummarySection copyChanges() {
    LabelSummarySection copy = new LabelSummarySection();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(LabelSummarySection src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new LabelSummarySection(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<LabelSummarySection> CREATOR = new android.os.Parcelable.Creator<LabelSummarySection>() {
    @Override
    public LabelSummarySection createFromParcel(android.os.Parcel in) {
      LabelSummarySection instance = new LabelSummarySection(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public LabelSummarySection[] newArray(int size) {
      return new LabelSummarySection[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<LabelSummarySection> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<LabelSummarySection>() {
    public Class<LabelSummarySection> getCreatedClass() {
      return LabelSummarySection.class;
    }

    @Override
    public LabelSummarySection create(org.json.JSONObject jsonObject) {
      return new LabelSummarySection(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean ROWS_IS_REQUIRED = false;
    public static final boolean WARNINGS_IS_REQUIRED = false;
    public static final boolean TOTAL_IS_REQUIRED = false;
    public static final boolean MAJORLABELSEXIST_IS_REQUIRED = false;
  }

}
