/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.report;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getRevenueItems revenueItems}</li>
 * <li>{@link #getNonRevenueItems nonRevenueItems}</li>
 * <li>{@link #getMajorLabelsExist majorLabelsExist}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class LineItemsReport extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  public com.clover.sdk.v3.report.LineItemsArrayAndWarning getRevenueItems() {
    return genClient.cacheGet(CacheKey.revenueItems);
  }

  public com.clover.sdk.v3.report.LineItemsArrayAndWarning getNonRevenueItems() {
    return genClient.cacheGet(CacheKey.nonRevenueItems);
  }

  /**
   * Whether the merchant has any labels marked 'Show in Reporting?'
   */
  public java.lang.Boolean getMajorLabelsExist() {
    return genClient.cacheGet(CacheKey.majorLabelsExist);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    revenueItems
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.report.LineItemsArrayAndWarning.JSON_CREATOR)),
    nonRevenueItems
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.report.LineItemsArrayAndWarning.JSON_CREATOR)),
    majorLabelsExist
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<LineItemsReport> genClient;

  /**
   * Constructs a new empty instance.
   */
  public LineItemsReport() {
    genClient = new GenericClient<LineItemsReport>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected LineItemsReport(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public LineItemsReport(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public LineItemsReport(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public LineItemsReport(LineItemsReport src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
  }

  /** Checks whether the 'revenueItems' field is set and is not null */
  public boolean isNotNullRevenueItems() {
    return genClient.cacheValueIsNotNull(CacheKey.revenueItems);
  }

  /** Checks whether the 'nonRevenueItems' field is set and is not null */
  public boolean isNotNullNonRevenueItems() {
    return genClient.cacheValueIsNotNull(CacheKey.nonRevenueItems);
  }

  /** Checks whether the 'majorLabelsExist' field is set and is not null */
  public boolean isNotNullMajorLabelsExist() {
    return genClient.cacheValueIsNotNull(CacheKey.majorLabelsExist);
  }



  /** Checks whether the 'revenueItems' field has been set, however the value could be null */
  public boolean hasRevenueItems() {
    return genClient.cacheHasKey(CacheKey.revenueItems);
  }

  /** Checks whether the 'nonRevenueItems' field has been set, however the value could be null */
  public boolean hasNonRevenueItems() {
    return genClient.cacheHasKey(CacheKey.nonRevenueItems);
  }

  /** Checks whether the 'majorLabelsExist' field has been set, however the value could be null */
  public boolean hasMajorLabelsExist() {
    return genClient.cacheHasKey(CacheKey.majorLabelsExist);
  }


  /**
   * Sets the field 'revenueItems'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public LineItemsReport setRevenueItems(com.clover.sdk.v3.report.LineItemsArrayAndWarning revenueItems) {
    return genClient.setRecord(revenueItems, CacheKey.revenueItems);
  }

  /**
   * Sets the field 'nonRevenueItems'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public LineItemsReport setNonRevenueItems(com.clover.sdk.v3.report.LineItemsArrayAndWarning nonRevenueItems) {
    return genClient.setRecord(nonRevenueItems, CacheKey.nonRevenueItems);
  }

  /**
   * Sets the field 'majorLabelsExist'.
   */
  public LineItemsReport setMajorLabelsExist(java.lang.Boolean majorLabelsExist) {
    return genClient.setOther(majorLabelsExist, CacheKey.majorLabelsExist);
  }


  /** Clears the 'revenueItems' field, the 'has' method for this field will now return false */
  public void clearRevenueItems() {
    genClient.clear(CacheKey.revenueItems);
  }
  /** Clears the 'nonRevenueItems' field, the 'has' method for this field will now return false */
  public void clearNonRevenueItems() {
    genClient.clear(CacheKey.nonRevenueItems);
  }
  /** Clears the 'majorLabelsExist' field, the 'has' method for this field will now return false */
  public void clearMajorLabelsExist() {
    genClient.clear(CacheKey.majorLabelsExist);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public LineItemsReport copyChanges() {
    LineItemsReport copy = new LineItemsReport();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(LineItemsReport src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new LineItemsReport(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<LineItemsReport> CREATOR = new android.os.Parcelable.Creator<LineItemsReport>() {
    @Override
    public LineItemsReport createFromParcel(android.os.Parcel in) {
      LineItemsReport instance = new LineItemsReport(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public LineItemsReport[] newArray(int size) {
      return new LineItemsReport[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<LineItemsReport> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<LineItemsReport>() {
    public Class<LineItemsReport> getCreatedClass() {
      return LineItemsReport.class;
    }

    @Override
    public LineItemsReport create(org.json.JSONObject jsonObject) {
      return new LineItemsReport(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean REVENUEITEMS_IS_REQUIRED = false;
    public static final boolean NONREVENUEITEMS_IS_REQUIRED = false;
    public static final boolean MAJORLABELSEXIST_IS_REQUIRED = false;
  }

}
