/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.report;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getId id}</li>
 * <li>{@link #getNumTotalLocations numTotalLocations}</li>
 * <li>{@link #getNumOpenLocations numOpenLocations}</li>
 * <li>{@link #getNumClosedLocations numClosedLocations}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class LocationBreakdown extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  public java.lang.String getId() {
    return genClient.cacheGet(CacheKey.id);
  }

  /**
   * Number of locations where the employee is at across all locations (ML purposes only)
   */
  public java.lang.Long getNumTotalLocations() {
    return genClient.cacheGet(CacheKey.numTotalLocations);
  }

  /**
   * Number of locations where the employee is at across all open locations (ML purposes only)
   */
  public java.lang.Long getNumOpenLocations() {
    return genClient.cacheGet(CacheKey.numOpenLocations);
  }

  /**
   * Number of locations where the employee is at across all closed locations (ML purposes only)
   */
  public java.lang.Long getNumClosedLocations() {
    return genClient.cacheGet(CacheKey.numClosedLocations);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    id
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    numTotalLocations
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    numOpenLocations
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    numClosedLocations
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<LocationBreakdown> genClient;

  /**
   * Constructs a new empty instance.
   */
  public LocationBreakdown() {
    genClient = new GenericClient<LocationBreakdown>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected LocationBreakdown(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public LocationBreakdown(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public LocationBreakdown(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public LocationBreakdown(LocationBreakdown src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
  }

  /** Checks whether the 'id' field is set and is not null */
  public boolean isNotNullId() {
    return genClient.cacheValueIsNotNull(CacheKey.id);
  }

  /** Checks whether the 'numTotalLocations' field is set and is not null */
  public boolean isNotNullNumTotalLocations() {
    return genClient.cacheValueIsNotNull(CacheKey.numTotalLocations);
  }

  /** Checks whether the 'numOpenLocations' field is set and is not null */
  public boolean isNotNullNumOpenLocations() {
    return genClient.cacheValueIsNotNull(CacheKey.numOpenLocations);
  }

  /** Checks whether the 'numClosedLocations' field is set and is not null */
  public boolean isNotNullNumClosedLocations() {
    return genClient.cacheValueIsNotNull(CacheKey.numClosedLocations);
  }



  /** Checks whether the 'id' field has been set, however the value could be null */
  public boolean hasId() {
    return genClient.cacheHasKey(CacheKey.id);
  }

  /** Checks whether the 'numTotalLocations' field has been set, however the value could be null */
  public boolean hasNumTotalLocations() {
    return genClient.cacheHasKey(CacheKey.numTotalLocations);
  }

  /** Checks whether the 'numOpenLocations' field has been set, however the value could be null */
  public boolean hasNumOpenLocations() {
    return genClient.cacheHasKey(CacheKey.numOpenLocations);
  }

  /** Checks whether the 'numClosedLocations' field has been set, however the value could be null */
  public boolean hasNumClosedLocations() {
    return genClient.cacheHasKey(CacheKey.numClosedLocations);
  }


  /**
   * Sets the field 'id'.
   */
  public LocationBreakdown setId(java.lang.String id) {
    return genClient.setOther(id, CacheKey.id);
  }

  /**
   * Sets the field 'numTotalLocations'.
   */
  public LocationBreakdown setNumTotalLocations(java.lang.Long numTotalLocations) {
    return genClient.setOther(numTotalLocations, CacheKey.numTotalLocations);
  }

  /**
   * Sets the field 'numOpenLocations'.
   */
  public LocationBreakdown setNumOpenLocations(java.lang.Long numOpenLocations) {
    return genClient.setOther(numOpenLocations, CacheKey.numOpenLocations);
  }

  /**
   * Sets the field 'numClosedLocations'.
   */
  public LocationBreakdown setNumClosedLocations(java.lang.Long numClosedLocations) {
    return genClient.setOther(numClosedLocations, CacheKey.numClosedLocations);
  }


  /** Clears the 'id' field, the 'has' method for this field will now return false */
  public void clearId() {
    genClient.clear(CacheKey.id);
  }
  /** Clears the 'numTotalLocations' field, the 'has' method for this field will now return false */
  public void clearNumTotalLocations() {
    genClient.clear(CacheKey.numTotalLocations);
  }
  /** Clears the 'numOpenLocations' field, the 'has' method for this field will now return false */
  public void clearNumOpenLocations() {
    genClient.clear(CacheKey.numOpenLocations);
  }
  /** Clears the 'numClosedLocations' field, the 'has' method for this field will now return false */
  public void clearNumClosedLocations() {
    genClient.clear(CacheKey.numClosedLocations);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public LocationBreakdown copyChanges() {
    LocationBreakdown copy = new LocationBreakdown();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(LocationBreakdown src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new LocationBreakdown(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<LocationBreakdown> CREATOR = new android.os.Parcelable.Creator<LocationBreakdown>() {
    @Override
    public LocationBreakdown createFromParcel(android.os.Parcel in) {
      LocationBreakdown instance = new LocationBreakdown(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public LocationBreakdown[] newArray(int size) {
      return new LocationBreakdown[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<LocationBreakdown> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<LocationBreakdown>() {
    public Class<LocationBreakdown> getCreatedClass() {
      return LocationBreakdown.class;
    }

    @Override
    public LocationBreakdown create(org.json.JSONObject jsonObject) {
      return new LocationBreakdown(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean ID_IS_REQUIRED = false;
    public static final boolean NUMTOTALLOCATIONS_IS_REQUIRED = false;
    public static final boolean NUMOPENLOCATIONS_IS_REQUIRED = false;
    public static final boolean NUMCLOSEDLOCATIONS_IS_REQUIRED = false;
  }

}
