/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.report;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getOrder order}</li>
 * <li>{@link #getApprovers approvers}</li>
 * <li>{@link #getOrderDiscountTotal orderDiscountTotal}</li>
 * <li>{@link #getOrderDiscountCount orderDiscountCount}</li>
 * <li>{@link #getLineItemDiscountTotal lineItemDiscountTotal}</li>
 * <li>{@link #getLineItemDiscountCount lineItemDiscountCount}</li>
 * <li>{@link #getTotalDiscount totalDiscount}</li>
 * <li>{@link #getTotalDiscountCount totalDiscountCount}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class ReportDiscountRow extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * The order for this row
   */
  public com.clover.sdk.v3.order.Order getOrder() {
    return genClient.cacheGet(CacheKey.order);
  }

  /**
   * Reference to the employees who approved the discounts on this order
   */
  public java.util.List<com.clover.sdk.v3.employees.Employee> getApprovers() {
    return genClient.cacheGet(CacheKey.approvers);
  }

  /**
   * Total value of discounts on order
   */
  public java.lang.Long getOrderDiscountTotal() {
    return genClient.cacheGet(CacheKey.orderDiscountTotal);
  }

  /**
   * Total number of discounts on order
   */
  public java.lang.Long getOrderDiscountCount() {
    return genClient.cacheGet(CacheKey.orderDiscountCount);
  }

  /**
   * Total value of discounts on the order's line items
   */
  public java.lang.Long getLineItemDiscountTotal() {
    return genClient.cacheGet(CacheKey.lineItemDiscountTotal);
  }

  /**
   * Total number of discounts on the order's line items
   */
  public java.lang.Long getLineItemDiscountCount() {
    return genClient.cacheGet(CacheKey.lineItemDiscountCount);
  }

  /**
   * Total value of all line item and order discounts
   */
  public java.lang.Long getTotalDiscount() {
    return genClient.cacheGet(CacheKey.totalDiscount);
  }

  /**
   * Total count of all line item and order discounts
   */
  public java.lang.Long getTotalDiscountCount() {
    return genClient.cacheGet(CacheKey.totalDiscountCount);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    order
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.order.Order.JSON_CREATOR)),
    approvers
        (com.clover.sdk.extractors.RecordListExtractionStrategy.instance(com.clover.sdk.v3.employees.Employee.JSON_CREATOR)),
    orderDiscountTotal
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    orderDiscountCount
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    lineItemDiscountTotal
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    lineItemDiscountCount
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    totalDiscount
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    totalDiscountCount
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<ReportDiscountRow> genClient;

  /**
   * Constructs a new empty instance.
   */
  public ReportDiscountRow() {
    genClient = new GenericClient<ReportDiscountRow>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected ReportDiscountRow(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public ReportDiscountRow(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public ReportDiscountRow(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public ReportDiscountRow(ReportDiscountRow src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
  }

  /** Checks whether the 'order' field is set and is not null */
  public boolean isNotNullOrder() {
    return genClient.cacheValueIsNotNull(CacheKey.order);
  }

  /** Checks whether the 'approvers' field is set and is not null */
  public boolean isNotNullApprovers() {
    return genClient.cacheValueIsNotNull(CacheKey.approvers);
  }

  /** Checks whether the 'approvers' field is set and is not null and is not empty */
  public boolean isNotEmptyApprovers() { return isNotNullApprovers() && !getApprovers().isEmpty(); }

  /** Checks whether the 'orderDiscountTotal' field is set and is not null */
  public boolean isNotNullOrderDiscountTotal() {
    return genClient.cacheValueIsNotNull(CacheKey.orderDiscountTotal);
  }

  /** Checks whether the 'orderDiscountCount' field is set and is not null */
  public boolean isNotNullOrderDiscountCount() {
    return genClient.cacheValueIsNotNull(CacheKey.orderDiscountCount);
  }

  /** Checks whether the 'lineItemDiscountTotal' field is set and is not null */
  public boolean isNotNullLineItemDiscountTotal() {
    return genClient.cacheValueIsNotNull(CacheKey.lineItemDiscountTotal);
  }

  /** Checks whether the 'lineItemDiscountCount' field is set and is not null */
  public boolean isNotNullLineItemDiscountCount() {
    return genClient.cacheValueIsNotNull(CacheKey.lineItemDiscountCount);
  }

  /** Checks whether the 'totalDiscount' field is set and is not null */
  public boolean isNotNullTotalDiscount() {
    return genClient.cacheValueIsNotNull(CacheKey.totalDiscount);
  }

  /** Checks whether the 'totalDiscountCount' field is set and is not null */
  public boolean isNotNullTotalDiscountCount() {
    return genClient.cacheValueIsNotNull(CacheKey.totalDiscountCount);
  }



  /** Checks whether the 'order' field has been set, however the value could be null */
  public boolean hasOrder() {
    return genClient.cacheHasKey(CacheKey.order);
  }

  /** Checks whether the 'approvers' field has been set, however the value could be null */
  public boolean hasApprovers() {
    return genClient.cacheHasKey(CacheKey.approvers);
  }

  /** Checks whether the 'orderDiscountTotal' field has been set, however the value could be null */
  public boolean hasOrderDiscountTotal() {
    return genClient.cacheHasKey(CacheKey.orderDiscountTotal);
  }

  /** Checks whether the 'orderDiscountCount' field has been set, however the value could be null */
  public boolean hasOrderDiscountCount() {
    return genClient.cacheHasKey(CacheKey.orderDiscountCount);
  }

  /** Checks whether the 'lineItemDiscountTotal' field has been set, however the value could be null */
  public boolean hasLineItemDiscountTotal() {
    return genClient.cacheHasKey(CacheKey.lineItemDiscountTotal);
  }

  /** Checks whether the 'lineItemDiscountCount' field has been set, however the value could be null */
  public boolean hasLineItemDiscountCount() {
    return genClient.cacheHasKey(CacheKey.lineItemDiscountCount);
  }

  /** Checks whether the 'totalDiscount' field has been set, however the value could be null */
  public boolean hasTotalDiscount() {
    return genClient.cacheHasKey(CacheKey.totalDiscount);
  }

  /** Checks whether the 'totalDiscountCount' field has been set, however the value could be null */
  public boolean hasTotalDiscountCount() {
    return genClient.cacheHasKey(CacheKey.totalDiscountCount);
  }


  /**
   * Sets the field 'order'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public ReportDiscountRow setOrder(com.clover.sdk.v3.order.Order order) {
    return genClient.setRecord(order, CacheKey.order);
  }

  /**
   * Sets the field 'approvers'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public ReportDiscountRow setApprovers(java.util.List<com.clover.sdk.v3.employees.Employee> approvers) {
    return genClient.setArrayRecord(approvers, CacheKey.approvers);
  }

  /**
   * Sets the field 'orderDiscountTotal'.
   */
  public ReportDiscountRow setOrderDiscountTotal(java.lang.Long orderDiscountTotal) {
    return genClient.setOther(orderDiscountTotal, CacheKey.orderDiscountTotal);
  }

  /**
   * Sets the field 'orderDiscountCount'.
   */
  public ReportDiscountRow setOrderDiscountCount(java.lang.Long orderDiscountCount) {
    return genClient.setOther(orderDiscountCount, CacheKey.orderDiscountCount);
  }

  /**
   * Sets the field 'lineItemDiscountTotal'.
   */
  public ReportDiscountRow setLineItemDiscountTotal(java.lang.Long lineItemDiscountTotal) {
    return genClient.setOther(lineItemDiscountTotal, CacheKey.lineItemDiscountTotal);
  }

  /**
   * Sets the field 'lineItemDiscountCount'.
   */
  public ReportDiscountRow setLineItemDiscountCount(java.lang.Long lineItemDiscountCount) {
    return genClient.setOther(lineItemDiscountCount, CacheKey.lineItemDiscountCount);
  }

  /**
   * Sets the field 'totalDiscount'.
   */
  public ReportDiscountRow setTotalDiscount(java.lang.Long totalDiscount) {
    return genClient.setOther(totalDiscount, CacheKey.totalDiscount);
  }

  /**
   * Sets the field 'totalDiscountCount'.
   */
  public ReportDiscountRow setTotalDiscountCount(java.lang.Long totalDiscountCount) {
    return genClient.setOther(totalDiscountCount, CacheKey.totalDiscountCount);
  }


  /** Clears the 'order' field, the 'has' method for this field will now return false */
  public void clearOrder() {
    genClient.clear(CacheKey.order);
  }
  /** Clears the 'approvers' field, the 'has' method for this field will now return false */
  public void clearApprovers() {
    genClient.clear(CacheKey.approvers);
  }
  /** Clears the 'orderDiscountTotal' field, the 'has' method for this field will now return false */
  public void clearOrderDiscountTotal() {
    genClient.clear(CacheKey.orderDiscountTotal);
  }
  /** Clears the 'orderDiscountCount' field, the 'has' method for this field will now return false */
  public void clearOrderDiscountCount() {
    genClient.clear(CacheKey.orderDiscountCount);
  }
  /** Clears the 'lineItemDiscountTotal' field, the 'has' method for this field will now return false */
  public void clearLineItemDiscountTotal() {
    genClient.clear(CacheKey.lineItemDiscountTotal);
  }
  /** Clears the 'lineItemDiscountCount' field, the 'has' method for this field will now return false */
  public void clearLineItemDiscountCount() {
    genClient.clear(CacheKey.lineItemDiscountCount);
  }
  /** Clears the 'totalDiscount' field, the 'has' method for this field will now return false */
  public void clearTotalDiscount() {
    genClient.clear(CacheKey.totalDiscount);
  }
  /** Clears the 'totalDiscountCount' field, the 'has' method for this field will now return false */
  public void clearTotalDiscountCount() {
    genClient.clear(CacheKey.totalDiscountCount);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public ReportDiscountRow copyChanges() {
    ReportDiscountRow copy = new ReportDiscountRow();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(ReportDiscountRow src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new ReportDiscountRow(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<ReportDiscountRow> CREATOR = new android.os.Parcelable.Creator<ReportDiscountRow>() {
    @Override
    public ReportDiscountRow createFromParcel(android.os.Parcel in) {
      ReportDiscountRow instance = new ReportDiscountRow(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public ReportDiscountRow[] newArray(int size) {
      return new ReportDiscountRow[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<ReportDiscountRow> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<ReportDiscountRow>() {
    public Class<ReportDiscountRow> getCreatedClass() {
      return ReportDiscountRow.class;
    }

    @Override
    public ReportDiscountRow create(org.json.JSONObject jsonObject) {
      return new ReportDiscountRow(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean ORDER_IS_REQUIRED = false;
    public static final boolean APPROVERS_IS_REQUIRED = false;
    public static final boolean ORDERDISCOUNTTOTAL_IS_REQUIRED = false;
    public static final boolean ORDERDISCOUNTCOUNT_IS_REQUIRED = false;
    public static final boolean LINEITEMDISCOUNTTOTAL_IS_REQUIRED = false;
    public static final boolean LINEITEMDISCOUNTCOUNT_IS_REQUIRED = false;
    public static final boolean TOTALDISCOUNT_IS_REQUIRED = false;
    public static final boolean TOTALDISCOUNTCOUNT_IS_REQUIRED = false;
  }

}
