/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.report;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getId id}</li>
 * <li>{@link #getName name}</li>
 * <li>{@link #getNumberSold numberSold}</li>
 * <li>{@link #getRevenueSold revenueSold}</li>
 * <li>{@link #getNumNonRevenueSold numNonRevenueSold}</li>
 * <li>{@link #getPriceSold priceSold}</li>
 * <li>{@link #getNumRefunds numRefunds}</li>
 * <li>{@link #getRefundAmount refundAmount}</li>
 * <li>{@link #getRefundAmountRegardlessOfRepayment refundAmountRegardlessOfRepayment}</li>
 * <li>{@link #getRefundAmountRegardlessOfRepaymentFractionalCents refundAmountRegardlessOfRepaymentFractionalCents}</li>
 * <li>{@link #getRefundRepaymentAmount refundRepaymentAmount}</li>
 * <li>{@link #getRefundRepaymentAmountFractionalCents refundRepaymentAmountFractionalCents}</li>
 * <li>{@link #getNumExchanges numExchanges}</li>
 * <li>{@link #getExchangeAmount exchangeAmount}</li>
 * <li>{@link #getInACategory inACategory}</li>
 * <li>{@link #getInventoryItem inventoryItem}</li>
 * <li>{@link #getDiscountSales discountSales}</li>
 * <li>{@link #getOrderLevelDiscounts orderLevelDiscounts}</li>
 * <li>{@link #getLabels labels}</li>
 * <li>{@link #getCategories categories}</li>
 * <li>{@link #getDeletedCategories deletedCategories}</li>
 * <li>{@link #getModifierSales modifierSales}</li>
 * <li>{@link #getGrossModifierSales grossModifierSales}</li>
 * <li>{@link #getTotalDiscounts totalDiscounts}</li>
 * <li>{@link #getTotalDiscountsFractionalCents totalDiscountsFractionalCents}</li>
 * <li>{@link #getNetNumberSold netNumberSold}</li>
 * <li>{@link #getGrossItemSales grossItemSales}</li>
 * <li>{@link #getGrossSales grossSales}</li>
 * <li>{@link #getNetItemSales netItemSales}</li>
 * <li>{@link #getNetItemSalesFractionalCents netItemSalesFractionalCents}</li>
 * <li>{@link #getNetModifierSales netModifierSales}</li>
 * <li>{@link #getNetModifierSalesFractionalCents netModifierSalesFractionalCents}</li>
 * <li>{@link #getNetSales netSales}</li>
 * <li>{@link #getNetSalesFractionalCents netSalesFractionalCents}</li>
 * <li>{@link #getCostOfGoodsSold costOfGoodsSold}</li>
 * <li>{@link #getGrossProfit grossProfit}</li>
 * <li>{@link #getGrossProfitMargin grossProfitMargin}</li>
 * <li>{@link #getAverageNetSales averageNetSales}</li>
 * <li>{@link #getPercentTotalNetSales percentTotalNetSales}</li>
 * <li>{@link #getPartialRefundAmount partialRefundAmount}</li>
 * <li>{@link #getPartialRefundRepaymentAmount partialRefundRepaymentAmount}</li>
 * <li>{@link #getCategory category}</li>
 * <li>{@link #getSegmentLabel segmentLabel}</li>
 * <li>{@link #getStartTimestamp startTimestamp}</li>
 * <li>{@link #getEndTimestamp endTimestamp}</li>
 * <li>{@link #getChangeInNetSales changeInNetSales}</li>
 * <li>{@link #getChangeInNetNumberSold changeInNetNumberSold}</li>
 * <li>{@link #getIsRevenue isRevenue}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class ReportItem extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  public java.lang.String getId() {
    return genClient.cacheGet(CacheKey.id);
  }

  public java.lang.String getName() {
    return genClient.cacheGet(CacheKey.name);
  }

  public java.lang.Double getNumberSold() {
    return genClient.cacheGet(CacheKey.numberSold);
  }

  /**
   * This is item gross sales for line items where is_revenue=true. It is the item value before discounts and refunds. Does not include non-revenue items and modifier gross sales.
   */
  public java.lang.Long getRevenueSold() {
    return genClient.cacheGet(CacheKey.revenueSold);
  }

  public java.lang.Double getNumNonRevenueSold() {
    return genClient.cacheGet(CacheKey.numNonRevenueSold);
  }

  public java.lang.Double getPriceSold() {
    return genClient.cacheGet(CacheKey.priceSold);
  }

  public java.lang.Double getNumRefunds() {
    return genClient.cacheGet(CacheKey.numRefunds);
  }

  /**
   * Total value of items that were fully refunded. This excludes amounts that were later fully repaid. This is for the original design of the report from 2019.
   */
  public java.lang.Long getRefundAmount() {
    return genClient.cacheGet(CacheKey.refundAmount);
  }

  /**
   * Total value of items that were fully refunded. This includes amounts that were later fully repaid. This is for the amendment to the design of the report in 2020 to separate the display of refund repayments from refunds.
   */
  public java.lang.Long getRefundAmountRegardlessOfRepayment() {
    return genClient.cacheGet(CacheKey.refundAmountRegardlessOfRepayment);
  }

  /**
   * Total value of items that were fully refunded. This includes amounts that were later fully repaid. This is for the amendment to the design of the report in 2020 to separate the display of refund repayments from refunds. Values are reported as fractional cents as this field can represent a refund of multiple line items attributed here to a single line item.
   */
  public java.lang.Double getRefundAmountRegardlessOfRepaymentFractionalCents() {
    return genClient.cacheGet(CacheKey.refundAmountRegardlessOfRepaymentFractionalCents);
  }

  /**
   * Total value of items that were fully refunded and then later fully repaid.
   */
  public java.lang.Long getRefundRepaymentAmount() {
    return genClient.cacheGet(CacheKey.refundRepaymentAmount);
  }

  /**
   * Total value of items that were fully refunded and then later fully repaid. Values are reported as fractional cents as this field can represent a payment for multiple line items attributed here to a single line item.
   */
  public java.lang.Double getRefundRepaymentAmountFractionalCents() {
    return genClient.cacheGet(CacheKey.refundRepaymentAmountFractionalCents);
  }

  public java.lang.Double getNumExchanges() {
    return genClient.cacheGet(CacheKey.numExchanges);
  }

  public java.lang.Long getExchangeAmount() {
    return genClient.cacheGet(CacheKey.exchangeAmount);
  }

  public java.lang.Boolean getInACategory() {
    return genClient.cacheGet(CacheKey.inACategory);
  }

  public com.clover.sdk.v3.inventory.Item getInventoryItem() {
    return genClient.cacheGet(CacheKey.inventoryItem);
  }

  public java.util.List<com.clover.sdk.v3.report.BaseSale> getDiscountSales() {
    return genClient.cacheGet(CacheKey.discountSales);
  }

  public java.util.List<com.clover.sdk.v3.report.BaseSale> getOrderLevelDiscounts() {
    return genClient.cacheGet(CacheKey.orderLevelDiscounts);
  }

  public java.util.List<com.clover.sdk.v3.report.ReportLabel> getLabels() {
    return genClient.cacheGet(CacheKey.labels);
  }

  /**
   * DEPRECATED. Use 'category'. In practice this is the oldest active category that the item belongs to. If there are no categories for this item, then this is empty. If item belongs to categories that are all deleted, then this is not populated.
   */
  @Deprecated
  public java.util.List<com.clover.sdk.v3.report.ItemSalesBucket> getCategories() {
    return genClient.cacheGet(CacheKey.categories);
  }

  /**
   * DEPRECATED. Use 'category'. In practice if the item belongs to only categories that are deleted, then this is most recently deleted category. If the item is in an active category then this is not populated.
   */
  @Deprecated
  public java.util.List<com.clover.sdk.v3.report.ItemSalesBucket> getDeletedCategories() {
    return genClient.cacheGet(CacheKey.deletedCategories);
  }

  public java.util.List<com.clover.sdk.v3.report.BaseSale> getModifierSales() {
    return genClient.cacheGet(CacheKey.modifierSales);
  }

  /**
   * Total value of all modifiers sold for this item.
   */
  public java.lang.Long getGrossModifierSales() {
    return genClient.cacheGet(CacheKey.grossModifierSales);
  }

  /**
   * Total value of line item discounts and order level discounts. Order level discounts are an estimate of how much of the order level discount can be attributed to the line item. Units are cents. Fractional cents are rounded to the nearest cent.
   */
  public java.lang.Long getTotalDiscounts() {
    return genClient.cacheGet(CacheKey.totalDiscounts);
  }

  /**
   * Total value of line item discounts and order level discounts. Order level discounts are an estimate of how much of the order level discount can be attributed to the line item. Units are cents. Fractional cents are preserved.
   */
  public java.lang.Double getTotalDiscountsFractionalCents() {
    return genClient.cacheGet(CacheKey.totalDiscountsFractionalCents);
  }

  /**
   * The number sold minus the number refunded and exchanged.
   */
  public java.lang.Double getNetNumberSold() {
    return genClient.cacheGet(CacheKey.netNumberSold);
  }

  /**
   * Item value before discounts and refunds. Does not include modifier gross sales.
   */
  public java.lang.Long getGrossItemSales() {
    return genClient.cacheGet(CacheKey.grossItemSales);
  }

  /**
   * Total value of sales of this item with modifiers before refunds and without taxes, discounts and service charges. Sum of Gross Modifier Sales and Gross Item Sales.
   */
  public java.lang.Long getGrossSales() {
    return genClient.cacheGet(CacheKey.grossSales);
  }

  /**
   * Total value of sales of this item after refunds and with discounts. Does not include modifier sales.
   */
  public java.lang.Long getNetItemSales() {
    return genClient.cacheGet(CacheKey.netItemSales);
  }

  /**
   * Total value of sales of this item after refunds and with discounts. Does not include modifier sales. Units are cents. Fractional cents are returned to allow a precise total.
   */
  public java.lang.Double getNetItemSalesFractionalCents() {
    return genClient.cacheGet(CacheKey.netItemSalesFractionalCents);
  }

  /**
   * Total value of all modifiers sold for this item minus total value of all modifiers refunded.
   */
  public java.lang.Long getNetModifierSales() {
    return genClient.cacheGet(CacheKey.netModifierSales);
  }

  /**
   * Total value of all modifiers sold for this item minus total value of all modifiers refunded. Units are cents. Fractional cents are returned to allow a precise total.
   */
  public java.lang.Double getNetModifierSalesFractionalCents() {
    return genClient.cacheGet(CacheKey.netModifierSalesFractionalCents);
  }

  /**
   * Total value of sales of this item with modifiers after refunds and with discounts. Sum of Net Modifier Sales and Net Item Sales. Units are cents. Rounded to the nearest penny.
   */
  public java.lang.Long getNetSales() {
    return genClient.cacheGet(CacheKey.netSales);
  }

  /**
   * Total value of sales of this item with modifiers after refunds and with discounts. Sum of Net Modifier Sales and Net Item Sales. Units are cents. Decimal portion is fractional cents.
   */
  public java.lang.Double getNetSalesFractionalCents() {
    return genClient.cacheGet(CacheKey.netSalesFractionalCents);
  }

  /**
   * Cost of Goods Sold (COGS): net quantity sold multiplied by the cost.
   */
  public java.lang.Long getCostOfGoodsSold() {
    return genClient.cacheGet(CacheKey.costOfGoodsSold);
  }

  /**
   * Gross sales minus cost of goods sold.
   */
  public java.lang.Long getGrossProfit() {
    return genClient.cacheGet(CacheKey.grossProfit);
  }

  /**
   * Gross profit divided by gross sales.
   */
  public java.lang.Double getGrossProfitMargin() {
    return genClient.cacheGet(CacheKey.grossProfitMargin);
  }

  /**
   * Net sales divided by net number sold.
   */
  public java.lang.Long getAverageNetSales() {
    return genClient.cacheGet(CacheKey.averageNetSales);
  }

  /**
   * The percentage of the net sales of this item versus total net sales of all revenue items or of all non-revenue items.
   */
  public java.lang.Double getPercentTotalNetSales() {
    return genClient.cacheGet(CacheKey.percentTotalNetSales);
  }

  /**
   * Total amount of refunds that partially refunded the item but did not fully refund the item, in units of cents. Rounded to the nearest penny.
   */
  public java.lang.Long getPartialRefundAmount() {
    return genClient.cacheGet(CacheKey.partialRefundAmount);
  }

  /**
   * Total amount of refunds that partially refunded the item but did not fully refund the item and then were later re-paid, in units of cents. Rounded to the nearest penny.
   */
  public java.lang.Long getPartialRefundRepaymentAmount() {
    return genClient.cacheGet(CacheKey.partialRefundRepaymentAmount);
  }

  /**
   * The oldest active category that the item belongs to. If item belongs to categories that are all deleted, then this is the most recently deleted category. If there are no categories for this item, then this is empty. 
   */
  public com.clover.sdk.v3.report.ItemSalesBucket getCategory() {
    return genClient.cacheGet(CacheKey.category);
  }

  /**
   * An identifier that may be used to align report segments across different merchants.
   */
  public java.lang.Integer getSegmentLabel() {
    return genClient.cacheGet(CacheKey.segmentLabel);
  }

  /**
   * Beginning of the time period for this summary
   */
  public java.lang.Long getStartTimestamp() {
    return genClient.cacheGet(CacheKey.startTimestamp);
  }

  /**
   * End of the time period for this summary
   */
  public java.lang.Long getEndTimestamp() {
    return genClient.cacheGet(CacheKey.endTimestamp);
  }

  /**
   * Change in net sales comparing the previous period to this period. Expressed as a proportion: 0.5 = 50% increase, -0.75 = 75% decrease, 0 = no change, null = previous period had no sales, 1.2 = 120% increase.
   */
  public java.lang.Double getChangeInNetSales() {
    return genClient.cacheGet(CacheKey.changeInNetSales);
  }

  /**
   * Change in net quantity comparing the previous period to this period. Expressed as a proportion: 0.5 = 50% increase, -0.75 = 75% decrease, 0 = no change, null = previous period had no sales, 1.2 = 120% increase.
   */
  public java.lang.Double getChangeInNetNumberSold() {
    return genClient.cacheGet(CacheKey.changeInNetNumberSold);
  }

  /**
   * True if this item should be counted as revenue. For example, gift cards and donations would not be counted as revenue.
   */
  public java.lang.Boolean getIsRevenue() {
    return genClient.cacheGet(CacheKey.isRevenue);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    id
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    name
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    numberSold
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Double.class)),
    revenueSold
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    numNonRevenueSold
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Double.class)),
    priceSold
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Double.class)),
    numRefunds
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Double.class)),
    refundAmount
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    refundAmountRegardlessOfRepayment
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    refundAmountRegardlessOfRepaymentFractionalCents
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Double.class)),
    refundRepaymentAmount
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    refundRepaymentAmountFractionalCents
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Double.class)),
    numExchanges
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Double.class)),
    exchangeAmount
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    inACategory
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    inventoryItem
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.inventory.Item.JSON_CREATOR)),
    discountSales
        (com.clover.sdk.extractors.RecordListExtractionStrategy.instance(com.clover.sdk.v3.report.BaseSale.JSON_CREATOR)),
    orderLevelDiscounts
        (com.clover.sdk.extractors.RecordListExtractionStrategy.instance(com.clover.sdk.v3.report.BaseSale.JSON_CREATOR)),
    labels
        (com.clover.sdk.extractors.RecordListExtractionStrategy.instance(com.clover.sdk.v3.report.ReportLabel.JSON_CREATOR)),
    categories
        (com.clover.sdk.extractors.RecordListExtractionStrategy.instance(com.clover.sdk.v3.report.ItemSalesBucket.JSON_CREATOR)),
    deletedCategories
        (com.clover.sdk.extractors.RecordListExtractionStrategy.instance(com.clover.sdk.v3.report.ItemSalesBucket.JSON_CREATOR)),
    modifierSales
        (com.clover.sdk.extractors.RecordListExtractionStrategy.instance(com.clover.sdk.v3.report.BaseSale.JSON_CREATOR)),
    grossModifierSales
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    totalDiscounts
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    totalDiscountsFractionalCents
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Double.class)),
    netNumberSold
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Double.class)),
    grossItemSales
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    grossSales
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    netItemSales
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    netItemSalesFractionalCents
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Double.class)),
    netModifierSales
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    netModifierSalesFractionalCents
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Double.class)),
    netSales
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    netSalesFractionalCents
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Double.class)),
    costOfGoodsSold
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    grossProfit
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    grossProfitMargin
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Double.class)),
    averageNetSales
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    percentTotalNetSales
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Double.class)),
    partialRefundAmount
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    partialRefundRepaymentAmount
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    category
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.report.ItemSalesBucket.JSON_CREATOR)),
    segmentLabel
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Integer.class)),
    startTimestamp
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    endTimestamp
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    changeInNetSales
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Double.class)),
    changeInNetNumberSold
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Double.class)),
    isRevenue
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<ReportItem> genClient;

  /**
   * Constructs a new empty instance.
   */
  public ReportItem() {
    genClient = new GenericClient<ReportItem>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected ReportItem(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public ReportItem(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public ReportItem(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public ReportItem(ReportItem src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {

    genClient.validateLength(CacheKey.name, getName(), 255);
  }

  /** Checks whether the 'id' field is set and is not null */
  public boolean isNotNullId() {
    return genClient.cacheValueIsNotNull(CacheKey.id);
  }

  /** Checks whether the 'name' field is set and is not null */
  public boolean isNotNullName() {
    return genClient.cacheValueIsNotNull(CacheKey.name);
  }

  /** Checks whether the 'numberSold' field is set and is not null */
  public boolean isNotNullNumberSold() {
    return genClient.cacheValueIsNotNull(CacheKey.numberSold);
  }

  /** Checks whether the 'revenueSold' field is set and is not null */
  public boolean isNotNullRevenueSold() {
    return genClient.cacheValueIsNotNull(CacheKey.revenueSold);
  }

  /** Checks whether the 'numNonRevenueSold' field is set and is not null */
  public boolean isNotNullNumNonRevenueSold() {
    return genClient.cacheValueIsNotNull(CacheKey.numNonRevenueSold);
  }

  /** Checks whether the 'priceSold' field is set and is not null */
  public boolean isNotNullPriceSold() {
    return genClient.cacheValueIsNotNull(CacheKey.priceSold);
  }

  /** Checks whether the 'numRefunds' field is set and is not null */
  public boolean isNotNullNumRefunds() {
    return genClient.cacheValueIsNotNull(CacheKey.numRefunds);
  }

  /** Checks whether the 'refundAmount' field is set and is not null */
  public boolean isNotNullRefundAmount() {
    return genClient.cacheValueIsNotNull(CacheKey.refundAmount);
  }

  /** Checks whether the 'refundAmountRegardlessOfRepayment' field is set and is not null */
  public boolean isNotNullRefundAmountRegardlessOfRepayment() {
    return genClient.cacheValueIsNotNull(CacheKey.refundAmountRegardlessOfRepayment);
  }

  /** Checks whether the 'refundAmountRegardlessOfRepaymentFractionalCents' field is set and is not null */
  public boolean isNotNullRefundAmountRegardlessOfRepaymentFractionalCents() {
    return genClient.cacheValueIsNotNull(CacheKey.refundAmountRegardlessOfRepaymentFractionalCents);
  }

  /** Checks whether the 'refundRepaymentAmount' field is set and is not null */
  public boolean isNotNullRefundRepaymentAmount() {
    return genClient.cacheValueIsNotNull(CacheKey.refundRepaymentAmount);
  }

  /** Checks whether the 'refundRepaymentAmountFractionalCents' field is set and is not null */
  public boolean isNotNullRefundRepaymentAmountFractionalCents() {
    return genClient.cacheValueIsNotNull(CacheKey.refundRepaymentAmountFractionalCents);
  }

  /** Checks whether the 'numExchanges' field is set and is not null */
  public boolean isNotNullNumExchanges() {
    return genClient.cacheValueIsNotNull(CacheKey.numExchanges);
  }

  /** Checks whether the 'exchangeAmount' field is set and is not null */
  public boolean isNotNullExchangeAmount() {
    return genClient.cacheValueIsNotNull(CacheKey.exchangeAmount);
  }

  /** Checks whether the 'inACategory' field is set and is not null */
  public boolean isNotNullInACategory() {
    return genClient.cacheValueIsNotNull(CacheKey.inACategory);
  }

  /** Checks whether the 'inventoryItem' field is set and is not null */
  public boolean isNotNullInventoryItem() {
    return genClient.cacheValueIsNotNull(CacheKey.inventoryItem);
  }

  /** Checks whether the 'discountSales' field is set and is not null */
  public boolean isNotNullDiscountSales() {
    return genClient.cacheValueIsNotNull(CacheKey.discountSales);
  }

  /** Checks whether the 'discountSales' field is set and is not null and is not empty */
  public boolean isNotEmptyDiscountSales() { return isNotNullDiscountSales() && !getDiscountSales().isEmpty(); }

  /** Checks whether the 'orderLevelDiscounts' field is set and is not null */
  public boolean isNotNullOrderLevelDiscounts() {
    return genClient.cacheValueIsNotNull(CacheKey.orderLevelDiscounts);
  }

  /** Checks whether the 'orderLevelDiscounts' field is set and is not null and is not empty */
  public boolean isNotEmptyOrderLevelDiscounts() { return isNotNullOrderLevelDiscounts() && !getOrderLevelDiscounts().isEmpty(); }

  /** Checks whether the 'labels' field is set and is not null */
  public boolean isNotNullLabels() {
    return genClient.cacheValueIsNotNull(CacheKey.labels);
  }

  /** Checks whether the 'labels' field is set and is not null and is not empty */
  public boolean isNotEmptyLabels() { return isNotNullLabels() && !getLabels().isEmpty(); }

  /** Checks whether the 'categories' field is set and is not null */
  public boolean isNotNullCategories() {
    return genClient.cacheValueIsNotNull(CacheKey.categories);
  }

  /** Checks whether the 'categories' field is set and is not null and is not empty */
  public boolean isNotEmptyCategories() { return isNotNullCategories() && !getCategories().isEmpty(); }

  /** Checks whether the 'deletedCategories' field is set and is not null */
  public boolean isNotNullDeletedCategories() {
    return genClient.cacheValueIsNotNull(CacheKey.deletedCategories);
  }

  /** Checks whether the 'deletedCategories' field is set and is not null and is not empty */
  public boolean isNotEmptyDeletedCategories() { return isNotNullDeletedCategories() && !getDeletedCategories().isEmpty(); }

  /** Checks whether the 'modifierSales' field is set and is not null */
  public boolean isNotNullModifierSales() {
    return genClient.cacheValueIsNotNull(CacheKey.modifierSales);
  }

  /** Checks whether the 'modifierSales' field is set and is not null and is not empty */
  public boolean isNotEmptyModifierSales() { return isNotNullModifierSales() && !getModifierSales().isEmpty(); }

  /** Checks whether the 'grossModifierSales' field is set and is not null */
  public boolean isNotNullGrossModifierSales() {
    return genClient.cacheValueIsNotNull(CacheKey.grossModifierSales);
  }

  /** Checks whether the 'totalDiscounts' field is set and is not null */
  public boolean isNotNullTotalDiscounts() {
    return genClient.cacheValueIsNotNull(CacheKey.totalDiscounts);
  }

  /** Checks whether the 'totalDiscountsFractionalCents' field is set and is not null */
  public boolean isNotNullTotalDiscountsFractionalCents() {
    return genClient.cacheValueIsNotNull(CacheKey.totalDiscountsFractionalCents);
  }

  /** Checks whether the 'netNumberSold' field is set and is not null */
  public boolean isNotNullNetNumberSold() {
    return genClient.cacheValueIsNotNull(CacheKey.netNumberSold);
  }

  /** Checks whether the 'grossItemSales' field is set and is not null */
  public boolean isNotNullGrossItemSales() {
    return genClient.cacheValueIsNotNull(CacheKey.grossItemSales);
  }

  /** Checks whether the 'grossSales' field is set and is not null */
  public boolean isNotNullGrossSales() {
    return genClient.cacheValueIsNotNull(CacheKey.grossSales);
  }

  /** Checks whether the 'netItemSales' field is set and is not null */
  public boolean isNotNullNetItemSales() {
    return genClient.cacheValueIsNotNull(CacheKey.netItemSales);
  }

  /** Checks whether the 'netItemSalesFractionalCents' field is set and is not null */
  public boolean isNotNullNetItemSalesFractionalCents() {
    return genClient.cacheValueIsNotNull(CacheKey.netItemSalesFractionalCents);
  }

  /** Checks whether the 'netModifierSales' field is set and is not null */
  public boolean isNotNullNetModifierSales() {
    return genClient.cacheValueIsNotNull(CacheKey.netModifierSales);
  }

  /** Checks whether the 'netModifierSalesFractionalCents' field is set and is not null */
  public boolean isNotNullNetModifierSalesFractionalCents() {
    return genClient.cacheValueIsNotNull(CacheKey.netModifierSalesFractionalCents);
  }

  /** Checks whether the 'netSales' field is set and is not null */
  public boolean isNotNullNetSales() {
    return genClient.cacheValueIsNotNull(CacheKey.netSales);
  }

  /** Checks whether the 'netSalesFractionalCents' field is set and is not null */
  public boolean isNotNullNetSalesFractionalCents() {
    return genClient.cacheValueIsNotNull(CacheKey.netSalesFractionalCents);
  }

  /** Checks whether the 'costOfGoodsSold' field is set and is not null */
  public boolean isNotNullCostOfGoodsSold() {
    return genClient.cacheValueIsNotNull(CacheKey.costOfGoodsSold);
  }

  /** Checks whether the 'grossProfit' field is set and is not null */
  public boolean isNotNullGrossProfit() {
    return genClient.cacheValueIsNotNull(CacheKey.grossProfit);
  }

  /** Checks whether the 'grossProfitMargin' field is set and is not null */
  public boolean isNotNullGrossProfitMargin() {
    return genClient.cacheValueIsNotNull(CacheKey.grossProfitMargin);
  }

  /** Checks whether the 'averageNetSales' field is set and is not null */
  public boolean isNotNullAverageNetSales() {
    return genClient.cacheValueIsNotNull(CacheKey.averageNetSales);
  }

  /** Checks whether the 'percentTotalNetSales' field is set and is not null */
  public boolean isNotNullPercentTotalNetSales() {
    return genClient.cacheValueIsNotNull(CacheKey.percentTotalNetSales);
  }

  /** Checks whether the 'partialRefundAmount' field is set and is not null */
  public boolean isNotNullPartialRefundAmount() {
    return genClient.cacheValueIsNotNull(CacheKey.partialRefundAmount);
  }

  /** Checks whether the 'partialRefundRepaymentAmount' field is set and is not null */
  public boolean isNotNullPartialRefundRepaymentAmount() {
    return genClient.cacheValueIsNotNull(CacheKey.partialRefundRepaymentAmount);
  }

  /** Checks whether the 'category' field is set and is not null */
  public boolean isNotNullCategory() {
    return genClient.cacheValueIsNotNull(CacheKey.category);
  }

  /** Checks whether the 'segmentLabel' field is set and is not null */
  public boolean isNotNullSegmentLabel() {
    return genClient.cacheValueIsNotNull(CacheKey.segmentLabel);
  }

  /** Checks whether the 'startTimestamp' field is set and is not null */
  public boolean isNotNullStartTimestamp() {
    return genClient.cacheValueIsNotNull(CacheKey.startTimestamp);
  }

  /** Checks whether the 'endTimestamp' field is set and is not null */
  public boolean isNotNullEndTimestamp() {
    return genClient.cacheValueIsNotNull(CacheKey.endTimestamp);
  }

  /** Checks whether the 'changeInNetSales' field is set and is not null */
  public boolean isNotNullChangeInNetSales() {
    return genClient.cacheValueIsNotNull(CacheKey.changeInNetSales);
  }

  /** Checks whether the 'changeInNetNumberSold' field is set and is not null */
  public boolean isNotNullChangeInNetNumberSold() {
    return genClient.cacheValueIsNotNull(CacheKey.changeInNetNumberSold);
  }

  /** Checks whether the 'isRevenue' field is set and is not null */
  public boolean isNotNullIsRevenue() {
    return genClient.cacheValueIsNotNull(CacheKey.isRevenue);
  }



  /** Checks whether the 'id' field has been set, however the value could be null */
  public boolean hasId() {
    return genClient.cacheHasKey(CacheKey.id);
  }

  /** Checks whether the 'name' field has been set, however the value could be null */
  public boolean hasName() {
    return genClient.cacheHasKey(CacheKey.name);
  }

  /** Checks whether the 'numberSold' field has been set, however the value could be null */
  public boolean hasNumberSold() {
    return genClient.cacheHasKey(CacheKey.numberSold);
  }

  /** Checks whether the 'revenueSold' field has been set, however the value could be null */
  public boolean hasRevenueSold() {
    return genClient.cacheHasKey(CacheKey.revenueSold);
  }

  /** Checks whether the 'numNonRevenueSold' field has been set, however the value could be null */
  public boolean hasNumNonRevenueSold() {
    return genClient.cacheHasKey(CacheKey.numNonRevenueSold);
  }

  /** Checks whether the 'priceSold' field has been set, however the value could be null */
  public boolean hasPriceSold() {
    return genClient.cacheHasKey(CacheKey.priceSold);
  }

  /** Checks whether the 'numRefunds' field has been set, however the value could be null */
  public boolean hasNumRefunds() {
    return genClient.cacheHasKey(CacheKey.numRefunds);
  }

  /** Checks whether the 'refundAmount' field has been set, however the value could be null */
  public boolean hasRefundAmount() {
    return genClient.cacheHasKey(CacheKey.refundAmount);
  }

  /** Checks whether the 'refundAmountRegardlessOfRepayment' field has been set, however the value could be null */
  public boolean hasRefundAmountRegardlessOfRepayment() {
    return genClient.cacheHasKey(CacheKey.refundAmountRegardlessOfRepayment);
  }

  /** Checks whether the 'refundAmountRegardlessOfRepaymentFractionalCents' field has been set, however the value could be null */
  public boolean hasRefundAmountRegardlessOfRepaymentFractionalCents() {
    return genClient.cacheHasKey(CacheKey.refundAmountRegardlessOfRepaymentFractionalCents);
  }

  /** Checks whether the 'refundRepaymentAmount' field has been set, however the value could be null */
  public boolean hasRefundRepaymentAmount() {
    return genClient.cacheHasKey(CacheKey.refundRepaymentAmount);
  }

  /** Checks whether the 'refundRepaymentAmountFractionalCents' field has been set, however the value could be null */
  public boolean hasRefundRepaymentAmountFractionalCents() {
    return genClient.cacheHasKey(CacheKey.refundRepaymentAmountFractionalCents);
  }

  /** Checks whether the 'numExchanges' field has been set, however the value could be null */
  public boolean hasNumExchanges() {
    return genClient.cacheHasKey(CacheKey.numExchanges);
  }

  /** Checks whether the 'exchangeAmount' field has been set, however the value could be null */
  public boolean hasExchangeAmount() {
    return genClient.cacheHasKey(CacheKey.exchangeAmount);
  }

  /** Checks whether the 'inACategory' field has been set, however the value could be null */
  public boolean hasInACategory() {
    return genClient.cacheHasKey(CacheKey.inACategory);
  }

  /** Checks whether the 'inventoryItem' field has been set, however the value could be null */
  public boolean hasInventoryItem() {
    return genClient.cacheHasKey(CacheKey.inventoryItem);
  }

  /** Checks whether the 'discountSales' field has been set, however the value could be null */
  public boolean hasDiscountSales() {
    return genClient.cacheHasKey(CacheKey.discountSales);
  }

  /** Checks whether the 'orderLevelDiscounts' field has been set, however the value could be null */
  public boolean hasOrderLevelDiscounts() {
    return genClient.cacheHasKey(CacheKey.orderLevelDiscounts);
  }

  /** Checks whether the 'labels' field has been set, however the value could be null */
  public boolean hasLabels() {
    return genClient.cacheHasKey(CacheKey.labels);
  }

  /** Checks whether the 'categories' field has been set, however the value could be null */
  public boolean hasCategories() {
    return genClient.cacheHasKey(CacheKey.categories);
  }

  /** Checks whether the 'deletedCategories' field has been set, however the value could be null */
  public boolean hasDeletedCategories() {
    return genClient.cacheHasKey(CacheKey.deletedCategories);
  }

  /** Checks whether the 'modifierSales' field has been set, however the value could be null */
  public boolean hasModifierSales() {
    return genClient.cacheHasKey(CacheKey.modifierSales);
  }

  /** Checks whether the 'grossModifierSales' field has been set, however the value could be null */
  public boolean hasGrossModifierSales() {
    return genClient.cacheHasKey(CacheKey.grossModifierSales);
  }

  /** Checks whether the 'totalDiscounts' field has been set, however the value could be null */
  public boolean hasTotalDiscounts() {
    return genClient.cacheHasKey(CacheKey.totalDiscounts);
  }

  /** Checks whether the 'totalDiscountsFractionalCents' field has been set, however the value could be null */
  public boolean hasTotalDiscountsFractionalCents() {
    return genClient.cacheHasKey(CacheKey.totalDiscountsFractionalCents);
  }

  /** Checks whether the 'netNumberSold' field has been set, however the value could be null */
  public boolean hasNetNumberSold() {
    return genClient.cacheHasKey(CacheKey.netNumberSold);
  }

  /** Checks whether the 'grossItemSales' field has been set, however the value could be null */
  public boolean hasGrossItemSales() {
    return genClient.cacheHasKey(CacheKey.grossItemSales);
  }

  /** Checks whether the 'grossSales' field has been set, however the value could be null */
  public boolean hasGrossSales() {
    return genClient.cacheHasKey(CacheKey.grossSales);
  }

  /** Checks whether the 'netItemSales' field has been set, however the value could be null */
  public boolean hasNetItemSales() {
    return genClient.cacheHasKey(CacheKey.netItemSales);
  }

  /** Checks whether the 'netItemSalesFractionalCents' field has been set, however the value could be null */
  public boolean hasNetItemSalesFractionalCents() {
    return genClient.cacheHasKey(CacheKey.netItemSalesFractionalCents);
  }

  /** Checks whether the 'netModifierSales' field has been set, however the value could be null */
  public boolean hasNetModifierSales() {
    return genClient.cacheHasKey(CacheKey.netModifierSales);
  }

  /** Checks whether the 'netModifierSalesFractionalCents' field has been set, however the value could be null */
  public boolean hasNetModifierSalesFractionalCents() {
    return genClient.cacheHasKey(CacheKey.netModifierSalesFractionalCents);
  }

  /** Checks whether the 'netSales' field has been set, however the value could be null */
  public boolean hasNetSales() {
    return genClient.cacheHasKey(CacheKey.netSales);
  }

  /** Checks whether the 'netSalesFractionalCents' field has been set, however the value could be null */
  public boolean hasNetSalesFractionalCents() {
    return genClient.cacheHasKey(CacheKey.netSalesFractionalCents);
  }

  /** Checks whether the 'costOfGoodsSold' field has been set, however the value could be null */
  public boolean hasCostOfGoodsSold() {
    return genClient.cacheHasKey(CacheKey.costOfGoodsSold);
  }

  /** Checks whether the 'grossProfit' field has been set, however the value could be null */
  public boolean hasGrossProfit() {
    return genClient.cacheHasKey(CacheKey.grossProfit);
  }

  /** Checks whether the 'grossProfitMargin' field has been set, however the value could be null */
  public boolean hasGrossProfitMargin() {
    return genClient.cacheHasKey(CacheKey.grossProfitMargin);
  }

  /** Checks whether the 'averageNetSales' field has been set, however the value could be null */
  public boolean hasAverageNetSales() {
    return genClient.cacheHasKey(CacheKey.averageNetSales);
  }

  /** Checks whether the 'percentTotalNetSales' field has been set, however the value could be null */
  public boolean hasPercentTotalNetSales() {
    return genClient.cacheHasKey(CacheKey.percentTotalNetSales);
  }

  /** Checks whether the 'partialRefundAmount' field has been set, however the value could be null */
  public boolean hasPartialRefundAmount() {
    return genClient.cacheHasKey(CacheKey.partialRefundAmount);
  }

  /** Checks whether the 'partialRefundRepaymentAmount' field has been set, however the value could be null */
  public boolean hasPartialRefundRepaymentAmount() {
    return genClient.cacheHasKey(CacheKey.partialRefundRepaymentAmount);
  }

  /** Checks whether the 'category' field has been set, however the value could be null */
  public boolean hasCategory() {
    return genClient.cacheHasKey(CacheKey.category);
  }

  /** Checks whether the 'segmentLabel' field has been set, however the value could be null */
  public boolean hasSegmentLabel() {
    return genClient.cacheHasKey(CacheKey.segmentLabel);
  }

  /** Checks whether the 'startTimestamp' field has been set, however the value could be null */
  public boolean hasStartTimestamp() {
    return genClient.cacheHasKey(CacheKey.startTimestamp);
  }

  /** Checks whether the 'endTimestamp' field has been set, however the value could be null */
  public boolean hasEndTimestamp() {
    return genClient.cacheHasKey(CacheKey.endTimestamp);
  }

  /** Checks whether the 'changeInNetSales' field has been set, however the value could be null */
  public boolean hasChangeInNetSales() {
    return genClient.cacheHasKey(CacheKey.changeInNetSales);
  }

  /** Checks whether the 'changeInNetNumberSold' field has been set, however the value could be null */
  public boolean hasChangeInNetNumberSold() {
    return genClient.cacheHasKey(CacheKey.changeInNetNumberSold);
  }

  /** Checks whether the 'isRevenue' field has been set, however the value could be null */
  public boolean hasIsRevenue() {
    return genClient.cacheHasKey(CacheKey.isRevenue);
  }


  /**
   * Sets the field 'id'.
   */
  public ReportItem setId(java.lang.String id) {
    return genClient.setOther(id, CacheKey.id);
  }

  /**
   * Sets the field 'name'.
   */
  public ReportItem setName(java.lang.String name) {
    return genClient.setOther(name, CacheKey.name);
  }

  /**
   * Sets the field 'numberSold'.
   */
  public ReportItem setNumberSold(java.lang.Double numberSold) {
    return genClient.setOther(numberSold, CacheKey.numberSold);
  }

  /**
   * Sets the field 'revenueSold'.
   */
  public ReportItem setRevenueSold(java.lang.Long revenueSold) {
    return genClient.setOther(revenueSold, CacheKey.revenueSold);
  }

  /**
   * Sets the field 'numNonRevenueSold'.
   */
  public ReportItem setNumNonRevenueSold(java.lang.Double numNonRevenueSold) {
    return genClient.setOther(numNonRevenueSold, CacheKey.numNonRevenueSold);
  }

  /**
   * Sets the field 'priceSold'.
   */
  public ReportItem setPriceSold(java.lang.Double priceSold) {
    return genClient.setOther(priceSold, CacheKey.priceSold);
  }

  /**
   * Sets the field 'numRefunds'.
   */
  public ReportItem setNumRefunds(java.lang.Double numRefunds) {
    return genClient.setOther(numRefunds, CacheKey.numRefunds);
  }

  /**
   * Sets the field 'refundAmount'.
   */
  public ReportItem setRefundAmount(java.lang.Long refundAmount) {
    return genClient.setOther(refundAmount, CacheKey.refundAmount);
  }

  /**
   * Sets the field 'refundAmountRegardlessOfRepayment'.
   */
  public ReportItem setRefundAmountRegardlessOfRepayment(java.lang.Long refundAmountRegardlessOfRepayment) {
    return genClient.setOther(refundAmountRegardlessOfRepayment, CacheKey.refundAmountRegardlessOfRepayment);
  }

  /**
   * Sets the field 'refundAmountRegardlessOfRepaymentFractionalCents'.
   */
  public ReportItem setRefundAmountRegardlessOfRepaymentFractionalCents(java.lang.Double refundAmountRegardlessOfRepaymentFractionalCents) {
    return genClient.setOther(refundAmountRegardlessOfRepaymentFractionalCents, CacheKey.refundAmountRegardlessOfRepaymentFractionalCents);
  }

  /**
   * Sets the field 'refundRepaymentAmount'.
   */
  public ReportItem setRefundRepaymentAmount(java.lang.Long refundRepaymentAmount) {
    return genClient.setOther(refundRepaymentAmount, CacheKey.refundRepaymentAmount);
  }

  /**
   * Sets the field 'refundRepaymentAmountFractionalCents'.
   */
  public ReportItem setRefundRepaymentAmountFractionalCents(java.lang.Double refundRepaymentAmountFractionalCents) {
    return genClient.setOther(refundRepaymentAmountFractionalCents, CacheKey.refundRepaymentAmountFractionalCents);
  }

  /**
   * Sets the field 'numExchanges'.
   */
  public ReportItem setNumExchanges(java.lang.Double numExchanges) {
    return genClient.setOther(numExchanges, CacheKey.numExchanges);
  }

  /**
   * Sets the field 'exchangeAmount'.
   */
  public ReportItem setExchangeAmount(java.lang.Long exchangeAmount) {
    return genClient.setOther(exchangeAmount, CacheKey.exchangeAmount);
  }

  /**
   * Sets the field 'inACategory'.
   */
  public ReportItem setInACategory(java.lang.Boolean inACategory) {
    return genClient.setOther(inACategory, CacheKey.inACategory);
  }

  /**
   * Sets the field 'inventoryItem'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public ReportItem setInventoryItem(com.clover.sdk.v3.inventory.Item inventoryItem) {
    return genClient.setRecord(inventoryItem, CacheKey.inventoryItem);
  }

  /**
   * Sets the field 'discountSales'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public ReportItem setDiscountSales(java.util.List<com.clover.sdk.v3.report.BaseSale> discountSales) {
    return genClient.setArrayRecord(discountSales, CacheKey.discountSales);
  }

  /**
   * Sets the field 'orderLevelDiscounts'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public ReportItem setOrderLevelDiscounts(java.util.List<com.clover.sdk.v3.report.BaseSale> orderLevelDiscounts) {
    return genClient.setArrayRecord(orderLevelDiscounts, CacheKey.orderLevelDiscounts);
  }

  /**
   * Sets the field 'labels'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public ReportItem setLabels(java.util.List<com.clover.sdk.v3.report.ReportLabel> labels) {
    return genClient.setArrayRecord(labels, CacheKey.labels);
  }

  /**
   * Sets the field 'categories'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public ReportItem setCategories(java.util.List<com.clover.sdk.v3.report.ItemSalesBucket> categories) {
    return genClient.setArrayRecord(categories, CacheKey.categories);
  }

  /**
   * Sets the field 'deletedCategories'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public ReportItem setDeletedCategories(java.util.List<com.clover.sdk.v3.report.ItemSalesBucket> deletedCategories) {
    return genClient.setArrayRecord(deletedCategories, CacheKey.deletedCategories);
  }

  /**
   * Sets the field 'modifierSales'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public ReportItem setModifierSales(java.util.List<com.clover.sdk.v3.report.BaseSale> modifierSales) {
    return genClient.setArrayRecord(modifierSales, CacheKey.modifierSales);
  }

  /**
   * Sets the field 'grossModifierSales'.
   */
  public ReportItem setGrossModifierSales(java.lang.Long grossModifierSales) {
    return genClient.setOther(grossModifierSales, CacheKey.grossModifierSales);
  }

  /**
   * Sets the field 'totalDiscounts'.
   */
  public ReportItem setTotalDiscounts(java.lang.Long totalDiscounts) {
    return genClient.setOther(totalDiscounts, CacheKey.totalDiscounts);
  }

  /**
   * Sets the field 'totalDiscountsFractionalCents'.
   */
  public ReportItem setTotalDiscountsFractionalCents(java.lang.Double totalDiscountsFractionalCents) {
    return genClient.setOther(totalDiscountsFractionalCents, CacheKey.totalDiscountsFractionalCents);
  }

  /**
   * Sets the field 'netNumberSold'.
   */
  public ReportItem setNetNumberSold(java.lang.Double netNumberSold) {
    return genClient.setOther(netNumberSold, CacheKey.netNumberSold);
  }

  /**
   * Sets the field 'grossItemSales'.
   */
  public ReportItem setGrossItemSales(java.lang.Long grossItemSales) {
    return genClient.setOther(grossItemSales, CacheKey.grossItemSales);
  }

  /**
   * Sets the field 'grossSales'.
   */
  public ReportItem setGrossSales(java.lang.Long grossSales) {
    return genClient.setOther(grossSales, CacheKey.grossSales);
  }

  /**
   * Sets the field 'netItemSales'.
   */
  public ReportItem setNetItemSales(java.lang.Long netItemSales) {
    return genClient.setOther(netItemSales, CacheKey.netItemSales);
  }

  /**
   * Sets the field 'netItemSalesFractionalCents'.
   */
  public ReportItem setNetItemSalesFractionalCents(java.lang.Double netItemSalesFractionalCents) {
    return genClient.setOther(netItemSalesFractionalCents, CacheKey.netItemSalesFractionalCents);
  }

  /**
   * Sets the field 'netModifierSales'.
   */
  public ReportItem setNetModifierSales(java.lang.Long netModifierSales) {
    return genClient.setOther(netModifierSales, CacheKey.netModifierSales);
  }

  /**
   * Sets the field 'netModifierSalesFractionalCents'.
   */
  public ReportItem setNetModifierSalesFractionalCents(java.lang.Double netModifierSalesFractionalCents) {
    return genClient.setOther(netModifierSalesFractionalCents, CacheKey.netModifierSalesFractionalCents);
  }

  /**
   * Sets the field 'netSales'.
   */
  public ReportItem setNetSales(java.lang.Long netSales) {
    return genClient.setOther(netSales, CacheKey.netSales);
  }

  /**
   * Sets the field 'netSalesFractionalCents'.
   */
  public ReportItem setNetSalesFractionalCents(java.lang.Double netSalesFractionalCents) {
    return genClient.setOther(netSalesFractionalCents, CacheKey.netSalesFractionalCents);
  }

  /**
   * Sets the field 'costOfGoodsSold'.
   */
  public ReportItem setCostOfGoodsSold(java.lang.Long costOfGoodsSold) {
    return genClient.setOther(costOfGoodsSold, CacheKey.costOfGoodsSold);
  }

  /**
   * Sets the field 'grossProfit'.
   */
  public ReportItem setGrossProfit(java.lang.Long grossProfit) {
    return genClient.setOther(grossProfit, CacheKey.grossProfit);
  }

  /**
   * Sets the field 'grossProfitMargin'.
   */
  public ReportItem setGrossProfitMargin(java.lang.Double grossProfitMargin) {
    return genClient.setOther(grossProfitMargin, CacheKey.grossProfitMargin);
  }

  /**
   * Sets the field 'averageNetSales'.
   */
  public ReportItem setAverageNetSales(java.lang.Long averageNetSales) {
    return genClient.setOther(averageNetSales, CacheKey.averageNetSales);
  }

  /**
   * Sets the field 'percentTotalNetSales'.
   */
  public ReportItem setPercentTotalNetSales(java.lang.Double percentTotalNetSales) {
    return genClient.setOther(percentTotalNetSales, CacheKey.percentTotalNetSales);
  }

  /**
   * Sets the field 'partialRefundAmount'.
   */
  public ReportItem setPartialRefundAmount(java.lang.Long partialRefundAmount) {
    return genClient.setOther(partialRefundAmount, CacheKey.partialRefundAmount);
  }

  /**
   * Sets the field 'partialRefundRepaymentAmount'.
   */
  public ReportItem setPartialRefundRepaymentAmount(java.lang.Long partialRefundRepaymentAmount) {
    return genClient.setOther(partialRefundRepaymentAmount, CacheKey.partialRefundRepaymentAmount);
  }

  /**
   * Sets the field 'category'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public ReportItem setCategory(com.clover.sdk.v3.report.ItemSalesBucket category) {
    return genClient.setRecord(category, CacheKey.category);
  }

  /**
   * Sets the field 'segmentLabel'.
   */
  public ReportItem setSegmentLabel(java.lang.Integer segmentLabel) {
    return genClient.setOther(segmentLabel, CacheKey.segmentLabel);
  }

  /**
   * Sets the field 'startTimestamp'.
   */
  public ReportItem setStartTimestamp(java.lang.Long startTimestamp) {
    return genClient.setOther(startTimestamp, CacheKey.startTimestamp);
  }

  /**
   * Sets the field 'endTimestamp'.
   */
  public ReportItem setEndTimestamp(java.lang.Long endTimestamp) {
    return genClient.setOther(endTimestamp, CacheKey.endTimestamp);
  }

  /**
   * Sets the field 'changeInNetSales'.
   */
  public ReportItem setChangeInNetSales(java.lang.Double changeInNetSales) {
    return genClient.setOther(changeInNetSales, CacheKey.changeInNetSales);
  }

  /**
   * Sets the field 'changeInNetNumberSold'.
   */
  public ReportItem setChangeInNetNumberSold(java.lang.Double changeInNetNumberSold) {
    return genClient.setOther(changeInNetNumberSold, CacheKey.changeInNetNumberSold);
  }

  /**
   * Sets the field 'isRevenue'.
   */
  public ReportItem setIsRevenue(java.lang.Boolean isRevenue) {
    return genClient.setOther(isRevenue, CacheKey.isRevenue);
  }


  /** Clears the 'id' field, the 'has' method for this field will now return false */
  public void clearId() {
    genClient.clear(CacheKey.id);
  }
  /** Clears the 'name' field, the 'has' method for this field will now return false */
  public void clearName() {
    genClient.clear(CacheKey.name);
  }
  /** Clears the 'numberSold' field, the 'has' method for this field will now return false */
  public void clearNumberSold() {
    genClient.clear(CacheKey.numberSold);
  }
  /** Clears the 'revenueSold' field, the 'has' method for this field will now return false */
  public void clearRevenueSold() {
    genClient.clear(CacheKey.revenueSold);
  }
  /** Clears the 'numNonRevenueSold' field, the 'has' method for this field will now return false */
  public void clearNumNonRevenueSold() {
    genClient.clear(CacheKey.numNonRevenueSold);
  }
  /** Clears the 'priceSold' field, the 'has' method for this field will now return false */
  public void clearPriceSold() {
    genClient.clear(CacheKey.priceSold);
  }
  /** Clears the 'numRefunds' field, the 'has' method for this field will now return false */
  public void clearNumRefunds() {
    genClient.clear(CacheKey.numRefunds);
  }
  /** Clears the 'refundAmount' field, the 'has' method for this field will now return false */
  public void clearRefundAmount() {
    genClient.clear(CacheKey.refundAmount);
  }
  /** Clears the 'refundAmountRegardlessOfRepayment' field, the 'has' method for this field will now return false */
  public void clearRefundAmountRegardlessOfRepayment() {
    genClient.clear(CacheKey.refundAmountRegardlessOfRepayment);
  }
  /** Clears the 'refundAmountRegardlessOfRepaymentFractionalCents' field, the 'has' method for this field will now return false */
  public void clearRefundAmountRegardlessOfRepaymentFractionalCents() {
    genClient.clear(CacheKey.refundAmountRegardlessOfRepaymentFractionalCents);
  }
  /** Clears the 'refundRepaymentAmount' field, the 'has' method for this field will now return false */
  public void clearRefundRepaymentAmount() {
    genClient.clear(CacheKey.refundRepaymentAmount);
  }
  /** Clears the 'refundRepaymentAmountFractionalCents' field, the 'has' method for this field will now return false */
  public void clearRefundRepaymentAmountFractionalCents() {
    genClient.clear(CacheKey.refundRepaymentAmountFractionalCents);
  }
  /** Clears the 'numExchanges' field, the 'has' method for this field will now return false */
  public void clearNumExchanges() {
    genClient.clear(CacheKey.numExchanges);
  }
  /** Clears the 'exchangeAmount' field, the 'has' method for this field will now return false */
  public void clearExchangeAmount() {
    genClient.clear(CacheKey.exchangeAmount);
  }
  /** Clears the 'inACategory' field, the 'has' method for this field will now return false */
  public void clearInACategory() {
    genClient.clear(CacheKey.inACategory);
  }
  /** Clears the 'inventoryItem' field, the 'has' method for this field will now return false */
  public void clearInventoryItem() {
    genClient.clear(CacheKey.inventoryItem);
  }
  /** Clears the 'discountSales' field, the 'has' method for this field will now return false */
  public void clearDiscountSales() {
    genClient.clear(CacheKey.discountSales);
  }
  /** Clears the 'orderLevelDiscounts' field, the 'has' method for this field will now return false */
  public void clearOrderLevelDiscounts() {
    genClient.clear(CacheKey.orderLevelDiscounts);
  }
  /** Clears the 'labels' field, the 'has' method for this field will now return false */
  public void clearLabels() {
    genClient.clear(CacheKey.labels);
  }
  /** Clears the 'categories' field, the 'has' method for this field will now return false */
  public void clearCategories() {
    genClient.clear(CacheKey.categories);
  }
  /** Clears the 'deletedCategories' field, the 'has' method for this field will now return false */
  public void clearDeletedCategories() {
    genClient.clear(CacheKey.deletedCategories);
  }
  /** Clears the 'modifierSales' field, the 'has' method for this field will now return false */
  public void clearModifierSales() {
    genClient.clear(CacheKey.modifierSales);
  }
  /** Clears the 'grossModifierSales' field, the 'has' method for this field will now return false */
  public void clearGrossModifierSales() {
    genClient.clear(CacheKey.grossModifierSales);
  }
  /** Clears the 'totalDiscounts' field, the 'has' method for this field will now return false */
  public void clearTotalDiscounts() {
    genClient.clear(CacheKey.totalDiscounts);
  }
  /** Clears the 'totalDiscountsFractionalCents' field, the 'has' method for this field will now return false */
  public void clearTotalDiscountsFractionalCents() {
    genClient.clear(CacheKey.totalDiscountsFractionalCents);
  }
  /** Clears the 'netNumberSold' field, the 'has' method for this field will now return false */
  public void clearNetNumberSold() {
    genClient.clear(CacheKey.netNumberSold);
  }
  /** Clears the 'grossItemSales' field, the 'has' method for this field will now return false */
  public void clearGrossItemSales() {
    genClient.clear(CacheKey.grossItemSales);
  }
  /** Clears the 'grossSales' field, the 'has' method for this field will now return false */
  public void clearGrossSales() {
    genClient.clear(CacheKey.grossSales);
  }
  /** Clears the 'netItemSales' field, the 'has' method for this field will now return false */
  public void clearNetItemSales() {
    genClient.clear(CacheKey.netItemSales);
  }
  /** Clears the 'netItemSalesFractionalCents' field, the 'has' method for this field will now return false */
  public void clearNetItemSalesFractionalCents() {
    genClient.clear(CacheKey.netItemSalesFractionalCents);
  }
  /** Clears the 'netModifierSales' field, the 'has' method for this field will now return false */
  public void clearNetModifierSales() {
    genClient.clear(CacheKey.netModifierSales);
  }
  /** Clears the 'netModifierSalesFractionalCents' field, the 'has' method for this field will now return false */
  public void clearNetModifierSalesFractionalCents() {
    genClient.clear(CacheKey.netModifierSalesFractionalCents);
  }
  /** Clears the 'netSales' field, the 'has' method for this field will now return false */
  public void clearNetSales() {
    genClient.clear(CacheKey.netSales);
  }
  /** Clears the 'netSalesFractionalCents' field, the 'has' method for this field will now return false */
  public void clearNetSalesFractionalCents() {
    genClient.clear(CacheKey.netSalesFractionalCents);
  }
  /** Clears the 'costOfGoodsSold' field, the 'has' method for this field will now return false */
  public void clearCostOfGoodsSold() {
    genClient.clear(CacheKey.costOfGoodsSold);
  }
  /** Clears the 'grossProfit' field, the 'has' method for this field will now return false */
  public void clearGrossProfit() {
    genClient.clear(CacheKey.grossProfit);
  }
  /** Clears the 'grossProfitMargin' field, the 'has' method for this field will now return false */
  public void clearGrossProfitMargin() {
    genClient.clear(CacheKey.grossProfitMargin);
  }
  /** Clears the 'averageNetSales' field, the 'has' method for this field will now return false */
  public void clearAverageNetSales() {
    genClient.clear(CacheKey.averageNetSales);
  }
  /** Clears the 'percentTotalNetSales' field, the 'has' method for this field will now return false */
  public void clearPercentTotalNetSales() {
    genClient.clear(CacheKey.percentTotalNetSales);
  }
  /** Clears the 'partialRefundAmount' field, the 'has' method for this field will now return false */
  public void clearPartialRefundAmount() {
    genClient.clear(CacheKey.partialRefundAmount);
  }
  /** Clears the 'partialRefundRepaymentAmount' field, the 'has' method for this field will now return false */
  public void clearPartialRefundRepaymentAmount() {
    genClient.clear(CacheKey.partialRefundRepaymentAmount);
  }
  /** Clears the 'category' field, the 'has' method for this field will now return false */
  public void clearCategory() {
    genClient.clear(CacheKey.category);
  }
  /** Clears the 'segmentLabel' field, the 'has' method for this field will now return false */
  public void clearSegmentLabel() {
    genClient.clear(CacheKey.segmentLabel);
  }
  /** Clears the 'startTimestamp' field, the 'has' method for this field will now return false */
  public void clearStartTimestamp() {
    genClient.clear(CacheKey.startTimestamp);
  }
  /** Clears the 'endTimestamp' field, the 'has' method for this field will now return false */
  public void clearEndTimestamp() {
    genClient.clear(CacheKey.endTimestamp);
  }
  /** Clears the 'changeInNetSales' field, the 'has' method for this field will now return false */
  public void clearChangeInNetSales() {
    genClient.clear(CacheKey.changeInNetSales);
  }
  /** Clears the 'changeInNetNumberSold' field, the 'has' method for this field will now return false */
  public void clearChangeInNetNumberSold() {
    genClient.clear(CacheKey.changeInNetNumberSold);
  }
  /** Clears the 'isRevenue' field, the 'has' method for this field will now return false */
  public void clearIsRevenue() {
    genClient.clear(CacheKey.isRevenue);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public ReportItem copyChanges() {
    ReportItem copy = new ReportItem();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(ReportItem src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new ReportItem(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<ReportItem> CREATOR = new android.os.Parcelable.Creator<ReportItem>() {
    @Override
    public ReportItem createFromParcel(android.os.Parcel in) {
      ReportItem instance = new ReportItem(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public ReportItem[] newArray(int size) {
      return new ReportItem[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<ReportItem> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<ReportItem>() {
    public Class<ReportItem> getCreatedClass() {
      return ReportItem.class;
    }

    @Override
    public ReportItem create(org.json.JSONObject jsonObject) {
      return new ReportItem(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean ID_IS_REQUIRED = false;
    public static final boolean NAME_IS_REQUIRED = false;
    public static final long NAME_MAX_LEN = 255;
    public static final boolean NUMBERSOLD_IS_REQUIRED = false;
    public static final boolean REVENUESOLD_IS_REQUIRED = false;
    public static final boolean NUMNONREVENUESOLD_IS_REQUIRED = false;
    public static final boolean PRICESOLD_IS_REQUIRED = false;
    public static final boolean NUMREFUNDS_IS_REQUIRED = false;
    public static final boolean REFUNDAMOUNT_IS_REQUIRED = false;
    public static final boolean REFUNDAMOUNTREGARDLESSOFREPAYMENT_IS_REQUIRED = false;
    public static final boolean REFUNDAMOUNTREGARDLESSOFREPAYMENTFRACTIONALCENTS_IS_REQUIRED = false;
    public static final boolean REFUNDREPAYMENTAMOUNT_IS_REQUIRED = false;
    public static final boolean REFUNDREPAYMENTAMOUNTFRACTIONALCENTS_IS_REQUIRED = false;
    public static final boolean NUMEXCHANGES_IS_REQUIRED = false;
    public static final boolean EXCHANGEAMOUNT_IS_REQUIRED = false;
    public static final boolean INACATEGORY_IS_REQUIRED = false;
    public static final boolean INVENTORYITEM_IS_REQUIRED = false;
    public static final boolean DISCOUNTSALES_IS_REQUIRED = false;
    public static final boolean ORDERLEVELDISCOUNTS_IS_REQUIRED = false;
    public static final boolean LABELS_IS_REQUIRED = false;
    public static final boolean CATEGORIES_IS_REQUIRED = false;
    public static final boolean DELETEDCATEGORIES_IS_REQUIRED = false;
    public static final boolean MODIFIERSALES_IS_REQUIRED = false;
    public static final boolean GROSSMODIFIERSALES_IS_REQUIRED = false;
    public static final boolean TOTALDISCOUNTS_IS_REQUIRED = false;
    public static final boolean TOTALDISCOUNTSFRACTIONALCENTS_IS_REQUIRED = false;
    public static final boolean NETNUMBERSOLD_IS_REQUIRED = false;
    public static final boolean GROSSITEMSALES_IS_REQUIRED = false;
    public static final boolean GROSSSALES_IS_REQUIRED = false;
    public static final boolean NETITEMSALES_IS_REQUIRED = false;
    public static final boolean NETITEMSALESFRACTIONALCENTS_IS_REQUIRED = false;
    public static final boolean NETMODIFIERSALES_IS_REQUIRED = false;
    public static final boolean NETMODIFIERSALESFRACTIONALCENTS_IS_REQUIRED = false;
    public static final boolean NETSALES_IS_REQUIRED = false;
    public static final boolean NETSALESFRACTIONALCENTS_IS_REQUIRED = false;
    public static final boolean COSTOFGOODSSOLD_IS_REQUIRED = false;
    public static final boolean GROSSPROFIT_IS_REQUIRED = false;
    public static final boolean GROSSPROFITMARGIN_IS_REQUIRED = false;
    public static final boolean AVERAGENETSALES_IS_REQUIRED = false;
    public static final boolean PERCENTTOTALNETSALES_IS_REQUIRED = false;
    public static final boolean PARTIALREFUNDAMOUNT_IS_REQUIRED = false;
    public static final boolean PARTIALREFUNDREPAYMENTAMOUNT_IS_REQUIRED = false;
    public static final boolean CATEGORY_IS_REQUIRED = false;
    public static final boolean SEGMENTLABEL_IS_REQUIRED = false;
    public static final boolean STARTTIMESTAMP_IS_REQUIRED = false;
    public static final boolean ENDTIMESTAMP_IS_REQUIRED = false;
    public static final boolean CHANGEINNETSALES_IS_REQUIRED = false;
    public static final boolean CHANGEINNETNUMBERSOLD_IS_REQUIRED = false;
    public static final boolean ISREVENUE_IS_REQUIRED = false;
  }

}
