/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.report;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * Combines a collection of rows with a total to form a section in the payments report
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getRows rows}</li>
 * <li>{@link #getTotal total}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class ReportPaymentsV2Section extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * The detail rows of a particular section of the payments report
   */
  public java.util.List<com.clover.sdk.v3.report.ReportPaymentsV2Row> getRows() {
    return genClient.cacheGet(CacheKey.rows);
  }

  /**
   * The sum of the above rows
   */
  public com.clover.sdk.v3.report.ReportPaymentsV2Row getTotal() {
    return genClient.cacheGet(CacheKey.total);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    rows
        (com.clover.sdk.extractors.RecordListExtractionStrategy.instance(com.clover.sdk.v3.report.ReportPaymentsV2Row.JSON_CREATOR)),
    total
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.report.ReportPaymentsV2Row.JSON_CREATOR)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<ReportPaymentsV2Section> genClient;

  /**
   * Constructs a new empty instance.
   */
  public ReportPaymentsV2Section() {
    genClient = new GenericClient<ReportPaymentsV2Section>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected ReportPaymentsV2Section(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public ReportPaymentsV2Section(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public ReportPaymentsV2Section(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public ReportPaymentsV2Section(ReportPaymentsV2Section src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
  }

  /** Checks whether the 'rows' field is set and is not null */
  public boolean isNotNullRows() {
    return genClient.cacheValueIsNotNull(CacheKey.rows);
  }

  /** Checks whether the 'rows' field is set and is not null and is not empty */
  public boolean isNotEmptyRows() { return isNotNullRows() && !getRows().isEmpty(); }

  /** Checks whether the 'total' field is set and is not null */
  public boolean isNotNullTotal() {
    return genClient.cacheValueIsNotNull(CacheKey.total);
  }



  /** Checks whether the 'rows' field has been set, however the value could be null */
  public boolean hasRows() {
    return genClient.cacheHasKey(CacheKey.rows);
  }

  /** Checks whether the 'total' field has been set, however the value could be null */
  public boolean hasTotal() {
    return genClient.cacheHasKey(CacheKey.total);
  }


  /**
   * Sets the field 'rows'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public ReportPaymentsV2Section setRows(java.util.List<com.clover.sdk.v3.report.ReportPaymentsV2Row> rows) {
    return genClient.setArrayRecord(rows, CacheKey.rows);
  }

  /**
   * Sets the field 'total'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public ReportPaymentsV2Section setTotal(com.clover.sdk.v3.report.ReportPaymentsV2Row total) {
    return genClient.setRecord(total, CacheKey.total);
  }


  /** Clears the 'rows' field, the 'has' method for this field will now return false */
  public void clearRows() {
    genClient.clear(CacheKey.rows);
  }
  /** Clears the 'total' field, the 'has' method for this field will now return false */
  public void clearTotal() {
    genClient.clear(CacheKey.total);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public ReportPaymentsV2Section copyChanges() {
    ReportPaymentsV2Section copy = new ReportPaymentsV2Section();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(ReportPaymentsV2Section src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new ReportPaymentsV2Section(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<ReportPaymentsV2Section> CREATOR = new android.os.Parcelable.Creator<ReportPaymentsV2Section>() {
    @Override
    public ReportPaymentsV2Section createFromParcel(android.os.Parcel in) {
      ReportPaymentsV2Section instance = new ReportPaymentsV2Section(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public ReportPaymentsV2Section[] newArray(int size) {
      return new ReportPaymentsV2Section[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<ReportPaymentsV2Section> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<ReportPaymentsV2Section>() {
    public Class<ReportPaymentsV2Section> getCreatedClass() {
      return ReportPaymentsV2Section.class;
    }

    @Override
    public ReportPaymentsV2Section create(org.json.JSONObject jsonObject) {
      return new ReportPaymentsV2Section(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean ROWS_IS_REQUIRED = false;
    public static final boolean TOTAL_IS_REQUIRED = false;
  }

}
