/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.report;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * Holds sales summaries with totals for the entire report period plus totals over an optional sub-period like day, week or month and also has returns the previous period.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getComparisonType comparisonType}</li>
 * <li>{@link #getCurrent current}</li>
 * <li>{@link #getPrevious previous}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class SalesBucketsWithComparison extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * The type of comparison requested by the client. One of NO_COMPARISON, PREVIOUS_PERIOD, SAME_PERIOD_LAST_WEEK, SAME_PERIOD_LAST_MONTH, SAME_PERIOD_LAST_YEAR
   */
  public com.clover.sdk.v3.report.ComparisonType getComparisonType() {
    return genClient.cacheGet(CacheKey.comparisonType);
  }

  /**
   * Sales for the requested report range plus, if requested, totals for each day, week or month in that range
   */
  public com.clover.sdk.v3.report.PaymentsAndNonRevenueGroupedOverTime getCurrent() {
    return genClient.cacheGet(CacheKey.current);
  }

  /**
   * Sales for the report range that precedes the current one, plus, if requested, totals for each day, week or month in that range
   */
  public com.clover.sdk.v3.report.PaymentsAndNonRevenueGroupedOverTime getPrevious() {
    return genClient.cacheGet(CacheKey.previous);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    comparisonType
        (com.clover.sdk.extractors.EnumExtractionStrategy.instance(com.clover.sdk.v3.report.ComparisonType.class)),
    current
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.report.PaymentsAndNonRevenueGroupedOverTime.JSON_CREATOR)),
    previous
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.report.PaymentsAndNonRevenueGroupedOverTime.JSON_CREATOR)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<SalesBucketsWithComparison> genClient;

  /**
   * Constructs a new empty instance.
   */
  public SalesBucketsWithComparison() {
    genClient = new GenericClient<SalesBucketsWithComparison>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected SalesBucketsWithComparison(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public SalesBucketsWithComparison(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public SalesBucketsWithComparison(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public SalesBucketsWithComparison(SalesBucketsWithComparison src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
  }

  /** Checks whether the 'comparisonType' field is set and is not null */
  public boolean isNotNullComparisonType() {
    return genClient.cacheValueIsNotNull(CacheKey.comparisonType);
  }

  /** Checks whether the 'current' field is set and is not null */
  public boolean isNotNullCurrent() {
    return genClient.cacheValueIsNotNull(CacheKey.current);
  }

  /** Checks whether the 'previous' field is set and is not null */
  public boolean isNotNullPrevious() {
    return genClient.cacheValueIsNotNull(CacheKey.previous);
  }



  /** Checks whether the 'comparisonType' field has been set, however the value could be null */
  public boolean hasComparisonType() {
    return genClient.cacheHasKey(CacheKey.comparisonType);
  }

  /** Checks whether the 'current' field has been set, however the value could be null */
  public boolean hasCurrent() {
    return genClient.cacheHasKey(CacheKey.current);
  }

  /** Checks whether the 'previous' field has been set, however the value could be null */
  public boolean hasPrevious() {
    return genClient.cacheHasKey(CacheKey.previous);
  }


  /**
   * Sets the field 'comparisonType'.
   */
  public SalesBucketsWithComparison setComparisonType(com.clover.sdk.v3.report.ComparisonType comparisonType) {
    return genClient.setOther(comparisonType, CacheKey.comparisonType);
  }

  /**
   * Sets the field 'current'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public SalesBucketsWithComparison setCurrent(com.clover.sdk.v3.report.PaymentsAndNonRevenueGroupedOverTime current) {
    return genClient.setRecord(current, CacheKey.current);
  }

  /**
   * Sets the field 'previous'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public SalesBucketsWithComparison setPrevious(com.clover.sdk.v3.report.PaymentsAndNonRevenueGroupedOverTime previous) {
    return genClient.setRecord(previous, CacheKey.previous);
  }


  /** Clears the 'comparisonType' field, the 'has' method for this field will now return false */
  public void clearComparisonType() {
    genClient.clear(CacheKey.comparisonType);
  }
  /** Clears the 'current' field, the 'has' method for this field will now return false */
  public void clearCurrent() {
    genClient.clear(CacheKey.current);
  }
  /** Clears the 'previous' field, the 'has' method for this field will now return false */
  public void clearPrevious() {
    genClient.clear(CacheKey.previous);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public SalesBucketsWithComparison copyChanges() {
    SalesBucketsWithComparison copy = new SalesBucketsWithComparison();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(SalesBucketsWithComparison src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new SalesBucketsWithComparison(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<SalesBucketsWithComparison> CREATOR = new android.os.Parcelable.Creator<SalesBucketsWithComparison>() {
    @Override
    public SalesBucketsWithComparison createFromParcel(android.os.Parcel in) {
      SalesBucketsWithComparison instance = new SalesBucketsWithComparison(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public SalesBucketsWithComparison[] newArray(int size) {
      return new SalesBucketsWithComparison[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<SalesBucketsWithComparison> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<SalesBucketsWithComparison>() {
    public Class<SalesBucketsWithComparison> getCreatedClass() {
      return SalesBucketsWithComparison.class;
    }

    @Override
    public SalesBucketsWithComparison create(org.json.JSONObject jsonObject) {
      return new SalesBucketsWithComparison(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean COMPARISONTYPE_IS_REQUIRED = false;
    public static final boolean CURRENT_IS_REQUIRED = false;
    public static final boolean PREVIOUS_IS_REQUIRED = false;
  }

}
