/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.report;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getRefundsTotal refundsTotal}</li>
 * <li>{@link #getDiscountsTotal discountsTotal}</li>
 * <li>{@link #getVoidedLineItemsTotal voidedLineItemsTotal}</li>
 * <li>{@link #getNetItemSales netItemSales}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class SummaryLineItems extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * net refunds - taxes refunded - tips refunded
   */
  public java.lang.Long getRefundsTotal() {
    return genClient.cacheGet(CacheKey.refundsTotal);
  }

  public java.lang.Long getDiscountsTotal() {
    return genClient.cacheGet(CacheKey.discountsTotal);
  }

  /**
   * Total value of line items removed from orders
   */
  public java.lang.Long getVoidedLineItemsTotal() {
    return genClient.cacheGet(CacheKey.voidedLineItemsTotal);
  }

  /**
   * Payment summary: original item revenue - taxes - tips - refunds - discounts + modifiers
   */
  public java.lang.Long getNetItemSales() {
    return genClient.cacheGet(CacheKey.netItemSales);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    refundsTotal
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    discountsTotal
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    voidedLineItemsTotal
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    netItemSales
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<SummaryLineItems> genClient;

  /**
   * Constructs a new empty instance.
   */
  public SummaryLineItems() {
    genClient = new GenericClient<SummaryLineItems>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected SummaryLineItems(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public SummaryLineItems(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public SummaryLineItems(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public SummaryLineItems(SummaryLineItems src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
  }

  /** Checks whether the 'refundsTotal' field is set and is not null */
  public boolean isNotNullRefundsTotal() {
    return genClient.cacheValueIsNotNull(CacheKey.refundsTotal);
  }

  /** Checks whether the 'discountsTotal' field is set and is not null */
  public boolean isNotNullDiscountsTotal() {
    return genClient.cacheValueIsNotNull(CacheKey.discountsTotal);
  }

  /** Checks whether the 'voidedLineItemsTotal' field is set and is not null */
  public boolean isNotNullVoidedLineItemsTotal() {
    return genClient.cacheValueIsNotNull(CacheKey.voidedLineItemsTotal);
  }

  /** Checks whether the 'netItemSales' field is set and is not null */
  public boolean isNotNullNetItemSales() {
    return genClient.cacheValueIsNotNull(CacheKey.netItemSales);
  }



  /** Checks whether the 'refundsTotal' field has been set, however the value could be null */
  public boolean hasRefundsTotal() {
    return genClient.cacheHasKey(CacheKey.refundsTotal);
  }

  /** Checks whether the 'discountsTotal' field has been set, however the value could be null */
  public boolean hasDiscountsTotal() {
    return genClient.cacheHasKey(CacheKey.discountsTotal);
  }

  /** Checks whether the 'voidedLineItemsTotal' field has been set, however the value could be null */
  public boolean hasVoidedLineItemsTotal() {
    return genClient.cacheHasKey(CacheKey.voidedLineItemsTotal);
  }

  /** Checks whether the 'netItemSales' field has been set, however the value could be null */
  public boolean hasNetItemSales() {
    return genClient.cacheHasKey(CacheKey.netItemSales);
  }


  /**
   * Sets the field 'refundsTotal'.
   */
  public SummaryLineItems setRefundsTotal(java.lang.Long refundsTotal) {
    return genClient.setOther(refundsTotal, CacheKey.refundsTotal);
  }

  /**
   * Sets the field 'discountsTotal'.
   */
  public SummaryLineItems setDiscountsTotal(java.lang.Long discountsTotal) {
    return genClient.setOther(discountsTotal, CacheKey.discountsTotal);
  }

  /**
   * Sets the field 'voidedLineItemsTotal'.
   */
  public SummaryLineItems setVoidedLineItemsTotal(java.lang.Long voidedLineItemsTotal) {
    return genClient.setOther(voidedLineItemsTotal, CacheKey.voidedLineItemsTotal);
  }

  /**
   * Sets the field 'netItemSales'.
   */
  public SummaryLineItems setNetItemSales(java.lang.Long netItemSales) {
    return genClient.setOther(netItemSales, CacheKey.netItemSales);
  }


  /** Clears the 'refundsTotal' field, the 'has' method for this field will now return false */
  public void clearRefundsTotal() {
    genClient.clear(CacheKey.refundsTotal);
  }
  /** Clears the 'discountsTotal' field, the 'has' method for this field will now return false */
  public void clearDiscountsTotal() {
    genClient.clear(CacheKey.discountsTotal);
  }
  /** Clears the 'voidedLineItemsTotal' field, the 'has' method for this field will now return false */
  public void clearVoidedLineItemsTotal() {
    genClient.clear(CacheKey.voidedLineItemsTotal);
  }
  /** Clears the 'netItemSales' field, the 'has' method for this field will now return false */
  public void clearNetItemSales() {
    genClient.clear(CacheKey.netItemSales);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public SummaryLineItems copyChanges() {
    SummaryLineItems copy = new SummaryLineItems();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(SummaryLineItems src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new SummaryLineItems(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<SummaryLineItems> CREATOR = new android.os.Parcelable.Creator<SummaryLineItems>() {
    @Override
    public SummaryLineItems createFromParcel(android.os.Parcel in) {
      SummaryLineItems instance = new SummaryLineItems(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public SummaryLineItems[] newArray(int size) {
      return new SummaryLineItems[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<SummaryLineItems> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<SummaryLineItems>() {
    public Class<SummaryLineItems> getCreatedClass() {
      return SummaryLineItems.class;
    }

    @Override
    public SummaryLineItems create(org.json.JSONObject jsonObject) {
      return new SummaryLineItems(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean REFUNDSTOTAL_IS_REQUIRED = false;
    public static final boolean DISCOUNTSTOTAL_IS_REQUIRED = false;
    public static final boolean VOIDEDLINEITEMSTOTAL_IS_REQUIRED = false;
    public static final boolean NETITEMSALES_IS_REQUIRED = false;
  }

}
