/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.report;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * Combines a collection of rows with a total to form a section in reporting API responses.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getRows rows}</li>
 * <li>{@link #getTotal total}</li>
 * <li>{@link #getMajorLabelsExist majorLabelsExist}</li>
 * <li>{@link #getPeriod period}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class SummarySection extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * The detail rows of a particular section of a reporting API response.
   */
  public java.util.List<com.clover.sdk.v3.report.Summary> getRows() {
    return genClient.cacheGet(CacheKey.rows);
  }

  /**
   * The sum of the above rows.
   */
  public com.clover.sdk.v3.report.Summary getTotal() {
    return genClient.cacheGet(CacheKey.total);
  }

  /**
   * Optional flag used for revenue class to indicate whether the merchant has any labels marked 'Show in Reporting?'.
   */
  public java.lang.Boolean getMajorLabelsExist() {
    return genClient.cacheGet(CacheKey.majorLabelsExist);
  }

  /**
   * The time period that defines the size of the groups: hour, day, week, month, ungrouped. In some contexts this section might have a different grouping size than the rest of the objects on the response.
   */
  public com.clover.sdk.v3.report.TimePeriod getPeriod() {
    return genClient.cacheGet(CacheKey.period);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    rows
        (com.clover.sdk.extractors.RecordListExtractionStrategy.instance(com.clover.sdk.v3.report.Summary.JSON_CREATOR)),
    total
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.report.Summary.JSON_CREATOR)),
    majorLabelsExist
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    period
        (com.clover.sdk.extractors.EnumExtractionStrategy.instance(com.clover.sdk.v3.report.TimePeriod.class)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<SummarySection> genClient;

  /**
   * Constructs a new empty instance.
   */
  public SummarySection() {
    genClient = new GenericClient<SummarySection>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected SummarySection(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public SummarySection(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public SummarySection(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public SummarySection(SummarySection src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
  }

  /** Checks whether the 'rows' field is set and is not null */
  public boolean isNotNullRows() {
    return genClient.cacheValueIsNotNull(CacheKey.rows);
  }

  /** Checks whether the 'rows' field is set and is not null and is not empty */
  public boolean isNotEmptyRows() { return isNotNullRows() && !getRows().isEmpty(); }

  /** Checks whether the 'total' field is set and is not null */
  public boolean isNotNullTotal() {
    return genClient.cacheValueIsNotNull(CacheKey.total);
  }

  /** Checks whether the 'majorLabelsExist' field is set and is not null */
  public boolean isNotNullMajorLabelsExist() {
    return genClient.cacheValueIsNotNull(CacheKey.majorLabelsExist);
  }

  /** Checks whether the 'period' field is set and is not null */
  public boolean isNotNullPeriod() {
    return genClient.cacheValueIsNotNull(CacheKey.period);
  }



  /** Checks whether the 'rows' field has been set, however the value could be null */
  public boolean hasRows() {
    return genClient.cacheHasKey(CacheKey.rows);
  }

  /** Checks whether the 'total' field has been set, however the value could be null */
  public boolean hasTotal() {
    return genClient.cacheHasKey(CacheKey.total);
  }

  /** Checks whether the 'majorLabelsExist' field has been set, however the value could be null */
  public boolean hasMajorLabelsExist() {
    return genClient.cacheHasKey(CacheKey.majorLabelsExist);
  }

  /** Checks whether the 'period' field has been set, however the value could be null */
  public boolean hasPeriod() {
    return genClient.cacheHasKey(CacheKey.period);
  }


  /**
   * Sets the field 'rows'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public SummarySection setRows(java.util.List<com.clover.sdk.v3.report.Summary> rows) {
    return genClient.setArrayRecord(rows, CacheKey.rows);
  }

  /**
   * Sets the field 'total'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public SummarySection setTotal(com.clover.sdk.v3.report.Summary total) {
    return genClient.setRecord(total, CacheKey.total);
  }

  /**
   * Sets the field 'majorLabelsExist'.
   */
  public SummarySection setMajorLabelsExist(java.lang.Boolean majorLabelsExist) {
    return genClient.setOther(majorLabelsExist, CacheKey.majorLabelsExist);
  }

  /**
   * Sets the field 'period'.
   */
  public SummarySection setPeriod(com.clover.sdk.v3.report.TimePeriod period) {
    return genClient.setOther(period, CacheKey.period);
  }


  /** Clears the 'rows' field, the 'has' method for this field will now return false */
  public void clearRows() {
    genClient.clear(CacheKey.rows);
  }
  /** Clears the 'total' field, the 'has' method for this field will now return false */
  public void clearTotal() {
    genClient.clear(CacheKey.total);
  }
  /** Clears the 'majorLabelsExist' field, the 'has' method for this field will now return false */
  public void clearMajorLabelsExist() {
    genClient.clear(CacheKey.majorLabelsExist);
  }
  /** Clears the 'period' field, the 'has' method for this field will now return false */
  public void clearPeriod() {
    genClient.clear(CacheKey.period);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public SummarySection copyChanges() {
    SummarySection copy = new SummarySection();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(SummarySection src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new SummarySection(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<SummarySection> CREATOR = new android.os.Parcelable.Creator<SummarySection>() {
    @Override
    public SummarySection createFromParcel(android.os.Parcel in) {
      SummarySection instance = new SummarySection(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public SummarySection[] newArray(int size) {
      return new SummarySection[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<SummarySection> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<SummarySection>() {
    public Class<SummarySection> getCreatedClass() {
      return SummarySection.class;
    }

    @Override
    public SummarySection create(org.json.JSONObject jsonObject) {
      return new SummarySection(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean ROWS_IS_REQUIRED = false;
    public static final boolean TOTAL_IS_REQUIRED = false;
    public static final boolean MAJORLABELSEXIST_IS_REQUIRED = false;
    public static final boolean PERIOD_IS_REQUIRED = false;
  }

}
