/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.report;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * Summary of a group of tenders, like Cash vs. Card vs. Other.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getType type}</li>
 * <li>{@link #getAmountCollected amountCollected}</li>
 * <li>{@link #getNumPayments numPayments}</li>
 * <li>{@link #getNumRefunds numRefunds}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class TenderGroupRow extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * The name of the tender grouping, like 'cash' vs. 'card' vs. 'other'.
   */
  public java.lang.String getType() {
    return genClient.cacheGet(CacheKey.type);
  }

  /**
   * Amount of all charges paid minus the amount of all charges refunded, excluding any amount of service charge refunded that was later repaid.
   */
  public java.lang.Long getAmountCollected() {
    return genClient.cacheGet(CacheKey.amountCollected);
  }

  /**
   * Number of payments for the current period.
   */
  public java.lang.Long getNumPayments() {
    return genClient.cacheGet(CacheKey.numPayments);
  }

  /**
   * Number of payment refunds and manual refunds for the current period.
   */
  public java.lang.Long getNumRefunds() {
    return genClient.cacheGet(CacheKey.numRefunds);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    type
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    amountCollected
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    numPayments
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    numRefunds
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<TenderGroupRow> genClient;

  /**
   * Constructs a new empty instance.
   */
  public TenderGroupRow() {
    genClient = new GenericClient<TenderGroupRow>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected TenderGroupRow(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public TenderGroupRow(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public TenderGroupRow(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public TenderGroupRow(TenderGroupRow src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
  }

  /** Checks whether the 'type' field is set and is not null */
  public boolean isNotNullType() {
    return genClient.cacheValueIsNotNull(CacheKey.type);
  }

  /** Checks whether the 'amountCollected' field is set and is not null */
  public boolean isNotNullAmountCollected() {
    return genClient.cacheValueIsNotNull(CacheKey.amountCollected);
  }

  /** Checks whether the 'numPayments' field is set and is not null */
  public boolean isNotNullNumPayments() {
    return genClient.cacheValueIsNotNull(CacheKey.numPayments);
  }

  /** Checks whether the 'numRefunds' field is set and is not null */
  public boolean isNotNullNumRefunds() {
    return genClient.cacheValueIsNotNull(CacheKey.numRefunds);
  }



  /** Checks whether the 'type' field has been set, however the value could be null */
  public boolean hasType() {
    return genClient.cacheHasKey(CacheKey.type);
  }

  /** Checks whether the 'amountCollected' field has been set, however the value could be null */
  public boolean hasAmountCollected() {
    return genClient.cacheHasKey(CacheKey.amountCollected);
  }

  /** Checks whether the 'numPayments' field has been set, however the value could be null */
  public boolean hasNumPayments() {
    return genClient.cacheHasKey(CacheKey.numPayments);
  }

  /** Checks whether the 'numRefunds' field has been set, however the value could be null */
  public boolean hasNumRefunds() {
    return genClient.cacheHasKey(CacheKey.numRefunds);
  }


  /**
   * Sets the field 'type'.
   */
  public TenderGroupRow setType(java.lang.String type) {
    return genClient.setOther(type, CacheKey.type);
  }

  /**
   * Sets the field 'amountCollected'.
   */
  public TenderGroupRow setAmountCollected(java.lang.Long amountCollected) {
    return genClient.setOther(amountCollected, CacheKey.amountCollected);
  }

  /**
   * Sets the field 'numPayments'.
   */
  public TenderGroupRow setNumPayments(java.lang.Long numPayments) {
    return genClient.setOther(numPayments, CacheKey.numPayments);
  }

  /**
   * Sets the field 'numRefunds'.
   */
  public TenderGroupRow setNumRefunds(java.lang.Long numRefunds) {
    return genClient.setOther(numRefunds, CacheKey.numRefunds);
  }


  /** Clears the 'type' field, the 'has' method for this field will now return false */
  public void clearType() {
    genClient.clear(CacheKey.type);
  }
  /** Clears the 'amountCollected' field, the 'has' method for this field will now return false */
  public void clearAmountCollected() {
    genClient.clear(CacheKey.amountCollected);
  }
  /** Clears the 'numPayments' field, the 'has' method for this field will now return false */
  public void clearNumPayments() {
    genClient.clear(CacheKey.numPayments);
  }
  /** Clears the 'numRefunds' field, the 'has' method for this field will now return false */
  public void clearNumRefunds() {
    genClient.clear(CacheKey.numRefunds);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public TenderGroupRow copyChanges() {
    TenderGroupRow copy = new TenderGroupRow();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(TenderGroupRow src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new TenderGroupRow(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<TenderGroupRow> CREATOR = new android.os.Parcelable.Creator<TenderGroupRow>() {
    @Override
    public TenderGroupRow createFromParcel(android.os.Parcel in) {
      TenderGroupRow instance = new TenderGroupRow(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public TenderGroupRow[] newArray(int size) {
      return new TenderGroupRow[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<TenderGroupRow> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<TenderGroupRow>() {
    public Class<TenderGroupRow> getCreatedClass() {
      return TenderGroupRow.class;
    }

    @Override
    public TenderGroupRow create(org.json.JSONObject jsonObject) {
      return new TenderGroupRow(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean TYPE_IS_REQUIRED = false;
    public static final boolean AMOUNTCOLLECTED_IS_REQUIRED = false;
    public static final boolean NUMPAYMENTS_IS_REQUIRED = false;
    public static final boolean NUMREFUNDS_IS_REQUIRED = false;
  }

}
