/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.tables2;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getId id}</li>
 * <li>{@link #getName name}</li>
 * <li>{@link #getMerchant merchant}</li>
 * <li>{@link #getSection section}</li>
 * <li>{@link #getTopLeftX topLeftX}</li>
 * <li>{@link #getTopLeftY topLeftY}</li>
 * <li>{@link #getWidth width}</li>
 * <li>{@link #getHeight height}</li>
 * <li>{@link #getType type}</li>
 * <li>{@link #getShape shape}</li>
 * <li>{@link #getRotation rotation}</li>
 * <li>{@link #getCreatedTime createdTime}</li>
 * <li>{@link #getModifiedTime modifiedTime}</li>
 * <li>{@link #getDeletedTime deletedTime}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class Landmark extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * Unique identifier
   */
  public java.lang.String getId() {
    return genClient.cacheGet(CacheKey.id);
  }

  /**
   * Name of the landmark
   */
  public java.lang.String getName() {
    return genClient.cacheGet(CacheKey.name);
  }

  /**
   * The merchant the landmark belongs to
   */
  public com.clover.sdk.v3.base.Reference getMerchant() {
    return genClient.cacheGet(CacheKey.merchant);
  }

  /**
   * The section this landmark belongs to
   */
  public com.clover.sdk.v3.base.Reference getSection() {
    return genClient.cacheGet(CacheKey.section);
  }

  /**
   * X coordinate of the landmark's top left location on the floor map
   */
  public java.lang.Integer getTopLeftX() {
    return genClient.cacheGet(CacheKey.topLeftX);
  }

  /**
   * Y coordinate of the landmark's top left location on the floor map
   */
  public java.lang.Integer getTopLeftY() {
    return genClient.cacheGet(CacheKey.topLeftY);
  }

  /**
   * Width of the landmark on the landmark map
   */
  public java.lang.Integer getWidth() {
    return genClient.cacheGet(CacheKey.width);
  }

  /**
   * Height of the landmark on the landmark map
   */
  public java.lang.Integer getHeight() {
    return genClient.cacheGet(CacheKey.height);
  }

  /**
   * Type of the landmark
   */
  public com.clover.sdk.v3.tables2.LandmarkType getType() {
    return genClient.cacheGet(CacheKey.type);
  }

  /**
   * Shape of the landmark
   */
  public com.clover.sdk.v3.tables2.LandmarkShape getShape() {
    return genClient.cacheGet(CacheKey.shape);
  }

  /**
   * Counterclockwise rotation of the landmark on the landmark map
   */
  public java.lang.Integer getRotation() {
    return genClient.cacheGet(CacheKey.rotation);
  }

  /**
   * Timestamp when the landmark was created
   */
  public java.lang.Long getCreatedTime() {
    return genClient.cacheGet(CacheKey.createdTime);
  }

  /**
   * Timestamp when the landmark was last modified
   */
  public java.lang.Long getModifiedTime() {
    return genClient.cacheGet(CacheKey.modifiedTime);
  }

  /**
   * Timestamp when landmark was last deleted
   */
  public java.lang.Long getDeletedTime() {
    return genClient.cacheGet(CacheKey.deletedTime);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    id
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    name
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    merchant
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.base.Reference.JSON_CREATOR)),
    section
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.base.Reference.JSON_CREATOR)),
    topLeftX
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Integer.class)),
    topLeftY
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Integer.class)),
    width
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Integer.class)),
    height
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Integer.class)),
    type
        (com.clover.sdk.extractors.EnumExtractionStrategy.instance(com.clover.sdk.v3.tables2.LandmarkType.class)),
    shape
        (com.clover.sdk.extractors.EnumExtractionStrategy.instance(com.clover.sdk.v3.tables2.LandmarkShape.class)),
    rotation
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Integer.class)),
    createdTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    modifiedTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    deletedTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<Landmark> genClient;

  /**
   * Constructs a new empty instance.
   */
  public Landmark() {
    genClient = new GenericClient<Landmark>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected Landmark(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public Landmark(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public Landmark(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public Landmark(Landmark src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
    genClient.validateCloverId(CacheKey.id, getId());

    genClient.validateLength(CacheKey.name, getName(), 64);
    genClient.validateReferences(CacheKey.merchant);
    genClient.validateReferences(CacheKey.section);
  }

  /** Checks whether the 'id' field is set and is not null */
  public boolean isNotNullId() {
    return genClient.cacheValueIsNotNull(CacheKey.id);
  }

  /** Checks whether the 'name' field is set and is not null */
  public boolean isNotNullName() {
    return genClient.cacheValueIsNotNull(CacheKey.name);
  }

  /** Checks whether the 'merchant' field is set and is not null */
  public boolean isNotNullMerchant() {
    return genClient.cacheValueIsNotNull(CacheKey.merchant);
  }

  /** Checks whether the 'section' field is set and is not null */
  public boolean isNotNullSection() {
    return genClient.cacheValueIsNotNull(CacheKey.section);
  }

  /** Checks whether the 'topLeftX' field is set and is not null */
  public boolean isNotNullTopLeftX() {
    return genClient.cacheValueIsNotNull(CacheKey.topLeftX);
  }

  /** Checks whether the 'topLeftY' field is set and is not null */
  public boolean isNotNullTopLeftY() {
    return genClient.cacheValueIsNotNull(CacheKey.topLeftY);
  }

  /** Checks whether the 'width' field is set and is not null */
  public boolean isNotNullWidth() {
    return genClient.cacheValueIsNotNull(CacheKey.width);
  }

  /** Checks whether the 'height' field is set and is not null */
  public boolean isNotNullHeight() {
    return genClient.cacheValueIsNotNull(CacheKey.height);
  }

  /** Checks whether the 'type' field is set and is not null */
  public boolean isNotNullType() {
    return genClient.cacheValueIsNotNull(CacheKey.type);
  }

  /** Checks whether the 'shape' field is set and is not null */
  public boolean isNotNullShape() {
    return genClient.cacheValueIsNotNull(CacheKey.shape);
  }

  /** Checks whether the 'rotation' field is set and is not null */
  public boolean isNotNullRotation() {
    return genClient.cacheValueIsNotNull(CacheKey.rotation);
  }

  /** Checks whether the 'createdTime' field is set and is not null */
  public boolean isNotNullCreatedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.createdTime);
  }

  /** Checks whether the 'modifiedTime' field is set and is not null */
  public boolean isNotNullModifiedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.modifiedTime);
  }

  /** Checks whether the 'deletedTime' field is set and is not null */
  public boolean isNotNullDeletedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.deletedTime);
  }



  /** Checks whether the 'id' field has been set, however the value could be null */
  public boolean hasId() {
    return genClient.cacheHasKey(CacheKey.id);
  }

  /** Checks whether the 'name' field has been set, however the value could be null */
  public boolean hasName() {
    return genClient.cacheHasKey(CacheKey.name);
  }

  /** Checks whether the 'merchant' field has been set, however the value could be null */
  public boolean hasMerchant() {
    return genClient.cacheHasKey(CacheKey.merchant);
  }

  /** Checks whether the 'section' field has been set, however the value could be null */
  public boolean hasSection() {
    return genClient.cacheHasKey(CacheKey.section);
  }

  /** Checks whether the 'topLeftX' field has been set, however the value could be null */
  public boolean hasTopLeftX() {
    return genClient.cacheHasKey(CacheKey.topLeftX);
  }

  /** Checks whether the 'topLeftY' field has been set, however the value could be null */
  public boolean hasTopLeftY() {
    return genClient.cacheHasKey(CacheKey.topLeftY);
  }

  /** Checks whether the 'width' field has been set, however the value could be null */
  public boolean hasWidth() {
    return genClient.cacheHasKey(CacheKey.width);
  }

  /** Checks whether the 'height' field has been set, however the value could be null */
  public boolean hasHeight() {
    return genClient.cacheHasKey(CacheKey.height);
  }

  /** Checks whether the 'type' field has been set, however the value could be null */
  public boolean hasType() {
    return genClient.cacheHasKey(CacheKey.type);
  }

  /** Checks whether the 'shape' field has been set, however the value could be null */
  public boolean hasShape() {
    return genClient.cacheHasKey(CacheKey.shape);
  }

  /** Checks whether the 'rotation' field has been set, however the value could be null */
  public boolean hasRotation() {
    return genClient.cacheHasKey(CacheKey.rotation);
  }

  /** Checks whether the 'createdTime' field has been set, however the value could be null */
  public boolean hasCreatedTime() {
    return genClient.cacheHasKey(CacheKey.createdTime);
  }

  /** Checks whether the 'modifiedTime' field has been set, however the value could be null */
  public boolean hasModifiedTime() {
    return genClient.cacheHasKey(CacheKey.modifiedTime);
  }

  /** Checks whether the 'deletedTime' field has been set, however the value could be null */
  public boolean hasDeletedTime() {
    return genClient.cacheHasKey(CacheKey.deletedTime);
  }


  /**
   * Sets the field 'id'.
   */
  public Landmark setId(java.lang.String id) {
    return genClient.setOther(id, CacheKey.id);
  }

  /**
   * Sets the field 'name'.
   */
  public Landmark setName(java.lang.String name) {
    return genClient.setOther(name, CacheKey.name);
  }

  /**
   * Sets the field 'merchant'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Landmark setMerchant(com.clover.sdk.v3.base.Reference merchant) {
    return genClient.setRecord(merchant, CacheKey.merchant);
  }

  /**
   * Sets the field 'section'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Landmark setSection(com.clover.sdk.v3.base.Reference section) {
    return genClient.setRecord(section, CacheKey.section);
  }

  /**
   * Sets the field 'topLeftX'.
   */
  public Landmark setTopLeftX(java.lang.Integer topLeftX) {
    return genClient.setOther(topLeftX, CacheKey.topLeftX);
  }

  /**
   * Sets the field 'topLeftY'.
   */
  public Landmark setTopLeftY(java.lang.Integer topLeftY) {
    return genClient.setOther(topLeftY, CacheKey.topLeftY);
  }

  /**
   * Sets the field 'width'.
   */
  public Landmark setWidth(java.lang.Integer width) {
    return genClient.setOther(width, CacheKey.width);
  }

  /**
   * Sets the field 'height'.
   */
  public Landmark setHeight(java.lang.Integer height) {
    return genClient.setOther(height, CacheKey.height);
  }

  /**
   * Sets the field 'type'.
   */
  public Landmark setType(com.clover.sdk.v3.tables2.LandmarkType type) {
    return genClient.setOther(type, CacheKey.type);
  }

  /**
   * Sets the field 'shape'.
   */
  public Landmark setShape(com.clover.sdk.v3.tables2.LandmarkShape shape) {
    return genClient.setOther(shape, CacheKey.shape);
  }

  /**
   * Sets the field 'rotation'.
   */
  public Landmark setRotation(java.lang.Integer rotation) {
    return genClient.setOther(rotation, CacheKey.rotation);
  }

  /**
   * Sets the field 'createdTime'.
   */
  public Landmark setCreatedTime(java.lang.Long createdTime) {
    return genClient.setOther(createdTime, CacheKey.createdTime);
  }

  /**
   * Sets the field 'modifiedTime'.
   */
  public Landmark setModifiedTime(java.lang.Long modifiedTime) {
    return genClient.setOther(modifiedTime, CacheKey.modifiedTime);
  }

  /**
   * Sets the field 'deletedTime'.
   */
  public Landmark setDeletedTime(java.lang.Long deletedTime) {
    return genClient.setOther(deletedTime, CacheKey.deletedTime);
  }


  /** Clears the 'id' field, the 'has' method for this field will now return false */
  public void clearId() {
    genClient.clear(CacheKey.id);
  }
  /** Clears the 'name' field, the 'has' method for this field will now return false */
  public void clearName() {
    genClient.clear(CacheKey.name);
  }
  /** Clears the 'merchant' field, the 'has' method for this field will now return false */
  public void clearMerchant() {
    genClient.clear(CacheKey.merchant);
  }
  /** Clears the 'section' field, the 'has' method for this field will now return false */
  public void clearSection() {
    genClient.clear(CacheKey.section);
  }
  /** Clears the 'topLeftX' field, the 'has' method for this field will now return false */
  public void clearTopLeftX() {
    genClient.clear(CacheKey.topLeftX);
  }
  /** Clears the 'topLeftY' field, the 'has' method for this field will now return false */
  public void clearTopLeftY() {
    genClient.clear(CacheKey.topLeftY);
  }
  /** Clears the 'width' field, the 'has' method for this field will now return false */
  public void clearWidth() {
    genClient.clear(CacheKey.width);
  }
  /** Clears the 'height' field, the 'has' method for this field will now return false */
  public void clearHeight() {
    genClient.clear(CacheKey.height);
  }
  /** Clears the 'type' field, the 'has' method for this field will now return false */
  public void clearType() {
    genClient.clear(CacheKey.type);
  }
  /** Clears the 'shape' field, the 'has' method for this field will now return false */
  public void clearShape() {
    genClient.clear(CacheKey.shape);
  }
  /** Clears the 'rotation' field, the 'has' method for this field will now return false */
  public void clearRotation() {
    genClient.clear(CacheKey.rotation);
  }
  /** Clears the 'createdTime' field, the 'has' method for this field will now return false */
  public void clearCreatedTime() {
    genClient.clear(CacheKey.createdTime);
  }
  /** Clears the 'modifiedTime' field, the 'has' method for this field will now return false */
  public void clearModifiedTime() {
    genClient.clear(CacheKey.modifiedTime);
  }
  /** Clears the 'deletedTime' field, the 'has' method for this field will now return false */
  public void clearDeletedTime() {
    genClient.clear(CacheKey.deletedTime);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public Landmark copyChanges() {
    Landmark copy = new Landmark();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(Landmark src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new Landmark(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<Landmark> CREATOR = new android.os.Parcelable.Creator<Landmark>() {
    @Override
    public Landmark createFromParcel(android.os.Parcel in) {
      Landmark instance = new Landmark(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public Landmark[] newArray(int size) {
      return new Landmark[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<Landmark> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<Landmark>() {
    public Class<Landmark> getCreatedClass() {
      return Landmark.class;
    }

    @Override
    public Landmark create(org.json.JSONObject jsonObject) {
      return new Landmark(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean ID_IS_REQUIRED = false;
    public static final long ID_MAX_LEN = 13;
    public static final boolean NAME_IS_REQUIRED = false;
    public static final long NAME_MAX_LEN = 64;
    public static final boolean MERCHANT_IS_REQUIRED = false;
    public static final boolean SECTION_IS_REQUIRED = false;
    public static final boolean TOPLEFTX_IS_REQUIRED = false;
    public static final boolean TOPLEFTY_IS_REQUIRED = false;
    public static final boolean WIDTH_IS_REQUIRED = false;
    public static final boolean HEIGHT_IS_REQUIRED = false;
    public static final boolean TYPE_IS_REQUIRED = false;
    public static final boolean SHAPE_IS_REQUIRED = false;
    public static final boolean ROTATION_IS_REQUIRED = false;
    public static final boolean CREATEDTIME_IS_REQUIRED = false;
    public static final boolean MODIFIEDTIME_IS_REQUIRED = false;
    public static final boolean DELETEDTIME_IS_REQUIRED = false;
  }

}
