/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.tokens;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getId id}</li>
 * <li>{@link #getTokenMetaId token_meta_id}</li>
 * <li>{@link #getFdAccountId fd_account_id}</li>
 * <li>{@link #getFdCustomerId fd_customer_id}</li>
 * <li>{@link #getAccountLast4 account_last4}</li>
 * <li>{@link #getRoutingLast4 routing_last4}</li>
 * <li>{@link #getBankName bank_name}</li>
 * <li>{@link #getCorporateAccountFlag corporate_account_flag}</li>
 * <li>{@link #getAccountStatus account_status}</li>
 * <li>{@link #getAccountStatusDesc account_status_desc}</li>
 * <li>{@link #getTransactionStatus transaction_status}</li>
 * <li>{@link #getTransactionStatusCode transaction_status_code}</li>
 * <li>{@link #getTransactionStatusDesc transaction_status_desc}</li>
 * <li>{@link #getReferenceTransactionId reference_transaction_id}</li>
 * <li>{@link #getAccountValidationDetails account_validation_details}</li>
 * <li>{@link #getCreatedTime created_time}</li>
 * <li>{@link #getModifiedTime modified_time}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class Ach extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * Unique identifier for the object.
   */
  public String getId() {
    return genClient.cacheGet(CacheKey.id);
  }

  /**
   * token meta id in the db
   */
  public Long getTokenMetaId() {
    return genClient.cacheGet(CacheKey.token_meta_id);
  }

  /**
   * first data ach account number
   */
  public String getFdAccountId() {
    return genClient.cacheGet(CacheKey.fd_account_id);
  }

  /**
   * Unique consumer identifier in Fiserv Telecheck.
   */
  public String getFdCustomerId() {
    return genClient.cacheGet(CacheKey.fd_customer_id);
  }

  /**
   * Last4 of bank account
   */
  public String getAccountLast4() {
    return genClient.cacheGet(CacheKey.account_last4);
  }

  /**
   * Last4 of bank routing
   */
  public String getRoutingLast4() {
    return genClient.cacheGet(CacheKey.routing_last4);
  }

  /**
   * Name of the bank
   */
  public String getBankName() {
    return genClient.cacheGet(CacheKey.bank_name);
  }

  /**
   * Corporate account flag
   */
  public com.clover.sdk.v3.tokens.CorporateAccountFlag getCorporateAccountFlag() {
    return genClient.cacheGet(CacheKey.corporate_account_flag);
  }

  /**
   * Numeric value which defines the status of ACH account.
   */
  public String getAccountStatus() {
    return genClient.cacheGet(CacheKey.account_status);
  }

  /**
   * Short description which describes the accountStatus.
   */
  public String getAccountStatusDesc() {
    return genClient.cacheGet(CacheKey.account_status_desc);
  }

  /**
   * Overall status of the call.
   */
  public String getTransactionStatus() {
    return genClient.cacheGet(CacheKey.transaction_status);
  }

  /**
   * Unique code signifying detailed transaction status
   */
  public Long getTransactionStatusCode() {
    return genClient.cacheGet(CacheKey.transaction_status_code);
  }

  /**
   * Short description of the above code.
   */
  public String getTransactionStatusDesc() {
    return genClient.cacheGet(CacheKey.transaction_status_desc);
  }

  /**
   * Unique ID for each Transaction which could be used to trace a transaction.
   */
  public String getReferenceTransactionId() {
    return genClient.cacheGet(CacheKey.reference_transaction_id);
  }

  /**
   * List of connect pay validation details
   */
  public java.util.List<com.clover.sdk.v3.connectpay.ValidationDetails> getAccountValidationDetails() {
    return genClient.cacheGet(CacheKey.account_validation_details);
  }

  public Long getCreatedTime() {
    return genClient.cacheGet(CacheKey.created_time);
  }

  public Long getModifiedTime() {
    return genClient.cacheGet(CacheKey.modified_time);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    id
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    token_meta_id
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(Long.class)),
    fd_account_id
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    fd_customer_id
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    account_last4
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    routing_last4
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    bank_name
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    corporate_account_flag
        (com.clover.sdk.extractors.EnumExtractionStrategy.instance(com.clover.sdk.v3.tokens.CorporateAccountFlag.class)),
    account_status
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    account_status_desc
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    transaction_status
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    transaction_status_code
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(Long.class)),
    transaction_status_desc
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    reference_transaction_id
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    account_validation_details
        (com.clover.sdk.extractors.RecordListExtractionStrategy.instance(com.clover.sdk.v3.connectpay.ValidationDetails.JSON_CREATOR)),
    created_time
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(Long.class)),
    modified_time
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(Long.class)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<Ach> genClient;

  /**
   * Constructs a new empty instance.
   */
  public Ach() {
    genClient = new GenericClient<Ach>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected Ach(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public Ach(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public Ach(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public Ach(Ach src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
  }

  /** Checks whether the 'id' field is set and is not null */
  public boolean isNotNullId() {
    return genClient.cacheValueIsNotNull(CacheKey.id);
  }

  /** Checks whether the 'token_meta_id' field is set and is not null */
  public boolean isNotNullTokenMetaId() {
    return genClient.cacheValueIsNotNull(CacheKey.token_meta_id);
  }

  /** Checks whether the 'fd_account_id' field is set and is not null */
  public boolean isNotNullFdAccountId() {
    return genClient.cacheValueIsNotNull(CacheKey.fd_account_id);
  }

  /** Checks whether the 'fd_customer_id' field is set and is not null */
  public boolean isNotNullFdCustomerId() {
    return genClient.cacheValueIsNotNull(CacheKey.fd_customer_id);
  }

  /** Checks whether the 'account_last4' field is set and is not null */
  public boolean isNotNullAccountLast4() {
    return genClient.cacheValueIsNotNull(CacheKey.account_last4);
  }

  /** Checks whether the 'routing_last4' field is set and is not null */
  public boolean isNotNullRoutingLast4() {
    return genClient.cacheValueIsNotNull(CacheKey.routing_last4);
  }

  /** Checks whether the 'bank_name' field is set and is not null */
  public boolean isNotNullBankName() {
    return genClient.cacheValueIsNotNull(CacheKey.bank_name);
  }

  /** Checks whether the 'corporate_account_flag' field is set and is not null */
  public boolean isNotNullCorporateAccountFlag() {
    return genClient.cacheValueIsNotNull(CacheKey.corporate_account_flag);
  }

  /** Checks whether the 'account_status' field is set and is not null */
  public boolean isNotNullAccountStatus() {
    return genClient.cacheValueIsNotNull(CacheKey.account_status);
  }

  /** Checks whether the 'account_status_desc' field is set and is not null */
  public boolean isNotNullAccountStatusDesc() {
    return genClient.cacheValueIsNotNull(CacheKey.account_status_desc);
  }

  /** Checks whether the 'transaction_status' field is set and is not null */
  public boolean isNotNullTransactionStatus() {
    return genClient.cacheValueIsNotNull(CacheKey.transaction_status);
  }

  /** Checks whether the 'transaction_status_code' field is set and is not null */
  public boolean isNotNullTransactionStatusCode() {
    return genClient.cacheValueIsNotNull(CacheKey.transaction_status_code);
  }

  /** Checks whether the 'transaction_status_desc' field is set and is not null */
  public boolean isNotNullTransactionStatusDesc() {
    return genClient.cacheValueIsNotNull(CacheKey.transaction_status_desc);
  }

  /** Checks whether the 'reference_transaction_id' field is set and is not null */
  public boolean isNotNullReferenceTransactionId() {
    return genClient.cacheValueIsNotNull(CacheKey.reference_transaction_id);
  }

  /** Checks whether the 'account_validation_details' field is set and is not null */
  public boolean isNotNullAccountValidationDetails() {
    return genClient.cacheValueIsNotNull(CacheKey.account_validation_details);
  }

  /** Checks whether the 'account_validation_details' field is set and is not null and is not empty */
  public boolean isNotEmptyAccountValidationDetails() { return isNotNullAccountValidationDetails() && !getAccountValidationDetails().isEmpty(); }

  /** Checks whether the 'created_time' field is set and is not null */
  public boolean isNotNullCreatedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.created_time);
  }

  /** Checks whether the 'modified_time' field is set and is not null */
  public boolean isNotNullModifiedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.modified_time);
  }



  /** Checks whether the 'id' field has been set, however the value could be null */
  public boolean hasId() {
    return genClient.cacheHasKey(CacheKey.id);
  }

  /** Checks whether the 'token_meta_id' field has been set, however the value could be null */
  public boolean hasTokenMetaId() {
    return genClient.cacheHasKey(CacheKey.token_meta_id);
  }

  /** Checks whether the 'fd_account_id' field has been set, however the value could be null */
  public boolean hasFdAccountId() {
    return genClient.cacheHasKey(CacheKey.fd_account_id);
  }

  /** Checks whether the 'fd_customer_id' field has been set, however the value could be null */
  public boolean hasFdCustomerId() {
    return genClient.cacheHasKey(CacheKey.fd_customer_id);
  }

  /** Checks whether the 'account_last4' field has been set, however the value could be null */
  public boolean hasAccountLast4() {
    return genClient.cacheHasKey(CacheKey.account_last4);
  }

  /** Checks whether the 'routing_last4' field has been set, however the value could be null */
  public boolean hasRoutingLast4() {
    return genClient.cacheHasKey(CacheKey.routing_last4);
  }

  /** Checks whether the 'bank_name' field has been set, however the value could be null */
  public boolean hasBankName() {
    return genClient.cacheHasKey(CacheKey.bank_name);
  }

  /** Checks whether the 'corporate_account_flag' field has been set, however the value could be null */
  public boolean hasCorporateAccountFlag() {
    return genClient.cacheHasKey(CacheKey.corporate_account_flag);
  }

  /** Checks whether the 'account_status' field has been set, however the value could be null */
  public boolean hasAccountStatus() {
    return genClient.cacheHasKey(CacheKey.account_status);
  }

  /** Checks whether the 'account_status_desc' field has been set, however the value could be null */
  public boolean hasAccountStatusDesc() {
    return genClient.cacheHasKey(CacheKey.account_status_desc);
  }

  /** Checks whether the 'transaction_status' field has been set, however the value could be null */
  public boolean hasTransactionStatus() {
    return genClient.cacheHasKey(CacheKey.transaction_status);
  }

  /** Checks whether the 'transaction_status_code' field has been set, however the value could be null */
  public boolean hasTransactionStatusCode() {
    return genClient.cacheHasKey(CacheKey.transaction_status_code);
  }

  /** Checks whether the 'transaction_status_desc' field has been set, however the value could be null */
  public boolean hasTransactionStatusDesc() {
    return genClient.cacheHasKey(CacheKey.transaction_status_desc);
  }

  /** Checks whether the 'reference_transaction_id' field has been set, however the value could be null */
  public boolean hasReferenceTransactionId() {
    return genClient.cacheHasKey(CacheKey.reference_transaction_id);
  }

  /** Checks whether the 'account_validation_details' field has been set, however the value could be null */
  public boolean hasAccountValidationDetails() {
    return genClient.cacheHasKey(CacheKey.account_validation_details);
  }

  /** Checks whether the 'created_time' field has been set, however the value could be null */
  public boolean hasCreatedTime() {
    return genClient.cacheHasKey(CacheKey.created_time);
  }

  /** Checks whether the 'modified_time' field has been set, however the value could be null */
  public boolean hasModifiedTime() {
    return genClient.cacheHasKey(CacheKey.modified_time);
  }


  /**
   * Sets the field 'id'.
   */
  public Ach setId(String id) {
    return genClient.setOther(id, CacheKey.id);
  }

  /**
   * Sets the field 'token_meta_id'.
   */
  public Ach setTokenMetaId(Long token_meta_id) {
    return genClient.setOther(token_meta_id, CacheKey.token_meta_id);
  }

  /**
   * Sets the field 'fd_account_id'.
   */
  public Ach setFdAccountId(String fd_account_id) {
    return genClient.setOther(fd_account_id, CacheKey.fd_account_id);
  }

  /**
   * Sets the field 'fd_customer_id'.
   */
  public Ach setFdCustomerId(String fd_customer_id) {
    return genClient.setOther(fd_customer_id, CacheKey.fd_customer_id);
  }

  /**
   * Sets the field 'account_last4'.
   */
  public Ach setAccountLast4(String account_last4) {
    return genClient.setOther(account_last4, CacheKey.account_last4);
  }

  /**
   * Sets the field 'routing_last4'.
   */
  public Ach setRoutingLast4(String routing_last4) {
    return genClient.setOther(routing_last4, CacheKey.routing_last4);
  }

  /**
   * Sets the field 'bank_name'.
   */
  public Ach setBankName(String bank_name) {
    return genClient.setOther(bank_name, CacheKey.bank_name);
  }

  /**
   * Sets the field 'corporate_account_flag'.
   */
  public Ach setCorporateAccountFlag(com.clover.sdk.v3.tokens.CorporateAccountFlag corporate_account_flag) {
    return genClient.setOther(corporate_account_flag, CacheKey.corporate_account_flag);
  }

  /**
   * Sets the field 'account_status'.
   */
  public Ach setAccountStatus(String account_status) {
    return genClient.setOther(account_status, CacheKey.account_status);
  }

  /**
   * Sets the field 'account_status_desc'.
   */
  public Ach setAccountStatusDesc(String account_status_desc) {
    return genClient.setOther(account_status_desc, CacheKey.account_status_desc);
  }

  /**
   * Sets the field 'transaction_status'.
   */
  public Ach setTransactionStatus(String transaction_status) {
    return genClient.setOther(transaction_status, CacheKey.transaction_status);
  }

  /**
   * Sets the field 'transaction_status_code'.
   */
  public Ach setTransactionStatusCode(Long transaction_status_code) {
    return genClient.setOther(transaction_status_code, CacheKey.transaction_status_code);
  }

  /**
   * Sets the field 'transaction_status_desc'.
   */
  public Ach setTransactionStatusDesc(String transaction_status_desc) {
    return genClient.setOther(transaction_status_desc, CacheKey.transaction_status_desc);
  }

  /**
   * Sets the field 'reference_transaction_id'.
   */
  public Ach setReferenceTransactionId(String reference_transaction_id) {
    return genClient.setOther(reference_transaction_id, CacheKey.reference_transaction_id);
  }

  /**
   * Sets the field 'account_validation_details'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public Ach setAccountValidationDetails(java.util.List<com.clover.sdk.v3.connectpay.ValidationDetails> account_validation_details) {
    return genClient.setArrayRecord(account_validation_details, CacheKey.account_validation_details);
  }

  /**
   * Sets the field 'created_time'.
   */
  public Ach setCreatedTime(Long created_time) {
    return genClient.setOther(created_time, CacheKey.created_time);
  }

  /**
   * Sets the field 'modified_time'.
   */
  public Ach setModifiedTime(Long modified_time) {
    return genClient.setOther(modified_time, CacheKey.modified_time);
  }


  /** Clears the 'id' field, the 'has' method for this field will now return false */
  public void clearId() {
    genClient.clear(CacheKey.id);
  }
  /** Clears the 'token_meta_id' field, the 'has' method for this field will now return false */
  public void clearTokenMetaId() {
    genClient.clear(CacheKey.token_meta_id);
  }
  /** Clears the 'fd_account_id' field, the 'has' method for this field will now return false */
  public void clearFdAccountId() {
    genClient.clear(CacheKey.fd_account_id);
  }
  /** Clears the 'fd_customer_id' field, the 'has' method for this field will now return false */
  public void clearFdCustomerId() {
    genClient.clear(CacheKey.fd_customer_id);
  }
  /** Clears the 'account_last4' field, the 'has' method for this field will now return false */
  public void clearAccountLast4() {
    genClient.clear(CacheKey.account_last4);
  }
  /** Clears the 'routing_last4' field, the 'has' method for this field will now return false */
  public void clearRoutingLast4() {
    genClient.clear(CacheKey.routing_last4);
  }
  /** Clears the 'bank_name' field, the 'has' method for this field will now return false */
  public void clearBankName() {
    genClient.clear(CacheKey.bank_name);
  }
  /** Clears the 'corporate_account_flag' field, the 'has' method for this field will now return false */
  public void clearCorporateAccountFlag() {
    genClient.clear(CacheKey.corporate_account_flag);
  }
  /** Clears the 'account_status' field, the 'has' method for this field will now return false */
  public void clearAccountStatus() {
    genClient.clear(CacheKey.account_status);
  }
  /** Clears the 'account_status_desc' field, the 'has' method for this field will now return false */
  public void clearAccountStatusDesc() {
    genClient.clear(CacheKey.account_status_desc);
  }
  /** Clears the 'transaction_status' field, the 'has' method for this field will now return false */
  public void clearTransactionStatus() {
    genClient.clear(CacheKey.transaction_status);
  }
  /** Clears the 'transaction_status_code' field, the 'has' method for this field will now return false */
  public void clearTransactionStatusCode() {
    genClient.clear(CacheKey.transaction_status_code);
  }
  /** Clears the 'transaction_status_desc' field, the 'has' method for this field will now return false */
  public void clearTransactionStatusDesc() {
    genClient.clear(CacheKey.transaction_status_desc);
  }
  /** Clears the 'reference_transaction_id' field, the 'has' method for this field will now return false */
  public void clearReferenceTransactionId() {
    genClient.clear(CacheKey.reference_transaction_id);
  }
  /** Clears the 'account_validation_details' field, the 'has' method for this field will now return false */
  public void clearAccountValidationDetails() {
    genClient.clear(CacheKey.account_validation_details);
  }
  /** Clears the 'created_time' field, the 'has' method for this field will now return false */
  public void clearCreatedTime() {
    genClient.clear(CacheKey.created_time);
  }
  /** Clears the 'modified_time' field, the 'has' method for this field will now return false */
  public void clearModifiedTime() {
    genClient.clear(CacheKey.modified_time);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public Ach copyChanges() {
    Ach copy = new Ach();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(Ach src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new Ach(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<Ach> CREATOR = new android.os.Parcelable.Creator<Ach>() {
    @Override
    public Ach createFromParcel(android.os.Parcel in) {
      Ach instance = new Ach(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public Ach[] newArray(int size) {
      return new Ach[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<Ach> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<Ach>() {
    public Class<Ach> getCreatedClass() {
      return Ach.class;
    }

    @Override
    public Ach create(org.json.JSONObject jsonObject) {
      return new Ach(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean ID_IS_REQUIRED = false;
    public static final boolean TOKEN_META_ID_IS_REQUIRED = false;
    public static final boolean FD_ACCOUNT_ID_IS_REQUIRED = false;
    public static final boolean FD_CUSTOMER_ID_IS_REQUIRED = false;
    public static final boolean ACCOUNT_LAST4_IS_REQUIRED = false;
    public static final boolean ROUTING_LAST4_IS_REQUIRED = false;
    public static final boolean BANK_NAME_IS_REQUIRED = false;
    public static final boolean CORPORATE_ACCOUNT_FLAG_IS_REQUIRED = false;
    public static final boolean ACCOUNT_STATUS_IS_REQUIRED = false;
    public static final boolean ACCOUNT_STATUS_DESC_IS_REQUIRED = false;
    public static final boolean TRANSACTION_STATUS_IS_REQUIRED = false;
    public static final boolean TRANSACTION_STATUS_CODE_IS_REQUIRED = false;
    public static final boolean TRANSACTION_STATUS_DESC_IS_REQUIRED = false;
    public static final boolean REFERENCE_TRANSACTION_ID_IS_REQUIRED = false;
    public static final boolean ACCOUNT_VALIDATION_DETAILS_IS_REQUIRED = false;
    public static final boolean CREATED_TIME_IS_REQUIRED = false;
    public static final boolean MODIFIED_TIME_IS_REQUIRED = false;
  }

}
