/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.tokens;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getId id}</li>
 * <li>{@link #getObject object}</li>
 * <li>{@link #getCard card}</li>
 * <li>{@link #getWallet wallet}</li>
 * <li>{@link #getAch ach}</li>
 * <li>{@link #getClientIp client_ip}</li>
 * <li>{@link #getCreated created}</li>
 * <li>{@link #getLivemode livemode}</li>
 * <li>{@link #getType type}</li>
 * <li>{@link #getUsed used}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class CreateTokenResponse extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * identifier for request
   */
  public String getId() {
    return genClient.cacheGet(CacheKey.id);
  }

  /**
   * token value, expired after configured time null if error occurred
   */
  public String getObject() {
    return genClient.cacheGet(CacheKey.object);
  }

  /**
   * card details, meta data of the card tokenized
   */
  public com.clover.sdk.v3.tokens.Card getCard() {
    return genClient.cacheGet(CacheKey.card);
  }

  /**
   * wallet details (apple or google pay), meta data of the wallet tokenized
   */
  public com.clover.sdk.v3.tokens.Wallet getWallet() {
    return genClient.cacheGet(CacheKey.wallet);
  }

  /**
   * ACH (Connect Pay) details, meta data of the ACH tokenized
   */
  public com.clover.sdk.v3.tokens.Ach getAch() {
    return genClient.cacheGet(CacheKey.ach);
  }

  /**
   * IP address of the client that generated the token.
   */
  public String getClientIp() {
    return genClient.cacheGet(CacheKey.client_ip);
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  public Long getCreated() {
    return genClient.cacheGet(CacheKey.created);
  }

  /**
   * Has the value true if the object exists in live mode or the value false if the object exists in test mode.
   */
  public Boolean getLivemode() {
    return genClient.cacheGet(CacheKey.livemode);
  }

  /**
   * Type of the token: account, bank_account, card, or pii.
   */
  public String getType() {
    return genClient.cacheGet(CacheKey.type);
  }

  /**
   * Whether this token has already been used (tokens can be used only once).
   */
  public Boolean getUsed() {
    return genClient.cacheGet(CacheKey.used);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    id
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    object
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    card
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.tokens.Card.JSON_CREATOR)),
    wallet
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.tokens.Wallet.JSON_CREATOR)),
    ach
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.tokens.Ach.JSON_CREATOR)),
    client_ip
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    created
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(Long.class)),
    livemode
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(Boolean.class)),
    type
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    used
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(Boolean.class)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<CreateTokenResponse> genClient;

  /**
   * Constructs a new empty instance.
   */
  public CreateTokenResponse() {
    genClient = new GenericClient<CreateTokenResponse>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected CreateTokenResponse(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public CreateTokenResponse(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public CreateTokenResponse(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public CreateTokenResponse(CreateTokenResponse src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
  }

  /** Checks whether the 'id' field is set and is not null */
  public boolean isNotNullId() {
    return genClient.cacheValueIsNotNull(CacheKey.id);
  }

  /** Checks whether the 'object' field is set and is not null */
  public boolean isNotNullObject() {
    return genClient.cacheValueIsNotNull(CacheKey.object);
  }

  /** Checks whether the 'card' field is set and is not null */
  public boolean isNotNullCard() {
    return genClient.cacheValueIsNotNull(CacheKey.card);
  }

  /** Checks whether the 'wallet' field is set and is not null */
  public boolean isNotNullWallet() {
    return genClient.cacheValueIsNotNull(CacheKey.wallet);
  }

  /** Checks whether the 'ach' field is set and is not null */
  public boolean isNotNullAch() {
    return genClient.cacheValueIsNotNull(CacheKey.ach);
  }

  /** Checks whether the 'client_ip' field is set and is not null */
  public boolean isNotNullClientIp() {
    return genClient.cacheValueIsNotNull(CacheKey.client_ip);
  }

  /** Checks whether the 'created' field is set and is not null */
  public boolean isNotNullCreated() {
    return genClient.cacheValueIsNotNull(CacheKey.created);
  }

  /** Checks whether the 'livemode' field is set and is not null */
  public boolean isNotNullLivemode() {
    return genClient.cacheValueIsNotNull(CacheKey.livemode);
  }

  /** Checks whether the 'type' field is set and is not null */
  public boolean isNotNullType() {
    return genClient.cacheValueIsNotNull(CacheKey.type);
  }

  /** Checks whether the 'used' field is set and is not null */
  public boolean isNotNullUsed() {
    return genClient.cacheValueIsNotNull(CacheKey.used);
  }



  /** Checks whether the 'id' field has been set, however the value could be null */
  public boolean hasId() {
    return genClient.cacheHasKey(CacheKey.id);
  }

  /** Checks whether the 'object' field has been set, however the value could be null */
  public boolean hasObject() {
    return genClient.cacheHasKey(CacheKey.object);
  }

  /** Checks whether the 'card' field has been set, however the value could be null */
  public boolean hasCard() {
    return genClient.cacheHasKey(CacheKey.card);
  }

  /** Checks whether the 'wallet' field has been set, however the value could be null */
  public boolean hasWallet() {
    return genClient.cacheHasKey(CacheKey.wallet);
  }

  /** Checks whether the 'ach' field has been set, however the value could be null */
  public boolean hasAch() {
    return genClient.cacheHasKey(CacheKey.ach);
  }

  /** Checks whether the 'client_ip' field has been set, however the value could be null */
  public boolean hasClientIp() {
    return genClient.cacheHasKey(CacheKey.client_ip);
  }

  /** Checks whether the 'created' field has been set, however the value could be null */
  public boolean hasCreated() {
    return genClient.cacheHasKey(CacheKey.created);
  }

  /** Checks whether the 'livemode' field has been set, however the value could be null */
  public boolean hasLivemode() {
    return genClient.cacheHasKey(CacheKey.livemode);
  }

  /** Checks whether the 'type' field has been set, however the value could be null */
  public boolean hasType() {
    return genClient.cacheHasKey(CacheKey.type);
  }

  /** Checks whether the 'used' field has been set, however the value could be null */
  public boolean hasUsed() {
    return genClient.cacheHasKey(CacheKey.used);
  }


  /**
   * Sets the field 'id'.
   */
  public CreateTokenResponse setId(String id) {
    return genClient.setOther(id, CacheKey.id);
  }

  /**
   * Sets the field 'object'.
   */
  public CreateTokenResponse setObject(String object) {
    return genClient.setOther(object, CacheKey.object);
  }

  /**
   * Sets the field 'card'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public CreateTokenResponse setCard(com.clover.sdk.v3.tokens.Card card) {
    return genClient.setRecord(card, CacheKey.card);
  }

  /**
   * Sets the field 'wallet'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public CreateTokenResponse setWallet(com.clover.sdk.v3.tokens.Wallet wallet) {
    return genClient.setRecord(wallet, CacheKey.wallet);
  }

  /**
   * Sets the field 'ach'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public CreateTokenResponse setAch(com.clover.sdk.v3.tokens.Ach ach) {
    return genClient.setRecord(ach, CacheKey.ach);
  }

  /**
   * Sets the field 'client_ip'.
   */
  public CreateTokenResponse setClientIp(String client_ip) {
    return genClient.setOther(client_ip, CacheKey.client_ip);
  }

  /**
   * Sets the field 'created'.
   */
  public CreateTokenResponse setCreated(Long created) {
    return genClient.setOther(created, CacheKey.created);
  }

  /**
   * Sets the field 'livemode'.
   */
  public CreateTokenResponse setLivemode(Boolean livemode) {
    return genClient.setOther(livemode, CacheKey.livemode);
  }

  /**
   * Sets the field 'type'.
   */
  public CreateTokenResponse setType(String type) {
    return genClient.setOther(type, CacheKey.type);
  }

  /**
   * Sets the field 'used'.
   */
  public CreateTokenResponse setUsed(Boolean used) {
    return genClient.setOther(used, CacheKey.used);
  }


  /** Clears the 'id' field, the 'has' method for this field will now return false */
  public void clearId() {
    genClient.clear(CacheKey.id);
  }
  /** Clears the 'object' field, the 'has' method for this field will now return false */
  public void clearObject() {
    genClient.clear(CacheKey.object);
  }
  /** Clears the 'card' field, the 'has' method for this field will now return false */
  public void clearCard() {
    genClient.clear(CacheKey.card);
  }
  /** Clears the 'wallet' field, the 'has' method for this field will now return false */
  public void clearWallet() {
    genClient.clear(CacheKey.wallet);
  }
  /** Clears the 'ach' field, the 'has' method for this field will now return false */
  public void clearAch() {
    genClient.clear(CacheKey.ach);
  }
  /** Clears the 'client_ip' field, the 'has' method for this field will now return false */
  public void clearClientIp() {
    genClient.clear(CacheKey.client_ip);
  }
  /** Clears the 'created' field, the 'has' method for this field will now return false */
  public void clearCreated() {
    genClient.clear(CacheKey.created);
  }
  /** Clears the 'livemode' field, the 'has' method for this field will now return false */
  public void clearLivemode() {
    genClient.clear(CacheKey.livemode);
  }
  /** Clears the 'type' field, the 'has' method for this field will now return false */
  public void clearType() {
    genClient.clear(CacheKey.type);
  }
  /** Clears the 'used' field, the 'has' method for this field will now return false */
  public void clearUsed() {
    genClient.clear(CacheKey.used);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public CreateTokenResponse copyChanges() {
    CreateTokenResponse copy = new CreateTokenResponse();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(CreateTokenResponse src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new CreateTokenResponse(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<CreateTokenResponse> CREATOR = new android.os.Parcelable.Creator<CreateTokenResponse>() {
    @Override
    public CreateTokenResponse createFromParcel(android.os.Parcel in) {
      CreateTokenResponse instance = new CreateTokenResponse(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public CreateTokenResponse[] newArray(int size) {
      return new CreateTokenResponse[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<CreateTokenResponse> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<CreateTokenResponse>() {
    public Class<CreateTokenResponse> getCreatedClass() {
      return CreateTokenResponse.class;
    }

    @Override
    public CreateTokenResponse create(org.json.JSONObject jsonObject) {
      return new CreateTokenResponse(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean ID_IS_REQUIRED = false;
    public static final boolean OBJECT_IS_REQUIRED = false;
    public static final boolean CARD_IS_REQUIRED = false;
    public static final boolean WALLET_IS_REQUIRED = false;
    public static final boolean ACH_IS_REQUIRED = false;
    public static final boolean CLIENT_IP_IS_REQUIRED = false;
    public static final boolean CREATED_IS_REQUIRED = false;
    public static final boolean LIVEMODE_IS_REQUIRED = false;
    public static final boolean TYPE_IS_REQUIRED = false;
    public static final boolean USED_IS_REQUIRED = false;
  }

}
