/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.tokens;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getId id}</li>
 * <li>{@link #getNumber number}</li>
 * <li>{@link #getEncryptedPan encrypted_pan}</li>
 * <li>{@link #getEncryptedPanForBinLookup encrypted_pan_for_bin_lookup}</li>
 * <li>{@link #getTokenMetaId token_meta_id}</li>
 * <li>{@link #getExpMonth exp_month}</li>
 * <li>{@link #getExpYear exp_year}</li>
 * <li>{@link #getCryptogram cryptogram}</li>
 * <li>{@link #getWalletType walletType}</li>
 * <li>{@link #getPaymentDataType paymentDataType}</li>
 * <li>{@link #getEciIndicator eciIndicator}</li>
 * <li>{@link #getGoogleMessageId googleMessageId}</li>
 * <li>{@link #getGoogleMessageExpiration googleMessageExpiration}</li>
 * <li>{@link #getAppleDeviceManufacturerIdentifier appleDeviceManufacturerIdentifier}</li>
 * <li>{@link #getCurrencyCode currencyCode}</li>
 * <li>{@link #getTransactionAmount transactionAmount}</li>
 * <li>{@link #getTransactionAmountType transactionAmountType}</li>
 * <li>{@link #getLast4 last4}</li>
 * <li>{@link #getFirst6 first6}</li>
 * <li>{@link #getCountry country}</li>
 * <li>{@link #getBrand brand}</li>
 * <li>{@link #getCreatedTime created_time}</li>
 * <li>{@link #getModifiedTime modified_time}</li>
 * <li>{@link #getObject object}</li>
 * <li>{@link #getCurrency currency}</li>
 * <li>{@link #getName name}</li>
 * <li>{@link #getAddressLine1 address_line1}</li>
 * <li>{@link #getAddressLine1Check address_line1_check}</li>
 * <li>{@link #getAddressLine2 address_line2}</li>
 * <li>{@link #getAddressCity address_city}</li>
 * <li>{@link #getAddressState address_state}</li>
 * <li>{@link #getAddressZip address_zip}</li>
 * <li>{@link #getAddressZipCheck address_zip_check}</li>
 * <li>{@link #getAddressCountry address_country}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class Wallet extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * Unique identifier for the object.
   */
  public String getId() {
    return genClient.cacheGet(CacheKey.id);
  }

  /**
   * card number or DPAN depending on whether it is 3DSecure or PAN only
   */
  public String getNumber() {
    return genClient.cacheGet(CacheKey.number);
  }

  /**
   * Encrypted Card provided by TA - used in PAN Only case of google pay
   */
  public String getEncryptedPan() {
    return genClient.cacheGet(CacheKey.encrypted_pan);
  }

  /**
   * Encrypted pan or dpan for bin lookup purposes only. This is encrypted with custom RSA key used by Bin lookup service
   */
  public String getEncryptedPanForBinLookup() {
    return genClient.cacheGet(CacheKey.encrypted_pan_for_bin_lookup);
  }

  /**
   * token meta id in the db
   */
  public Long getTokenMetaId() {
    return genClient.cacheGet(CacheKey.token_meta_id);
  }

  /**
   * Two-digit number representing the card's expiration month.
   */
  public String getExpMonth() {
    return genClient.cacheGet(CacheKey.exp_month);
  }

  /**
   * Two- or four-digit number representing the card's expiration year.
   */
  public String getExpYear() {
    return genClient.cacheGet(CacheKey.exp_year);
  }

  /**
   * cryptogram for 3DSecure also known as cavv
   */
  public String getCryptogram() {
    return genClient.cacheGet(CacheKey.cryptogram);
  }

  /**
   * apple or google pay
   */
  public WalletType getWalletType() {
    return genClient.cacheGet(CacheKey.walletType);
  }

  /**
   * Payment data type - 3DSecure or pan only
   */
  public com.clover.sdk.v3.tokens.WalletPaymentDataType getPaymentDataType() {
    return genClient.cacheGet(CacheKey.paymentDataType);
  }

  /**
   * ECI EComm indicator
   */
  public String getEciIndicator() {
    return genClient.cacheGet(CacheKey.eciIndicator);
  }

  /**
   * message id from google pay
   */
  public String getGoogleMessageId() {
    return genClient.cacheGet(CacheKey.googleMessageId);
  }

  /**
   * message expiration from google pay
   */
  public String getGoogleMessageExpiration() {
    return genClient.cacheGet(CacheKey.googleMessageExpiration);
  }

  /**
   * apple pay device manufacturer identifier
   */
  public String getAppleDeviceManufacturerIdentifier() {
    return genClient.cacheGet(CacheKey.appleDeviceManufacturerIdentifier);
  }

  /**
   * apple or google pay currency code
   */
  public String getCurrencyCode() {
    return genClient.cacheGet(CacheKey.currencyCode);
  }

  /**
   * apple or google pay transaction amount
   */
  public Long getTransactionAmount() {
    return genClient.cacheGet(CacheKey.transactionAmount);
  }

  /**
   * Transaction amount type - FINAL or ESTIMATED
   */
  public com.clover.sdk.v3.tokens.TransactionAmountType getTransactionAmountType() {
    return genClient.cacheGet(CacheKey.transactionAmountType);
  }

  /**
   * last4 of number (for response only)
   */
  public String getLast4() {
    return genClient.cacheGet(CacheKey.last4);
  }

  /**
   * first6 of number
   */
  public String getFirst6() {
    return genClient.cacheGet(CacheKey.first6);
  }

  /**
   * two character country code
   */
  public String getCountry() {
    return genClient.cacheGet(CacheKey.country);
  }

  /**
   * brand of card (for response only)
   */
  public com.clover.sdk.v3.payments.CardType getBrand() {
    return genClient.cacheGet(CacheKey.brand);
  }

  public Long getCreatedTime() {
    return genClient.cacheGet(CacheKey.created_time);
  }

  public Long getModifiedTime() {
    return genClient.cacheGet(CacheKey.modified_time);
  }

  /**
   * String representing the object’s type. Objects of the same type share the same value.
   */
  public String getObject() {
    return genClient.cacheGet(CacheKey.object);
  }

  /**
   * Required in order to add the card to an account; in all other cases, this parameter is not used. When added to an account, the card (which must be a debit card) can be used as a transfer destination for funds in this currency. Currently, the only supported currency for debit card payouts is `usd`.
   */
  public String getCurrency() {
    return genClient.cacheGet(CacheKey.currency);
  }

  /**
   * Cardholder's full name.
   */
  public String getName() {
    return genClient.cacheGet(CacheKey.name);
  }

  /**
   * Address line 1 (Street address / PO Box / Company name).
   */
  public String getAddressLine1() {
    return genClient.cacheGet(CacheKey.address_line1);
  }

  /**
   * If address_line1 was provided, results of the check: pass, fail, unavailable, or unchecked.
   */
  public String getAddressLine1Check() {
    return genClient.cacheGet(CacheKey.address_line1_check);
  }

  /**
   * Address line 2 (Apartment / Suite / Unit / Building).
   */
  public String getAddressLine2() {
    return genClient.cacheGet(CacheKey.address_line2);
  }

  /**
   * City / District / Suburb / Town / Village.
   */
  public String getAddressCity() {
    return genClient.cacheGet(CacheKey.address_city);
  }

  /**
   * State / County / Province / Region.
   */
  public String getAddressState() {
    return genClient.cacheGet(CacheKey.address_state);
  }

  /**
   * ZIP or postal code.
   */
  public String getAddressZip() {
    return genClient.cacheGet(CacheKey.address_zip);
  }

  /**
   * If address_zip was provided, results of the check: pass, fail, unavailable, or unchecked.
   */
  public String getAddressZipCheck() {
    return genClient.cacheGet(CacheKey.address_zip_check);
  }

  /**
   * Billing address country, if provided.
   */
  public String getAddressCountry() {
    return genClient.cacheGet(CacheKey.address_country);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    id
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    number
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    encrypted_pan
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    encrypted_pan_for_bin_lookup
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    token_meta_id
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(Long.class)),
    exp_month
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    exp_year
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    cryptogram
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    walletType
        (com.clover.sdk.extractors.EnumExtractionStrategy.instance(WalletType.class)),
    paymentDataType
        (com.clover.sdk.extractors.EnumExtractionStrategy.instance(com.clover.sdk.v3.tokens.WalletPaymentDataType.class)),
    eciIndicator
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    googleMessageId
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    googleMessageExpiration
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    appleDeviceManufacturerIdentifier
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    currencyCode
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    transactionAmount
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(Long.class)),
    transactionAmountType
        (com.clover.sdk.extractors.EnumExtractionStrategy.instance(com.clover.sdk.v3.tokens.TransactionAmountType.class)),
    last4
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    first6
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    country
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    brand
        (com.clover.sdk.extractors.EnumExtractionStrategy.instance(com.clover.sdk.v3.payments.CardType.class)),
    created_time
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(Long.class)),
    modified_time
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(Long.class)),
    object
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    currency
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    name
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    address_line1
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    address_line1_check
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    address_line2
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    address_city
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    address_state
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    address_zip
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    address_zip_check
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    address_country
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<Wallet> genClient;

  /**
   * Constructs a new empty instance.
   */
  public Wallet() {
    genClient = new GenericClient<Wallet>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected Wallet(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public Wallet(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public Wallet(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public Wallet(Wallet src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {

    genClient.validateLength(CacheKey.country, getCountry(), 2);
  }

  /** Checks whether the 'id' field is set and is not null */
  public boolean isNotNullId() {
    return genClient.cacheValueIsNotNull(CacheKey.id);
  }

  /** Checks whether the 'number' field is set and is not null */
  public boolean isNotNullNumber() {
    return genClient.cacheValueIsNotNull(CacheKey.number);
  }

  /** Checks whether the 'encrypted_pan' field is set and is not null */
  public boolean isNotNullEncryptedPan() {
    return genClient.cacheValueIsNotNull(CacheKey.encrypted_pan);
  }

  /** Checks whether the 'encrypted_pan_for_bin_lookup' field is set and is not null */
  public boolean isNotNullEncryptedPanForBinLookup() {
    return genClient.cacheValueIsNotNull(CacheKey.encrypted_pan_for_bin_lookup);
  }

  /** Checks whether the 'token_meta_id' field is set and is not null */
  public boolean isNotNullTokenMetaId() {
    return genClient.cacheValueIsNotNull(CacheKey.token_meta_id);
  }

  /** Checks whether the 'exp_month' field is set and is not null */
  public boolean isNotNullExpMonth() {
    return genClient.cacheValueIsNotNull(CacheKey.exp_month);
  }

  /** Checks whether the 'exp_year' field is set and is not null */
  public boolean isNotNullExpYear() {
    return genClient.cacheValueIsNotNull(CacheKey.exp_year);
  }

  /** Checks whether the 'cryptogram' field is set and is not null */
  public boolean isNotNullCryptogram() {
    return genClient.cacheValueIsNotNull(CacheKey.cryptogram);
  }

  /** Checks whether the 'walletType' field is set and is not null */
  public boolean isNotNullWalletType() {
    return genClient.cacheValueIsNotNull(CacheKey.walletType);
  }

  /** Checks whether the 'paymentDataType' field is set and is not null */
  public boolean isNotNullPaymentDataType() {
    return genClient.cacheValueIsNotNull(CacheKey.paymentDataType);
  }

  /** Checks whether the 'eciIndicator' field is set and is not null */
  public boolean isNotNullEciIndicator() {
    return genClient.cacheValueIsNotNull(CacheKey.eciIndicator);
  }

  /** Checks whether the 'googleMessageId' field is set and is not null */
  public boolean isNotNullGoogleMessageId() {
    return genClient.cacheValueIsNotNull(CacheKey.googleMessageId);
  }

  /** Checks whether the 'googleMessageExpiration' field is set and is not null */
  public boolean isNotNullGoogleMessageExpiration() {
    return genClient.cacheValueIsNotNull(CacheKey.googleMessageExpiration);
  }

  /** Checks whether the 'appleDeviceManufacturerIdentifier' field is set and is not null */
  public boolean isNotNullAppleDeviceManufacturerIdentifier() {
    return genClient.cacheValueIsNotNull(CacheKey.appleDeviceManufacturerIdentifier);
  }

  /** Checks whether the 'currencyCode' field is set and is not null */
  public boolean isNotNullCurrencyCode() {
    return genClient.cacheValueIsNotNull(CacheKey.currencyCode);
  }

  /** Checks whether the 'transactionAmount' field is set and is not null */
  public boolean isNotNullTransactionAmount() {
    return genClient.cacheValueIsNotNull(CacheKey.transactionAmount);
  }

  /** Checks whether the 'transactionAmountType' field is set and is not null */
  public boolean isNotNullTransactionAmountType() {
    return genClient.cacheValueIsNotNull(CacheKey.transactionAmountType);
  }

  /** Checks whether the 'last4' field is set and is not null */
  public boolean isNotNullLast4() {
    return genClient.cacheValueIsNotNull(CacheKey.last4);
  }

  /** Checks whether the 'first6' field is set and is not null */
  public boolean isNotNullFirst6() {
    return genClient.cacheValueIsNotNull(CacheKey.first6);
  }

  /** Checks whether the 'country' field is set and is not null */
  public boolean isNotNullCountry() {
    return genClient.cacheValueIsNotNull(CacheKey.country);
  }

  /** Checks whether the 'brand' field is set and is not null */
  public boolean isNotNullBrand() {
    return genClient.cacheValueIsNotNull(CacheKey.brand);
  }

  /** Checks whether the 'created_time' field is set and is not null */
  public boolean isNotNullCreatedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.created_time);
  }

  /** Checks whether the 'modified_time' field is set and is not null */
  public boolean isNotNullModifiedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.modified_time);
  }

  /** Checks whether the 'object' field is set and is not null */
  public boolean isNotNullObject() {
    return genClient.cacheValueIsNotNull(CacheKey.object);
  }

  /** Checks whether the 'currency' field is set and is not null */
  public boolean isNotNullCurrency() {
    return genClient.cacheValueIsNotNull(CacheKey.currency);
  }

  /** Checks whether the 'name' field is set and is not null */
  public boolean isNotNullName() {
    return genClient.cacheValueIsNotNull(CacheKey.name);
  }

  /** Checks whether the 'address_line1' field is set and is not null */
  public boolean isNotNullAddressLine1() {
    return genClient.cacheValueIsNotNull(CacheKey.address_line1);
  }

  /** Checks whether the 'address_line1_check' field is set and is not null */
  public boolean isNotNullAddressLine1Check() {
    return genClient.cacheValueIsNotNull(CacheKey.address_line1_check);
  }

  /** Checks whether the 'address_line2' field is set and is not null */
  public boolean isNotNullAddressLine2() {
    return genClient.cacheValueIsNotNull(CacheKey.address_line2);
  }

  /** Checks whether the 'address_city' field is set and is not null */
  public boolean isNotNullAddressCity() {
    return genClient.cacheValueIsNotNull(CacheKey.address_city);
  }

  /** Checks whether the 'address_state' field is set and is not null */
  public boolean isNotNullAddressState() {
    return genClient.cacheValueIsNotNull(CacheKey.address_state);
  }

  /** Checks whether the 'address_zip' field is set and is not null */
  public boolean isNotNullAddressZip() {
    return genClient.cacheValueIsNotNull(CacheKey.address_zip);
  }

  /** Checks whether the 'address_zip_check' field is set and is not null */
  public boolean isNotNullAddressZipCheck() {
    return genClient.cacheValueIsNotNull(CacheKey.address_zip_check);
  }

  /** Checks whether the 'address_country' field is set and is not null */
  public boolean isNotNullAddressCountry() {
    return genClient.cacheValueIsNotNull(CacheKey.address_country);
  }



  /** Checks whether the 'id' field has been set, however the value could be null */
  public boolean hasId() {
    return genClient.cacheHasKey(CacheKey.id);
  }

  /** Checks whether the 'number' field has been set, however the value could be null */
  public boolean hasNumber() {
    return genClient.cacheHasKey(CacheKey.number);
  }

  /** Checks whether the 'encrypted_pan' field has been set, however the value could be null */
  public boolean hasEncryptedPan() {
    return genClient.cacheHasKey(CacheKey.encrypted_pan);
  }

  /** Checks whether the 'encrypted_pan_for_bin_lookup' field has been set, however the value could be null */
  public boolean hasEncryptedPanForBinLookup() {
    return genClient.cacheHasKey(CacheKey.encrypted_pan_for_bin_lookup);
  }

  /** Checks whether the 'token_meta_id' field has been set, however the value could be null */
  public boolean hasTokenMetaId() {
    return genClient.cacheHasKey(CacheKey.token_meta_id);
  }

  /** Checks whether the 'exp_month' field has been set, however the value could be null */
  public boolean hasExpMonth() {
    return genClient.cacheHasKey(CacheKey.exp_month);
  }

  /** Checks whether the 'exp_year' field has been set, however the value could be null */
  public boolean hasExpYear() {
    return genClient.cacheHasKey(CacheKey.exp_year);
  }

  /** Checks whether the 'cryptogram' field has been set, however the value could be null */
  public boolean hasCryptogram() {
    return genClient.cacheHasKey(CacheKey.cryptogram);
  }

  /** Checks whether the 'walletType' field has been set, however the value could be null */
  public boolean hasWalletType() {
    return genClient.cacheHasKey(CacheKey.walletType);
  }

  /** Checks whether the 'paymentDataType' field has been set, however the value could be null */
  public boolean hasPaymentDataType() {
    return genClient.cacheHasKey(CacheKey.paymentDataType);
  }

  /** Checks whether the 'eciIndicator' field has been set, however the value could be null */
  public boolean hasEciIndicator() {
    return genClient.cacheHasKey(CacheKey.eciIndicator);
  }

  /** Checks whether the 'googleMessageId' field has been set, however the value could be null */
  public boolean hasGoogleMessageId() {
    return genClient.cacheHasKey(CacheKey.googleMessageId);
  }

  /** Checks whether the 'googleMessageExpiration' field has been set, however the value could be null */
  public boolean hasGoogleMessageExpiration() {
    return genClient.cacheHasKey(CacheKey.googleMessageExpiration);
  }

  /** Checks whether the 'appleDeviceManufacturerIdentifier' field has been set, however the value could be null */
  public boolean hasAppleDeviceManufacturerIdentifier() {
    return genClient.cacheHasKey(CacheKey.appleDeviceManufacturerIdentifier);
  }

  /** Checks whether the 'currencyCode' field has been set, however the value could be null */
  public boolean hasCurrencyCode() {
    return genClient.cacheHasKey(CacheKey.currencyCode);
  }

  /** Checks whether the 'transactionAmount' field has been set, however the value could be null */
  public boolean hasTransactionAmount() {
    return genClient.cacheHasKey(CacheKey.transactionAmount);
  }

  /** Checks whether the 'transactionAmountType' field has been set, however the value could be null */
  public boolean hasTransactionAmountType() {
    return genClient.cacheHasKey(CacheKey.transactionAmountType);
  }

  /** Checks whether the 'last4' field has been set, however the value could be null */
  public boolean hasLast4() {
    return genClient.cacheHasKey(CacheKey.last4);
  }

  /** Checks whether the 'first6' field has been set, however the value could be null */
  public boolean hasFirst6() {
    return genClient.cacheHasKey(CacheKey.first6);
  }

  /** Checks whether the 'country' field has been set, however the value could be null */
  public boolean hasCountry() {
    return genClient.cacheHasKey(CacheKey.country);
  }

  /** Checks whether the 'brand' field has been set, however the value could be null */
  public boolean hasBrand() {
    return genClient.cacheHasKey(CacheKey.brand);
  }

  /** Checks whether the 'created_time' field has been set, however the value could be null */
  public boolean hasCreatedTime() {
    return genClient.cacheHasKey(CacheKey.created_time);
  }

  /** Checks whether the 'modified_time' field has been set, however the value could be null */
  public boolean hasModifiedTime() {
    return genClient.cacheHasKey(CacheKey.modified_time);
  }

  /** Checks whether the 'object' field has been set, however the value could be null */
  public boolean hasObject() {
    return genClient.cacheHasKey(CacheKey.object);
  }

  /** Checks whether the 'currency' field has been set, however the value could be null */
  public boolean hasCurrency() {
    return genClient.cacheHasKey(CacheKey.currency);
  }

  /** Checks whether the 'name' field has been set, however the value could be null */
  public boolean hasName() {
    return genClient.cacheHasKey(CacheKey.name);
  }

  /** Checks whether the 'address_line1' field has been set, however the value could be null */
  public boolean hasAddressLine1() {
    return genClient.cacheHasKey(CacheKey.address_line1);
  }

  /** Checks whether the 'address_line1_check' field has been set, however the value could be null */
  public boolean hasAddressLine1Check() {
    return genClient.cacheHasKey(CacheKey.address_line1_check);
  }

  /** Checks whether the 'address_line2' field has been set, however the value could be null */
  public boolean hasAddressLine2() {
    return genClient.cacheHasKey(CacheKey.address_line2);
  }

  /** Checks whether the 'address_city' field has been set, however the value could be null */
  public boolean hasAddressCity() {
    return genClient.cacheHasKey(CacheKey.address_city);
  }

  /** Checks whether the 'address_state' field has been set, however the value could be null */
  public boolean hasAddressState() {
    return genClient.cacheHasKey(CacheKey.address_state);
  }

  /** Checks whether the 'address_zip' field has been set, however the value could be null */
  public boolean hasAddressZip() {
    return genClient.cacheHasKey(CacheKey.address_zip);
  }

  /** Checks whether the 'address_zip_check' field has been set, however the value could be null */
  public boolean hasAddressZipCheck() {
    return genClient.cacheHasKey(CacheKey.address_zip_check);
  }

  /** Checks whether the 'address_country' field has been set, however the value could be null */
  public boolean hasAddressCountry() {
    return genClient.cacheHasKey(CacheKey.address_country);
  }


  /**
   * Sets the field 'id'.
   */
  public Wallet setId(String id) {
    return genClient.setOther(id, CacheKey.id);
  }

  /**
   * Sets the field 'number'.
   */
  public Wallet setNumber(String number) {
    return genClient.setOther(number, CacheKey.number);
  }

  /**
   * Sets the field 'encrypted_pan'.
   */
  public Wallet setEncryptedPan(String encrypted_pan) {
    return genClient.setOther(encrypted_pan, CacheKey.encrypted_pan);
  }

  /**
   * Sets the field 'encrypted_pan_for_bin_lookup'.
   */
  public Wallet setEncryptedPanForBinLookup(String encrypted_pan_for_bin_lookup) {
    return genClient.setOther(encrypted_pan_for_bin_lookup, CacheKey.encrypted_pan_for_bin_lookup);
  }

  /**
   * Sets the field 'token_meta_id'.
   */
  public Wallet setTokenMetaId(Long token_meta_id) {
    return genClient.setOther(token_meta_id, CacheKey.token_meta_id);
  }

  /**
   * Sets the field 'exp_month'.
   */
  public Wallet setExpMonth(String exp_month) {
    return genClient.setOther(exp_month, CacheKey.exp_month);
  }

  /**
   * Sets the field 'exp_year'.
   */
  public Wallet setExpYear(String exp_year) {
    return genClient.setOther(exp_year, CacheKey.exp_year);
  }

  /**
   * Sets the field 'cryptogram'.
   */
  public Wallet setCryptogram(String cryptogram) {
    return genClient.setOther(cryptogram, CacheKey.cryptogram);
  }

  /**
   * Sets the field 'walletType'.
   */
  public Wallet setWalletType(WalletType walletType) {
    return genClient.setOther(walletType, CacheKey.walletType);
  }

  /**
   * Sets the field 'paymentDataType'.
   */
  public Wallet setPaymentDataType(com.clover.sdk.v3.tokens.WalletPaymentDataType paymentDataType) {
    return genClient.setOther(paymentDataType, CacheKey.paymentDataType);
  }

  /**
   * Sets the field 'eciIndicator'.
   */
  public Wallet setEciIndicator(String eciIndicator) {
    return genClient.setOther(eciIndicator, CacheKey.eciIndicator);
  }

  /**
   * Sets the field 'googleMessageId'.
   */
  public Wallet setGoogleMessageId(String googleMessageId) {
    return genClient.setOther(googleMessageId, CacheKey.googleMessageId);
  }

  /**
   * Sets the field 'googleMessageExpiration'.
   */
  public Wallet setGoogleMessageExpiration(String googleMessageExpiration) {
    return genClient.setOther(googleMessageExpiration, CacheKey.googleMessageExpiration);
  }

  /**
   * Sets the field 'appleDeviceManufacturerIdentifier'.
   */
  public Wallet setAppleDeviceManufacturerIdentifier(String appleDeviceManufacturerIdentifier) {
    return genClient.setOther(appleDeviceManufacturerIdentifier, CacheKey.appleDeviceManufacturerIdentifier);
  }

  /**
   * Sets the field 'currencyCode'.
   */
  public Wallet setCurrencyCode(String currencyCode) {
    return genClient.setOther(currencyCode, CacheKey.currencyCode);
  }

  /**
   * Sets the field 'transactionAmount'.
   */
  public Wallet setTransactionAmount(Long transactionAmount) {
    return genClient.setOther(transactionAmount, CacheKey.transactionAmount);
  }

  /**
   * Sets the field 'transactionAmountType'.
   */
  public Wallet setTransactionAmountType(com.clover.sdk.v3.tokens.TransactionAmountType transactionAmountType) {
    return genClient.setOther(transactionAmountType, CacheKey.transactionAmountType);
  }

  /**
   * Sets the field 'last4'.
   */
  public Wallet setLast4(String last4) {
    return genClient.setOther(last4, CacheKey.last4);
  }

  /**
   * Sets the field 'first6'.
   */
  public Wallet setFirst6(String first6) {
    return genClient.setOther(first6, CacheKey.first6);
  }

  /**
   * Sets the field 'country'.
   */
  public Wallet setCountry(String country) {
    return genClient.setOther(country, CacheKey.country);
  }

  /**
   * Sets the field 'brand'.
   */
  public Wallet setBrand(com.clover.sdk.v3.payments.CardType brand) {
    return genClient.setOther(brand, CacheKey.brand);
  }

  /**
   * Sets the field 'created_time'.
   */
  public Wallet setCreatedTime(Long created_time) {
    return genClient.setOther(created_time, CacheKey.created_time);
  }

  /**
   * Sets the field 'modified_time'.
   */
  public Wallet setModifiedTime(Long modified_time) {
    return genClient.setOther(modified_time, CacheKey.modified_time);
  }

  /**
   * Sets the field 'object'.
   */
  public Wallet setObject(String object) {
    return genClient.setOther(object, CacheKey.object);
  }

  /**
   * Sets the field 'currency'.
   */
  public Wallet setCurrency(String currency) {
    return genClient.setOther(currency, CacheKey.currency);
  }

  /**
   * Sets the field 'name'.
   */
  public Wallet setName(String name) {
    return genClient.setOther(name, CacheKey.name);
  }

  /**
   * Sets the field 'address_line1'.
   */
  public Wallet setAddressLine1(String address_line1) {
    return genClient.setOther(address_line1, CacheKey.address_line1);
  }

  /**
   * Sets the field 'address_line1_check'.
   */
  public Wallet setAddressLine1Check(String address_line1_check) {
    return genClient.setOther(address_line1_check, CacheKey.address_line1_check);
  }

  /**
   * Sets the field 'address_line2'.
   */
  public Wallet setAddressLine2(String address_line2) {
    return genClient.setOther(address_line2, CacheKey.address_line2);
  }

  /**
   * Sets the field 'address_city'.
   */
  public Wallet setAddressCity(String address_city) {
    return genClient.setOther(address_city, CacheKey.address_city);
  }

  /**
   * Sets the field 'address_state'.
   */
  public Wallet setAddressState(String address_state) {
    return genClient.setOther(address_state, CacheKey.address_state);
  }

  /**
   * Sets the field 'address_zip'.
   */
  public Wallet setAddressZip(String address_zip) {
    return genClient.setOther(address_zip, CacheKey.address_zip);
  }

  /**
   * Sets the field 'address_zip_check'.
   */
  public Wallet setAddressZipCheck(String address_zip_check) {
    return genClient.setOther(address_zip_check, CacheKey.address_zip_check);
  }

  /**
   * Sets the field 'address_country'.
   */
  public Wallet setAddressCountry(String address_country) {
    return genClient.setOther(address_country, CacheKey.address_country);
  }


  /** Clears the 'id' field, the 'has' method for this field will now return false */
  public void clearId() {
    genClient.clear(CacheKey.id);
  }
  /** Clears the 'number' field, the 'has' method for this field will now return false */
  public void clearNumber() {
    genClient.clear(CacheKey.number);
  }
  /** Clears the 'encrypted_pan' field, the 'has' method for this field will now return false */
  public void clearEncryptedPan() {
    genClient.clear(CacheKey.encrypted_pan);
  }
  /** Clears the 'encrypted_pan_for_bin_lookup' field, the 'has' method for this field will now return false */
  public void clearEncryptedPanForBinLookup() {
    genClient.clear(CacheKey.encrypted_pan_for_bin_lookup);
  }
  /** Clears the 'token_meta_id' field, the 'has' method for this field will now return false */
  public void clearTokenMetaId() {
    genClient.clear(CacheKey.token_meta_id);
  }
  /** Clears the 'exp_month' field, the 'has' method for this field will now return false */
  public void clearExpMonth() {
    genClient.clear(CacheKey.exp_month);
  }
  /** Clears the 'exp_year' field, the 'has' method for this field will now return false */
  public void clearExpYear() {
    genClient.clear(CacheKey.exp_year);
  }
  /** Clears the 'cryptogram' field, the 'has' method for this field will now return false */
  public void clearCryptogram() {
    genClient.clear(CacheKey.cryptogram);
  }
  /** Clears the 'walletType' field, the 'has' method for this field will now return false */
  public void clearWalletType() {
    genClient.clear(CacheKey.walletType);
  }
  /** Clears the 'paymentDataType' field, the 'has' method for this field will now return false */
  public void clearPaymentDataType() {
    genClient.clear(CacheKey.paymentDataType);
  }
  /** Clears the 'eciIndicator' field, the 'has' method for this field will now return false */
  public void clearEciIndicator() {
    genClient.clear(CacheKey.eciIndicator);
  }
  /** Clears the 'googleMessageId' field, the 'has' method for this field will now return false */
  public void clearGoogleMessageId() {
    genClient.clear(CacheKey.googleMessageId);
  }
  /** Clears the 'googleMessageExpiration' field, the 'has' method for this field will now return false */
  public void clearGoogleMessageExpiration() {
    genClient.clear(CacheKey.googleMessageExpiration);
  }
  /** Clears the 'appleDeviceManufacturerIdentifier' field, the 'has' method for this field will now return false */
  public void clearAppleDeviceManufacturerIdentifier() {
    genClient.clear(CacheKey.appleDeviceManufacturerIdentifier);
  }
  /** Clears the 'currencyCode' field, the 'has' method for this field will now return false */
  public void clearCurrencyCode() {
    genClient.clear(CacheKey.currencyCode);
  }
  /** Clears the 'transactionAmount' field, the 'has' method for this field will now return false */
  public void clearTransactionAmount() {
    genClient.clear(CacheKey.transactionAmount);
  }
  /** Clears the 'transactionAmountType' field, the 'has' method for this field will now return false */
  public void clearTransactionAmountType() {
    genClient.clear(CacheKey.transactionAmountType);
  }
  /** Clears the 'last4' field, the 'has' method for this field will now return false */
  public void clearLast4() {
    genClient.clear(CacheKey.last4);
  }
  /** Clears the 'first6' field, the 'has' method for this field will now return false */
  public void clearFirst6() {
    genClient.clear(CacheKey.first6);
  }
  /** Clears the 'country' field, the 'has' method for this field will now return false */
  public void clearCountry() {
    genClient.clear(CacheKey.country);
  }
  /** Clears the 'brand' field, the 'has' method for this field will now return false */
  public void clearBrand() {
    genClient.clear(CacheKey.brand);
  }
  /** Clears the 'created_time' field, the 'has' method for this field will now return false */
  public void clearCreatedTime() {
    genClient.clear(CacheKey.created_time);
  }
  /** Clears the 'modified_time' field, the 'has' method for this field will now return false */
  public void clearModifiedTime() {
    genClient.clear(CacheKey.modified_time);
  }
  /** Clears the 'object' field, the 'has' method for this field will now return false */
  public void clearObject() {
    genClient.clear(CacheKey.object);
  }
  /** Clears the 'currency' field, the 'has' method for this field will now return false */
  public void clearCurrency() {
    genClient.clear(CacheKey.currency);
  }
  /** Clears the 'name' field, the 'has' method for this field will now return false */
  public void clearName() {
    genClient.clear(CacheKey.name);
  }
  /** Clears the 'address_line1' field, the 'has' method for this field will now return false */
  public void clearAddressLine1() {
    genClient.clear(CacheKey.address_line1);
  }
  /** Clears the 'address_line1_check' field, the 'has' method for this field will now return false */
  public void clearAddressLine1Check() {
    genClient.clear(CacheKey.address_line1_check);
  }
  /** Clears the 'address_line2' field, the 'has' method for this field will now return false */
  public void clearAddressLine2() {
    genClient.clear(CacheKey.address_line2);
  }
  /** Clears the 'address_city' field, the 'has' method for this field will now return false */
  public void clearAddressCity() {
    genClient.clear(CacheKey.address_city);
  }
  /** Clears the 'address_state' field, the 'has' method for this field will now return false */
  public void clearAddressState() {
    genClient.clear(CacheKey.address_state);
  }
  /** Clears the 'address_zip' field, the 'has' method for this field will now return false */
  public void clearAddressZip() {
    genClient.clear(CacheKey.address_zip);
  }
  /** Clears the 'address_zip_check' field, the 'has' method for this field will now return false */
  public void clearAddressZipCheck() {
    genClient.clear(CacheKey.address_zip_check);
  }
  /** Clears the 'address_country' field, the 'has' method for this field will now return false */
  public void clearAddressCountry() {
    genClient.clear(CacheKey.address_country);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public Wallet copyChanges() {
    Wallet copy = new Wallet();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(Wallet src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new Wallet(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<Wallet> CREATOR = new android.os.Parcelable.Creator<Wallet>() {
    @Override
    public Wallet createFromParcel(android.os.Parcel in) {
      Wallet instance = new Wallet(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public Wallet[] newArray(int size) {
      return new Wallet[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<Wallet> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<Wallet>() {
    public Class<Wallet> getCreatedClass() {
      return Wallet.class;
    }

    @Override
    public Wallet create(org.json.JSONObject jsonObject) {
      return new Wallet(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean ID_IS_REQUIRED = false;
    public static final boolean NUMBER_IS_REQUIRED = false;
    public static final boolean ENCRYPTED_PAN_IS_REQUIRED = false;
    public static final boolean ENCRYPTED_PAN_FOR_BIN_LOOKUP_IS_REQUIRED = false;
    public static final boolean TOKEN_META_ID_IS_REQUIRED = false;
    public static final boolean EXP_MONTH_IS_REQUIRED = false;
    public static final boolean EXP_YEAR_IS_REQUIRED = false;
    public static final boolean CRYPTOGRAM_IS_REQUIRED = false;
    public static final boolean WALLETTYPE_IS_REQUIRED = false;
    public static final boolean PAYMENTDATATYPE_IS_REQUIRED = false;
    public static final boolean ECIINDICATOR_IS_REQUIRED = false;
    public static final boolean GOOGLEMESSAGEID_IS_REQUIRED = false;
    public static final boolean GOOGLEMESSAGEEXPIRATION_IS_REQUIRED = false;
    public static final boolean APPLEDEVICEMANUFACTURERIDENTIFIER_IS_REQUIRED = false;
    public static final boolean CURRENCYCODE_IS_REQUIRED = false;
    public static final boolean TRANSACTIONAMOUNT_IS_REQUIRED = false;
    public static final boolean TRANSACTIONAMOUNTTYPE_IS_REQUIRED = false;
    public static final boolean LAST4_IS_REQUIRED = false;
    public static final boolean FIRST6_IS_REQUIRED = false;
    public static final boolean COUNTRY_IS_REQUIRED = false;
    public static final long COUNTRY_MAX_LEN = 2;
    public static final boolean BRAND_IS_REQUIRED = false;
    public static final boolean CREATED_TIME_IS_REQUIRED = false;
    public static final boolean MODIFIED_TIME_IS_REQUIRED = false;
    public static final boolean OBJECT_IS_REQUIRED = false;
    public static final boolean CURRENCY_IS_REQUIRED = false;
    public static final boolean NAME_IS_REQUIRED = false;
    public static final boolean ADDRESS_LINE1_IS_REQUIRED = false;
    public static final boolean ADDRESS_LINE1_CHECK_IS_REQUIRED = false;
    public static final boolean ADDRESS_LINE2_IS_REQUIRED = false;
    public static final boolean ADDRESS_CITY_IS_REQUIRED = false;
    public static final boolean ADDRESS_STATE_IS_REQUIRED = false;
    public static final boolean ADDRESS_ZIP_IS_REQUIRED = false;
    public static final boolean ADDRESS_ZIP_CHECK_IS_REQUIRED = false;
    public static final boolean ADDRESS_COUNTRY_IS_REQUIRED = false;
  }

}
