/*
 * Copyright (C) 2013 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Autogenerated by Avro
 *
 * DO NOT EDIT DIRECTLY
 */


package com.clover.sdk.v1.inventory;

@SuppressWarnings("all")
public class CategoryDescription implements android.os.Parcelable, com.clover.sdk.v1.Validator {

  protected String jsonString = null;
  protected org.json.JSONObject jsonObject = null;

  public CategoryDescription(String json, boolean ignore) {
    this.jsonString = json;
  }

  public CategoryDescription(org.json.JSONObject jsonObject) {
    this.jsonObject = jsonObject;
  }

  public CategoryDescription(java.lang.String id, java.lang.String name, java.lang.Integer sortOrder, java.util.List<java.lang.String> items) throws org.json.JSONException {
    if (name == null) {
      throw new IllegalArgumentException("'name' is required to be non-null");
    }
    setId(id);
    setName(name);
    setSortOrder(sortOrder);
    setItems(items);
  }

  protected org.json.JSONObject getJSONObject() {
    try {
      if (jsonObject == null) {
        if (jsonString != null) {
          jsonObject = (org.json.JSONObject) new org.json.JSONTokener(jsonString).nextValue();
        } else {
          jsonObject = new org.json.JSONObject();
        }
      }
    } catch (org.json.JSONException e) {
      // print some kind of error
    }
    return jsonObject;
  }

  public void validate() throws org.json.JSONException {
    if (getName() == null) {
      throw new IllegalArgumentException("'name' is required to be non-null");
    }
    java.lang.String id = getId();
    if (id != null && id.length() > 13) {
      throw new IllegalArgumentException("Maximum string length exceeded for 'id'");
    }
    java.lang.String name = getName();
    if (name != null && name.length() > 127) {
      throw new IllegalArgumentException("Maximum string length exceeded for 'name'");
    }
    java.lang.Integer sortOrder = getSortOrder();
    if (sortOrder != null && sortOrder < 0) {
      throw new IllegalArgumentException("Invalid value for 'sortOrder'");
    }
    java.util.List<java.lang.String> items = getItems();

    // TODO: also validate string length, valid ranges and other integrity checks
  }

  public java.lang.String getId() {
    return getJSONObject().optString("id");
  }

  /**
   *
   */
  public java.lang.String getName() {
    return getJSONObject().optString("name");
  }

  public java.lang.Integer getSortOrder() {
    return getJSONObject().optInt("sortOrder");
  }

  public java.util.List<java.lang.String> getItems() {
    java.util.List<java.lang.String> itemList = null;
    if (getJSONObject().has("items")) {
      itemList = new java.util.ArrayList<java.lang.String>();
      org.json.JSONArray itemArray = getJSONObject().optJSONArray("items");
      for (int i = 0; i < itemArray.length(); i++) {
        org.json.JSONObject obj = itemArray.optJSONObject(i);
        java.lang.String item = obj.toString();
        itemList.add(item);
      }
    }
    return itemList;
  }


  /**
   * Checks whether the 'id' field has been set
   */
  public boolean hasId() {
    return getJSONObject().has("id");
  }

  /**
   * Checks whether the 'name' field has been set
   */
  public boolean hasName() {
    return getJSONObject().has("name");
  }

  /**
   * Checks whether the 'sortOrder' field has been set
   */
  public boolean hasSortOrder() {
    return getJSONObject().has("sortOrder");
  }

  /**
   * Checks whether the 'items' field has been set
   */
  public boolean hasItems() {
    return getJSONObject().has("items");
  }

  public void setId(java.lang.String id) throws org.json.JSONException {
    if (id != null && id.length() > 13) {
      throw new IllegalArgumentException("Maximum string length exceeded for 'id'");
    }
    getJSONObject().put("id", id);
  }

  public void setName(java.lang.String name) throws org.json.JSONException {
    if (name != null && name.length() > 127) {
      throw new IllegalArgumentException("Maximum string length exceeded for 'name'");
    }
    getJSONObject().put("name", name);
  }

  public void setSortOrder(java.lang.Integer sortOrder) throws org.json.JSONException {
    if (sortOrder != null && sortOrder < 0) {
      throw new IllegalArgumentException("Invalid value for 'sortOrder'");
    }
    getJSONObject().put("sortOrder", sortOrder);
  }

  public void setItems(java.util.List<java.lang.String> items) throws org.json.JSONException {
    if (items != null) {
      org.json.JSONArray array = new org.json.JSONArray();
      for (java.lang.String obj : items) {
        array.put(obj.toString());
      }
      getJSONObject().put("items", array);
    }
  }


  @Override
  public int describeContents() {
    return 0;
  }

  @Override
  public void writeToParcel(android.os.Parcel dest, int flags) {
    String json = jsonString != null ? jsonString : getJSONObject().toString();
    dest.writeString(json);
  }

  public static final android.os.Parcelable.Creator<CategoryDescription> CREATOR = new android.os.Parcelable.Creator<CategoryDescription>() {
    public CategoryDescription createFromParcel(android.os.Parcel in) {
      String json = in.readString();
      return new CategoryDescription(json, true);
    }

    public CategoryDescription[] newArray(int size) {
      return new CategoryDescription[size];
    }
  };

  public static class Builder {

    private java.lang.String id;
    private java.lang.String name;
    private java.lang.Integer sortOrder;
    private java.util.List<java.lang.String> items;

    public Builder() {
    }

    public Builder id(java.lang.String id) {
      if (id != null && id.length() > 13) {
        throw new IllegalArgumentException("Maximum string length exceeded for 'id'");
      }
      this.id = id;
      return this;
    }

    public Builder name(java.lang.String name) {
      if (name != null && name.length() > 127) {
        throw new IllegalArgumentException("Maximum string length exceeded for 'name'");
      }
      this.name = name;
      return this;
    }

    public Builder sortOrder(java.lang.Integer sortOrder) {
      if (sortOrder != null && sortOrder < 0) {
        throw new IllegalArgumentException("Invalid value for 'sortOrder'");
      }
      this.sortOrder = sortOrder;
      return this;
    }

    public Builder items(java.util.List<java.lang.String> items) {

      this.items = items;
      return this;
    }

    public CategoryDescription build() throws org.json.JSONException {
      return new CategoryDescription(id, name, sortOrder, items);
    }
  }

}
