/*
 * Copyright (C) 2013 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Autogenerated by Avro
 *
 * DO NOT EDIT DIRECTLY
 */


package com.clover.sdk.v1.inventory;

@SuppressWarnings("all")
public class Modifier implements android.os.Parcelable, com.clover.sdk.v1.Validator {

  protected String jsonString = null;
  protected org.json.JSONObject jsonObject = null;

  public Modifier(String json, boolean ignore) {
    this.jsonString = json;
  }

  public Modifier(org.json.JSONObject jsonObject) {
    this.jsonObject = jsonObject;
  }

  public Modifier(java.lang.String id, java.lang.String name, java.lang.String alternateName, java.lang.Long price) throws org.json.JSONException {
    if (name == null) {
      throw new IllegalArgumentException("'name' is required to be non-null");
    }
    setId(id);
    setName(name);
    setAlternateName(alternateName);
    setPrice(price);
  }

  protected org.json.JSONObject getJSONObject() {
    try {
      if (jsonObject == null) {
        if (jsonString != null) {
          jsonObject = (org.json.JSONObject) new org.json.JSONTokener(jsonString).nextValue();
        } else {
          jsonObject = new org.json.JSONObject();
        }
      }
    } catch (org.json.JSONException e) {
      // print some kind of error
    }
    return jsonObject;
  }

  public void validate() throws org.json.JSONException {
    if (getName() == null) {
      throw new IllegalArgumentException("'name' is required to be non-null");
    }
    java.lang.String id = getId();
    if (id != null && id.length() > 13) {
      throw new IllegalArgumentException("Maximum string length exceeded for 'id'");
    }
    java.lang.String name = getName();
    if (name != null && name.length() > 255) {
      throw new IllegalArgumentException("Maximum string length exceeded for 'name'");
    }
    java.lang.String alternateName = getAlternateName();
    if (alternateName != null && alternateName.length() > 255) {
      throw new IllegalArgumentException("Maximum string length exceeded for 'alternateName'");
    }
    java.lang.Long price = getPrice();
    if (price != null && price < 0) {
      throw new IllegalArgumentException("Invalid value for 'price'");
    }
    // TODO: also validate string length, valid ranges and other integrity checks
  }

  /**
   * Unique identifier
   */
  public java.lang.String getId() {
    return getJSONObject().optString("id");
  }

  /**
   * Name of the modifier
   */
  public java.lang.String getName() {
    return getJSONObject().optString("name");
  }

  /**
   * Alternate name of the modifier
   */
  public java.lang.String getAlternateName() {
    return getJSONObject().optString("alternateName");
  }

  /**
   *
   */
  public java.lang.Long getPrice() {
    return getJSONObject().optLong("price", 0);
  }


  /**
   * Checks whether the 'id' field has been set
   */
  public boolean hasId() {
    return getJSONObject().has("id");
  }

  /**
   * Checks whether the 'name' field has been set
   */
  public boolean hasName() {
    return getJSONObject().has("name");
  }

  /**
   * Checks whether the 'alternateName' field has been set
   */
  public boolean hasAlternateName() {
    return getJSONObject().has("alternateName");
  }

  /**
   * Checks whether the 'price' field has been set
   */
  public boolean hasPrice() {
    return getJSONObject().has("price");
  }

  public void setId(java.lang.String id) throws org.json.JSONException {
    if (id != null && id.length() > 13) {
      throw new IllegalArgumentException("Maximum string length exceeded for 'id'");
    }
    getJSONObject().put("id", id);
  }

  public void setName(java.lang.String name) throws org.json.JSONException {
    if (name != null && name.length() > 255) {
      throw new IllegalArgumentException("Maximum string length exceeded for 'name'");
    }
    getJSONObject().put("name", name);
  }

  public void setAlternateName(java.lang.String alternateName) throws org.json.JSONException {
    if (alternateName != null && alternateName.length() > 255) {
      throw new IllegalArgumentException("Maximum string length exceeded for 'alternateName'");
    }
    getJSONObject().put("alternateName", alternateName);
  }

  public void setPrice(java.lang.Long price) throws org.json.JSONException {
    if (price != null && price < 0) {
      throw new IllegalArgumentException("Invalid value for 'price'");
    }
    getJSONObject().put("price", price);
  }


  @Override
  public int describeContents() {
    return 0;
  }

  @Override
  public void writeToParcel(android.os.Parcel dest, int flags) {
    String json = jsonString != null ? jsonString : getJSONObject().toString();
    dest.writeString(json);
  }

  public static final android.os.Parcelable.Creator<Modifier> CREATOR = new android.os.Parcelable.Creator<Modifier>() {
    public Modifier createFromParcel(android.os.Parcel in) {
      String json = in.readString();
      return new Modifier(json, true);
    }

    public Modifier[] newArray(int size) {
      return new Modifier[size];
    }
  };

  public static class Builder {

    private java.lang.String id;
    private java.lang.String name;
    private java.lang.String alternateName;
    private java.lang.Long price;

    public Builder() {
    }

    public Builder id(java.lang.String id) {
      if (id != null && id.length() > 13) {
        throw new IllegalArgumentException("Maximum string length exceeded for 'id'");
      }
      this.id = id;
      return this;
    }

    public Builder name(java.lang.String name) {
      if (name != null && name.length() > 255) {
        throw new IllegalArgumentException("Maximum string length exceeded for 'name'");
      }
      this.name = name;
      return this;
    }

    public Builder alternateName(java.lang.String alternateName) {
      if (alternateName != null && alternateName.length() > 255) {
        throw new IllegalArgumentException("Maximum string length exceeded for 'alternateName'");
      }
      this.alternateName = alternateName;
      return this;
    }

    public Builder price(java.lang.Long price) {
      if (price != null && price < 0) {
        throw new IllegalArgumentException("Invalid value for 'price'");
      }
      this.price = price;
      return this;
    }

    public Modifier build() throws org.json.JSONException {
      return new Modifier(id, name, alternateName, price);
    }
  }

}
