/*
 * Copyright (C) 2013 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Autogenerated by Avro
 *
 * DO NOT EDIT DIRECTLY
 */


package com.clover.sdk.v1.inventory;

@SuppressWarnings("all")
public class ModifierGroup implements android.os.Parcelable, com.clover.sdk.v1.Validator {

  protected String jsonString = null;
  protected org.json.JSONObject jsonObject = null;

  public ModifierGroup(String json, boolean ignore) {
    this.jsonString = json;
  }

  public ModifierGroup(org.json.JSONObject jsonObject) {
    this.jsonObject = jsonObject;
  }

  public ModifierGroup(java.lang.String id, java.lang.String name, java.lang.Boolean showByDefault, java.util.List<com.clover.sdk.v1.inventory.Modifier> modifiers) throws org.json.JSONException {
    if (name == null) {
      throw new IllegalArgumentException("'name' is required to be non-null");
    }
    setId(id);
    setName(name);
    setShowByDefault(showByDefault);
    setModifiers(modifiers);
  }

  protected org.json.JSONObject getJSONObject() {
    try {
      if (jsonObject == null) {
        if (jsonString != null) {
          jsonObject = (org.json.JSONObject) new org.json.JSONTokener(jsonString).nextValue();
        } else {
          jsonObject = new org.json.JSONObject();
        }
      }
    } catch (org.json.JSONException e) {
      // print some kind of error
    }
    return jsonObject;
  }

  public void validate() throws org.json.JSONException {
    if (getName() == null) {
      throw new IllegalArgumentException("'name' is required to be non-null");
    }
    java.lang.String id = getId();
    if (id != null && id.length() > 13) {
      throw new IllegalArgumentException("Maximum string length exceeded for 'id'");
    }
    java.lang.String name = getName();
    if (name != null && name.length() > 255) {
      throw new IllegalArgumentException("Maximum string length exceeded for 'name'");
    }
    java.lang.Boolean showByDefault = getShowByDefault();

    java.util.List<com.clover.sdk.v1.inventory.Modifier> modifiers = getModifiers();

    // TODO: also validate string length, valid ranges and other integrity checks
  }

  public java.lang.String getId() {
    return getJSONObject().optString("id");
  }

  /**
   * Name of the modifier group
   */
  public java.lang.String getName() {
    return getJSONObject().optString("name");
  }

  public java.lang.Boolean getShowByDefault() {
    return getJSONObject().optBoolean("showByDefault", true);
  }

  public java.util.List<com.clover.sdk.v1.inventory.Modifier> getModifiers() throws org.json.JSONException {
    java.util.List<com.clover.sdk.v1.inventory.Modifier> itemList = null;
    if (getJSONObject().has("modifiers")) {
      itemList = new java.util.ArrayList<com.clover.sdk.v1.inventory.Modifier>();
      org.json.JSONArray itemArray = getJSONObject().getJSONArray("modifiers");
      for (int i = 0; i < itemArray.length(); i++) {
        org.json.JSONObject obj = itemArray.getJSONObject(i);
        com.clover.sdk.v1.inventory.Modifier item = new com.clover.sdk.v1.inventory.Modifier(obj);
        itemList.add(item);
      }
    }
    return itemList;
  }


  /**
   * Checks whether the 'id' field has been set
   */
  public boolean hasId() {
    return getJSONObject().has("id");
  }

  /**
   * Checks whether the 'name' field has been set
   */
  public boolean hasName() {
    return getJSONObject().has("name");
  }

  /**
   * Checks whether the 'showByDefault' field has been set
   */
  public boolean hasShowByDefault() {
    return getJSONObject().has("showByDefault");
  }

  /**
   * Checks whether the 'modifiers' field has been set
   */
  public boolean hasModifiers() {
    return getJSONObject().has("modifiers");
  }

  public void setId(java.lang.String id) throws org.json.JSONException {
    if (id != null && id.length() > 13) {
      throw new IllegalArgumentException("Maximum string length exceeded for 'id'");
    }
    getJSONObject().put("id", id);
  }

  public void setName(java.lang.String name) throws org.json.JSONException {
    if (name != null && name.length() > 255) {
      throw new IllegalArgumentException("Maximum string length exceeded for 'name'");
    }
    getJSONObject().put("name", name);
  }

  public void setShowByDefault(java.lang.Boolean showByDefault) throws org.json.JSONException {

    getJSONObject().put("showByDefault", showByDefault);
  }

  public void setModifiers(java.util.List<com.clover.sdk.v1.inventory.Modifier> modifiers) throws org.json.JSONException {
    if (modifiers != null) {
      org.json.JSONArray array = new org.json.JSONArray();
      for (com.clover.sdk.v1.inventory.Modifier obj : modifiers) {
        array.put(obj.getJSONObject());
      }
      getJSONObject().put("modifiers", array);
    }
  }


  @Override
  public int describeContents() {
    return 0;
  }

  @Override
  public void writeToParcel(android.os.Parcel dest, int flags) {
    String json = jsonString != null ? jsonString : getJSONObject().toString();
    dest.writeString(json);
  }

  public static final android.os.Parcelable.Creator<ModifierGroup> CREATOR = new android.os.Parcelable.Creator<ModifierGroup>() {
    public ModifierGroup createFromParcel(android.os.Parcel in) {
      String json = in.readString();
      return new ModifierGroup(json, true);
    }

    public ModifierGroup[] newArray(int size) {
      return new ModifierGroup[size];
    }
  };

  public static class Builder {

    private java.lang.String id;
    private java.lang.String name;
    private java.lang.Boolean showByDefault;
    private java.util.List<com.clover.sdk.v1.inventory.Modifier> modifiers;

    public Builder() {
    }

    public Builder id(java.lang.String id) {
      if (id != null && id.length() > 13) {
        throw new IllegalArgumentException("Maximum string length exceeded for 'id'");
      }
      this.id = id;
      return this;
    }

    public Builder name(java.lang.String name) {
      if (name != null && name.length() > 255) {
        throw new IllegalArgumentException("Maximum string length exceeded for 'name'");
      }
      this.name = name;
      return this;
    }

    public Builder showByDefault(java.lang.Boolean showByDefault) {

      this.showByDefault = showByDefault;
      return this;
    }

    public Builder modifiers(java.util.List<com.clover.sdk.v1.inventory.Modifier> modifiers) {

      this.modifiers = modifiers;
      return this;
    }

    public ModifierGroup build() throws org.json.JSONException {
      return new ModifierGroup(id, name, showByDefault, modifiers);
    }
  }

}
