/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.action;

import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.action.ActionUtil;
import ch.qos.logback.core.joran.spi.InterpretationContext;
import ch.qos.logback.core.pattern.util.RegularEscapeUtil;
import ch.qos.logback.core.util.Loader;
import ch.qos.logback.core.util.OptionHelper;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.xml.sax.Attributes;

public class PropertyAction
extends Action {
    static final String RESOURCE_ATTRIBUTE = "resource";
    static String INVALID_ATTRIBUTES = "In <property> element, either the \"file\" attribute alone, or the \"resource\" element alone, or both the \"name\" and \"value\" attributes must be set.";

    public void begin(InterpretationContext ec, String localName, Attributes attributes) {
        if ("substitutionProperty".equals(localName)) {
            this.addWarn("[substitutionProperty] element has been deprecated. Please use the [property] element instead.");
        }
        String name2 = attributes.getValue("name");
        String value2 = attributes.getValue("value");
        String scopeStr = attributes.getValue("scope");
        ActionUtil.Scope scope = ActionUtil.stringToScope(scopeStr);
        if (this.checkFileAttributeSanity(attributes)) {
            String file2 = attributes.getValue("file");
            file2 = ec.subst(file2);
            try {
                FileInputStream istream = new FileInputStream(file2);
                this.loadAndSetProperties(ec, istream, scope);
            }
            catch (FileNotFoundException e) {
                this.addError("Could not find properties file [" + file2 + "].");
            }
            catch (IOException e1) {
                this.addError("Could not read properties file [" + file2 + "].", e1);
            }
        } else if (this.checkResourceAttributeSanity(attributes)) {
            String resource2 = attributes.getValue(RESOURCE_ATTRIBUTE);
            URL resourceURL = Loader.getResourceBySelfClassLoader(resource2 = ec.subst(resource2));
            if (resourceURL == null) {
                this.addError("Could not find resource [" + resource2 + "].");
            } else {
                try {
                    InputStream istream = resourceURL.openStream();
                    this.loadAndSetProperties(ec, istream, scope);
                }
                catch (IOException e) {
                    this.addError("Could not read resource file [" + resource2 + "].", e);
                }
            }
        } else if (this.checkValueNameAttributesSanity(attributes)) {
            value2 = RegularEscapeUtil.basicEscape(value2);
            value2 = value2.trim();
            value2 = ec.subst(value2);
            ActionUtil.setProperty(ec, name2, value2, scope);
        } else {
            this.addError(INVALID_ATTRIBUTES);
        }
    }

    void loadAndSetProperties(InterpretationContext ec, InputStream istream, ActionUtil.Scope scope) throws IOException {
        Properties props2 = new Properties();
        props2.load(istream);
        istream.close();
        ActionUtil.setProperties(ec, props2, scope);
    }

    boolean checkFileAttributeSanity(Attributes attributes) {
        String file2 = attributes.getValue("file");
        String name2 = attributes.getValue("name");
        String value2 = attributes.getValue("value");
        String resource2 = attributes.getValue(RESOURCE_ATTRIBUTE);
        return !OptionHelper.isEmpty(file2) && OptionHelper.isEmpty(name2) && OptionHelper.isEmpty(value2) && OptionHelper.isEmpty(resource2);
    }

    boolean checkResourceAttributeSanity(Attributes attributes) {
        String file2 = attributes.getValue("file");
        String name2 = attributes.getValue("name");
        String value2 = attributes.getValue("value");
        String resource2 = attributes.getValue(RESOURCE_ATTRIBUTE);
        return !OptionHelper.isEmpty(resource2) && OptionHelper.isEmpty(name2) && OptionHelper.isEmpty(value2) && OptionHelper.isEmpty(file2);
    }

    boolean checkValueNameAttributesSanity(Attributes attributes) {
        String file2 = attributes.getValue("file");
        String name2 = attributes.getValue("name");
        String value2 = attributes.getValue("value");
        String resource2 = attributes.getValue(RESOURCE_ATTRIBUTE);
        return !OptionHelper.isEmpty(name2) && !OptionHelper.isEmpty(value2) && OptionHelper.isEmpty(file2) && OptionHelper.isEmpty(resource2);
    }

    public void end(InterpretationContext ec, String name2) {
    }

    public void finish(InterpretationContext ec) {
    }
}

