/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling;

import ch.qos.logback.core.rolling.TriggeringPolicyBase;
import ch.qos.logback.core.util.FileSize;
import ch.qos.logback.core.util.InvocationGate;
import java.io.File;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SizeBasedTriggeringPolicy<E>
extends TriggeringPolicyBase<E> {
    public static final String SEE_SIZE_FORMAT = "http://logback.qos.ch/codes.html#sbtp_size_format";
    public static final long DEFAULT_MAX_FILE_SIZE = 0xA00000L;
    String maxFileSizeAsString = Long.toString(0xA00000L);
    FileSize maxFileSize;
    private InvocationGate invocationGate = new InvocationGate();

    public SizeBasedTriggeringPolicy() {
    }

    public SizeBasedTriggeringPolicy(String maxFileSize) {
        this.setMaxFileSize(maxFileSize);
    }

    @Override
    public boolean isTriggeringEvent(File activeFile, E event) {
        if (this.invocationGate.skipFurtherWork()) {
            return false;
        }
        long now = System.currentTimeMillis();
        this.invocationGate.updateMaskIfNecessary(now);
        return activeFile.length() >= this.maxFileSize.getSize();
    }

    public String getMaxFileSize() {
        return this.maxFileSizeAsString;
    }

    public void setMaxFileSize(String maxFileSize) {
        this.maxFileSizeAsString = maxFileSize;
        this.maxFileSize = FileSize.valueOf(maxFileSize);
    }

    long toFileSize(String value2) {
        if (value2 == null) {
            return 0xA00000L;
        }
        String s2 = value2.trim().toUpperCase();
        long multiplier = 1L;
        int index2 = s2.indexOf("KB");
        if (index2 != -1) {
            multiplier = 1024L;
            s2 = s2.substring(0, index2);
        } else {
            index2 = s2.indexOf("MB");
            if (index2 != -1) {
                multiplier = 0x100000L;
                s2 = s2.substring(0, index2);
            } else {
                index2 = s2.indexOf("GB");
                if (index2 != -1) {
                    multiplier = 0x40000000L;
                    s2 = s2.substring(0, index2);
                }
            }
        }
        if (s2 != null) {
            try {
                return Long.valueOf(s2) * multiplier;
            }
            catch (NumberFormatException e) {
                this.addError("[" + s2 + "] is not in proper int format. Please refer to " + SEE_SIZE_FORMAT);
                this.addError("[" + value2 + "] not in expected format.", e);
            }
        }
        return 0xA00000L;
    }
}

