/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.cfg;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class ContextAttributes {
    public static ContextAttributes getEmpty() {
        return Impl.getEmpty();
    }

    public abstract ContextAttributes withSharedAttribute(Object var1, Object var2);

    public abstract ContextAttributes withSharedAttributes(Map<Object, Object> var1);

    public abstract ContextAttributes withoutSharedAttribute(Object var1);

    public abstract Object getAttribute(Object var1);

    public abstract ContextAttributes withPerCallAttribute(Object var1, Object var2);

    public static class Impl
    extends ContextAttributes
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected static final Impl EMPTY = new Impl(Collections.<Object, Object>emptyMap());
        protected static final Object NULL_SURROGATE = new Object();
        protected final Map<Object, Object> _shared;
        protected transient Map<Object, Object> _nonShared;

        protected Impl(Map<Object, Object> map2) {
            this._shared = map2;
            this._nonShared = null;
        }

        protected Impl(Map<Object, Object> map2, Map<Object, Object> map3) {
            this._shared = map2;
            this._nonShared = map3;
        }

        public static ContextAttributes getEmpty() {
            return EMPTY;
        }

        @Override
        public ContextAttributes withSharedAttribute(Object object, Object object2) {
            Map<Object, Object> map2 = this == EMPTY ? new HashMap(8) : this._copy(this._shared);
            map2.put(object, object2);
            return new Impl(map2);
        }

        @Override
        public ContextAttributes withSharedAttributes(Map<Object, Object> map2) {
            return new Impl(map2);
        }

        @Override
        public ContextAttributes withoutSharedAttribute(Object object) {
            if (this._shared.isEmpty()) {
                return this;
            }
            if (this._shared.containsKey(object)) {
                if (this._shared.size() == 1) {
                    return EMPTY;
                }
            } else {
                return this;
            }
            Map<Object, Object> map2 = this._copy(this._shared);
            map2.remove(object);
            return new Impl(map2);
        }

        @Override
        public Object getAttribute(Object object) {
            Object object2;
            if (this._nonShared != null && (object2 = this._nonShared.get(object)) != null) {
                if (object2 == NULL_SURROGATE) {
                    return null;
                }
                return object2;
            }
            return this._shared.get(object);
        }

        @Override
        public ContextAttributes withPerCallAttribute(Object object, Object object2) {
            if (object2 == null) {
                if (this._shared.containsKey(object)) {
                    object2 = NULL_SURROGATE;
                } else {
                    return this;
                }
            }
            if (this._nonShared == null) {
                return this.nonSharedInstance(object, object2);
            }
            this._nonShared.put(object, object2);
            return this;
        }

        protected ContextAttributes nonSharedInstance(Object object, Object object2) {
            HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
            if (object2 == null) {
                object2 = NULL_SURROGATE;
            }
            hashMap.put(object, object2);
            return new Impl(this._shared, hashMap);
        }

        private Map<Object, Object> _copy(Map<Object, Object> map2) {
            return new HashMap<Object, Object>(map2);
        }
    }
}

