/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import java.io.IOException;
import java.net.InetSocketAddress;

public class InetSocketAddressDeserializer
extends FromStringDeserializer<InetSocketAddress> {
    private static final long serialVersionUID = 1L;
    public static final InetSocketAddressDeserializer instance = new InetSocketAddressDeserializer();

    public InetSocketAddressDeserializer() {
        super(InetSocketAddress.class);
    }

    @Override
    protected InetSocketAddress _deserialize(String string2, DeserializationContext deserializationContext) throws IOException {
        if (string2.startsWith("[")) {
            int n = string2.lastIndexOf(93);
            if (n == -1) {
                throw new InvalidFormatException("Bracketed IPv6 address must contain closing bracket.", string2, InetSocketAddress.class);
            }
            int n2 = string2.indexOf(58, n);
            int n3 = n2 > -1 ? Integer.parseInt(string2.substring(n2 + 1)) : 0;
            return new InetSocketAddress(string2.substring(0, n + 1), n3);
        }
        int n = string2.indexOf(58);
        if (n != -1 && string2.indexOf(58, n + 1) == -1) {
            int n4 = Integer.parseInt(string2.substring(n));
            return new InetSocketAddress(string2.substring(0, n), n4);
        }
        return new InetSocketAddress(string2, 0);
    }
}

