/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import java.io.IOException;

public class JavaTypeDeserializer
extends StdScalarDeserializer<JavaType> {
    private static final long serialVersionUID = 1L;
    public static final JavaTypeDeserializer instance = new JavaTypeDeserializer();

    public JavaTypeDeserializer() {
        super(JavaType.class);
    }

    @Override
    public JavaType deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_STRING) {
            String string2 = jsonParser.getText().trim();
            if (string2.length() == 0) {
                return (JavaType)this.getEmptyValue();
            }
            return deserializationContext.getTypeFactory().constructFromCanonical(string2);
        }
        if (jsonToken == JsonToken.VALUE_EMBEDDED_OBJECT) {
            return (JavaType)jsonParser.getEmbeddedObject();
        }
        throw deserializationContext.mappingException(this._valueClass);
    }
}

