/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.ContextualKeyDeserializer;
import com.fasterxml.jackson.databind.deser.ResolvableDeserializer;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.impl.PropertyBasedCreator;
import com.fasterxml.jackson.databind.deser.impl.PropertyValueBuffer;
import com.fasterxml.jackson.databind.deser.std.ContainerDeserializerBase;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.util.ArrayBuilders;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Map;

@JacksonStdImpl
public class MapDeserializer
extends ContainerDeserializerBase<Map<Object, Object>>
implements ContextualDeserializer,
ResolvableDeserializer {
    private static final long serialVersionUID = -3378654289961736240L;
    protected final JavaType _mapType;
    protected final KeyDeserializer _keyDeserializer;
    protected boolean _standardStringKey;
    protected final JsonDeserializer<Object> _valueDeserializer;
    protected final TypeDeserializer _valueTypeDeserializer;
    protected final ValueInstantiator _valueInstantiator;
    protected final boolean _hasDefaultCreator;
    protected JsonDeserializer<Object> _delegateDeserializer;
    protected PropertyBasedCreator _propertyBasedCreator;
    protected HashSet<String> _ignorableProperties;

    public MapDeserializer(JavaType javaType, ValueInstantiator valueInstantiator, KeyDeserializer keyDeserializer, JsonDeserializer<Object> jsonDeserializer, TypeDeserializer typeDeserializer) {
        super(javaType);
        this._mapType = javaType;
        this._keyDeserializer = keyDeserializer;
        this._valueDeserializer = jsonDeserializer;
        this._valueTypeDeserializer = typeDeserializer;
        this._valueInstantiator = valueInstantiator;
        this._hasDefaultCreator = valueInstantiator.canCreateUsingDefault();
        this._delegateDeserializer = null;
        this._propertyBasedCreator = null;
        this._standardStringKey = this._isStdKeyDeser(javaType, keyDeserializer);
    }

    protected MapDeserializer(MapDeserializer mapDeserializer) {
        super(mapDeserializer._mapType);
        this._mapType = mapDeserializer._mapType;
        this._keyDeserializer = mapDeserializer._keyDeserializer;
        this._valueDeserializer = mapDeserializer._valueDeserializer;
        this._valueTypeDeserializer = mapDeserializer._valueTypeDeserializer;
        this._valueInstantiator = mapDeserializer._valueInstantiator;
        this._propertyBasedCreator = mapDeserializer._propertyBasedCreator;
        this._delegateDeserializer = mapDeserializer._delegateDeserializer;
        this._hasDefaultCreator = mapDeserializer._hasDefaultCreator;
        this._ignorableProperties = mapDeserializer._ignorableProperties;
        this._standardStringKey = mapDeserializer._standardStringKey;
    }

    protected MapDeserializer(MapDeserializer mapDeserializer, KeyDeserializer keyDeserializer, JsonDeserializer<Object> jsonDeserializer, TypeDeserializer typeDeserializer, HashSet<String> hashSet) {
        super(mapDeserializer._mapType);
        this._mapType = mapDeserializer._mapType;
        this._keyDeserializer = keyDeserializer;
        this._valueDeserializer = jsonDeserializer;
        this._valueTypeDeserializer = typeDeserializer;
        this._valueInstantiator = mapDeserializer._valueInstantiator;
        this._propertyBasedCreator = mapDeserializer._propertyBasedCreator;
        this._delegateDeserializer = mapDeserializer._delegateDeserializer;
        this._hasDefaultCreator = mapDeserializer._hasDefaultCreator;
        this._ignorableProperties = hashSet;
        this._standardStringKey = this._isStdKeyDeser(this._mapType, keyDeserializer);
    }

    protected MapDeserializer withResolved(KeyDeserializer keyDeserializer, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer, HashSet<String> hashSet) {
        if (this._keyDeserializer == keyDeserializer && this._valueDeserializer == jsonDeserializer && this._valueTypeDeserializer == typeDeserializer && this._ignorableProperties == hashSet) {
            return this;
        }
        return new MapDeserializer(this, keyDeserializer, jsonDeserializer, typeDeserializer, hashSet);
    }

    protected final boolean _isStdKeyDeser(JavaType javaType, KeyDeserializer keyDeserializer) {
        if (keyDeserializer == null) {
            return true;
        }
        JavaType javaType2 = javaType.getKeyType();
        if (javaType2 == null) {
            return true;
        }
        Class<?> clazz = javaType2.getRawClass();
        return (clazz == String.class || clazz == Object.class) && this.isDefaultKeyDeserializer(keyDeserializer);
    }

    public void setIgnorableProperties(String[] stringArray) {
        this._ignorableProperties = stringArray == null || stringArray.length == 0 ? null : ArrayBuilders.arrayToSet(stringArray);
    }

    @Override
    public void resolve(DeserializationContext deserializationContext) throws JsonMappingException {
        SettableBeanProperty[] settableBeanPropertyArray;
        if (this._valueInstantiator.canCreateUsingDelegate()) {
            settableBeanPropertyArray = this._valueInstantiator.getDelegateType(deserializationContext.getConfig());
            if (settableBeanPropertyArray == null) {
                throw new IllegalArgumentException("Invalid delegate-creator definition for " + this._mapType + ": value instantiator (" + this._valueInstantiator.getClass().getName() + ") returned true for 'canCreateUsingDelegate()', but null for 'getDelegateType()'");
            }
            this._delegateDeserializer = this.findDeserializer(deserializationContext, (JavaType)settableBeanPropertyArray, null);
        }
        if (this._valueInstantiator.canCreateFromObjectWith()) {
            settableBeanPropertyArray = this._valueInstantiator.getFromObjectArguments(deserializationContext.getConfig());
            this._propertyBasedCreator = PropertyBasedCreator.construct(deserializationContext, this._valueInstantiator, settableBeanPropertyArray);
        }
        this._standardStringKey = this._isStdKeyDeser(this._mapType, this._keyDeserializer);
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext deserializationContext, BeanProperty beanProperty) throws JsonMappingException {
        String[] stringArray;
        KeyDeserializer keyDeserializer = this._keyDeserializer;
        if (keyDeserializer == null) {
            keyDeserializer = deserializationContext.findKeyDeserializer(this._mapType.getKeyType(), beanProperty);
        } else if (keyDeserializer instanceof ContextualKeyDeserializer) {
            keyDeserializer = ((ContextualKeyDeserializer)((Object)keyDeserializer)).createContextual(deserializationContext, beanProperty);
        }
        JsonDeserializer<Object> jsonDeserializer = this._valueDeserializer;
        jsonDeserializer = this.findConvertingContentDeserializer(deserializationContext, beanProperty, jsonDeserializer);
        jsonDeserializer = jsonDeserializer == null ? deserializationContext.findContextualValueDeserializer(this._mapType.getContentType(), beanProperty) : deserializationContext.handleSecondaryContextualization(jsonDeserializer, beanProperty);
        TypeDeserializer typeDeserializer = this._valueTypeDeserializer;
        if (typeDeserializer != null) {
            typeDeserializer = typeDeserializer.forProperty(beanProperty);
        }
        HashSet<String> hashSet = this._ignorableProperties;
        AnnotationIntrospector annotationIntrospector = deserializationContext.getAnnotationIntrospector();
        if (annotationIntrospector != null && beanProperty != null && (stringArray = annotationIntrospector.findPropertiesToIgnore(beanProperty.getMember())) != null) {
            hashSet = hashSet == null ? new HashSet() : new HashSet<String>(hashSet);
            for (String string2 : stringArray) {
                hashSet.add(string2);
            }
        }
        return this.withResolved(keyDeserializer, typeDeserializer, jsonDeserializer, hashSet);
    }

    @Override
    public JavaType getContentType() {
        return this._mapType.getContentType();
    }

    @Override
    public JsonDeserializer<Object> getContentDeserializer() {
        return this._valueDeserializer;
    }

    @Override
    public Map<Object, Object> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        if (this._propertyBasedCreator != null) {
            return this._deserializeUsingCreator(jsonParser, deserializationContext);
        }
        if (this._delegateDeserializer != null) {
            return (Map)this._valueInstantiator.createUsingDelegate(deserializationContext, this._delegateDeserializer.deserialize(jsonParser, deserializationContext));
        }
        if (!this._hasDefaultCreator) {
            throw deserializationContext.instantiationException(this.getMapClass(), "No default constructor found");
        }
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken != JsonToken.START_OBJECT && jsonToken != JsonToken.FIELD_NAME && jsonToken != JsonToken.END_OBJECT) {
            if (jsonToken == JsonToken.VALUE_STRING) {
                return (Map)this._valueInstantiator.createFromString(deserializationContext, jsonParser.getText());
            }
            throw deserializationContext.mappingException(this.getMapClass());
        }
        Map map2 = (Map)this._valueInstantiator.createUsingDefault(deserializationContext);
        if (this._standardStringKey) {
            this._readAndBindStringMap(jsonParser, deserializationContext, map2);
            return map2;
        }
        this._readAndBind(jsonParser, deserializationContext, map2);
        return map2;
    }

    @Override
    public Map<Object, Object> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext, Map<Object, Object> map2) throws IOException, JsonProcessingException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken != JsonToken.START_OBJECT && jsonToken != JsonToken.FIELD_NAME) {
            throw deserializationContext.mappingException(this.getMapClass());
        }
        if (this._standardStringKey) {
            this._readAndBindStringMap(jsonParser, deserializationContext, map2);
            return map2;
        }
        this._readAndBind(jsonParser, deserializationContext, map2);
        return map2;
    }

    @Override
    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) throws IOException, JsonProcessingException {
        return typeDeserializer.deserializeTypedFromObject(jsonParser, deserializationContext);
    }

    public final Class<?> getMapClass() {
        return this._mapType.getRawClass();
    }

    @Override
    public JavaType getValueType() {
        return this._mapType;
    }

    protected final void _readAndBind(JsonParser jsonParser, DeserializationContext deserializationContext, Map<Object, Object> map2) throws IOException, JsonProcessingException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.START_OBJECT) {
            jsonToken = jsonParser.nextToken();
        }
        KeyDeserializer keyDeserializer = this._keyDeserializer;
        JsonDeserializer<Object> jsonDeserializer = this._valueDeserializer;
        TypeDeserializer typeDeserializer = this._valueTypeDeserializer;
        while (jsonToken == JsonToken.FIELD_NAME) {
            String string2 = jsonParser.getCurrentName();
            Object object = keyDeserializer.deserializeKey(string2, deserializationContext);
            jsonToken = jsonParser.nextToken();
            if (this._ignorableProperties != null && this._ignorableProperties.contains(string2)) {
                jsonParser.skipChildren();
            } else {
                Object object2 = jsonToken == JsonToken.VALUE_NULL ? null : (typeDeserializer == null ? jsonDeserializer.deserialize(jsonParser, deserializationContext) : jsonDeserializer.deserializeWithType(jsonParser, deserializationContext, typeDeserializer));
                map2.put(object, object2);
            }
            jsonToken = jsonParser.nextToken();
        }
    }

    protected final void _readAndBindStringMap(JsonParser jsonParser, DeserializationContext deserializationContext, Map<Object, Object> map2) throws IOException, JsonProcessingException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.START_OBJECT) {
            jsonToken = jsonParser.nextToken();
        }
        JsonDeserializer<Object> jsonDeserializer = this._valueDeserializer;
        TypeDeserializer typeDeserializer = this._valueTypeDeserializer;
        while (jsonToken == JsonToken.FIELD_NAME) {
            String string2 = jsonParser.getCurrentName();
            jsonToken = jsonParser.nextToken();
            if (this._ignorableProperties != null && this._ignorableProperties.contains(string2)) {
                jsonParser.skipChildren();
            } else {
                Object object = jsonToken == JsonToken.VALUE_NULL ? null : (typeDeserializer == null ? jsonDeserializer.deserialize(jsonParser, deserializationContext) : jsonDeserializer.deserializeWithType(jsonParser, deserializationContext, typeDeserializer));
                map2.put(string2, object);
            }
            jsonToken = jsonParser.nextToken();
        }
    }

    public Map<Object, Object> _deserializeUsingCreator(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        PropertyBasedCreator propertyBasedCreator = this._propertyBasedCreator;
        PropertyValueBuffer propertyValueBuffer = propertyBasedCreator.startBuilding(jsonParser, deserializationContext, null);
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.START_OBJECT) {
            jsonToken = jsonParser.nextToken();
        }
        JsonDeserializer<Object> jsonDeserializer = this._valueDeserializer;
        TypeDeserializer typeDeserializer = this._valueTypeDeserializer;
        while (jsonToken == JsonToken.FIELD_NAME) {
            String string2 = jsonParser.getCurrentName();
            jsonToken = jsonParser.nextToken();
            if (this._ignorableProperties != null && this._ignorableProperties.contains(string2)) {
                jsonParser.skipChildren();
            } else {
                Object object;
                Object object2;
                SettableBeanProperty settableBeanProperty = propertyBasedCreator.findCreatorProperty(string2);
                if (settableBeanProperty != null) {
                    object2 = settableBeanProperty.deserialize(jsonParser, deserializationContext);
                    if (propertyValueBuffer.assignParameter(settableBeanProperty.getCreatorIndex(), object2)) {
                        jsonParser.nextToken();
                        try {
                            object = (Map)propertyBasedCreator.build(deserializationContext, propertyValueBuffer);
                        }
                        catch (Exception exception) {
                            this.wrapAndThrow(exception, this._mapType.getRawClass());
                            return null;
                        }
                        this._readAndBind(jsonParser, deserializationContext, (Map<Object, Object>)object);
                        return object;
                    }
                } else {
                    object2 = jsonParser.getCurrentName();
                    object = this._keyDeserializer.deserializeKey((String)object2, deserializationContext);
                    Object object3 = jsonToken == JsonToken.VALUE_NULL ? null : (typeDeserializer == null ? jsonDeserializer.deserialize(jsonParser, deserializationContext) : jsonDeserializer.deserializeWithType(jsonParser, deserializationContext, typeDeserializer));
                    propertyValueBuffer.bufferMapProperty(object, object3);
                }
            }
            jsonToken = jsonParser.nextToken();
        }
        try {
            return (Map)propertyBasedCreator.build(deserializationContext, propertyValueBuffer);
        }
        catch (Exception exception) {
            this.wrapAndThrow(exception, this._mapType.getRawClass());
            return null;
        }
    }

    protected void wrapAndThrow(Throwable throwable, Object object) throws IOException {
        while (throwable instanceof InvocationTargetException && throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        if (throwable instanceof IOException && !(throwable instanceof JsonMappingException)) {
            throw (IOException)throwable;
        }
        throw JsonMappingException.wrapWithPath(throwable, object, null);
    }
}

