/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import java.io.IOException;

public class StackTraceElementDeserializer
extends StdScalarDeserializer<StackTraceElement> {
    private static final long serialVersionUID = 1L;
    public static final StackTraceElementDeserializer instance = new StackTraceElementDeserializer();

    public StackTraceElementDeserializer() {
        super(StackTraceElement.class);
    }

    @Override
    public StackTraceElement deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.START_OBJECT) {
            String string2 = "";
            String string3 = "";
            String string4 = "";
            int n = -1;
            while ((jsonToken = jsonParser.nextValue()) != JsonToken.END_OBJECT) {
                String string5 = jsonParser.getCurrentName();
                if ("className".equals(string5)) {
                    string2 = jsonParser.getText();
                    continue;
                }
                if ("fileName".equals(string5)) {
                    string4 = jsonParser.getText();
                    continue;
                }
                if ("lineNumber".equals(string5)) {
                    if (jsonToken.isNumeric()) {
                        n = jsonParser.getIntValue();
                        continue;
                    }
                    throw JsonMappingException.from(jsonParser, "Non-numeric token (" + (Object)((Object)jsonToken) + ") for property 'lineNumber'");
                }
                if ("methodName".equals(string5)) {
                    string3 = jsonParser.getText();
                    continue;
                }
                if ("nativeMethod".equals(string5)) continue;
                this.handleUnknownProperty(jsonParser, deserializationContext, this._valueClass, string5);
            }
            return new StackTraceElement(string2, string3, string4, n);
        }
        throw deserializationContext.mappingException(this._valueClass, jsonToken);
    }
}

