/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.introspect;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedConstructor;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.introspect.ObjectIdInfo;
import com.fasterxml.jackson.databind.introspect.POJOPropertyBuilder;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.fasterxml.jackson.databind.util.BeanUtil;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.lang.reflect.Modifier;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class POJOPropertiesCollector {
    protected final MapperConfig<?> _config;
    protected final boolean _forSerialization;
    protected final JavaType _type;
    protected final AnnotatedClass _classDef;
    protected final VisibilityChecker<?> _visibilityChecker;
    protected final AnnotationIntrospector _annotationIntrospector;
    protected final String _mutatorPrefix;
    protected final LinkedHashMap<String, POJOPropertyBuilder> _properties = new LinkedHashMap();
    protected LinkedList<POJOPropertyBuilder> _creatorProperties = null;
    protected LinkedList<AnnotatedMember> _anyGetters = null;
    protected LinkedList<AnnotatedMethod> _anySetters = null;
    protected LinkedList<AnnotatedMethod> _jsonValueGetters = null;
    protected HashSet<String> _ignoredPropertyNames;
    protected LinkedHashMap<Object, AnnotatedMember> _injectables;

    protected POJOPropertiesCollector(MapperConfig<?> mapperConfig, boolean bl, JavaType javaType, AnnotatedClass annotatedClass, String string2) {
        this._config = mapperConfig;
        this._forSerialization = bl;
        this._type = javaType;
        this._classDef = annotatedClass;
        this._mutatorPrefix = string2 == null ? "set" : string2;
        this._annotationIntrospector = mapperConfig.isAnnotationProcessingEnabled() ? this._config.getAnnotationIntrospector() : null;
        this._visibilityChecker = this._annotationIntrospector == null ? this._config.getDefaultVisibilityChecker() : this._annotationIntrospector.findAutoDetectVisibility(annotatedClass, this._config.getDefaultVisibilityChecker());
    }

    public MapperConfig<?> getConfig() {
        return this._config;
    }

    public JavaType getType() {
        return this._type;
    }

    public AnnotatedClass getClassDef() {
        return this._classDef;
    }

    public AnnotationIntrospector getAnnotationIntrospector() {
        return this._annotationIntrospector;
    }

    public List<BeanPropertyDefinition> getProperties() {
        return new ArrayList<BeanPropertyDefinition>(this._properties.values());
    }

    public Map<Object, AnnotatedMember> getInjectables() {
        return this._injectables;
    }

    public AnnotatedMethod getJsonValueMethod() {
        if (this._jsonValueGetters != null) {
            if (this._jsonValueGetters.size() > 1) {
                this.reportProblem("Multiple value properties defined (" + this._jsonValueGetters.get(0) + " vs " + this._jsonValueGetters.get(1) + ")");
            }
            return this._jsonValueGetters.get(0);
        }
        return null;
    }

    public AnnotatedMember getAnyGetter() {
        if (this._anyGetters != null) {
            if (this._anyGetters.size() > 1) {
                this.reportProblem("Multiple 'any-getters' defined (" + this._anyGetters.get(0) + " vs " + this._anyGetters.get(1) + ")");
            }
            return this._anyGetters.getFirst();
        }
        return null;
    }

    public AnnotatedMethod getAnySetterMethod() {
        if (this._anySetters != null) {
            if (this._anySetters.size() > 1) {
                this.reportProblem("Multiple 'any-setters' defined (" + this._anySetters.get(0) + " vs " + this._anySetters.get(1) + ")");
            }
            return this._anySetters.getFirst();
        }
        return null;
    }

    public Set<String> getIgnoredPropertyNames() {
        return this._ignoredPropertyNames;
    }

    public ObjectIdInfo getObjectIdInfo() {
        if (this._annotationIntrospector == null) {
            return null;
        }
        ObjectIdInfo objectIdInfo = this._annotationIntrospector.findObjectIdInfo(this._classDef);
        if (objectIdInfo != null) {
            objectIdInfo = this._annotationIntrospector.findObjectReferenceInfo(this._classDef, objectIdInfo);
        }
        return objectIdInfo;
    }

    public Class<?> findPOJOBuilderClass() {
        return this._annotationIntrospector.findPOJOBuilder(this._classDef);
    }

    protected Map<String, POJOPropertyBuilder> getPropertyMap() {
        return this._properties;
    }

    public POJOPropertiesCollector collect() {
        this._properties.clear();
        this._addFields();
        this._addMethods();
        this._addCreators();
        this._addInjectables();
        this._removeUnwantedProperties();
        this._renameProperties();
        PropertyNamingStrategy propertyNamingStrategy = this._findNamingStrategy();
        if (propertyNamingStrategy != null) {
            this._renameUsing(propertyNamingStrategy);
        }
        for (POJOPropertyBuilder pOJOPropertyBuilder : this._properties.values()) {
            pOJOPropertyBuilder.trimByVisibility();
        }
        for (POJOPropertyBuilder pOJOPropertyBuilder : this._properties.values()) {
            pOJOPropertyBuilder.mergeAnnotations(this._forSerialization);
        }
        if (this._config.isEnabled(MapperFeature.USE_WRAPPER_NAME_AS_PROPERTY_NAME)) {
            this._renameWithWrappers();
        }
        this._sortProperties();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    protected void _sortProperties() {
        String[] stringArray;
        AnnotationIntrospector annotationIntrospector = this._annotationIntrospector;
        Boolean bl = annotationIntrospector == null ? null : annotationIntrospector.findSerializationSortAlphabetically(this._classDef);
        boolean bl2 = bl == null ? this._config.shouldSortPropertiesAlphabetically() : bl.booleanValue();
        String[] stringArray2 = stringArray = annotationIntrospector == null ? null : annotationIntrospector.findSerializationPropertyOrder(this._classDef);
        if (!bl2 && this._creatorProperties == null && stringArray == null) {
            return;
        }
        int n = this._properties.size();
        AbstractMap abstractMap = bl2 ? new TreeMap() : new LinkedHashMap(n + n);
        for (POJOPropertyBuilder object : this._properties.values()) {
            abstractMap.put(object.getName(), object);
        }
        LinkedHashMap linkedHashMap = new LinkedHashMap(n + n);
        if (stringArray != null) {
            for (String string2 : stringArray) {
                void var11_20;
                POJOPropertyBuilder pOJOPropertyBuilder = (POJOPropertyBuilder)abstractMap.get(string2);
                if (pOJOPropertyBuilder == null) {
                    for (POJOPropertyBuilder pOJOPropertyBuilder2 : this._properties.values()) {
                        if (!string2.equals(pOJOPropertyBuilder2.getInternalName())) continue;
                        pOJOPropertyBuilder = pOJOPropertyBuilder2;
                        String string3 = pOJOPropertyBuilder2.getName();
                        break;
                    }
                }
                if (pOJOPropertyBuilder == null) continue;
                linkedHashMap.put(var11_20, pOJOPropertyBuilder);
            }
        }
        if (this._creatorProperties != null) {
            void var8_13;
            if (bl2) {
                TreeMap<String, POJOPropertyBuilder> treeMap = new TreeMap<String, POJOPropertyBuilder>();
                for (POJOPropertyBuilder pOJOPropertyBuilder : this._creatorProperties) {
                    treeMap.put(pOJOPropertyBuilder.getName(), pOJOPropertyBuilder);
                }
                Collection collection = treeMap.values();
            } else {
                LinkedList<POJOPropertyBuilder> linkedList = this._creatorProperties;
            }
            for (POJOPropertyBuilder pOJOPropertyBuilder : var8_13) {
                linkedHashMap.put(pOJOPropertyBuilder.getName(), pOJOPropertyBuilder);
            }
        }
        linkedHashMap.putAll(abstractMap);
        this._properties.clear();
        this._properties.putAll(linkedHashMap);
    }

    protected void _addFields() {
        AnnotationIntrospector annotationIntrospector = this._annotationIntrospector;
        boolean bl = !this._forSerialization && !this._config.isEnabled(MapperFeature.ALLOW_FINAL_FIELDS_AS_MUTATORS);
        for (AnnotatedField annotatedField : this._classDef.fields()) {
            boolean bl2;
            boolean bl3;
            String string2;
            String string3 = annotatedField.getName();
            if (annotationIntrospector == null) {
                string2 = null;
            } else if (this._forSerialization) {
                PropertyName propertyName = annotationIntrospector.findNameForSerialization(annotatedField);
                string2 = propertyName == null ? null : propertyName.getSimpleName();
            } else {
                PropertyName propertyName = annotationIntrospector.findNameForDeserialization(annotatedField);
                String string4 = string2 = propertyName == null ? null : propertyName.getSimpleName();
            }
            if ("".equals(string2)) {
                string2 = string3;
            }
            boolean bl4 = bl3 = string2 != null;
            if (!bl3) {
                bl3 = this._visibilityChecker.isFieldVisible(annotatedField);
            }
            boolean bl5 = bl2 = annotationIntrospector != null && annotationIntrospector.hasIgnoreMarker(annotatedField);
            if (bl && string2 == null && !bl2 && Modifier.isFinal(annotatedField.getModifiers())) continue;
            this._property(string3).addField(annotatedField, string2, bl3, bl2);
        }
    }

    protected void _addCreators() {
        POJOPropertyBuilder pOJOPropertyBuilder;
        String string2;
        PropertyName propertyName;
        AnnotatedParameter annotatedParameter;
        int n;
        int n2;
        AnnotationIntrospector annotationIntrospector = this._annotationIntrospector;
        if (annotationIntrospector == null) {
            return;
        }
        for (AnnotatedConstructor annotatedWithParams : this._classDef.getConstructors()) {
            if (this._creatorProperties == null) {
                this._creatorProperties = new LinkedList();
            }
            n2 = annotatedWithParams.getParameterCount();
            for (n = 0; n < n2; ++n) {
                annotatedParameter = annotatedWithParams.getParameter(n);
                propertyName = annotationIntrospector.findNameForDeserialization(annotatedParameter);
                String string3 = string2 = propertyName == null ? null : propertyName.getSimpleName();
                if (string2 == null) continue;
                pOJOPropertyBuilder = this._property(string2);
                pOJOPropertyBuilder.addCtor(annotatedParameter, string2, true, false);
                this._creatorProperties.add(pOJOPropertyBuilder);
            }
        }
        for (AnnotatedMethod annotatedMethod : this._classDef.getStaticMethods()) {
            if (this._creatorProperties == null) {
                this._creatorProperties = new LinkedList();
            }
            n2 = annotatedMethod.getParameterCount();
            for (n = 0; n < n2; ++n) {
                annotatedParameter = annotatedMethod.getParameter(n);
                propertyName = annotationIntrospector.findNameForDeserialization(annotatedParameter);
                String string4 = string2 = propertyName == null ? null : propertyName.getSimpleName();
                if (string2 == null) continue;
                pOJOPropertyBuilder = this._property(string2);
                pOJOPropertyBuilder.addCtor(annotatedParameter, string2, true, false);
                this._creatorProperties.add(pOJOPropertyBuilder);
            }
        }
    }

    protected void _addMethods() {
        AnnotationIntrospector annotationIntrospector = this._annotationIntrospector;
        for (AnnotatedMethod annotatedMethod : this._classDef.memberMethods()) {
            int n = annotatedMethod.getParameterCount();
            if (n == 0) {
                this._addGetterMethod(annotatedMethod, annotationIntrospector);
                continue;
            }
            if (n == 1) {
                this._addSetterMethod(annotatedMethod, annotationIntrospector);
                continue;
            }
            if (n != 2 || annotationIntrospector == null || !annotationIntrospector.hasAnySetterAnnotation(annotatedMethod)) continue;
            if (this._anySetters == null) {
                this._anySetters = new LinkedList();
            }
            this._anySetters.add(annotatedMethod);
        }
    }

    protected void _addGetterMethod(AnnotatedMethod annotatedMethod, AnnotationIntrospector annotationIntrospector) {
        boolean bl;
        String string2;
        String string3;
        if (annotationIntrospector != null) {
            if (annotationIntrospector.hasAnyGetterAnnotation(annotatedMethod)) {
                if (this._anyGetters == null) {
                    this._anyGetters = new LinkedList();
                }
                this._anyGetters.add(annotatedMethod);
                return;
            }
            if (annotationIntrospector.hasAsValueAnnotation(annotatedMethod)) {
                if (this._jsonValueGetters == null) {
                    this._jsonValueGetters = new LinkedList();
                }
                this._jsonValueGetters.add(annotatedMethod);
                return;
            }
        }
        PropertyName propertyName = annotationIntrospector == null ? null : annotationIntrospector.findNameForSerialization(annotatedMethod);
        String string4 = string3 = propertyName == null ? null : propertyName.getSimpleName();
        if (string3 == null) {
            string2 = BeanUtil.okNameForRegularGetter(annotatedMethod, annotatedMethod.getName());
            if (string2 == null) {
                string2 = BeanUtil.okNameForIsGetter(annotatedMethod, annotatedMethod.getName());
                if (string2 == null) {
                    return;
                }
                bl = this._visibilityChecker.isIsGetterVisible(annotatedMethod);
            } else {
                bl = this._visibilityChecker.isGetterVisible(annotatedMethod);
            }
        } else {
            string2 = BeanUtil.okNameForGetter(annotatedMethod);
            if (string2 == null) {
                string2 = annotatedMethod.getName();
            }
            if (string3.length() == 0) {
                string3 = string2;
            }
            bl = true;
        }
        boolean bl2 = annotationIntrospector == null ? false : annotationIntrospector.hasIgnoreMarker(annotatedMethod);
        this._property(string2).addGetter(annotatedMethod, string3, bl, bl2);
    }

    protected void _addSetterMethod(AnnotatedMethod annotatedMethod, AnnotationIntrospector annotationIntrospector) {
        boolean bl;
        String string2;
        String string3;
        PropertyName propertyName = annotationIntrospector == null ? null : annotationIntrospector.findNameForDeserialization(annotatedMethod);
        String string4 = string3 = propertyName == null ? null : propertyName.getSimpleName();
        if (string3 == null) {
            string2 = BeanUtil.okNameForMutator(annotatedMethod, this._mutatorPrefix);
            if (string2 == null) {
                return;
            }
            bl = this._visibilityChecker.isSetterVisible(annotatedMethod);
        } else {
            string2 = BeanUtil.okNameForMutator(annotatedMethod, this._mutatorPrefix);
            if (string2 == null) {
                string2 = annotatedMethod.getName();
            }
            if (string3.length() == 0) {
                string3 = string2;
            }
            bl = true;
        }
        boolean bl2 = annotationIntrospector == null ? false : annotationIntrospector.hasIgnoreMarker(annotatedMethod);
        this._property(string2).addSetter(annotatedMethod, string3, bl, bl2);
    }

    protected void _addInjectables() {
        AnnotationIntrospector annotationIntrospector = this._annotationIntrospector;
        if (annotationIntrospector == null) {
            return;
        }
        for (AnnotatedField annotatedMember : this._classDef.fields()) {
            this._doAddInjectable(annotationIntrospector.findInjectableValueId(annotatedMember), annotatedMember);
        }
        for (AnnotatedMethod annotatedMethod : this._classDef.memberMethods()) {
            if (annotatedMethod.getParameterCount() != 1) continue;
            this._doAddInjectable(annotationIntrospector.findInjectableValueId(annotatedMethod), annotatedMethod);
        }
    }

    protected void _doAddInjectable(Object object, AnnotatedMember annotatedMember) {
        AnnotatedMember annotatedMember2;
        if (object == null) {
            return;
        }
        if (this._injectables == null) {
            this._injectables = new LinkedHashMap();
        }
        if ((annotatedMember2 = this._injectables.put(object, annotatedMember)) != null) {
            String string2 = object.getClass().getName();
            throw new IllegalArgumentException("Duplicate injectable value with id '" + String.valueOf(object) + "' (of type " + string2 + ")");
        }
    }

    protected void _removeUnwantedProperties() {
        boolean bl;
        Iterator<Map.Entry<String, POJOPropertyBuilder>> iterator2 = this._properties.entrySet().iterator();
        boolean bl2 = bl = !this._config.isEnabled(MapperFeature.INFER_PROPERTY_MUTATORS);
        while (iterator2.hasNext()) {
            Map.Entry<String, POJOPropertyBuilder> entry = iterator2.next();
            POJOPropertyBuilder pOJOPropertyBuilder = entry.getValue();
            if (!pOJOPropertyBuilder.anyVisible()) {
                iterator2.remove();
                continue;
            }
            if (pOJOPropertyBuilder.anyIgnorals()) {
                if (!pOJOPropertyBuilder.isExplicitlyIncluded()) {
                    iterator2.remove();
                    this._addIgnored(pOJOPropertyBuilder.getName());
                    continue;
                }
                pOJOPropertyBuilder.removeIgnored();
                if (!this._forSerialization && !pOJOPropertyBuilder.couldDeserialize()) {
                    this._addIgnored(pOJOPropertyBuilder.getName());
                }
            }
            pOJOPropertyBuilder.removeNonVisible(bl);
        }
    }

    private void _addIgnored(String string2) {
        if (!this._forSerialization) {
            if (this._ignoredPropertyNames == null) {
                this._ignoredPropertyNames = new HashSet();
            }
            this._ignoredPropertyNames.add(string2);
        }
    }

    protected void _renameProperties() {
        String string2;
        Iterator<Map.Entry<String, POJOPropertyBuilder>> iterator2 = this._properties.entrySet().iterator();
        LinkedList<POJOPropertyBuilder> linkedList = null;
        while (iterator2.hasNext()) {
            Map.Entry<String, POJOPropertyBuilder> entry = iterator2.next();
            POJOPropertyBuilder pOJOPropertyBuilder = entry.getValue();
            string2 = pOJOPropertyBuilder.findNewName();
            if (string2 == null) continue;
            if (linkedList == null) {
                linkedList = new LinkedList<POJOPropertyBuilder>();
            }
            pOJOPropertyBuilder = pOJOPropertyBuilder.withSimpleName(string2);
            linkedList.add(pOJOPropertyBuilder);
            iterator2.remove();
        }
        if (linkedList != null) {
            for (POJOPropertyBuilder pOJOPropertyBuilder : linkedList) {
                string2 = pOJOPropertyBuilder.getName();
                POJOPropertyBuilder pOJOPropertyBuilder2 = this._properties.get(string2);
                if (pOJOPropertyBuilder2 == null) {
                    this._properties.put(string2, pOJOPropertyBuilder);
                } else {
                    pOJOPropertyBuilder2.addAll(pOJOPropertyBuilder);
                }
                this._updateCreatorProperty(pOJOPropertyBuilder, this._creatorProperties);
            }
        }
    }

    protected void _renameUsing(PropertyNamingStrategy propertyNamingStrategy) {
        POJOPropertyBuilder[] pOJOPropertyBuilderArray = this._properties.values().toArray(new POJOPropertyBuilder[this._properties.size()]);
        this._properties.clear();
        for (POJOPropertyBuilder pOJOPropertyBuilder : pOJOPropertyBuilderArray) {
            String string2;
            PropertyName propertyName = pOJOPropertyBuilder.getFullName();
            String string3 = null;
            if (this._forSerialization) {
                if (pOJOPropertyBuilder.hasGetter()) {
                    string3 = propertyNamingStrategy.nameForGetterMethod(this._config, pOJOPropertyBuilder.getGetter(), propertyName.getSimpleName());
                } else if (pOJOPropertyBuilder.hasField()) {
                    string3 = propertyNamingStrategy.nameForField(this._config, pOJOPropertyBuilder.getField(), propertyName.getSimpleName());
                }
            } else if (pOJOPropertyBuilder.hasSetter()) {
                string3 = propertyNamingStrategy.nameForSetterMethod(this._config, pOJOPropertyBuilder.getSetter(), propertyName.getSimpleName());
            } else if (pOJOPropertyBuilder.hasConstructorParameter()) {
                string3 = propertyNamingStrategy.nameForConstructorParameter(this._config, pOJOPropertyBuilder.getConstructorParameter(), propertyName.getSimpleName());
            } else if (pOJOPropertyBuilder.hasField()) {
                string3 = propertyNamingStrategy.nameForField(this._config, pOJOPropertyBuilder.getField(), propertyName.getSimpleName());
            } else if (pOJOPropertyBuilder.hasGetter()) {
                string3 = propertyNamingStrategy.nameForGetterMethod(this._config, pOJOPropertyBuilder.getGetter(), propertyName.getSimpleName());
            }
            if (string3 != null && !propertyName.hasSimpleName(string3)) {
                pOJOPropertyBuilder = pOJOPropertyBuilder.withSimpleName(string3);
                string2 = string3;
            } else {
                string2 = propertyName.getSimpleName();
            }
            POJOPropertyBuilder pOJOPropertyBuilder2 = this._properties.get(string2);
            if (pOJOPropertyBuilder2 == null) {
                this._properties.put(string2, pOJOPropertyBuilder);
            } else {
                pOJOPropertyBuilder2.addAll(pOJOPropertyBuilder);
            }
            this._updateCreatorProperty(pOJOPropertyBuilder, this._creatorProperties);
        }
    }

    protected void _renameWithWrappers() {
        Object object;
        Object object2;
        Iterator<Map.Entry<String, POJOPropertyBuilder>> iterator2 = this._properties.entrySet().iterator();
        LinkedList<POJOPropertyBuilder> linkedList = null;
        while (iterator2.hasNext()) {
            Map.Entry<String, POJOPropertyBuilder> entry = iterator2.next();
            POJOPropertyBuilder pOJOPropertyBuilder = entry.getValue();
            object2 = pOJOPropertyBuilder.getPrimaryMember();
            if (object2 == null || (object = this._annotationIntrospector.findWrapperName((Annotated)object2)) == null || !((PropertyName)object).hasSimpleName() || ((PropertyName)object).equals(pOJOPropertyBuilder.getFullName())) continue;
            if (linkedList == null) {
                linkedList = new LinkedList<POJOPropertyBuilder>();
            }
            pOJOPropertyBuilder = pOJOPropertyBuilder.withName((PropertyName)object);
            linkedList.add(pOJOPropertyBuilder);
            iterator2.remove();
        }
        if (linkedList != null) {
            for (POJOPropertyBuilder pOJOPropertyBuilder : linkedList) {
                object2 = pOJOPropertyBuilder.getName();
                object = this._properties.get(object2);
                if (object == null) {
                    this._properties.put((String)object2, pOJOPropertyBuilder);
                    continue;
                }
                ((POJOPropertyBuilder)object).addAll(pOJOPropertyBuilder);
            }
        }
    }

    protected void reportProblem(String string2) {
        throw new IllegalArgumentException("Problem with definition of " + this._classDef + ": " + string2);
    }

    protected POJOPropertyBuilder _property(String string2) {
        POJOPropertyBuilder pOJOPropertyBuilder = this._properties.get(string2);
        if (pOJOPropertyBuilder == null) {
            pOJOPropertyBuilder = new POJOPropertyBuilder(new PropertyName(string2), this._annotationIntrospector, this._forSerialization);
            this._properties.put(string2, pOJOPropertyBuilder);
        }
        return pOJOPropertyBuilder;
    }

    private PropertyNamingStrategy _findNamingStrategy() {
        PropertyNamingStrategy propertyNamingStrategy;
        Object object;
        Object object2 = object = this._annotationIntrospector == null ? null : this._annotationIntrospector.findNamingStrategy(this._classDef);
        if (object == null) {
            return this._config.getPropertyNamingStrategy();
        }
        if (object instanceof PropertyNamingStrategy) {
            return (PropertyNamingStrategy)object;
        }
        if (!(object instanceof Class)) {
            throw new IllegalStateException("AnnotationIntrospector returned PropertyNamingStrategy definition of type " + object.getClass().getName() + "; expected type PropertyNamingStrategy or Class<PropertyNamingStrategy> instead");
        }
        Class clazz = (Class)object;
        if (!PropertyNamingStrategy.class.isAssignableFrom(clazz)) {
            throw new IllegalStateException("AnnotationIntrospector returned Class " + clazz.getName() + "; expected Class<PropertyNamingStrategy>");
        }
        HandlerInstantiator handlerInstantiator = this._config.getHandlerInstantiator();
        if (handlerInstantiator != null && (propertyNamingStrategy = handlerInstantiator.namingStrategyInstance(this._config, this._classDef, clazz)) != null) {
            return propertyNamingStrategy;
        }
        return (PropertyNamingStrategy)ClassUtil.createInstance(clazz, this._config.canOverrideAccessModifiers());
    }

    protected void _updateCreatorProperty(POJOPropertyBuilder pOJOPropertyBuilder, List<POJOPropertyBuilder> list2) {
        if (list2 != null) {
            int n = list2.size();
            for (int i = 0; i < n; ++i) {
                if (!list2.get(i).getInternalName().equals(pOJOPropertyBuilder.getInternalName())) continue;
                list2.set(i, pOJOPropertyBuilder);
                break;
            }
        }
    }
}

