/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.jsontype.impl;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.jsontype.impl.ClassNameIdResolver;
import com.fasterxml.jackson.databind.type.TypeFactory;

public class MinimalClassNameIdResolver
extends ClassNameIdResolver {
    protected final String _basePackageName;
    protected final String _basePackagePrefix;

    protected MinimalClassNameIdResolver(JavaType javaType, TypeFactory typeFactory) {
        super(javaType, typeFactory);
        String string2 = javaType.getRawClass().getName();
        int n = string2.lastIndexOf(46);
        if (n < 0) {
            this._basePackageName = "";
            this._basePackagePrefix = ".";
        } else {
            this._basePackagePrefix = string2.substring(0, n + 1);
            this._basePackageName = string2.substring(0, n);
        }
    }

    @Override
    public JsonTypeInfo.Id getMechanism() {
        return JsonTypeInfo.Id.MINIMAL_CLASS;
    }

    @Override
    public String idFromValue(Object object) {
        String string2 = object.getClass().getName();
        if (string2.startsWith(this._basePackagePrefix)) {
            return string2.substring(this._basePackagePrefix.length() - 1);
        }
        return string2;
    }

    @Override
    protected JavaType _typeFromId(String string2, TypeFactory typeFactory) {
        if (string2.startsWith(".")) {
            StringBuilder stringBuilder = new StringBuilder(string2.length() + this._basePackageName.length());
            if (this._basePackageName.length() == 0) {
                stringBuilder.append(string2.substring(1));
            } else {
                stringBuilder.append(this._basePackageName).append(string2);
            }
            string2 = stringBuilder.toString();
        }
        return super._typeFromId(string2, typeFactory);
    }
}

