/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.node;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BaseJsonNode;
import com.fasterxml.jackson.databind.node.ContainerNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ObjectNode
extends ContainerNode<ObjectNode> {
    private final Map<String, JsonNode> _children = new LinkedHashMap<String, JsonNode>();

    public ObjectNode(JsonNodeFactory jsonNodeFactory) {
        super(jsonNodeFactory);
    }

    @Override
    protected JsonNode _at(JsonPointer jsonPointer) {
        return this.get(jsonPointer.getMatchingProperty());
    }

    public ObjectNode deepCopy() {
        ObjectNode objectNode = new ObjectNode(this._nodeFactory);
        for (Map.Entry<String, JsonNode> entry : this._children.entrySet()) {
            objectNode._children.put(entry.getKey(), (JsonNode)entry.getValue().deepCopy());
        }
        return objectNode;
    }

    @Override
    public JsonNodeType getNodeType() {
        return JsonNodeType.OBJECT;
    }

    @Override
    public JsonToken asToken() {
        return JsonToken.START_OBJECT;
    }

    @Override
    public int size() {
        return this._children.size();
    }

    @Override
    public Iterator<JsonNode> elements() {
        return this._children.values().iterator();
    }

    @Override
    public JsonNode get(int n) {
        return null;
    }

    @Override
    public JsonNode get(String string2) {
        return this._children.get(string2);
    }

    @Override
    public Iterator<String> fieldNames() {
        return this._children.keySet().iterator();
    }

    @Override
    public JsonNode path(int n) {
        return MissingNode.getInstance();
    }

    @Override
    public JsonNode path(String string2) {
        JsonNode jsonNode = this._children.get(string2);
        if (jsonNode != null) {
            return jsonNode;
        }
        return MissingNode.getInstance();
    }

    @Override
    public Iterator<Map.Entry<String, JsonNode>> fields() {
        return this._children.entrySet().iterator();
    }

    @Override
    public ObjectNode with(String string2) {
        JsonNode jsonNode = this._children.get(string2);
        if (jsonNode != null) {
            if (jsonNode instanceof ObjectNode) {
                return (ObjectNode)jsonNode;
            }
            throw new UnsupportedOperationException("Property '" + string2 + "' has value that is not of type ObjectNode (but " + jsonNode.getClass().getName() + ")");
        }
        ObjectNode objectNode = this.objectNode();
        this._children.put(string2, objectNode);
        return objectNode;
    }

    @Override
    public ArrayNode withArray(String string2) {
        JsonNode jsonNode = this._children.get(string2);
        if (jsonNode != null) {
            if (jsonNode instanceof ArrayNode) {
                return (ArrayNode)jsonNode;
            }
            throw new UnsupportedOperationException("Property '" + string2 + "' has value that is not of type ArrayNode (but " + jsonNode.getClass().getName() + ")");
        }
        ArrayNode arrayNode = this.arrayNode();
        this._children.put(string2, arrayNode);
        return arrayNode;
    }

    @Override
    public JsonNode findValue(String string2) {
        for (Map.Entry<String, JsonNode> entry : this._children.entrySet()) {
            if (string2.equals(entry.getKey())) {
                return entry.getValue();
            }
            JsonNode jsonNode = entry.getValue().findValue(string2);
            if (jsonNode == null) continue;
            return jsonNode;
        }
        return null;
    }

    @Override
    public List<JsonNode> findValues(String string2, List<JsonNode> list2) {
        for (Map.Entry<String, JsonNode> entry : this._children.entrySet()) {
            if (string2.equals(entry.getKey())) {
                if (list2 == null) {
                    list2 = new ArrayList<JsonNode>();
                }
                list2.add(entry.getValue());
                continue;
            }
            list2 = entry.getValue().findValues(string2, list2);
        }
        return list2;
    }

    @Override
    public List<String> findValuesAsText(String string2, List<String> list2) {
        for (Map.Entry<String, JsonNode> entry : this._children.entrySet()) {
            if (string2.equals(entry.getKey())) {
                if (list2 == null) {
                    list2 = new ArrayList<String>();
                }
                list2.add(entry.getValue().asText());
                continue;
            }
            list2 = entry.getValue().findValuesAsText(string2, list2);
        }
        return list2;
    }

    @Override
    public ObjectNode findParent(String string2) {
        for (Map.Entry<String, JsonNode> entry : this._children.entrySet()) {
            if (string2.equals(entry.getKey())) {
                return this;
            }
            JsonNode jsonNode = entry.getValue().findParent(string2);
            if (jsonNode == null) continue;
            return (ObjectNode)jsonNode;
        }
        return null;
    }

    @Override
    public List<JsonNode> findParents(String string2, List<JsonNode> list2) {
        for (Map.Entry<String, JsonNode> entry : this._children.entrySet()) {
            if (string2.equals(entry.getKey())) {
                if (list2 == null) {
                    list2 = new ArrayList<JsonNode>();
                }
                list2.add(this);
                continue;
            }
            list2 = entry.getValue().findParents(string2, list2);
        }
        return list2;
    }

    @Override
    public void serialize(JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
        jsonGenerator.writeStartObject();
        for (Map.Entry<String, JsonNode> entry : this._children.entrySet()) {
            jsonGenerator.writeFieldName(entry.getKey());
            ((BaseJsonNode)entry.getValue()).serialize(jsonGenerator, serializerProvider);
        }
        jsonGenerator.writeEndObject();
    }

    @Override
    public void serializeWithType(JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException, JsonProcessingException {
        typeSerializer.writeTypePrefixForObject(this, jsonGenerator);
        for (Map.Entry<String, JsonNode> entry : this._children.entrySet()) {
            jsonGenerator.writeFieldName(entry.getKey());
            ((BaseJsonNode)entry.getValue()).serialize(jsonGenerator, serializerProvider);
        }
        typeSerializer.writeTypeSuffixForObject(this, jsonGenerator);
    }

    public JsonNode set(String string2, JsonNode jsonNode) {
        if (jsonNode == null) {
            jsonNode = this.nullNode();
        }
        this._children.put(string2, jsonNode);
        return this;
    }

    public JsonNode setAll(Map<String, JsonNode> map2) {
        for (Map.Entry<String, JsonNode> entry : map2.entrySet()) {
            JsonNode jsonNode = entry.getValue();
            if (jsonNode == null) {
                jsonNode = this.nullNode();
            }
            this._children.put(entry.getKey(), jsonNode);
        }
        return this;
    }

    public JsonNode setAll(ObjectNode objectNode) {
        this._children.putAll(objectNode._children);
        return this;
    }

    public JsonNode replace(String string2, JsonNode jsonNode) {
        if (jsonNode == null) {
            jsonNode = this.nullNode();
        }
        return this._children.put(string2, jsonNode);
    }

    public JsonNode without(String string2) {
        this._children.remove(string2);
        return this;
    }

    public ObjectNode without(Collection<String> collection) {
        this._children.keySet().removeAll(collection);
        return this;
    }

    public JsonNode put(String string2, JsonNode jsonNode) {
        if (jsonNode == null) {
            jsonNode = this.nullNode();
        }
        return this._children.put(string2, jsonNode);
    }

    public JsonNode remove(String string2) {
        return this._children.remove(string2);
    }

    public ObjectNode remove(Collection<String> collection) {
        this._children.keySet().removeAll(collection);
        return this;
    }

    @Override
    public ObjectNode removeAll() {
        this._children.clear();
        return this;
    }

    public JsonNode putAll(Map<String, JsonNode> map2) {
        return this.setAll(map2);
    }

    public JsonNode putAll(ObjectNode objectNode) {
        return this.setAll(objectNode);
    }

    public ObjectNode retain(Collection<String> collection) {
        this._children.keySet().retainAll(collection);
        return this;
    }

    public ObjectNode retain(String ... stringArray) {
        return this.retain(Arrays.asList(stringArray));
    }

    public ArrayNode putArray(String string2) {
        ArrayNode arrayNode = this.arrayNode();
        this._put(string2, arrayNode);
        return arrayNode;
    }

    public ObjectNode putObject(String string2) {
        ObjectNode objectNode = this.objectNode();
        this._put(string2, objectNode);
        return objectNode;
    }

    public ObjectNode putPOJO(String string2, Object object) {
        return this._put(string2, this.pojoNode(object));
    }

    public ObjectNode putNull(String string2) {
        this._children.put(string2, this.nullNode());
        return this;
    }

    public ObjectNode put(String string2, short s2) {
        return this._put(string2, this.numberNode(s2));
    }

    public ObjectNode put(String string2, Short s2) {
        return this._put(string2, s2 == null ? this.nullNode() : this.numberNode((short)s2));
    }

    public ObjectNode put(String string2, int n) {
        return this._put(string2, this.numberNode(n));
    }

    public ObjectNode put(String string2, Integer n) {
        return this._put(string2, n == null ? this.nullNode() : this.numberNode((int)n));
    }

    public ObjectNode put(String string2, long l) {
        return this._put(string2, this.numberNode(l));
    }

    public ObjectNode put(String string2, Long l) {
        return this._put(string2, l == null ? this.nullNode() : this.numberNode((long)l));
    }

    public ObjectNode put(String string2, float f2) {
        return this._put(string2, this.numberNode(f2));
    }

    public ObjectNode put(String string2, Float f2) {
        return this._put(string2, f2 == null ? this.nullNode() : this.numberNode(f2.floatValue()));
    }

    public ObjectNode put(String string2, double d) {
        return this._put(string2, this.numberNode(d));
    }

    public ObjectNode put(String string2, Double d) {
        return this._put(string2, d == null ? this.nullNode() : this.numberNode((double)d));
    }

    public ObjectNode put(String string2, BigDecimal bigDecimal) {
        return this._put(string2, bigDecimal == null ? this.nullNode() : this.numberNode(bigDecimal));
    }

    public ObjectNode put(String string2, String string3) {
        return this._put(string2, string3 == null ? this.nullNode() : this.textNode(string3));
    }

    public ObjectNode put(String string2, boolean bl) {
        return this._put(string2, this.booleanNode(bl));
    }

    public ObjectNode put(String string2, Boolean bl) {
        return this._put(string2, bl == null ? this.nullNode() : this.booleanNode(bl));
    }

    public ObjectNode put(String string2, byte[] byArray) {
        return this._put(string2, byArray == null ? this.nullNode() : this.binaryNode(byArray));
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object instanceof ObjectNode) {
            return this._childrenEqual((ObjectNode)object);
        }
        return false;
    }

    protected boolean _childrenEqual(ObjectNode objectNode) {
        return this._children.equals(objectNode._children);
    }

    public int hashCode() {
        return this._children.hashCode();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(32 + (this.size() << 4));
        stringBuilder.append("{");
        int n = 0;
        for (Map.Entry<String, JsonNode> entry : this._children.entrySet()) {
            if (n > 0) {
                stringBuilder.append(",");
            }
            ++n;
            TextNode.appendQuoted(stringBuilder, entry.getKey());
            stringBuilder.append(':');
            stringBuilder.append(entry.getValue().toString());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    protected ObjectNode _put(String string2, JsonNode jsonNode) {
        this._children.put(string2, jsonNode);
        return this;
    }
}

