/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializable;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.annotation.NoClass;
import com.fasterxml.jackson.databind.cfg.SerializerFactoryConfig;
import com.fasterxml.jackson.databind.ext.OptionalHandlerFactory;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.BasicBeanDescription;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.SerializerFactory;
import com.fasterxml.jackson.databind.ser.Serializers;
import com.fasterxml.jackson.databind.ser.impl.IndexedStringListSerializer;
import com.fasterxml.jackson.databind.ser.impl.StringArraySerializer;
import com.fasterxml.jackson.databind.ser.impl.StringCollectionSerializer;
import com.fasterxml.jackson.databind.ser.std.BooleanSerializer;
import com.fasterxml.jackson.databind.ser.std.ByteBufferSerializer;
import com.fasterxml.jackson.databind.ser.std.CalendarSerializer;
import com.fasterxml.jackson.databind.ser.std.DateSerializer;
import com.fasterxml.jackson.databind.ser.std.EnumMapSerializer;
import com.fasterxml.jackson.databind.ser.std.EnumSerializer;
import com.fasterxml.jackson.databind.ser.std.InetAddressSerializer;
import com.fasterxml.jackson.databind.ser.std.InetSocketAddressSerializer;
import com.fasterxml.jackson.databind.ser.std.JsonValueSerializer;
import com.fasterxml.jackson.databind.ser.std.MapSerializer;
import com.fasterxml.jackson.databind.ser.std.NumberSerializers;
import com.fasterxml.jackson.databind.ser.std.ObjectArraySerializer;
import com.fasterxml.jackson.databind.ser.std.SerializableSerializer;
import com.fasterxml.jackson.databind.ser.std.SqlDateSerializer;
import com.fasterxml.jackson.databind.ser.std.SqlTimeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdArraySerializers;
import com.fasterxml.jackson.databind.ser.std.StdContainerSerializers;
import com.fasterxml.jackson.databind.ser.std.StdDelegatingSerializer;
import com.fasterxml.jackson.databind.ser.std.StdJdkSerializers;
import com.fasterxml.jackson.databind.ser.std.StdKeySerializers;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.ser.std.StringSerializer;
import com.fasterxml.jackson.databind.ser.std.TimeZoneSerializer;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.databind.ser.std.TokenBufferSerializer;
import com.fasterxml.jackson.databind.type.ArrayType;
import com.fasterxml.jackson.databind.type.CollectionLikeType;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapLikeType;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.Converter;
import com.fasterxml.jackson.databind.util.EnumValues;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.RandomAccess;
import java.util.TimeZone;

public abstract class BasicSerializerFactory
extends SerializerFactory
implements Serializable {
    protected static final HashMap<String, JsonSerializer<?>> _concrete = new HashMap();
    protected static final HashMap<String, Class<? extends JsonSerializer<?>>> _concreteLazy = new HashMap();
    protected final SerializerFactoryConfig _factoryConfig;

    protected BasicSerializerFactory(SerializerFactoryConfig serializerFactoryConfig) {
        this._factoryConfig = serializerFactoryConfig == null ? new SerializerFactoryConfig() : serializerFactoryConfig;
    }

    public SerializerFactoryConfig getFactoryConfig() {
        return this._factoryConfig;
    }

    public abstract SerializerFactory withConfig(SerializerFactoryConfig var1);

    @Override
    public final SerializerFactory withAdditionalSerializers(Serializers serializers) {
        return this.withConfig(this._factoryConfig.withAdditionalSerializers(serializers));
    }

    @Override
    public final SerializerFactory withAdditionalKeySerializers(Serializers serializers) {
        return this.withConfig(this._factoryConfig.withAdditionalKeySerializers(serializers));
    }

    @Override
    public final SerializerFactory withSerializerModifier(BeanSerializerModifier beanSerializerModifier) {
        return this.withConfig(this._factoryConfig.withSerializerModifier(beanSerializerModifier));
    }

    @Override
    public abstract JsonSerializer<Object> createSerializer(SerializerProvider var1, JavaType var2) throws JsonMappingException;

    @Override
    public JsonSerializer<Object> createKeySerializer(SerializationConfig serializationConfig, JavaType javaType, JsonSerializer<Object> jsonSerializer) {
        BeanDescription beanDescription = serializationConfig.introspectClassAnnotations(javaType.getRawClass());
        JsonSerializer<Object> jsonSerializer2 = null;
        if (this._factoryConfig.hasKeySerializers()) {
            Serializers object;
            Iterator<Object> iterator2 = this._factoryConfig.keySerializers().iterator();
            while (iterator2.hasNext() && (jsonSerializer2 = (object = iterator2.next()).findSerializer(serializationConfig, javaType, beanDescription)) == null) {
            }
        }
        if (jsonSerializer2 == null && (jsonSerializer2 = jsonSerializer) == null) {
            jsonSerializer2 = StdKeySerializers.getStdKeySerializer(javaType);
        }
        if (this._factoryConfig.hasSerializerModifiers()) {
            for (BeanSerializerModifier beanSerializerModifier : this._factoryConfig.serializerModifiers()) {
                jsonSerializer2 = beanSerializerModifier.modifyKeySerializer(serializationConfig, javaType, beanDescription, jsonSerializer2);
            }
        }
        return jsonSerializer2;
    }

    @Override
    public TypeSerializer createTypeSerializer(SerializationConfig serializationConfig, JavaType javaType) {
        BeanDescription beanDescription = serializationConfig.introspectClassAnnotations(javaType.getRawClass());
        AnnotatedClass annotatedClass = beanDescription.getClassInfo();
        AnnotationIntrospector annotationIntrospector = serializationConfig.getAnnotationIntrospector();
        TypeResolverBuilder<?> typeResolverBuilder = annotationIntrospector.findTypeResolver(serializationConfig, annotatedClass, javaType);
        Collection<NamedType> collection = null;
        if (typeResolverBuilder == null) {
            typeResolverBuilder = serializationConfig.getDefaultTyper(javaType);
        } else {
            collection = serializationConfig.getSubtypeResolver().collectAndResolveSubtypes(annotatedClass, serializationConfig, annotationIntrospector);
        }
        if (typeResolverBuilder == null) {
            return null;
        }
        return typeResolverBuilder.buildTypeSerializer(serializationConfig, javaType, collection);
    }

    protected abstract Iterable<Serializers> customSerializers();

    protected final JsonSerializer<?> findSerializerByLookup(JavaType javaType, SerializationConfig serializationConfig, BeanDescription beanDescription, boolean bl) {
        Class<JsonSerializer<?>> clazz;
        Class<?> clazz2 = javaType.getRawClass();
        String string2 = clazz2.getName();
        JsonSerializer<?> jsonSerializer = _concrete.get(string2);
        if (jsonSerializer == null && (clazz = _concreteLazy.get(string2)) != null) {
            try {
                return clazz.newInstance();
            }
            catch (Exception exception) {
                throw new IllegalStateException("Failed to instantiate standard serializer (of type " + clazz.getName() + "): " + exception.getMessage(), exception);
            }
        }
        return jsonSerializer;
    }

    protected final JsonSerializer<?> findSerializerByAnnotations(SerializerProvider serializerProvider, JavaType javaType, BeanDescription beanDescription) throws JsonMappingException {
        Class<?> clazz = javaType.getRawClass();
        if (JsonSerializable.class.isAssignableFrom(clazz)) {
            return SerializableSerializer.instance;
        }
        AnnotatedMethod annotatedMethod = beanDescription.findJsonValueMethod();
        if (annotatedMethod != null) {
            Method method = annotatedMethod.getAnnotated();
            if (serializerProvider.canOverrideAccessModifiers()) {
                ClassUtil.checkAndFixAccess(method);
            }
            JsonSerializer<Object> jsonSerializer = this.findSerializerFromAnnotation(serializerProvider, annotatedMethod);
            return new JsonValueSerializer(method, jsonSerializer);
        }
        return null;
    }

    protected final JsonSerializer<?> findSerializerByPrimaryType(SerializerProvider serializerProvider, JavaType javaType, BeanDescription beanDescription, boolean bl) throws JsonMappingException {
        Class<?> clazz = javaType.getRawClass();
        JsonSerializer<?> jsonSerializer = this.findOptionalStdSerializer(serializerProvider, javaType, beanDescription, bl);
        if (jsonSerializer != null) {
            return jsonSerializer;
        }
        if (Calendar.class.isAssignableFrom(clazz)) {
            return CalendarSerializer.instance;
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return DateSerializer.instance;
        }
        if (ByteBuffer.class.isAssignableFrom(clazz)) {
            return ByteBufferSerializer.instance;
        }
        if (InetAddress.class.isAssignableFrom(clazz)) {
            return InetAddressSerializer.instance;
        }
        if (InetSocketAddress.class.isAssignableFrom(clazz)) {
            return InetSocketAddressSerializer.instance;
        }
        if (TimeZone.class.isAssignableFrom(clazz)) {
            return TimeZoneSerializer.instance;
        }
        if (Charset.class.isAssignableFrom(clazz)) {
            return ToStringSerializer.instance;
        }
        if (Number.class.isAssignableFrom(clazz)) {
            return NumberSerializers.NumberSerializer.instance;
        }
        if (Enum.class.isAssignableFrom(clazz)) {
            return this.buildEnumSerializer(serializerProvider.getConfig(), javaType, beanDescription);
        }
        return null;
    }

    protected JsonSerializer<?> findOptionalStdSerializer(SerializerProvider serializerProvider, JavaType javaType, BeanDescription beanDescription, boolean bl) throws JsonMappingException {
        return OptionalHandlerFactory.instance.findSerializer(serializerProvider.getConfig(), javaType, beanDescription);
    }

    protected final JsonSerializer<?> findSerializerByAddonType(SerializationConfig serializationConfig, JavaType javaType, BeanDescription beanDescription, boolean bl) throws JsonMappingException {
        Class<?> clazz = javaType.getRawClass();
        if (Iterator.class.isAssignableFrom(clazz)) {
            return this.buildIteratorSerializer(serializationConfig, javaType, beanDescription, bl);
        }
        if (Iterable.class.isAssignableFrom(clazz)) {
            return this.buildIterableSerializer(serializationConfig, javaType, beanDescription, bl);
        }
        if (CharSequence.class.isAssignableFrom(clazz)) {
            return ToStringSerializer.instance;
        }
        return null;
    }

    protected JsonSerializer<Object> findSerializerFromAnnotation(SerializerProvider serializerProvider, Annotated annotated) throws JsonMappingException {
        Object object = serializerProvider.getAnnotationIntrospector().findSerializer(annotated);
        if (object == null) {
            return null;
        }
        JsonSerializer<Object> jsonSerializer = serializerProvider.serializerInstance(annotated, object);
        return this.findConvertingSerializer(serializerProvider, annotated, jsonSerializer);
    }

    protected JsonSerializer<?> findConvertingSerializer(SerializerProvider serializerProvider, Annotated annotated, JsonSerializer<?> jsonSerializer) throws JsonMappingException {
        Converter<Object, Object> converter = this.findConverter(serializerProvider, annotated);
        if (converter == null) {
            return jsonSerializer;
        }
        JavaType javaType = converter.getOutputType(serializerProvider.getTypeFactory());
        return new StdDelegatingSerializer(converter, javaType, jsonSerializer);
    }

    protected Converter<Object, Object> findConverter(SerializerProvider serializerProvider, Annotated annotated) throws JsonMappingException {
        Object object = serializerProvider.getAnnotationIntrospector().findSerializationConverter(annotated);
        if (object == null) {
            return null;
        }
        return serializerProvider.converterInstance(annotated, object);
    }

    @Deprecated
    protected final JsonSerializer<?> buildContainerSerializer(SerializerProvider serializerProvider, JavaType javaType, BeanDescription beanDescription, BeanProperty beanProperty, boolean bl) throws JsonMappingException {
        return this.buildContainerSerializer(serializerProvider, javaType, beanDescription, bl);
    }

    protected JsonSerializer<?> buildContainerSerializer(SerializerProvider serializerProvider, JavaType javaType, BeanDescription beanDescription, boolean bl) throws JsonMappingException {
        JavaType javaType2;
        TypeSerializer typeSerializer;
        SerializationConfig serializationConfig = serializerProvider.getConfig();
        if (!(bl || !javaType.useStaticType() || javaType.isContainerType() && javaType.getContentType().getRawClass() == Object.class)) {
            bl = true;
        }
        if ((typeSerializer = this.createTypeSerializer(serializationConfig, javaType2 = javaType.getContentType())) != null) {
            bl = false;
        }
        JsonSerializer<Object> jsonSerializer = this._findContentSerializer(serializerProvider, beanDescription.getClassInfo());
        if (javaType.isMapLikeType()) {
            MapLikeType mapLikeType = (MapLikeType)javaType;
            JsonSerializer<Object> jsonSerializer2 = this._findKeySerializer(serializerProvider, beanDescription.getClassInfo());
            if (mapLikeType.isTrueMapType()) {
                return this.buildMapSerializer(serializationConfig, (MapType)mapLikeType, beanDescription, bl, jsonSerializer2, typeSerializer, jsonSerializer);
            }
            for (Serializers serializers : this.customSerializers()) {
                MapLikeType mapLikeType2;
                JsonSerializer<?> jsonSerializer3 = serializers.findMapLikeSerializer(serializationConfig, mapLikeType2 = (MapLikeType)javaType, beanDescription, jsonSerializer2, typeSerializer, jsonSerializer);
                if (jsonSerializer3 == null) continue;
                if (this._factoryConfig.hasSerializerModifiers()) {
                    for (BeanSerializerModifier beanSerializerModifier : this._factoryConfig.serializerModifiers()) {
                        jsonSerializer3 = beanSerializerModifier.modifyMapLikeSerializer(serializationConfig, mapLikeType2, beanDescription, jsonSerializer3);
                    }
                }
                return jsonSerializer3;
            }
            return null;
        }
        if (javaType.isCollectionLikeType()) {
            CollectionLikeType collectionLikeType = (CollectionLikeType)javaType;
            if (collectionLikeType.isTrueCollectionType()) {
                return this.buildCollectionSerializer(serializationConfig, (CollectionType)collectionLikeType, beanDescription, bl, typeSerializer, jsonSerializer);
            }
            CollectionLikeType collectionLikeType2 = (CollectionLikeType)javaType;
            for (Serializers serializers : this.customSerializers()) {
                JsonSerializer<?> jsonSerializer4 = serializers.findCollectionLikeSerializer(serializationConfig, collectionLikeType2, beanDescription, typeSerializer, jsonSerializer);
                if (jsonSerializer4 == null) continue;
                if (this._factoryConfig.hasSerializerModifiers()) {
                    for (BeanSerializerModifier beanSerializerModifier : this._factoryConfig.serializerModifiers()) {
                        jsonSerializer4 = beanSerializerModifier.modifyCollectionLikeSerializer(serializationConfig, collectionLikeType2, beanDescription, jsonSerializer4);
                    }
                }
                return jsonSerializer4;
            }
            return null;
        }
        if (javaType.isArrayType()) {
            return this.buildArraySerializer(serializationConfig, (ArrayType)javaType, beanDescription, bl, typeSerializer, jsonSerializer);
        }
        return null;
    }

    @Deprecated
    protected final JsonSerializer<?> buildCollectionSerializer(SerializationConfig serializationConfig, CollectionType collectionType, BeanDescription beanDescription, BeanProperty beanProperty, boolean bl, TypeSerializer typeSerializer, JsonSerializer<Object> jsonSerializer) throws JsonMappingException {
        return this.buildCollectionSerializer(serializationConfig, collectionType, beanDescription, bl, typeSerializer, jsonSerializer);
    }

    protected JsonSerializer<?> buildCollectionSerializer(SerializationConfig serializationConfig, CollectionType collectionType, BeanDescription beanDescription, boolean bl, TypeSerializer typeSerializer, JsonSerializer<Object> jsonSerializer) throws JsonMappingException {
        Serializers clazz2;
        StdSerializer stdSerializer = null;
        Object object = this.customSerializers().iterator();
        while (object.hasNext() && (stdSerializer = (clazz2 = object.next()).findCollectionSerializer(serializationConfig, collectionType, beanDescription, typeSerializer, jsonSerializer)) == null) {
        }
        if (stdSerializer == null) {
            Type type;
            object = beanDescription.findExpectedFormat(null);
            if (object != null && ((JsonFormat.Value)object).getShape() == JsonFormat.Shape.OBJECT) {
                return null;
            }
            Class<?> clazz = collectionType.getRawClass();
            if (EnumSet.class.isAssignableFrom(clazz)) {
                type = collectionType.getContentType();
                if (!type.isEnumType()) {
                    type = null;
                }
                stdSerializer = StdContainerSerializers.enumSetSerializer(type);
            } else {
                type = collectionType.getContentType().getRawClass();
                if (this.isIndexedList(clazz)) {
                    if (type == String.class) {
                        if (jsonSerializer == null || ClassUtil.isJacksonStdImpl(jsonSerializer)) {
                            stdSerializer = IndexedStringListSerializer.instance;
                        }
                    } else {
                        stdSerializer = StdContainerSerializers.indexedListSerializer(collectionType.getContentType(), bl, typeSerializer, jsonSerializer);
                    }
                } else if (type == String.class && (jsonSerializer == null || ClassUtil.isJacksonStdImpl(jsonSerializer))) {
                    stdSerializer = StringCollectionSerializer.instance;
                }
                if (stdSerializer == null) {
                    stdSerializer = StdContainerSerializers.collectionSerializer(collectionType.getContentType(), bl, typeSerializer, jsonSerializer);
                }
            }
        }
        if (this._factoryConfig.hasSerializerModifiers()) {
            for (BeanSerializerModifier beanSerializerModifier : this._factoryConfig.serializerModifiers()) {
                stdSerializer = beanSerializerModifier.modifyCollectionSerializer(serializationConfig, collectionType, beanDescription, stdSerializer);
            }
        }
        return stdSerializer;
    }

    protected boolean isIndexedList(Class<?> clazz) {
        return RandomAccess.class.isAssignableFrom(clazz);
    }

    /*
     * WARNING - void declaration
     */
    protected JsonSerializer<?> buildMapSerializer(SerializationConfig serializationConfig, MapType mapType, BeanDescription beanDescription, boolean bl, JsonSerializer<Object> jsonSerializer, TypeSerializer typeSerializer, JsonSerializer<Object> jsonSerializer2) throws JsonMappingException {
        Serializers object3;
        JsonSerializer jsonSerializer3 = null;
        Object object2 = this.customSerializers().iterator();
        while (object2.hasNext() && (jsonSerializer3 = (object3 = object2.next()).findMapSerializer(serializationConfig, mapType, beanDescription, jsonSerializer, typeSerializer, jsonSerializer2)) == null) {
        }
        if (jsonSerializer3 == null) {
            if (EnumMap.class.isAssignableFrom(mapType.getRawClass())) {
                void var10_13;
                object2 = mapType.getKeyType();
                Object var10_11 = null;
                if (((JavaType)object2).isEnumType()) {
                    Class<Enum<?>> clazz = ((JavaType)object2).getRawClass();
                    EnumValues enumValues = EnumValues.construct(clazz, serializationConfig.getAnnotationIntrospector());
                }
                jsonSerializer3 = new EnumMapSerializer(mapType.getContentType(), bl, (EnumValues)var10_13, typeSerializer, jsonSerializer2);
            } else {
                object2 = this.findFilterId(serializationConfig, beanDescription);
                jsonSerializer3 = MapSerializer.construct(serializationConfig.getAnnotationIntrospector().findPropertiesToIgnore(beanDescription.getClassInfo()), mapType, bl, typeSerializer, jsonSerializer, jsonSerializer2, object2);
            }
        }
        if (this._factoryConfig.hasSerializerModifiers()) {
            for (BeanSerializerModifier beanSerializerModifier : this._factoryConfig.serializerModifiers()) {
                jsonSerializer3 = beanSerializerModifier.modifyMapSerializer(serializationConfig, mapType, beanDescription, jsonSerializer3);
            }
        }
        return jsonSerializer3;
    }

    protected JsonSerializer<?> buildArraySerializer(SerializationConfig serializationConfig, ArrayType arrayType, BeanDescription beanDescription, boolean bl, TypeSerializer typeSerializer, JsonSerializer<Object> jsonSerializer) throws JsonMappingException {
        Serializers object2;
        JsonSerializer jsonSerializer2 = null;
        Iterator<BeanSerializerModifier> iterator2 = this.customSerializers().iterator();
        while (iterator2.hasNext() && (jsonSerializer2 = (object2 = iterator2.next()).findArraySerializer(serializationConfig, arrayType, beanDescription, typeSerializer, jsonSerializer)) == null) {
        }
        if (jsonSerializer2 == null) {
            iterator2 = arrayType.getRawClass();
            if (jsonSerializer == null || ClassUtil.isJacksonStdImpl(jsonSerializer)) {
                jsonSerializer2 = String[].class == iterator2 ? StringArraySerializer.instance : StdArraySerializers.findStandardImpl(iterator2);
            }
            if (jsonSerializer2 == null) {
                jsonSerializer2 = new ObjectArraySerializer(arrayType.getContentType(), bl, typeSerializer, jsonSerializer);
            }
        }
        if (this._factoryConfig.hasSerializerModifiers()) {
            for (BeanSerializerModifier beanSerializerModifier : this._factoryConfig.serializerModifiers()) {
                jsonSerializer2 = beanSerializerModifier.modifyArraySerializer(serializationConfig, arrayType, beanDescription, jsonSerializer2);
            }
        }
        return jsonSerializer2;
    }

    protected JsonSerializer<?> buildIteratorSerializer(SerializationConfig serializationConfig, JavaType javaType, BeanDescription beanDescription, boolean bl) throws JsonMappingException {
        JavaType javaType2 = javaType.containedType(0);
        if (javaType2 == null) {
            javaType2 = TypeFactory.unknownType();
        }
        TypeSerializer typeSerializer = this.createTypeSerializer(serializationConfig, javaType2);
        return StdContainerSerializers.iteratorSerializer(javaType2, this.usesStaticTyping(serializationConfig, beanDescription, typeSerializer), typeSerializer);
    }

    protected JsonSerializer<?> buildIterableSerializer(SerializationConfig serializationConfig, JavaType javaType, BeanDescription beanDescription, boolean bl) throws JsonMappingException {
        JavaType javaType2 = javaType.containedType(0);
        if (javaType2 == null) {
            javaType2 = TypeFactory.unknownType();
        }
        TypeSerializer typeSerializer = this.createTypeSerializer(serializationConfig, javaType2);
        return StdContainerSerializers.iterableSerializer(javaType2, this.usesStaticTyping(serializationConfig, beanDescription, typeSerializer), typeSerializer);
    }

    protected JsonSerializer<?> buildEnumSerializer(SerializationConfig serializationConfig, JavaType javaType, BeanDescription beanDescription) throws JsonMappingException {
        JsonFormat.Value value2 = beanDescription.findExpectedFormat(null);
        if (value2 != null && value2.getShape() == JsonFormat.Shape.OBJECT) {
            ((BasicBeanDescription)beanDescription).removeProperty("declaringClass");
            return null;
        }
        Class<Enum<?>> clazz = javaType.getRawClass();
        JsonSerializer jsonSerializer = EnumSerializer.construct(clazz, serializationConfig, beanDescription, value2);
        if (this._factoryConfig.hasSerializerModifiers()) {
            for (BeanSerializerModifier beanSerializerModifier : this._factoryConfig.serializerModifiers()) {
                jsonSerializer = beanSerializerModifier.modifyEnumSerializer(serializationConfig, javaType, beanDescription, jsonSerializer);
            }
        }
        return jsonSerializer;
    }

    protected <T extends JavaType> T modifyTypeByAnnotation(SerializationConfig serializationConfig, Annotated annotated, T object) {
        Class<?> clazz = serializationConfig.getAnnotationIntrospector().findSerializationType(annotated);
        if (clazz != null) {
            try {
                object = object.widenBy(clazz);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalArgumentException("Failed to widen type " + object + " with concrete-type annotation (value " + clazz.getName() + "), method '" + annotated.getName() + "': " + illegalArgumentException.getMessage());
            }
        }
        return BasicSerializerFactory.modifySecondaryTypesByAnnotation(serializationConfig, annotated, object);
    }

    protected static <T extends JavaType> T modifySecondaryTypesByAnnotation(SerializationConfig serializationConfig, Annotated annotated, T object) {
        AnnotationIntrospector annotationIntrospector = serializationConfig.getAnnotationIntrospector();
        if (((JavaType)object).isContainerType()) {
            Class<?> clazz;
            Class<?> clazz2 = annotationIntrospector.findSerializationKeyType(annotated, ((JavaType)object).getKeyType());
            if (clazz2 != null) {
                if (!(object instanceof MapType)) {
                    throw new IllegalArgumentException("Illegal key-type annotation: type " + object + " is not a Map type");
                }
                try {
                    object = ((MapType)object).widenKey(clazz2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new IllegalArgumentException("Failed to narrow key type " + object + " with key-type annotation (" + clazz2.getName() + "): " + illegalArgumentException.getMessage());
                }
            }
            if ((clazz = annotationIntrospector.findSerializationContentType(annotated, ((JavaType)object).getContentType())) != null) {
                try {
                    object = ((JavaType)object).widenContentsBy(clazz);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new IllegalArgumentException("Failed to narrow content type " + object + " with content-type annotation (" + clazz.getName() + "): " + illegalArgumentException.getMessage());
                }
            }
        }
        return (T)object;
    }

    protected JsonSerializer<Object> _findKeySerializer(SerializerProvider serializerProvider, Annotated annotated) throws JsonMappingException {
        AnnotationIntrospector annotationIntrospector = serializerProvider.getAnnotationIntrospector();
        Object object = annotationIntrospector.findKeySerializer(annotated);
        if (object != null) {
            return serializerProvider.serializerInstance(annotated, object);
        }
        return null;
    }

    protected JsonSerializer<Object> _findContentSerializer(SerializerProvider serializerProvider, Annotated annotated) throws JsonMappingException {
        AnnotationIntrospector annotationIntrospector = serializerProvider.getAnnotationIntrospector();
        Object object = annotationIntrospector.findContentSerializer(annotated);
        if (object != null) {
            return serializerProvider.serializerInstance(annotated, object);
        }
        return null;
    }

    protected Object findFilterId(SerializationConfig serializationConfig, BeanDescription beanDescription) {
        return serializationConfig.getAnnotationIntrospector().findFilterId((Annotated)beanDescription.getClassInfo());
    }

    @Deprecated
    protected final boolean usesStaticTyping(SerializationConfig serializationConfig, BeanDescription beanDescription, TypeSerializer typeSerializer, BeanProperty beanProperty) {
        return this.usesStaticTyping(serializationConfig, beanDescription, typeSerializer);
    }

    protected boolean usesStaticTyping(SerializationConfig serializationConfig, BeanDescription beanDescription, TypeSerializer typeSerializer) {
        if (typeSerializer != null) {
            return false;
        }
        AnnotationIntrospector annotationIntrospector = serializationConfig.getAnnotationIntrospector();
        JsonSerialize.Typing typing = annotationIntrospector.findSerializationTyping(beanDescription.getClassInfo());
        if (typing != null && typing != JsonSerialize.Typing.DEFAULT_TYPING) {
            return typing == JsonSerialize.Typing.STATIC;
        }
        return serializationConfig.isEnabled(MapperFeature.USE_STATIC_TYPING);
    }

    protected Class<?> _verifyAsClass(Object object, String string2, Class<?> clazz) {
        if (object == null) {
            return null;
        }
        if (!(object instanceof Class)) {
            throw new IllegalStateException("AnnotationIntrospector." + string2 + "() returned value of type " + object.getClass().getName() + ": expected type JsonSerializer or Class<JsonSerializer> instead");
        }
        Class clazz2 = (Class)object;
        if (clazz2 == clazz || clazz2 == NoClass.class) {
            return null;
        }
        return clazz2;
    }

    static {
        _concrete.put(String.class.getName(), new StringSerializer());
        ToStringSerializer toStringSerializer = ToStringSerializer.instance;
        _concrete.put(StringBuffer.class.getName(), toStringSerializer);
        _concrete.put(StringBuilder.class.getName(), toStringSerializer);
        _concrete.put(Character.class.getName(), toStringSerializer);
        _concrete.put(Character.TYPE.getName(), toStringSerializer);
        NumberSerializers.addAll(_concrete);
        _concrete.put(Boolean.TYPE.getName(), new BooleanSerializer(true));
        _concrete.put(Boolean.class.getName(), new BooleanSerializer(false));
        NumberSerializers.NumberSerializer numberSerializer = new NumberSerializers.NumberSerializer();
        _concrete.put(BigInteger.class.getName(), numberSerializer);
        _concrete.put(BigDecimal.class.getName(), numberSerializer);
        _concrete.put(Calendar.class.getName(), CalendarSerializer.instance);
        DateSerializer dateSerializer = DateSerializer.instance;
        _concrete.put(Date.class.getName(), dateSerializer);
        _concrete.put(Timestamp.class.getName(), dateSerializer);
        _concreteLazy.put(java.sql.Date.class.getName(), SqlDateSerializer.class);
        _concreteLazy.put(Time.class.getName(), SqlTimeSerializer.class);
        for (Map.Entry<Class<?>, Object> entry : StdJdkSerializers.all()) {
            Object object = entry.getValue();
            if (object instanceof JsonSerializer) {
                _concrete.put(entry.getKey().getName(), (JsonSerializer)object);
                continue;
            }
            if (object instanceof Class) {
                Class clazz = (Class)object;
                _concreteLazy.put(entry.getKey().getName(), clazz);
                continue;
            }
            throw new IllegalStateException("Internal error: unrecognized value of type " + entry.getClass().getName());
        }
        _concreteLazy.put(TokenBuffer.class.getName(), TokenBufferSerializer.class);
    }
}

