/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.impl;

import com.fasterxml.jackson.annotation.ObjectIdGenerator;
import com.fasterxml.jackson.core.io.SerializedString;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.PropertyName;

public final class ObjectIdWriter {
    public final JavaType idType;
    public final SerializedString propertyName;
    public final ObjectIdGenerator<?> generator;
    public final JsonSerializer<Object> serializer;
    public final boolean alwaysAsId;

    protected ObjectIdWriter(JavaType javaType, SerializedString serializedString, ObjectIdGenerator<?> objectIdGenerator, JsonSerializer<?> jsonSerializer, boolean bl) {
        this.idType = javaType;
        this.propertyName = serializedString;
        this.generator = objectIdGenerator;
        this.serializer = jsonSerializer;
        this.alwaysAsId = bl;
    }

    public static ObjectIdWriter construct(JavaType javaType, PropertyName propertyName, ObjectIdGenerator<?> objectIdGenerator, boolean bl) {
        String string2 = propertyName == null ? null : propertyName.getSimpleName();
        return ObjectIdWriter.construct(javaType, string2, objectIdGenerator, bl);
    }

    @Deprecated
    public static ObjectIdWriter construct(JavaType javaType, String string2, ObjectIdGenerator<?> objectIdGenerator, boolean bl) {
        SerializedString serializedString = string2 == null ? null : new SerializedString(string2);
        return new ObjectIdWriter(javaType, serializedString, objectIdGenerator, null, bl);
    }

    public ObjectIdWriter withSerializer(JsonSerializer<?> jsonSerializer) {
        return new ObjectIdWriter(this.idType, this.propertyName, this.generator, jsonSerializer, this.alwaysAsId);
    }

    public ObjectIdWriter withAlwaysAsId(boolean bl) {
        if (bl == this.alwaysAsId) {
            return this;
        }
        return new ObjectIdWriter(this.idType, this.propertyName, this.generator, this.serializer, bl);
    }
}

