/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.impl;

import com.fasterxml.jackson.databind.ser.BeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.PropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class SimpleFilterProvider
extends FilterProvider
implements Serializable {
    private static final long serialVersionUID = -6305772546718366447L;
    protected final Map<String, PropertyFilter> _filtersById;
    protected PropertyFilter _defaultFilter;
    protected boolean _cfgFailOnUnknownId = true;

    public SimpleFilterProvider() {
        this(new HashMap());
    }

    public SimpleFilterProvider(Map<String, ?> map2) {
        for (Object obj2 : map2.values()) {
            if (obj2 instanceof PropertyFilter) continue;
            this._filtersById = SimpleFilterProvider._convert(map2);
            return;
        }
        this._filtersById = map2;
    }

    private static final Map<String, PropertyFilter> _convert(Map<String, ?> map2) {
        HashMap<String, PropertyFilter> hashMap = new HashMap<String, PropertyFilter>();
        for (Map.Entry<String, ?> entry : map2.entrySet()) {
            Object obj2 = entry.getValue();
            if (obj2 instanceof PropertyFilter) {
                hashMap.put(entry.getKey(), (PropertyFilter)obj2);
                continue;
            }
            if (obj2 instanceof BeanPropertyFilter) {
                hashMap.put(entry.getKey(), SimpleFilterProvider._convert((BeanPropertyFilter)obj2));
                continue;
            }
            throw new IllegalArgumentException("Unrecognized filter type (" + obj2.getClass().getName() + ")");
        }
        return hashMap;
    }

    private static final PropertyFilter _convert(BeanPropertyFilter beanPropertyFilter) {
        return SimpleBeanPropertyFilter.from(beanPropertyFilter);
    }

    @Deprecated
    public SimpleFilterProvider setDefaultFilter(BeanPropertyFilter beanPropertyFilter) {
        this._defaultFilter = SimpleBeanPropertyFilter.from(beanPropertyFilter);
        return this;
    }

    public SimpleFilterProvider setDefaultFilter(PropertyFilter propertyFilter) {
        this._defaultFilter = propertyFilter;
        return this;
    }

    public SimpleFilterProvider setDefaultFilter(SimpleBeanPropertyFilter simpleBeanPropertyFilter) {
        this._defaultFilter = simpleBeanPropertyFilter;
        return this;
    }

    public PropertyFilter getDefaultFilter() {
        return this._defaultFilter;
    }

    public SimpleFilterProvider setFailOnUnknownId(boolean bl) {
        this._cfgFailOnUnknownId = bl;
        return this;
    }

    public boolean willFailOnUnknownId() {
        return this._cfgFailOnUnknownId;
    }

    @Deprecated
    public SimpleFilterProvider addFilter(String string2, BeanPropertyFilter beanPropertyFilter) {
        this._filtersById.put(string2, SimpleFilterProvider._convert(beanPropertyFilter));
        return this;
    }

    public SimpleFilterProvider addFilter(String string2, PropertyFilter propertyFilter) {
        this._filtersById.put(string2, propertyFilter);
        return this;
    }

    public SimpleFilterProvider addFilter(String string2, SimpleBeanPropertyFilter simpleBeanPropertyFilter) {
        this._filtersById.put(string2, simpleBeanPropertyFilter);
        return this;
    }

    public PropertyFilter removeFilter(String string2) {
        return this._filtersById.remove(string2);
    }

    @Override
    @Deprecated
    public BeanPropertyFilter findFilter(Object object) {
        throw new UnsupportedOperationException("Access to deprecated filters not supported");
    }

    @Override
    public PropertyFilter findPropertyFilter(Object object, Object object2) {
        PropertyFilter propertyFilter = this._filtersById.get(object);
        if (propertyFilter == null && (propertyFilter = this._defaultFilter) == null && this._cfgFailOnUnknownId) {
            throw new IllegalArgumentException("No filter configured with id '" + object + "' (type " + object.getClass().getName() + ")");
        }
        return propertyFilter;
    }
}

