/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.type;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class TypeParser
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final TypeFactory _factory;

    public TypeParser(TypeFactory typeFactory) {
        this._factory = typeFactory;
    }

    public JavaType parse(String string2) throws IllegalArgumentException {
        string2 = string2.trim();
        MyTokenizer myTokenizer = new MyTokenizer(string2);
        JavaType javaType = this.parseType(myTokenizer);
        if (myTokenizer.hasMoreTokens()) {
            throw this._problem(myTokenizer, "Unexpected tokens after complete type");
        }
        return javaType;
    }

    protected JavaType parseType(MyTokenizer myTokenizer) throws IllegalArgumentException {
        if (!myTokenizer.hasMoreTokens()) {
            throw this._problem(myTokenizer, "Unexpected end-of-string");
        }
        Class<?> clazz = this.findClass(myTokenizer.nextToken(), myTokenizer);
        if (myTokenizer.hasMoreTokens()) {
            String string2 = myTokenizer.nextToken();
            if ("<".equals(string2)) {
                return this._factory._fromParameterizedClass(clazz, this.parseTypes(myTokenizer));
            }
            myTokenizer.pushBack(string2);
        }
        return this._factory._fromClass(clazz, null);
    }

    protected List<JavaType> parseTypes(MyTokenizer myTokenizer) throws IllegalArgumentException {
        ArrayList<JavaType> arrayList = new ArrayList<JavaType>();
        while (myTokenizer.hasMoreTokens()) {
            arrayList.add(this.parseType(myTokenizer));
            if (!myTokenizer.hasMoreTokens()) break;
            String string2 = myTokenizer.nextToken();
            if (">".equals(string2)) {
                return arrayList;
            }
            if (",".equals(string2)) continue;
            throw this._problem(myTokenizer, "Unexpected token '" + string2 + "', expected ',' or '>')");
        }
        throw this._problem(myTokenizer, "Unexpected end-of-string");
    }

    protected Class<?> findClass(String string2, MyTokenizer myTokenizer) {
        try {
            return ClassUtil.findClass(string2);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw this._problem(myTokenizer, "Can not locate class '" + string2 + "', problem: " + exception.getMessage());
        }
    }

    protected IllegalArgumentException _problem(MyTokenizer myTokenizer, String string2) {
        return new IllegalArgumentException("Failed to parse type '" + myTokenizer.getAllInput() + "' (remaining: '" + myTokenizer.getRemainingInput() + "'): " + string2);
    }

    static final class MyTokenizer
    extends StringTokenizer {
        protected final String _input;
        protected int _index;
        protected String _pushbackToken;

        public MyTokenizer(String string2) {
            super(string2, "<,>", true);
            this._input = string2;
        }

        @Override
        public boolean hasMoreTokens() {
            return this._pushbackToken != null || super.hasMoreTokens();
        }

        @Override
        public String nextToken() {
            String string2;
            if (this._pushbackToken != null) {
                string2 = this._pushbackToken;
                this._pushbackToken = null;
            } else {
                string2 = super.nextToken();
            }
            this._index += string2.length();
            return string2;
        }

        public void pushBack(String string2) {
            this._pushbackToken = string2;
            this._index -= string2.length();
        }

        public String getAllInput() {
            return this._input;
        }

        public String getUsedInput() {
            return this._input.substring(0, this._index);
        }

        public String getRemainingInput() {
            return this._input.substring(this._index);
        }
    }
}

