/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.util;

import java.lang.reflect.Array;
import java.util.List;

public final class ObjectBuffer {
    static final int INITIAL_CHUNK_SIZE = 12;
    static final int SMALL_CHUNK_SIZE = 16384;
    static final int MAX_CHUNK_SIZE = 262144;
    private Node _bufferHead;
    private Node _bufferTail;
    private int _bufferedEntryCount;
    private Object[] _freeBuffer;

    public Object[] resetAndStart() {
        this._reset();
        if (this._freeBuffer == null) {
            return new Object[12];
        }
        return this._freeBuffer;
    }

    public Object[] appendCompletedChunk(Object[] objectArray) {
        Node node = new Node(objectArray);
        if (this._bufferHead == null) {
            this._bufferHead = this._bufferTail = node;
        } else {
            this._bufferTail.linkNext(node);
            this._bufferTail = node;
        }
        int n = objectArray.length;
        this._bufferedEntryCount += n;
        n = n < 16384 ? (n += n) : (n += n >> 2);
        return new Object[n];
    }

    public Object[] completeAndClearBuffer(Object[] objectArray, int n) {
        int n2 = n + this._bufferedEntryCount;
        Object[] objectArray2 = new Object[n2];
        this._copyTo(objectArray2, n2, objectArray, n);
        return objectArray2;
    }

    public <T> T[] completeAndClearBuffer(Object[] objectArray, int n, Class<T> clazz) {
        int n2 = n + this._bufferedEntryCount;
        Object[] objectArray2 = (Object[])Array.newInstance(clazz, n2);
        this._copyTo(objectArray2, n2, objectArray, n);
        this._reset();
        return objectArray2;
    }

    public void completeAndClearBuffer(Object[] objectArray, int n, List<Object> list2) {
        for (Node node = this._bufferHead; node != null; node = node.next()) {
            Object[] objectArray2 = node.getData();
            int n2 = objectArray2.length;
            for (int i = 0; i < n2; ++i) {
                list2.add(objectArray2[i]);
            }
        }
        for (int i = 0; i < n; ++i) {
            list2.add(objectArray[i]);
        }
    }

    public int initialCapacity() {
        return this._freeBuffer == null ? 0 : this._freeBuffer.length;
    }

    public int bufferedSize() {
        return this._bufferedEntryCount;
    }

    protected void _reset() {
        if (this._bufferTail != null) {
            this._freeBuffer = this._bufferTail.getData();
        }
        this._bufferTail = null;
        this._bufferHead = null;
        this._bufferedEntryCount = 0;
    }

    protected final void _copyTo(Object object, int n, Object[] objectArray, int n2) {
        int n3 = 0;
        for (Node node = this._bufferHead; node != null; node = node.next()) {
            Object[] objectArray2 = node.getData();
            int n4 = objectArray2.length;
            System.arraycopy(objectArray2, 0, object, n3, n4);
            n3 += n4;
        }
        System.arraycopy(objectArray, 0, object, n3, n2);
        if ((n3 += n2) != n) {
            throw new IllegalStateException("Should have gotten " + n + " entries, got " + n3);
        }
    }

    static final class Node {
        final Object[] _data;
        Node _next;

        public Node(Object[] objectArray) {
            this._data = objectArray;
        }

        public Object[] getData() {
            return this._data;
        }

        public Node next() {
            return this._next;
        }

        public void linkNext(Node node) {
            if (this._next != null) {
                throw new IllegalStateException();
            }
            this._next = node;
        }
    }
}

