/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;

@GwtCompatible
final class CollectPreconditions {
    CollectPreconditions() {
    }

    static void checkEntryNotNull(Object key, Object value2) {
        if (key == null) {
            throw new NullPointerException("null key in entry: null=" + value2);
        }
        if (value2 == null) {
            throw new NullPointerException("null value in entry: " + key + "=null");
        }
    }

    static int checkNonnegative(int value2, String name2) {
        if (value2 < 0) {
            throw new IllegalArgumentException(name2 + " cannot be negative but was: " + value2);
        }
        return value2;
    }

    static void checkRemove(boolean canRemove) {
        Preconditions.checkState(canRemove, "no calls to next() since the last call to remove()");
    }
}

