/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLongArray;

public class AtomicDoubleArray
implements Serializable {
    private static final long serialVersionUID = 0L;
    private transient AtomicLongArray longs;

    public AtomicDoubleArray(int length) {
        this.longs = new AtomicLongArray(length);
    }

    public AtomicDoubleArray(double[] array) {
        int len2 = array.length;
        long[] longArray = new long[len2];
        for (int i = 0; i < len2; ++i) {
            longArray[i] = Double.doubleToRawLongBits(array[i]);
        }
        this.longs = new AtomicLongArray(longArray);
    }

    public final int length() {
        return this.longs.length();
    }

    public final double get(int i) {
        return Double.longBitsToDouble(this.longs.get(i));
    }

    public final void set(int i, double newValue) {
        long next2 = Double.doubleToRawLongBits(newValue);
        this.longs.set(i, next2);
    }

    public final void lazySet(int i, double newValue) {
        this.set(i, newValue);
    }

    public final double getAndSet(int i, double newValue) {
        long next2 = Double.doubleToRawLongBits(newValue);
        return Double.longBitsToDouble(this.longs.getAndSet(i, next2));
    }

    public final boolean compareAndSet(int i, double expect, double update2) {
        return this.longs.compareAndSet(i, Double.doubleToRawLongBits(expect), Double.doubleToRawLongBits(update2));
    }

    public final boolean weakCompareAndSet(int i, double expect, double update2) {
        return this.longs.weakCompareAndSet(i, Double.doubleToRawLongBits(expect), Double.doubleToRawLongBits(update2));
    }

    public final double getAndAdd(int i, double delta) {
        double currentVal;
        double nextVal;
        long next2;
        long current2;
        while (!this.longs.compareAndSet(i, current2 = this.longs.get(i), next2 = Double.doubleToRawLongBits(nextVal = (currentVal = Double.longBitsToDouble(current2)) + delta))) {
        }
        return currentVal;
    }

    public double addAndGet(int i, double delta) {
        double currentVal;
        double nextVal;
        long next2;
        long current2;
        while (!this.longs.compareAndSet(i, current2 = this.longs.get(i), next2 = Double.doubleToRawLongBits(nextVal = (currentVal = Double.longBitsToDouble(current2)) + delta))) {
        }
        return nextVal;
    }

    public String toString() {
        int iMax = this.length() - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuilder b = new StringBuilder(19 * (iMax + 1));
        b.append('[');
        int i = 0;
        while (true) {
            b.append(Double.longBitsToDouble(this.longs.get(i)));
            if (i == iMax) {
                return b.append(']').toString();
            }
            b.append(',').append(' ');
            ++i;
        }
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        int length = this.length();
        s2.writeInt(length);
        for (int i = 0; i < length; ++i) {
            s2.writeDouble(this.get(i));
        }
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        int length = s2.readInt();
        this.longs = new AtomicLongArray(length);
        for (int i = 0; i < length; ++i) {
            this.set(i, s2.readDouble());
        }
    }
}

