/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah;

import com.googlecode.javaewah.BitmapStorage;

public final class BitCounter
implements BitmapStorage {
    private int oneBits;

    @Override
    public void add(long newdata) {
        this.oneBits += Long.bitCount(newdata);
    }

    @Override
    public void addStreamOfLiteralWords(long[] data, int start2, int number2) {
        for (int i = start2; i < start2 + number2; ++i) {
            this.add(data[i]);
        }
    }

    @Override
    public void addStreamOfEmptyWords(boolean v, long number2) {
        if (v) {
            this.oneBits = (int)((long)this.oneBits + number2 * 64L);
        }
    }

    @Override
    public void addStreamOfNegatedLiteralWords(long[] data, int start2, int number2) {
        for (int i = start2; i < start2 + number2; ++i) {
            this.add(data[i] ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public int getCount() {
        return this.oneBits;
    }

    @Override
    public void setSizeInBits(int bits2) {
    }
}

