/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah;

import com.googlecode.javaewah.BitmapStorage;
import com.googlecode.javaewah.EWAHCompressedBitmap;
import com.googlecode.javaewah.IteratingBufferedRunningLengthWord;
import com.googlecode.javaewah.IteratingRLW;
import com.googlecode.javaewah.IteratorAggregation;
import com.googlecode.javaewah.LogicalElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.PriorityQueue;

public class FastAggregation {
    public static EWAHCompressedBitmap bufferedand(int bufsize, EWAHCompressedBitmap ... bitmaps) {
        EWAHCompressedBitmap answer = new EWAHCompressedBitmap();
        FastAggregation.bufferedandWithContainer(answer, bufsize, bitmaps);
        return answer;
    }

    public static void bufferedandWithContainer(BitmapStorage container, int bufsize, EWAHCompressedBitmap ... bitmaps) {
        LinkedList<IteratingBufferedRunningLengthWord> al = new LinkedList<IteratingBufferedRunningLengthWord>();
        for (EWAHCompressedBitmap bitmap : bitmaps) {
            al.add(new IteratingBufferedRunningLengthWord(bitmap));
        }
        long[] hardbitmap = new long[bufsize * bitmaps.length];
        for (IteratingBufferedRunningLengthWord i : al) {
            if (i.size() != 0L) continue;
            al.clear();
            break;
        }
        block2: while (!al.isEmpty()) {
            Arrays.fill(hardbitmap, -1L);
            long effective = Integer.MAX_VALUE;
            for (IteratingBufferedRunningLengthWord i : al) {
                int eff = IteratorAggregation.inplaceand(hardbitmap, i);
                if ((long)eff >= effective) continue;
                effective = eff;
            }
            int k = 0;
            while ((long)k < effective) {
                container.add(hardbitmap[k]);
                ++k;
            }
            for (IteratingBufferedRunningLengthWord i : al) {
                if (i.size() != 0L) continue;
                al.clear();
                continue block2;
            }
        }
    }

    public static EWAHCompressedBitmap bufferedor(int bufsize, EWAHCompressedBitmap ... bitmaps) {
        EWAHCompressedBitmap answer = new EWAHCompressedBitmap();
        FastAggregation.bufferedorWithContainer(answer, bufsize, bitmaps);
        return answer;
    }

    public static void bufferedorWithContainer(BitmapStorage container, int bufsize, EWAHCompressedBitmap ... bitmaps) {
        int range2 = 0;
        EWAHCompressedBitmap[] sbitmaps = (EWAHCompressedBitmap[])bitmaps.clone();
        Arrays.sort(sbitmaps, new Comparator<EWAHCompressedBitmap>(){

            @Override
            public int compare(EWAHCompressedBitmap a, EWAHCompressedBitmap b) {
                return b.sizeinbits - a.sizeinbits;
            }
        });
        ArrayList<IteratingBufferedRunningLengthWord> al = new ArrayList<IteratingBufferedRunningLengthWord>();
        for (EWAHCompressedBitmap bitmap : sbitmaps) {
            if (bitmap.sizeinbits > range2) {
                range2 = bitmap.sizeinbits;
            }
            al.add(new IteratingBufferedRunningLengthWord(bitmap));
        }
        long[] hardbitmap = new long[bufsize];
        int maxr = al.size();
        while (maxr > 0) {
            int k;
            long effective = 0L;
            for (k = 0; k < maxr; ++k) {
                if (((IteratingBufferedRunningLengthWord)al.get(k)).size() > 0L) {
                    int eff = IteratorAggregation.inplaceor(hardbitmap, (IteratingRLW)al.get(k));
                    if ((long)eff <= effective) continue;
                    effective = eff;
                    continue;
                }
                maxr = k;
            }
            k = 0;
            while ((long)k < effective) {
                container.add(hardbitmap[k]);
                ++k;
            }
            Arrays.fill(hardbitmap, 0L);
        }
        container.setSizeInBits(range2);
    }

    public static EWAHCompressedBitmap bufferedxor(int bufsize, EWAHCompressedBitmap ... bitmaps) {
        EWAHCompressedBitmap answer = new EWAHCompressedBitmap();
        FastAggregation.bufferedxorWithContainer(answer, bufsize, bitmaps);
        return answer;
    }

    public static void bufferedxorWithContainer(BitmapStorage container, int bufsize, EWAHCompressedBitmap ... bitmaps) {
        int range2 = 0;
        EWAHCompressedBitmap[] sbitmaps = (EWAHCompressedBitmap[])bitmaps.clone();
        Arrays.sort(sbitmaps, new Comparator<EWAHCompressedBitmap>(){

            @Override
            public int compare(EWAHCompressedBitmap a, EWAHCompressedBitmap b) {
                return b.sizeinbits - a.sizeinbits;
            }
        });
        ArrayList<IteratingBufferedRunningLengthWord> al = new ArrayList<IteratingBufferedRunningLengthWord>();
        for (EWAHCompressedBitmap bitmap : sbitmaps) {
            if (bitmap.sizeinbits > range2) {
                range2 = bitmap.sizeinbits;
            }
            al.add(new IteratingBufferedRunningLengthWord(bitmap));
        }
        long[] hardbitmap = new long[bufsize];
        int maxr = al.size();
        while (maxr > 0) {
            int k;
            long effective = 0L;
            for (k = 0; k < maxr; ++k) {
                if (((IteratingBufferedRunningLengthWord)al.get(k)).size() > 0L) {
                    int eff = IteratorAggregation.inplacexor(hardbitmap, (IteratingRLW)al.get(k));
                    if ((long)eff <= effective) continue;
                    effective = eff;
                    continue;
                }
                maxr = k;
            }
            k = 0;
            while ((long)k < effective) {
                container.add(hardbitmap[k]);
                ++k;
            }
            Arrays.fill(hardbitmap, 0L);
        }
        container.setSizeInBits(range2);
    }

    public static <T extends LogicalElement> T or(T ... bitmaps) {
        PriorityQueue<Object> pq = new PriorityQueue<Object>(bitmaps.length, new Comparator<T>(){

            @Override
            public int compare(T a, T b) {
                return a.sizeInBytes() - b.sizeInBytes();
            }
        });
        for (T x : bitmaps) {
            pq.add(x);
        }
        while (pq.size() > 1) {
            LogicalElement x1 = (LogicalElement)pq.poll();
            LogicalElement x2 = (LogicalElement)pq.poll();
            pq.add(x1.or(x2));
        }
        return (T)((LogicalElement)pq.poll());
    }

    public static void orToContainer(BitmapStorage container, EWAHCompressedBitmap ... bitmaps) {
        if (bitmaps.length < 2) {
            throw new IllegalArgumentException("We need at least two bitmaps");
        }
        PriorityQueue<EWAHCompressedBitmap> pq = new PriorityQueue<EWAHCompressedBitmap>(bitmaps.length, new Comparator<EWAHCompressedBitmap>(){

            @Override
            public int compare(EWAHCompressedBitmap a, EWAHCompressedBitmap b) {
                return a.sizeInBytes() - b.sizeInBytes();
            }
        });
        for (EWAHCompressedBitmap x : bitmaps) {
            pq.add(x);
        }
        while (pq.size() > 2) {
            EWAHCompressedBitmap x1 = pq.poll();
            EWAHCompressedBitmap x2 = pq.poll();
            pq.add(x1.or(x2));
        }
        pq.poll().orToContainer(pq.poll(), container);
    }

    public static <T extends LogicalElement> T xor(T ... bitmaps) {
        PriorityQueue<Object> pq = new PriorityQueue<Object>(bitmaps.length, new Comparator<T>(){

            @Override
            public int compare(T a, T b) {
                return a.sizeInBytes() - b.sizeInBytes();
            }
        });
        for (T x : bitmaps) {
            pq.add(x);
        }
        while (pq.size() > 1) {
            LogicalElement x1 = (LogicalElement)pq.poll();
            LogicalElement x2 = (LogicalElement)pq.poll();
            pq.add(x1.xor(x2));
        }
        return (T)((LogicalElement)pq.poll());
    }

    public static void xorToContainer(BitmapStorage container, EWAHCompressedBitmap ... bitmaps) {
        if (bitmaps.length < 2) {
            throw new IllegalArgumentException("We need at least two bitmaps");
        }
        PriorityQueue<EWAHCompressedBitmap> pq = new PriorityQueue<EWAHCompressedBitmap>(bitmaps.length, new Comparator<EWAHCompressedBitmap>(){

            @Override
            public int compare(EWAHCompressedBitmap a, EWAHCompressedBitmap b) {
                return a.sizeInBytes() - b.sizeInBytes();
            }
        });
        for (EWAHCompressedBitmap x : bitmaps) {
            pq.add(x);
        }
        while (pq.size() > 2) {
            EWAHCompressedBitmap x1 = pq.poll();
            EWAHCompressedBitmap x2 = pq.poll();
            pq.add(x1.xor(x2));
        }
        pq.poll().xorToContainer(pq.poll(), container);
    }

    /*
     * Unable to fully structure code
     */
    @Deprecated
    public static void legacy_orWithContainer(BitmapStorage container, EWAHCompressedBitmap ... bitmaps) {
        if (bitmaps.length == 2) {
            bitmaps[0].orToContainer(bitmaps[1], container);
            return;
        }
        sortedBitmaps = (EWAHCompressedBitmap[])bitmaps.clone();
        Arrays.sort(sortedBitmaps, new Comparator<EWAHCompressedBitmap>(){

            @Override
            public int compare(EWAHCompressedBitmap a, EWAHCompressedBitmap b) {
                return a.sizeinbits < b.sizeinbits ? 1 : (a.sizeinbits == b.sizeinbits ? 0 : -1);
            }
        });
        rlws = new IteratingBufferedRunningLengthWord[bitmaps.length];
        maxAvailablePos = 0;
        for (EWAHCompressedBitmap bitmap : sortedBitmaps) {
            iterator = bitmap.getEWAHIterator();
            if (!iterator.hasNext()) continue;
            rlws[maxAvailablePos++] = new IteratingBufferedRunningLengthWord(iterator);
        }
        if (maxAvailablePos == 0) {
            container.setSizeInBits(0);
            return;
        }
        maxSize = sortedBitmaps[0].sizeinbits;
        block1: while (true) {
            maxOneRl = 0L;
            minZeroRl = 0x7FFFFFFFFFFFFFFFL;
            minSize = 0x7FFFFFFFFFFFFFFFL;
            numEmptyRl = 0;
            for (i = 0; i < maxAvailablePos; ++i) {
                rlw = rlws[i];
                size = rlw.size();
                if (size == 0L) {
                    maxAvailablePos = i;
                    break;
                }
                minSize = Math.min(minSize, size);
                if (rlw.getRunningBit()) {
                    rl = rlw.getRunningLength();
                    maxOneRl = Math.max(maxOneRl, rl);
                    minZeroRl = 0L;
                    if (rl != 0L || size <= 0L) continue;
                    ++numEmptyRl;
                    continue;
                }
                rl = rlw.getRunningLength();
                minZeroRl = Math.min(minZeroRl, rl);
                if (rl != 0L || size <= 0L) continue;
                ++numEmptyRl;
            }
            if (maxAvailablePos == 0) break;
            if (maxAvailablePos == 1) {
                rlws[0].discharge(container);
                break;
            }
            if (maxOneRl > 0L) {
                container.addStreamOfEmptyWords(true, maxOneRl);
                i = 0;
                while (true) {
                    if (i >= maxAvailablePos) continue block1;
                    rlw = rlws[i];
                    rlw.discardFirstWords(maxOneRl);
                    ++i;
                }
            }
            if (minZeroRl > 0L) {
                container.addStreamOfEmptyWords(false, minZeroRl);
                i = 0;
                while (true) {
                    if (i >= maxAvailablePos) continue block1;
                    rlw = rlws[i];
                    rlw.discardFirstWords(minZeroRl);
                    ++i;
                }
            }
            index = 0;
            if (numEmptyRl == 1) {
                emptyRl = null;
                minNonEmptyRl = 0x7FFFFFFFFFFFFFFFL;
                for (i = 0; i < maxAvailablePos; ++i) {
                    rlw = rlws[i];
                    rl = rlw.getRunningLength();
                    if (rl == 0L) {
                        if (!FastAggregation.$assertionsDisabled && emptyRl != null) {
                            throw new AssertionError();
                        }
                        emptyRl = rlw;
                        continue;
                    }
                    minNonEmptyRl = Math.min(minNonEmptyRl, rl);
                }
                v0 = wordsToWrite = minNonEmptyRl > minSize ? minSize : minNonEmptyRl;
                if (emptyRl != null) {
                    emptyRl.writeLiteralWords((int)wordsToWrite, container);
                }
                index = (int)((long)index + wordsToWrite);
            }
            while ((long)index < minSize) {
                word = 0L;
                for (i = 0; i < maxAvailablePos; ++i) {
                    rlw = rlws[i];
                    if (rlw.getRunningLength() > (long)index) continue;
                    word |= rlw.getLiteralWordAt(index - (int)rlw.getRunningLength());
                }
                container.add(word);
                ++index;
            }
            i = 0;
            while (true) {
                if (i < maxAvailablePos) ** break;
                continue block1;
                rlw = rlws[i];
                rlw.discardFirstWords(minSize);
                ++i;
            }
            break;
        }
        container.setSizeInBits(maxSize);
    }
}

