/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah;

import com.googlecode.javaewah.BitmapStorage;
import com.googlecode.javaewah.BufferedRunningLengthWord;
import com.googlecode.javaewah.EWAHCompressedBitmap;
import com.googlecode.javaewah.EWAHIterator;
import com.googlecode.javaewah.IteratingRLW;

public final class IteratingBufferedRunningLengthWord
implements IteratingRLW,
Cloneable {
    private BufferedRunningLengthWord brlw;
    private long[] buffer;
    private int literalWordStartPosition;
    private EWAHIterator iterator;

    public IteratingBufferedRunningLengthWord(EWAHIterator iterator2) {
        this.iterator = iterator2;
        this.brlw = new BufferedRunningLengthWord(this.iterator.next());
        this.literalWordStartPosition = this.iterator.literalWords() + this.brlw.literalwordoffset;
        this.buffer = this.iterator.buffer();
    }

    public IteratingBufferedRunningLengthWord(EWAHCompressedBitmap bitmap) {
        this.iterator = EWAHIterator.getEWAHIterator(bitmap);
        this.brlw = new BufferedRunningLengthWord(this.iterator.next());
        this.literalWordStartPosition = this.iterator.literalWords() + this.brlw.literalwordoffset;
        this.buffer = this.iterator.buffer();
    }

    @Override
    public void discardFirstWords(long x) {
        while (x > 0L) {
            if (this.brlw.RunningLength > x) {
                this.brlw.RunningLength -= x;
                return;
            }
            this.brlw.RunningLength = 0L;
            long toDiscard = (x -= this.brlw.RunningLength) > (long)this.brlw.NumberOfLiteralWords ? (long)this.brlw.NumberOfLiteralWords : x;
            this.literalWordStartPosition = (int)((long)this.literalWordStartPosition + toDiscard);
            this.brlw.NumberOfLiteralWords = (int)((long)this.brlw.NumberOfLiteralWords - toDiscard);
            if ((x -= toDiscard) <= 0L && this.brlw.size() != 0L) continue;
            if (!this.iterator.hasNext()) break;
            this.brlw.reset(this.iterator.next());
            this.literalWordStartPosition = this.iterator.literalWords();
        }
    }

    @Override
    public boolean next() {
        if (!this.iterator.hasNext()) {
            this.brlw.NumberOfLiteralWords = 0;
            this.brlw.RunningLength = 0L;
            return false;
        }
        this.brlw.reset(this.iterator.next());
        this.literalWordStartPosition = this.iterator.literalWords();
        return true;
    }

    public long discharge(BitmapStorage container, long max2) {
        long index2;
        int pd;
        for (index2 = 0L; index2 < max2 && this.size() > 0L; index2 += (long)pd) {
            long pl = this.getRunningLength();
            if (index2 + pl > max2) {
                pl = max2 - index2;
            }
            container.addStreamOfEmptyWords(this.getRunningBit(), pl);
            pd = this.getNumberOfLiteralWords();
            if ((long)pd + (index2 += pl) > max2) {
                pd = (int)(max2 - index2);
            }
            this.writeLiteralWords(pd, container);
            this.discardFirstWords(pl + (long)pd);
        }
        return index2;
    }

    public long dischargeNegated(BitmapStorage container, long max2) {
        long index2;
        int pd;
        for (index2 = 0L; index2 < max2 && this.size() > 0L; index2 += (long)pd) {
            long pl = this.getRunningLength();
            if (index2 + pl > max2) {
                pl = max2 - index2;
            }
            container.addStreamOfEmptyWords(!this.getRunningBit(), pl);
            pd = this.getNumberOfLiteralWords();
            if ((long)pd + (index2 += pl) > max2) {
                pd = (int)(max2 - index2);
            }
            this.writeNegatedLiteralWords(pd, container);
            this.discardFirstWords(pl + (long)pd);
        }
        return index2;
    }

    public void dischargeAsEmpty(BitmapStorage container) {
        while (this.size() > 0L) {
            container.addStreamOfEmptyWords(false, this.size());
            this.discardFirstWords(this.size());
        }
    }

    public void discharge(BitmapStorage container) {
        this.brlw.literalwordoffset = this.literalWordStartPosition - this.iterator.literalWords();
        IteratingBufferedRunningLengthWord.discharge(this.brlw, this.iterator, container);
    }

    @Override
    public long getLiteralWordAt(int index2) {
        return this.buffer[this.literalWordStartPosition + index2];
    }

    @Override
    public int getNumberOfLiteralWords() {
        return this.brlw.NumberOfLiteralWords;
    }

    @Override
    public boolean getRunningBit() {
        return this.brlw.RunningBit;
    }

    @Override
    public long getRunningLength() {
        return this.brlw.RunningLength;
    }

    @Override
    public long size() {
        return this.brlw.size();
    }

    public void writeLiteralWords(int numWords, BitmapStorage container) {
        container.addStreamOfLiteralWords(this.buffer, this.literalWordStartPosition, numWords);
    }

    public void writeNegatedLiteralWords(int numWords, BitmapStorage container) {
        container.addStreamOfNegatedLiteralWords(this.buffer, this.literalWordStartPosition, numWords);
    }

    private static void discharge(BufferedRunningLengthWord initialWord, EWAHIterator iterator2, BitmapStorage container) {
        BufferedRunningLengthWord runningLengthWord = initialWord;
        while (true) {
            long runningLength = runningLengthWord.getRunningLength();
            container.addStreamOfEmptyWords(runningLengthWord.getRunningBit(), runningLength);
            container.addStreamOfLiteralWords(iterator2.buffer(), iterator2.literalWords() + runningLengthWord.literalwordoffset, runningLengthWord.getNumberOfLiteralWords());
            if (!iterator2.hasNext()) break;
            runningLengthWord = new BufferedRunningLengthWord(iterator2.next());
        }
    }

    @Override
    public IteratingBufferedRunningLengthWord clone() throws CloneNotSupportedException {
        IteratingBufferedRunningLengthWord answer = (IteratingBufferedRunningLengthWord)super.clone();
        answer.brlw = this.brlw.clone();
        answer.buffer = this.buffer;
        answer.iterator = this.iterator.clone();
        answer.literalWordStartPosition = this.literalWordStartPosition;
        return answer;
    }
}

