/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah.benchmark;

import com.googlecode.javaewah.EWAHCompressedBitmap;
import com.googlecode.javaewah.FastAggregation;
import com.googlecode.javaewah.IteratingBufferedRunningLengthWord;
import com.googlecode.javaewah.IteratingRLW;
import com.googlecode.javaewah.IteratorAggregation;
import com.googlecode.javaewah.IteratorUtil;
import com.googlecode.javaewah.LogicalElement;
import com.googlecode.javaewah.benchmark.ClusteredDataGenerator;
import java.text.DecimalFormat;

public class BenchmarkUnion {
    public static void main(String[] args) {
        BenchmarkUnion.test(10, 18, 1);
    }

    public static void test(int N, int nbr, int repeat2) {
        long bogus = 0L;
        DecimalFormat df = new DecimalFormat("0.###");
        ClusteredDataGenerator cdg = new ClusteredDataGenerator();
        for (int sparsity = 1; sparsity < 30 - nbr; ++sparsity) {
            for (int times2 = 0; times2 < 2; ++times2) {
                Object ewahor;
                Object[] ewahcp;
                int r;
                String line2 = "";
                line2 = line2 + sparsity;
                int[][] data = new int[N][];
                int Max2 = 1 << nbr + sparsity;
                for (int k = 0; k < N; ++k) {
                    data[k] = cdg.generateClustered(1 << nbr, Max2);
                }
                LogicalElement[] ewah = new EWAHCompressedBitmap[N];
                for (int k = 0; k < N; ++k) {
                    ewah[k] = new EWAHCompressedBitmap();
                    for (int x = 0; x < data[k].length; ++x) {
                        ewah[k].set(data[k][x]);
                    }
                    data[k] = null;
                }
                EWAHCompressedBitmap answer = ewah[0].or(ewah[1]);
                for (int k = 2; k < ewah.length; ++k) {
                    answer = answer.or(ewah[k]);
                }
                EWAHCompressedBitmap ewahor2 = EWAHCompressedBitmap.or((EWAHCompressedBitmap[])ewah);
                if (!answer.equals(ewahor2)) {
                    throw new RuntimeException("bug EWAHCompressedBitmap.or");
                }
                EWAHCompressedBitmap ewahor3 = (EWAHCompressedBitmap)FastAggregation.or((LogicalElement[])ewah);
                if (!ewahor2.equals(ewahor3)) {
                    throw new RuntimeException("bug FastAggregation.or");
                }
                EWAHCompressedBitmap ewahor22 = FastAggregation.bufferedor(65536, (EWAHCompressedBitmap[])ewah);
                if (!ewahor2.equals(ewahor22)) {
                    throw new RuntimeException("bug FastAggregation.bufferedor ");
                }
                long bef = System.currentTimeMillis();
                for (r = 0; r < repeat2; ++r) {
                    for (int k = 0; k < N; ++k) {
                        LogicalElement ewahor4 = ewah[0];
                        for (int j = 1; j < k + 1; ++j) {
                            ewahor4 = ((EWAHCompressedBitmap)ewahor4).or((EWAHCompressedBitmap)ewah[j]);
                        }
                    }
                }
                long aft = System.currentTimeMillis();
                line2 = line2 + "\t" + df.format((double)(aft - bef) / 1000.0);
                bef = System.currentTimeMillis();
                for (r = 0; r < repeat2; ++r) {
                    for (int k = 0; k < N; ++k) {
                        ewahcp = new EWAHCompressedBitmap[k + 1];
                        for (int j = 0; j < k + 1; ++j) {
                            ewahcp[j] = ewah[j];
                        }
                        ewahor = EWAHCompressedBitmap.or((EWAHCompressedBitmap[])ewahcp);
                        bogus += (long)((EWAHCompressedBitmap)ewahor).sizeInBits();
                    }
                }
                aft = System.currentTimeMillis();
                line2 = line2 + "\t" + df.format((double)(aft - bef) / 1000.0);
                bef = System.currentTimeMillis();
                for (r = 0; r < repeat2; ++r) {
                    for (int k = 0; k < N; ++k) {
                        ewahcp = new EWAHCompressedBitmap[k + 1];
                        for (int j = 0; j < k + 1; ++j) {
                            ewahcp[j] = ewah[j];
                        }
                        ewahor = (EWAHCompressedBitmap)FastAggregation.or((LogicalElement[])ewahcp);
                        bogus += (long)((EWAHCompressedBitmap)ewahor).sizeInBits();
                    }
                }
                aft = System.currentTimeMillis();
                line2 = line2 + "\t" + df.format((double)(aft - bef) / 1000.0);
                bef = System.currentTimeMillis();
                for (r = 0; r < repeat2; ++r) {
                    for (int k = 0; k < N; ++k) {
                        ewahcp = new EWAHCompressedBitmap[k + 1];
                        for (int j = 0; j < k + 1; ++j) {
                            ewahcp[j] = ewah[j];
                        }
                        ewahor = FastAggregation.bufferedor(65536, (EWAHCompressedBitmap[])ewahcp);
                        bogus += (long)((EWAHCompressedBitmap)ewahor).sizeInBits();
                    }
                }
                aft = System.currentTimeMillis();
                line2 = line2 + "\t" + df.format((double)(aft - bef) / 1000.0);
                bef = System.currentTimeMillis();
                for (r = 0; r < repeat2; ++r) {
                    for (int k = 0; k < N; ++k) {
                        ewahcp = new EWAHCompressedBitmap[k + 1];
                        for (int j = 0; j < k + 1; ++j) {
                            ewahcp[j] = ewah[j];
                        }
                        EWAHCompressedBitmap x = new EWAHCompressedBitmap();
                        FastAggregation.legacy_orWithContainer(x, (EWAHCompressedBitmap[])ewahcp);
                        bogus += (long)x.sizeInBits();
                    }
                }
                aft = System.currentTimeMillis();
                line2 = line2 + "\t" + df.format((double)(aft - bef) / 1000.0);
                bef = System.currentTimeMillis();
                for (r = 0; r < repeat2; ++r) {
                    for (int k = 0; k < N; ++k) {
                        ewahcp = new IteratingRLW[k + 1];
                        for (int j = 0; j < k + 1; ++j) {
                            ewahcp[j] = new IteratingBufferedRunningLengthWord((EWAHCompressedBitmap)ewah[j]);
                        }
                        ewahor = IteratorAggregation.bufferedor((IteratingRLW[])ewahcp);
                        int wordcounter = IteratorUtil.cardinality((IteratingRLW)ewahor);
                        bogus += (long)wordcounter;
                    }
                }
                aft = System.currentTimeMillis();
                line2 = line2 + "\t" + df.format((double)(aft - bef) / 1000.0);
                System.out.println("# times for: 2by2 EWAHCompressedBitmap.or FastAggregation.or experimentalor bufferedor legacygroupedor iterator-bufferedor");
                System.out.println(line2);
            }
            System.out.println("# bogus =" + bogus);
        }
    }
}

