/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah32;

import com.googlecode.javaewah.IntIterator;
import com.googlecode.javaewah.LogicalElement;
import com.googlecode.javaewah32.BitCounter32;
import com.googlecode.javaewah32.BitmapStorage32;
import com.googlecode.javaewah32.EWAHIterator32;
import com.googlecode.javaewah32.FastAggregation32;
import com.googlecode.javaewah32.IntIteratorImpl32;
import com.googlecode.javaewah32.IteratingBufferedRunningLengthWord32;
import com.googlecode.javaewah32.IteratingRLW32;
import com.googlecode.javaewah32.NonEmptyVirtualStorage32;
import com.googlecode.javaewah32.RunningLengthWord32;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public final class EWAHCompressedBitmap32
implements Cloneable,
Externalizable,
Iterable<Integer>,
BitmapStorage32,
LogicalElement<EWAHCompressedBitmap32> {
    int actualsizeinwords = 1;
    int[] buffer = null;
    RunningLengthWord32 rlw = null;
    int sizeinbits = 0;
    static final int defaultbuffersize = 4;
    public static final boolean usetrailingzeros = true;
    public static final boolean adjustContainerSizeWhenAggregating = true;
    public static final int wordinbits = 32;

    public EWAHCompressedBitmap32() {
        this.buffer = new int[4];
        this.rlw = new RunningLengthWord32(this, 0);
    }

    public EWAHCompressedBitmap32(int buffersize) {
        this.buffer = new int[buffersize];
        this.rlw = new RunningLengthWord32(this, 0);
    }

    @Override
    public void add(int newdata) {
        this.add(newdata, 32);
    }

    public void add(int newdata, int bitsthatmatter) {
        this.sizeinbits += bitsthatmatter;
        if (newdata == 0) {
            this.addEmptyWord(false);
        } else if (newdata == -1) {
            this.addEmptyWord(true);
        } else {
            this.addLiteralWord(newdata);
        }
    }

    private int addEmptyWord(boolean v) {
        boolean noliteralword = this.rlw.getNumberOfLiteralWords() == 0;
        int runlen = this.rlw.getRunningLength();
        if (noliteralword && runlen == 0) {
            this.rlw.setRunningBit(v);
        }
        if (noliteralword && this.rlw.getRunningBit() == v && runlen < 65535) {
            this.rlw.setRunningLength(runlen + 1);
            return 0;
        }
        this.push_back(0);
        this.rlw.position = this.actualsizeinwords - 1;
        this.rlw.setRunningBit(v);
        this.rlw.setRunningLength(1);
        return 1;
    }

    private int addLiteralWord(int newdata) {
        int numbersofar = this.rlw.getNumberOfLiteralWords();
        if (numbersofar >= Short.MAX_VALUE) {
            this.push_back(0);
            this.rlw.position = this.actualsizeinwords - 1;
            this.rlw.setNumberOfLiteralWords(1);
            this.push_back(newdata);
            return 2;
        }
        this.rlw.setNumberOfLiteralWords(numbersofar + 1);
        this.push_back(newdata);
        return 1;
    }

    @Override
    public void addStreamOfLiteralWords(int[] data, int start2, int number2) {
        int leftovernumber = number2;
        while (leftovernumber > 0) {
            int NumberOfLiteralWords = this.rlw.getNumberOfLiteralWords();
            int whatwecanadd = leftovernumber < Short.MAX_VALUE - NumberOfLiteralWords ? leftovernumber : Short.MAX_VALUE - NumberOfLiteralWords;
            this.rlw.setNumberOfLiteralWords(NumberOfLiteralWords + whatwecanadd);
            this.push_back(data, start2, whatwecanadd);
            this.sizeinbits += whatwecanadd * 32;
            if ((leftovernumber -= whatwecanadd) <= 0) continue;
            this.push_back(0);
            this.rlw.position = this.actualsizeinwords - 1;
        }
    }

    @Override
    public void addStreamOfEmptyWords(boolean v, int number2) {
        if (number2 == 0) {
            return;
        }
        this.sizeinbits += number2 * 32;
        if (this.rlw.getRunningBit() != v && this.rlw.size() == 0) {
            this.rlw.setRunningBit(v);
        } else if (this.rlw.getNumberOfLiteralWords() != 0 || this.rlw.getRunningBit() != v) {
            this.push_back(0);
            this.rlw.position = this.actualsizeinwords - 1;
            if (v) {
                this.rlw.setRunningBit(v);
            }
        }
        int runlen = this.rlw.getRunningLength();
        int whatwecanadd = number2 < 65535 - runlen ? number2 : 65535 - runlen;
        this.rlw.setRunningLength(runlen + whatwecanadd);
        number2 -= whatwecanadd;
        while (number2 >= 65535) {
            this.push_back(0);
            this.rlw.position = this.actualsizeinwords - 1;
            if (v) {
                this.rlw.setRunningBit(v);
            }
            this.rlw.setRunningLength(65535);
            number2 -= 65535;
        }
        if (number2 > 0) {
            this.push_back(0);
            this.rlw.position = this.actualsizeinwords - 1;
            if (v) {
                this.rlw.setRunningBit(v);
            }
            this.rlw.setRunningLength(number2);
        }
    }

    @Override
    public void addStreamOfNegatedLiteralWords(int[] data, int start2, int number2) {
        int leftovernumber = number2;
        while (leftovernumber > 0) {
            int NumberOfLiteralWords = this.rlw.getNumberOfLiteralWords();
            int whatwecanadd = leftovernumber < Short.MAX_VALUE - NumberOfLiteralWords ? leftovernumber : Short.MAX_VALUE - NumberOfLiteralWords;
            this.rlw.setNumberOfLiteralWords(NumberOfLiteralWords + whatwecanadd);
            this.negative_push_back(data, start2, whatwecanadd);
            this.sizeinbits += whatwecanadd * 32;
            if ((leftovernumber -= whatwecanadd) <= 0) continue;
            this.push_back(0);
            this.rlw.position = this.actualsizeinwords - 1;
        }
    }

    @Override
    public EWAHCompressedBitmap32 and(EWAHCompressedBitmap32 a) {
        EWAHCompressedBitmap32 container = new EWAHCompressedBitmap32();
        container.reserve(this.actualsizeinwords > a.actualsizeinwords ? this.actualsizeinwords : a.actualsizeinwords);
        this.andToContainer(a, container);
        return container;
    }

    public void andToContainer(EWAHCompressedBitmap32 a, BitmapStorage32 container) {
        EWAHIterator32 i = a.getEWAHIterator();
        EWAHIterator32 j = this.getEWAHIterator();
        IteratingBufferedRunningLengthWord32 rlwi = new IteratingBufferedRunningLengthWord32(i);
        IteratingBufferedRunningLengthWord32 rlwj = new IteratingBufferedRunningLengthWord32(j);
        while (rlwi.size() > 0 && rlwj.size() > 0) {
            while (rlwi.getRunningLength() > 0 || rlwj.getRunningLength() > 0) {
                IteratingBufferedRunningLengthWord32 predator;
                boolean i_is_prey = rlwi.getRunningLength() < rlwj.getRunningLength();
                IteratingBufferedRunningLengthWord32 prey = i_is_prey ? rlwi : rlwj;
                IteratingBufferedRunningLengthWord32 iteratingBufferedRunningLengthWord32 = predator = i_is_prey ? rlwj : rlwi;
                if (!predator.getRunningBit()) {
                    container.addStreamOfEmptyWords(false, predator.getRunningLength());
                    prey.discardFirstWords(predator.getRunningLength());
                    predator.discardFirstWords(predator.getRunningLength());
                    continue;
                }
                int index2 = prey.discharge(container, predator.getRunningLength());
                container.addStreamOfEmptyWords(false, predator.getRunningLength() - index2);
                predator.discardFirstWords(predator.getRunningLength());
            }
            int nbre_literal = Math.min(rlwi.getNumberOfLiteralWords(), rlwj.getNumberOfLiteralWords());
            if (nbre_literal <= 0) continue;
            for (int k = 0; k < nbre_literal; ++k) {
                container.add(rlwi.getLiteralWordAt(k) & rlwj.getLiteralWordAt(k));
            }
            rlwi.discardFirstWords(nbre_literal);
            rlwj.discardFirstWords(nbre_literal);
        }
        boolean i_remains = rlwi.size() > 0;
        IteratingBufferedRunningLengthWord32 remaining = i_remains ? rlwi : rlwj;
        remaining.dischargeAsEmpty(container);
        container.setSizeInBits(Math.max(this.sizeInBits(), a.sizeInBits()));
    }

    public int andCardinality(EWAHCompressedBitmap32 a) {
        BitCounter32 counter = new BitCounter32();
        this.andToContainer(a, counter);
        return counter.getCount();
    }

    @Override
    public EWAHCompressedBitmap32 andNot(EWAHCompressedBitmap32 a) {
        EWAHCompressedBitmap32 container = new EWAHCompressedBitmap32();
        container.reserve(this.actualsizeinwords > a.actualsizeinwords ? this.actualsizeinwords : a.actualsizeinwords);
        this.andNotToContainer(a, container);
        return container;
    }

    public void andNotToContainer(EWAHCompressedBitmap32 a, BitmapStorage32 container) {
        IteratingBufferedRunningLengthWord32 remaining;
        EWAHIterator32 i = this.getEWAHIterator();
        EWAHIterator32 j = a.getEWAHIterator();
        IteratingBufferedRunningLengthWord32 rlwi = new IteratingBufferedRunningLengthWord32(i);
        IteratingBufferedRunningLengthWord32 rlwj = new IteratingBufferedRunningLengthWord32(j);
        while (rlwi.size() > 0 && rlwj.size() > 0) {
            while (rlwi.getRunningLength() > 0 || rlwj.getRunningLength() > 0) {
                int index2;
                IteratingBufferedRunningLengthWord32 predator;
                boolean i_is_prey = rlwi.getRunningLength() < rlwj.getRunningLength();
                IteratingBufferedRunningLengthWord32 prey = i_is_prey ? rlwi : rlwj;
                IteratingBufferedRunningLengthWord32 iteratingBufferedRunningLengthWord32 = predator = i_is_prey ? rlwj : rlwi;
                if (predator.getRunningBit() && i_is_prey || !predator.getRunningBit() && !i_is_prey) {
                    container.addStreamOfEmptyWords(false, predator.getRunningLength());
                    prey.discardFirstWords(predator.getRunningLength());
                    predator.discardFirstWords(predator.getRunningLength());
                    continue;
                }
                if (i_is_prey) {
                    index2 = prey.discharge(container, predator.getRunningLength());
                    container.addStreamOfEmptyWords(false, predator.getRunningLength() - index2);
                    predator.discardFirstWords(predator.getRunningLength());
                    continue;
                }
                index2 = prey.dischargeNegated(container, predator.getRunningLength());
                container.addStreamOfEmptyWords(true, predator.getRunningLength() - index2);
                predator.discardFirstWords(predator.getRunningLength());
            }
            int nbre_literal = Math.min(rlwi.getNumberOfLiteralWords(), rlwj.getNumberOfLiteralWords());
            if (nbre_literal <= 0) continue;
            for (int k = 0; k < nbre_literal; ++k) {
                container.add(rlwi.getLiteralWordAt(k) & ~rlwj.getLiteralWordAt(k));
            }
            rlwi.discardFirstWords(nbre_literal);
            rlwj.discardFirstWords(nbre_literal);
        }
        boolean i_remains = rlwi.size() > 0;
        IteratingBufferedRunningLengthWord32 iteratingBufferedRunningLengthWord32 = remaining = i_remains ? rlwi : rlwj;
        if (i_remains) {
            remaining.discharge(container);
        } else {
            remaining.dischargeAsEmpty(container);
        }
        container.setSizeInBits(Math.max(this.sizeInBits(), a.sizeInBits()));
    }

    public int andNotCardinality(EWAHCompressedBitmap32 a) {
        BitCounter32 counter = new BitCounter32();
        this.andNotToContainer(a, counter);
        return counter.getCount();
    }

    public int cardinality() {
        int counter = 0;
        EWAHIterator32 i = new EWAHIterator32(this, this.actualsizeinwords);
        while (i.hasNext()) {
            RunningLengthWord32 localrlw = i.next();
            if (localrlw.getRunningBit()) {
                counter += 32 * localrlw.getRunningLength();
            }
            for (int j = 0; j < localrlw.getNumberOfLiteralWords(); ++j) {
                counter += Integer.bitCount(i.buffer()[i.literalWords() + j]);
            }
        }
        return counter;
    }

    public void clear() {
        this.sizeinbits = 0;
        this.actualsizeinwords = 1;
        this.rlw.position = 0;
        this.buffer[0] = 0;
    }

    public EWAHCompressedBitmap32 clone() throws CloneNotSupportedException {
        EWAHCompressedBitmap32 clone2 = (EWAHCompressedBitmap32)super.clone();
        clone2.buffer = (int[])this.buffer.clone();
        clone2.actualsizeinwords = this.actualsizeinwords;
        clone2.sizeinbits = this.sizeinbits;
        return clone2;
    }

    public void deserialize(DataInput in) throws IOException {
        this.sizeinbits = in.readInt();
        this.actualsizeinwords = in.readInt();
        if (this.buffer.length < this.actualsizeinwords) {
            this.buffer = new int[this.actualsizeinwords];
        }
        for (int k = 0; k < this.actualsizeinwords; ++k) {
            this.buffer[k] = in.readInt();
        }
        this.rlw = new RunningLengthWord32(this, in.readInt());
    }

    public boolean equals(Object o) {
        if (o instanceof EWAHCompressedBitmap32) {
            try {
                this.xorToContainer((EWAHCompressedBitmap32)o, new NonEmptyVirtualStorage32());
                return true;
            }
            catch (NonEmptyVirtualStorage32.NonEmptyException e) {
                return false;
            }
        }
        return false;
    }

    private void fastaddStreamOfEmptyWords(boolean v, int number2) {
        if (this.rlw.getRunningBit() != v && this.rlw.size() == 0) {
            this.rlw.setRunningBit(v);
        } else if (this.rlw.getNumberOfLiteralWords() != 0 || this.rlw.getRunningBit() != v) {
            this.push_back(0);
            this.rlw.position = this.actualsizeinwords - 1;
            if (v) {
                this.rlw.setRunningBit(v);
            }
        }
        int runlen = this.rlw.getRunningLength();
        int whatwecanadd = number2 < 65535 - runlen ? number2 : 65535 - runlen;
        this.rlw.setRunningLength(runlen + whatwecanadd);
        number2 -= whatwecanadd;
        while (number2 >= 65535) {
            this.push_back(0);
            this.rlw.position = this.actualsizeinwords - 1;
            if (v) {
                this.rlw.setRunningBit(v);
            }
            this.rlw.setRunningLength(65535);
            number2 -= 65535;
        }
        if (number2 > 0) {
            this.push_back(0);
            this.rlw.position = this.actualsizeinwords - 1;
            if (v) {
                this.rlw.setRunningBit(v);
            }
            this.rlw.setRunningLength(number2);
        }
    }

    public EWAHIterator32 getEWAHIterator() {
        return new EWAHIterator32(this, this.actualsizeinwords);
    }

    public IteratingRLW32 getIteratingRLW() {
        return new IteratingBufferedRunningLengthWord32(this);
    }

    public List<Integer> getPositions() {
        ArrayList<Integer> v = new ArrayList<Integer>();
        EWAHIterator32 i = new EWAHIterator32(this, this.actualsizeinwords);
        int pos = 0;
        while (i.hasNext()) {
            int j;
            RunningLengthWord32 localrlw = i.next();
            if (localrlw.getRunningBit()) {
                for (j = 0; j < localrlw.getRunningLength(); ++j) {
                    for (int c = 0; c < 32; ++c) {
                        v.add(new Integer(pos++));
                    }
                }
            } else {
                pos += 32 * localrlw.getRunningLength();
            }
            for (j = 0; j < localrlw.getNumberOfLiteralWords(); ++j) {
                int ntz;
                for (int data = i.buffer()[i.literalWords() + j]; data != 0; data ^= 1 << ntz) {
                    ntz = Integer.numberOfTrailingZeros(data);
                    v.add(new Integer(ntz + pos));
                }
                pos += 32;
            }
        }
        while (v.size() > 0 && v.get(v.size() - 1) >= this.sizeinbits) {
            v.remove(v.size() - 1);
        }
        return v;
    }

    public int hashCode() {
        int karprabin = 0;
        int B = 31;
        EWAHIterator32 i = new EWAHIterator32(this, this.actualsizeinwords);
        while (i.hasNext()) {
            i.next();
            if (i.rlw.getRunningBit()) {
                karprabin += 31 * karprabin + i.rlw.getRunningLength();
            }
            for (int k = 0; k < i.rlw.getNumberOfLiteralWords(); ++k) {
                karprabin += 31 * karprabin + this.buffer[k + i.literalWords()];
            }
        }
        return karprabin;
    }

    public boolean intersects(EWAHCompressedBitmap32 a) {
        NonEmptyVirtualStorage32 nevs = new NonEmptyVirtualStorage32();
        try {
            this.andToContainer(a, nevs);
        }
        catch (NonEmptyVirtualStorage32.NonEmptyException nee) {
            return true;
        }
        return false;
    }

    public IntIterator intIterator() {
        return new IntIteratorImpl32(new EWAHIterator32(this, this.actualsizeinwords));
    }

    @Override
    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(){
            private final IntIterator under;
            {
                this.under = EWAHCompressedBitmap32.this.intIterator();
            }

            @Override
            public boolean hasNext() {
                return this.under.hasNext();
            }

            @Override
            public Integer next() {
                return new Integer(this.under.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("bitsets do not support remove");
            }
        };
    }

    private void negative_push_back(int[] data, int start2, int number2) {
        while (this.actualsizeinwords + number2 >= this.buffer.length) {
            int[] oldbuffer = this.buffer;
            this.buffer = this.actualsizeinwords + number2 < 32768 ? new int[(this.actualsizeinwords + number2) * 2] : ((this.actualsizeinwords + number2) * 3 / 2 < this.actualsizeinwords + number2 ? new int[Integer.MAX_VALUE] : new int[(this.actualsizeinwords + number2) * 3 / 2]);
            System.arraycopy(oldbuffer, 0, this.buffer, 0, oldbuffer.length);
            this.rlw.parent.buffer = this.buffer;
        }
        for (int k = 0; k < number2; ++k) {
            this.buffer[this.actualsizeinwords + k] = ~data[start2 + k];
        }
        this.actualsizeinwords += number2;
    }

    @Override
    public void not() {
        RunningLengthWord32 rlw1;
        EWAHIterator32 i = new EWAHIterator32(this, this.actualsizeinwords);
        if (!i.hasNext()) {
            return;
        }
        do {
            rlw1.setRunningBit(!(rlw1 = i.next()).getRunningBit());
            for (int j = 0; j < rlw1.getNumberOfLiteralWords(); ++j) {
                i.buffer()[i.literalWords() + j] = ~i.buffer()[i.literalWords() + j];
            }
        } while (i.hasNext());
        int usedbitsinlast = this.sizeinbits % 32;
        if (usedbitsinlast == 0) {
            return;
        }
        if (rlw1.getNumberOfLiteralWords() == 0) {
            if (rlw1.getRunningLength() > 0 && rlw1.getRunningBit()) {
                rlw1.setRunningLength(rlw1.getRunningLength() - 1);
                this.addLiteralWord(-1 >>> 32 - usedbitsinlast);
            }
            return;
        }
        int[] nArray = i.buffer();
        int n = i.literalWords() + rlw1.getNumberOfLiteralWords() - 1;
        nArray[n] = nArray[n] & -1 >>> 32 - usedbitsinlast;
    }

    public EWAHCompressedBitmap32 or(EWAHCompressedBitmap32 a) {
        EWAHCompressedBitmap32 container = new EWAHCompressedBitmap32();
        container.reserve(this.actualsizeinwords + a.actualsizeinwords);
        this.orToContainer(a, container);
        return container;
    }

    public void orToContainer(EWAHCompressedBitmap32 a, BitmapStorage32 container) {
        EWAHIterator32 i = a.getEWAHIterator();
        EWAHIterator32 j = this.getEWAHIterator();
        IteratingBufferedRunningLengthWord32 rlwi = new IteratingBufferedRunningLengthWord32(i);
        IteratingBufferedRunningLengthWord32 rlwj = new IteratingBufferedRunningLengthWord32(j);
        while (rlwi.size() > 0 && rlwj.size() > 0) {
            while (rlwi.getRunningLength() > 0 || rlwj.getRunningLength() > 0) {
                IteratingBufferedRunningLengthWord32 predator;
                boolean i_is_prey = rlwi.getRunningLength() < rlwj.getRunningLength();
                IteratingBufferedRunningLengthWord32 prey = i_is_prey ? rlwi : rlwj;
                IteratingBufferedRunningLengthWord32 iteratingBufferedRunningLengthWord32 = predator = i_is_prey ? rlwj : rlwi;
                if (predator.getRunningBit()) {
                    container.addStreamOfEmptyWords(true, predator.getRunningLength());
                    prey.discardFirstWords(predator.getRunningLength());
                    predator.discardFirstWords(predator.getRunningLength());
                    continue;
                }
                int index2 = prey.discharge(container, predator.getRunningLength());
                container.addStreamOfEmptyWords(false, predator.getRunningLength() - index2);
                predator.discardFirstWords(predator.getRunningLength());
            }
            int nbre_literal = Math.min(rlwi.getNumberOfLiteralWords(), rlwj.getNumberOfLiteralWords());
            if (nbre_literal <= 0) continue;
            for (int k = 0; k < nbre_literal; ++k) {
                container.add(rlwi.getLiteralWordAt(k) | rlwj.getLiteralWordAt(k));
            }
            rlwi.discardFirstWords(nbre_literal);
            rlwj.discardFirstWords(nbre_literal);
        }
        boolean i_remains = rlwi.size() > 0;
        IteratingBufferedRunningLengthWord32 remaining = i_remains ? rlwi : rlwj;
        remaining.discharge(container);
        container.setSizeInBits(Math.max(this.sizeInBits(), a.sizeInBits()));
    }

    public int orCardinality(EWAHCompressedBitmap32 a) {
        BitCounter32 counter = new BitCounter32();
        this.orToContainer(a, counter);
        return counter.getCount();
    }

    private void push_back(int data) {
        if (this.actualsizeinwords == this.buffer.length) {
            int[] oldbuffer = this.buffer;
            this.buffer = oldbuffer.length < 32768 ? new int[oldbuffer.length * 2] : (oldbuffer.length * 3 / 2 < oldbuffer.length ? new int[Integer.MAX_VALUE] : new int[oldbuffer.length * 3 / 2]);
            System.arraycopy(oldbuffer, 0, this.buffer, 0, oldbuffer.length);
            this.rlw.parent.buffer = this.buffer;
        }
        this.buffer[this.actualsizeinwords++] = data;
    }

    private void push_back(int[] data, int start2, int number2) {
        if (this.actualsizeinwords + number2 >= this.buffer.length) {
            int[] oldbuffer = this.buffer;
            this.buffer = this.actualsizeinwords + number2 < 32768 ? new int[(this.actualsizeinwords + number2) * 2] : ((this.actualsizeinwords + number2) * 3 / 2 < this.actualsizeinwords + number2 ? new int[Integer.MAX_VALUE] : new int[(this.actualsizeinwords + number2) * 3 / 2]);
            System.arraycopy(oldbuffer, 0, this.buffer, 0, oldbuffer.length);
            this.rlw.parent.buffer = this.buffer;
        }
        System.arraycopy(data, start2, this.buffer, this.actualsizeinwords, number2);
        this.actualsizeinwords += number2;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.deserialize(in);
    }

    private boolean reserve(int size2) {
        if (size2 > this.buffer.length) {
            int[] oldbuffer = this.buffer;
            this.buffer = new int[size2];
            System.arraycopy(oldbuffer, 0, this.buffer, 0, oldbuffer.length);
            this.rlw.parent.buffer = this.buffer;
            return true;
        }
        return false;
    }

    public void serialize(DataOutput out) throws IOException {
        out.writeInt(this.sizeinbits);
        out.writeInt(this.actualsizeinwords);
        for (int k = 0; k < this.actualsizeinwords; ++k) {
            out.writeInt(this.buffer[k]);
        }
        out.writeInt(this.rlw.position);
    }

    public int serializedSizeInBytes() {
        return this.sizeInBytes() + 12;
    }

    public boolean get(int i) {
        if (i < 0 || i >= this.sizeinbits) {
            return false;
        }
        IteratingRLW32 j = this.getIteratingRLW();
        int wordi = i / 32;
        for (int WordChecked = 0; WordChecked <= wordi; WordChecked += j.getNumberOfLiteralWords()) {
            if (wordi < (WordChecked += j.getRunningLength())) {
                return j.getRunningBit();
            }
            if (wordi < WordChecked + j.getNumberOfLiteralWords()) {
                int w = j.getLiteralWordAt(wordi - WordChecked);
                return (w & 1 << i) != 0;
            }
            j.next();
        }
        return false;
    }

    public boolean set(int i) {
        if (i > 0x7FFFFFDF || i < 0) {
            throw new IndexOutOfBoundsException("Set values should be between 0 and 2147483615");
        }
        if (i < this.sizeinbits) {
            return false;
        }
        int dist = (i + 32) / 32 - (this.sizeinbits + 32 - 1) / 32;
        this.sizeinbits = i + 1;
        if (dist > 0) {
            if (dist > 1) {
                this.fastaddStreamOfEmptyWords(false, dist - 1);
            }
            this.addLiteralWord(1 << i % 32);
            return true;
        }
        if (this.rlw.getNumberOfLiteralWords() == 0) {
            this.rlw.setRunningLength(this.rlw.getRunningLength() - 1);
            this.addLiteralWord(1 << i % 32);
            return true;
        }
        int n = this.actualsizeinwords - 1;
        this.buffer[n] = this.buffer[n] | 1 << i % 32;
        if (this.buffer[this.actualsizeinwords - 1] == -1) {
            this.buffer[this.actualsizeinwords - 1] = 0;
            --this.actualsizeinwords;
            this.rlw.setNumberOfLiteralWords(this.rlw.getNumberOfLiteralWords() - 1);
            this.addEmptyWord(true);
        }
        return true;
    }

    @Override
    public void setSizeInBits(int size2) {
        if ((size2 + 32 - 1) / 32 != (this.sizeinbits + 32 - 1) / 32) {
            throw new RuntimeException("You can only reduce the size of the bitmap within the scope of the last word. To extend the bitmap, please call setSizeInbits(int,boolean): " + size2 + " " + this.sizeinbits);
        }
        this.sizeinbits = size2;
    }

    public boolean setSizeInBits(int size2, boolean defaultvalue) {
        if (size2 < this.sizeinbits) {
            return false;
        }
        if (!defaultvalue) {
            EWAHCompressedBitmap32.extendEmptyBits(this, this.sizeinbits, size2);
        } else {
            while (this.sizeinbits % 32 != 0 && this.sizeinbits < size2) {
                this.set(this.sizeinbits);
            }
            this.addStreamOfEmptyWords(defaultvalue, size2 / 32 - this.sizeinbits / 32);
            while (this.sizeinbits < size2) {
                this.set(this.sizeinbits);
            }
        }
        this.sizeinbits = size2;
        return true;
    }

    @Override
    public int sizeInBits() {
        return this.sizeinbits;
    }

    @Override
    public int sizeInBytes() {
        return this.actualsizeinwords * 4;
    }

    public int[] toArray() {
        int[] ans = new int[this.cardinality()];
        int inanspos = 0;
        int pos = 0;
        EWAHIterator32 i = new EWAHIterator32(this, this.actualsizeinwords);
        while (i.hasNext()) {
            int j;
            RunningLengthWord32 localrlw = i.next();
            if (localrlw.getRunningBit()) {
                for (j = 0; j < localrlw.getRunningLength(); ++j) {
                    for (int c = 0; c < 32; ++c) {
                        ans[inanspos++] = pos++;
                    }
                }
            } else {
                pos += 32 * localrlw.getRunningLength();
            }
            for (j = 0; j < localrlw.getNumberOfLiteralWords(); ++j) {
                int data = i.buffer()[i.literalWords() + j];
                while (data != 0) {
                    int ntz = Integer.numberOfTrailingZeros(data);
                    data = (int)((long)data ^ 1L << ntz);
                    ans[inanspos++] = ntz + pos;
                }
                pos += 32;
            }
        }
        return ans;
    }

    public String toDebugString() {
        String ans = " EWAHCompressedBitmap, size in bits = " + this.sizeinbits + " size in words = " + this.actualsizeinwords + "\n";
        EWAHIterator32 i = new EWAHIterator32(this, this.actualsizeinwords);
        while (i.hasNext()) {
            RunningLengthWord32 localrlw = i.next();
            ans = localrlw.getRunningBit() ? ans + localrlw.getRunningLength() + " 1x11\n" : ans + localrlw.getRunningLength() + " 0x00\n";
            ans = ans + localrlw.getNumberOfLiteralWords() + " dirties\n";
            for (int j = 0; j < localrlw.getNumberOfLiteralWords(); ++j) {
                int data = i.buffer()[i.literalWords() + j];
                ans = ans + "\t" + data + "\n";
            }
        }
        return ans;
    }

    public String toString() {
        StringBuffer answer = new StringBuffer();
        IntIterator i = this.intIterator();
        answer.append("{");
        if (i.hasNext()) {
            answer.append(i.next());
        }
        while (i.hasNext()) {
            answer.append(",");
            answer.append(i.next());
        }
        answer.append("}");
        return answer.toString();
    }

    public void swap(EWAHCompressedBitmap32 other) {
        int[] tmp = this.buffer;
        this.buffer = other.buffer;
        other.buffer = tmp;
        int tmp2 = this.rlw.position;
        this.rlw.position = other.rlw.position;
        other.rlw.position = tmp2;
        int tmp3 = this.actualsizeinwords;
        this.actualsizeinwords = other.actualsizeinwords;
        other.actualsizeinwords = tmp3;
        int tmp4 = this.sizeinbits;
        this.sizeinbits = other.sizeinbits;
        other.sizeinbits = tmp4;
    }

    public void trim() {
        this.buffer = Arrays.copyOf(this.buffer, this.actualsizeinwords);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.serialize(out);
    }

    @Override
    public EWAHCompressedBitmap32 xor(EWAHCompressedBitmap32 a) {
        EWAHCompressedBitmap32 container = new EWAHCompressedBitmap32();
        container.reserve(this.actualsizeinwords + a.actualsizeinwords);
        this.xorToContainer(a, container);
        return container;
    }

    public void xorToContainer(EWAHCompressedBitmap32 a, BitmapStorage32 container) {
        EWAHIterator32 i = a.getEWAHIterator();
        EWAHIterator32 j = this.getEWAHIterator();
        IteratingBufferedRunningLengthWord32 rlwi = new IteratingBufferedRunningLengthWord32(i);
        IteratingBufferedRunningLengthWord32 rlwj = new IteratingBufferedRunningLengthWord32(j);
        while (rlwi.size() > 0 && rlwj.size() > 0) {
            while (rlwi.getRunningLength() > 0 || rlwj.getRunningLength() > 0) {
                int index2;
                IteratingBufferedRunningLengthWord32 predator;
                boolean i_is_prey = rlwi.getRunningLength() < rlwj.getRunningLength();
                IteratingBufferedRunningLengthWord32 prey = i_is_prey ? rlwi : rlwj;
                IteratingBufferedRunningLengthWord32 iteratingBufferedRunningLengthWord32 = predator = i_is_prey ? rlwj : rlwi;
                if (!predator.getRunningBit()) {
                    index2 = prey.discharge(container, predator.getRunningLength());
                    container.addStreamOfEmptyWords(false, predator.getRunningLength() - index2);
                    predator.discardFirstWords(predator.getRunningLength());
                    continue;
                }
                index2 = prey.dischargeNegated(container, predator.getRunningLength());
                container.addStreamOfEmptyWords(true, predator.getRunningLength() - index2);
                predator.discardFirstWords(predator.getRunningLength());
            }
            int nbre_literal = Math.min(rlwi.getNumberOfLiteralWords(), rlwj.getNumberOfLiteralWords());
            if (nbre_literal <= 0) continue;
            for (int k = 0; k < nbre_literal; ++k) {
                container.add(rlwi.getLiteralWordAt(k) ^ rlwj.getLiteralWordAt(k));
            }
            rlwi.discardFirstWords(nbre_literal);
            rlwj.discardFirstWords(nbre_literal);
        }
        boolean i_remains = rlwi.size() > 0;
        IteratingBufferedRunningLengthWord32 remaining = i_remains ? rlwi : rlwj;
        remaining.discharge(container);
        container.setSizeInBits(Math.max(this.sizeInBits(), a.sizeInBits()));
    }

    public int xorCardinality(EWAHCompressedBitmap32 a) {
        BitCounter32 counter = new BitCounter32();
        this.xorToContainer(a, counter);
        return counter.getCount();
    }

    public static void andWithContainer(BitmapStorage32 container, EWAHCompressedBitmap32 ... bitmaps) {
        if (bitmaps.length == 1) {
            throw new IllegalArgumentException("Need at least one bitmap");
        }
        if (bitmaps.length == 2) {
            bitmaps[0].andToContainer(bitmaps[1], container);
            return;
        }
        EWAHCompressedBitmap32 answer = new EWAHCompressedBitmap32();
        EWAHCompressedBitmap32 tmp = new EWAHCompressedBitmap32();
        bitmaps[0].andToContainer(bitmaps[1], answer);
        for (int k = 2; k < bitmaps.length - 1; ++k) {
            answer.andToContainer(bitmaps[k], tmp);
            tmp.swap(answer);
            tmp.clear();
        }
        answer.andToContainer(bitmaps[bitmaps.length - 1], container);
    }

    public static EWAHCompressedBitmap32 and(EWAHCompressedBitmap32 ... bitmaps) {
        if (bitmaps.length == 1) {
            return bitmaps[0];
        }
        if (bitmaps.length == 2) {
            return bitmaps[0].and(bitmaps[1]);
        }
        EWAHCompressedBitmap32 answer = new EWAHCompressedBitmap32();
        EWAHCompressedBitmap32 tmp = new EWAHCompressedBitmap32();
        bitmaps[0].andToContainer(bitmaps[1], answer);
        for (int k = 2; k < bitmaps.length; ++k) {
            answer.andToContainer(bitmaps[k], tmp);
            tmp.swap(answer);
            tmp.clear();
        }
        return answer;
    }

    public static int andCardinality(EWAHCompressedBitmap32 ... bitmaps) {
        if (bitmaps.length == 1) {
            return bitmaps[0].cardinality();
        }
        BitCounter32 counter = new BitCounter32();
        EWAHCompressedBitmap32.andWithContainer(counter, bitmaps);
        return counter.getCount();
    }

    public static EWAHCompressedBitmap32 bitmapOf(int ... setbits) {
        EWAHCompressedBitmap32 a = new EWAHCompressedBitmap32();
        for (int k : setbits) {
            a.set(k);
        }
        return a;
    }

    private static void extendEmptyBits(BitmapStorage32 storage, int currentSize, int newSize) {
        int currentLeftover = currentSize % 32;
        int finalLeftover = newSize % 32;
        storage.addStreamOfEmptyWords(false, newSize / 32 - currentSize / 32 + (finalLeftover != 0 ? 1 : 0) + (currentLeftover != 0 ? -1 : 0));
    }

    public static void orWithContainer(BitmapStorage32 container, EWAHCompressedBitmap32 ... bitmaps) {
        if (bitmaps.length < 2) {
            throw new IllegalArgumentException("You should provide at least two bitmaps, provided " + bitmaps.length);
        }
        int size2 = 0;
        int sinbits = 0;
        for (EWAHCompressedBitmap32 b : bitmaps) {
            size2 += b.sizeInBytes();
            if (sinbits >= b.sizeInBits()) continue;
            sinbits = b.sizeInBits();
        }
        if (size2 * 8 > sinbits) {
            FastAggregation32.bufferedorWithContainer(container, 65536, bitmaps);
        } else {
            FastAggregation32.orToContainer(container, bitmaps);
        }
    }

    public static void xorWithContainer(BitmapStorage32 container, EWAHCompressedBitmap32 ... bitmaps) {
        if (bitmaps.length < 2) {
            throw new IllegalArgumentException("You should provide at least two bitmaps, provided " + bitmaps.length);
        }
        int size2 = 0;
        int sinbits = 0;
        for (EWAHCompressedBitmap32 b : bitmaps) {
            size2 += b.sizeInBytes();
            if (sinbits >= b.sizeInBits()) continue;
            sinbits = b.sizeInBits();
        }
        if (size2 * 8 > sinbits) {
            FastAggregation32.bufferedxorWithContainer(container, 65536, bitmaps);
        } else {
            FastAggregation32.xorToContainer(container, bitmaps);
        }
    }

    public static EWAHCompressedBitmap32 or(EWAHCompressedBitmap32 ... bitmaps) {
        if (bitmaps.length == 1) {
            return bitmaps[0];
        }
        EWAHCompressedBitmap32 container = new EWAHCompressedBitmap32();
        int largestSize = 0;
        for (EWAHCompressedBitmap32 bitmap : bitmaps) {
            largestSize = Math.max(bitmap.actualsizeinwords, largestSize);
        }
        container.reserve((int)((double)largestSize * 1.5));
        EWAHCompressedBitmap32.orWithContainer(container, bitmaps);
        return container;
    }

    public static EWAHCompressedBitmap32 xor(EWAHCompressedBitmap32 ... bitmaps) {
        if (bitmaps.length == 1) {
            return bitmaps[0];
        }
        EWAHCompressedBitmap32 container = new EWAHCompressedBitmap32();
        int largestSize = 0;
        for (EWAHCompressedBitmap32 bitmap : bitmaps) {
            largestSize = Math.max(bitmap.actualsizeinwords, largestSize);
        }
        container.reserve((int)((double)largestSize * 1.5));
        EWAHCompressedBitmap32.xorWithContainer(container, bitmaps);
        return container;
    }

    public static int orCardinality(EWAHCompressedBitmap32 ... bitmaps) {
        if (bitmaps.length == 1) {
            return bitmaps[0].cardinality();
        }
        BitCounter32 counter = new BitCounter32();
        EWAHCompressedBitmap32.orWithContainer(counter, bitmaps);
        return counter.getCount();
    }
}

