/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.HASH;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.Util;

public abstract class KeyExchange {
    static final int PROPOSAL_KEX_ALGS = 0;
    static final int PROPOSAL_SERVER_HOST_KEY_ALGS = 1;
    static final int PROPOSAL_ENC_ALGS_CTOS = 2;
    static final int PROPOSAL_ENC_ALGS_STOC = 3;
    static final int PROPOSAL_MAC_ALGS_CTOS = 4;
    static final int PROPOSAL_MAC_ALGS_STOC = 5;
    static final int PROPOSAL_COMP_ALGS_CTOS = 6;
    static final int PROPOSAL_COMP_ALGS_STOC = 7;
    static final int PROPOSAL_LANG_CTOS = 8;
    static final int PROPOSAL_LANG_STOC = 9;
    static final int PROPOSAL_MAX = 10;
    static String kex = "diffie-hellman-group1-sha1";
    static String server_host_key = "ssh-rsa,ssh-dss";
    static String enc_c2s = "blowfish-cbc";
    static String enc_s2c = "blowfish-cbc";
    static String mac_c2s = "hmac-md5";
    static String mac_s2c = "hmac-md5";
    static String lang_c2s = "";
    static String lang_s2c = "";
    public static final int STATE_END = 0;
    protected Session session = null;
    protected HASH sha = null;
    protected byte[] K = null;
    protected byte[] H = null;
    protected byte[] K_S = null;

    public abstract void init(Session var1, byte[] var2, byte[] var3, byte[] var4, byte[] var5) throws Exception;

    public abstract boolean next(Buffer var1) throws Exception;

    public abstract String getKeyType();

    public abstract int getState();

    protected static String[] guess(byte[] I_S, byte[] I_C) {
        int i;
        String[] guess = new String[10];
        Buffer sb = new Buffer(I_S);
        sb.setOffSet(17);
        Buffer cb = new Buffer(I_C);
        cb.setOffSet(17);
        if (JSch.getLogger().isEnabled(1)) {
            for (i = 0; i < 10; ++i) {
                JSch.getLogger().log(1, "kex: server: " + Util.byte2str(sb.getString()));
            }
            for (i = 0; i < 10; ++i) {
                JSch.getLogger().log(1, "kex: client: " + Util.byte2str(cb.getString()));
            }
            sb.setOffSet(17);
            cb.setOffSet(17);
        }
        for (i = 0; i < 10; ++i) {
            byte[] sp2 = sb.getString();
            byte[] cp = cb.getString();
            int j = 0;
            int k = 0;
            block3: while (j < cp.length) {
                while (j < cp.length && cp[j] != 44) {
                    ++j;
                }
                if (k == j) {
                    return null;
                }
                String algorithm2 = Util.byte2str(cp, k, j - k);
                int l = 0;
                int m = 0;
                while (l < sp2.length) {
                    while (l < sp2.length && sp2[l] != 44) {
                        ++l;
                    }
                    if (m == l) {
                        return null;
                    }
                    if (algorithm2.equals(Util.byte2str(sp2, m, l - m))) {
                        guess[i] = algorithm2;
                        break block3;
                    }
                    m = ++l;
                }
                k = ++j;
            }
            if (j == 0) {
                guess[i] = "";
                continue;
            }
            if (guess[i] != null) continue;
            return null;
        }
        if (JSch.getLogger().isEnabled(1)) {
            JSch.getLogger().log(1, "kex: server->client " + guess[3] + " " + guess[5] + " " + guess[7]);
            JSch.getLogger().log(1, "kex: client->server " + guess[2] + " " + guess[4] + " " + guess[6]);
        }
        return guess;
    }

    public String getFingerPrint() {
        HASH hash2 = null;
        try {
            Class<?> c = Class.forName(this.session.getConfig("md5"));
            hash2 = (HASH)c.newInstance();
        }
        catch (Exception e) {
            System.err.println("getFingerPrint: " + e);
        }
        return Util.getFingerPrint(hash2, this.getHostKey());
    }

    byte[] getK() {
        return this.K;
    }

    byte[] getH() {
        return this.H;
    }

    HASH getHash() {
        return this.sha;
    }

    byte[] getHostKey() {
        return this.K_S;
    }

    protected byte[] normalize(byte[] secret2) {
        if (secret2.length > 1 && secret2[0] == 0 && (secret2[1] & 0x80) == 0) {
            byte[] tmp = new byte[secret2.length - 1];
            System.arraycopy(secret2, 1, tmp, 0, tmp.length);
            secret2 = tmp;
        }
        return secret2;
    }
}

