/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client;

import com.ning.http.util.MiscUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FluentCaseInsensitiveStringsMap
implements Map<String, List<String>>,
Iterable<Map.Entry<String, List<String>>> {
    private final Map<String, List<String>> values = new LinkedHashMap<String, List<String>>();
    private final Map<String, String> keyLookup = new LinkedHashMap<String, String>();

    public FluentCaseInsensitiveStringsMap() {
    }

    public FluentCaseInsensitiveStringsMap(FluentCaseInsensitiveStringsMap src) {
        if (src != null) {
            for (Map.Entry<String, List<String>> header2 : src) {
                this.add(header2.getKey(), (Collection<String>)header2.getValue());
            }
        }
    }

    public FluentCaseInsensitiveStringsMap(Map<String, Collection<String>> src) {
        if (src != null) {
            for (Map.Entry<String, Collection<String>> header2 : src.entrySet()) {
                this.add(header2.getKey(), header2.getValue());
            }
        }
    }

    public FluentCaseInsensitiveStringsMap add(String key, String value2) {
        if (key != null) {
            String lcKey = key.toLowerCase(Locale.ENGLISH);
            String realKey = this.keyLookup.get(lcKey);
            List<String> curValues = null;
            if (realKey == null) {
                this.keyLookup.put(lcKey, key);
                curValues = new ArrayList<String>();
                this.values.put(key, curValues);
            } else {
                curValues = this.values.get(realKey);
            }
            String nonNullValue = value2 != null ? value2 : "";
            curValues.add(nonNullValue);
        }
        return this;
    }

    public FluentCaseInsensitiveStringsMap add(String key, String ... values2) {
        if (MiscUtil.isNonEmpty(values2)) {
            this.add(key, Arrays.asList(values2));
        }
        return this;
    }

    private List<String> fetchValues(Collection<String> values2) {
        ArrayList<String> result2 = null;
        if (values2 != null) {
            for (String value2 : values2) {
                if (value2 == null) {
                    value2 = "";
                }
                if (result2 == null) {
                    result2 = new ArrayList<String>();
                }
                result2.add(value2);
            }
        }
        return result2;
    }

    public FluentCaseInsensitiveStringsMap add(String key, Collection<String> values2) {
        List<String> nonNullValues;
        if (key != null && (nonNullValues = this.fetchValues(values2)) != null) {
            String lcKey = key.toLowerCase(Locale.ENGLISH);
            String realKey = this.keyLookup.get(lcKey);
            List<String> curValues = null;
            if (realKey == null) {
                realKey = key;
                this.keyLookup.put(lcKey, key);
            } else {
                curValues = this.values.get(realKey);
            }
            if (curValues == null) {
                curValues = new ArrayList<String>();
                this.values.put(realKey, curValues);
            }
            curValues.addAll(nonNullValues);
        }
        return this;
    }

    public FluentCaseInsensitiveStringsMap addAll(FluentCaseInsensitiveStringsMap src) {
        if (src != null) {
            for (Map.Entry<String, List<String>> header2 : src) {
                this.add(header2.getKey(), (Collection<String>)header2.getValue());
            }
        }
        return this;
    }

    public FluentCaseInsensitiveStringsMap addAll(Map<String, Collection<String>> src) {
        if (src != null) {
            for (Map.Entry<String, Collection<String>> header2 : src.entrySet()) {
                this.add(header2.getKey(), header2.getValue());
            }
        }
        return this;
    }

    @Override
    public FluentCaseInsensitiveStringsMap replace(String key, String ... values2) {
        return this.replace(key, (Collection<String>)Arrays.asList(values2));
    }

    @Override
    public FluentCaseInsensitiveStringsMap replace(String key, Collection<String> values2) {
        if (key != null) {
            List<String> nonNullValues = this.fetchValues(values2);
            String lcKkey = key.toLowerCase(Locale.ENGLISH);
            String realKey = this.keyLookup.get(lcKkey);
            if (nonNullValues == null) {
                this.keyLookup.remove(lcKkey);
                if (realKey != null) {
                    this.values.remove(realKey);
                }
            } else {
                if (!key.equals(realKey)) {
                    this.keyLookup.put(lcKkey, key);
                    this.values.remove(realKey);
                }
                this.values.put(key, nonNullValues);
            }
        }
        return this;
    }

    public FluentCaseInsensitiveStringsMap replaceAll(FluentCaseInsensitiveStringsMap src) {
        if (src != null) {
            for (Map.Entry<String, List<String>> header2 : src) {
                this.replace(header2.getKey(), (Collection<String>)header2.getValue());
            }
        }
        return this;
    }

    public FluentCaseInsensitiveStringsMap replaceAll(Map<? extends String, ? extends Collection<String>> src) {
        if (src != null) {
            for (Map.Entry<? extends String, ? extends Collection<String>> header2 : src.entrySet()) {
                this.replace(header2.getKey(), header2.getValue());
            }
        }
        return this;
    }

    @Override
    public List<String> put(String key, List<String> value2) {
        if (key == null) {
            throw new NullPointerException("Null keys are not allowed");
        }
        Object oldValue = this.get(key);
        this.replace(key, (Collection<String>)value2);
        return oldValue;
    }

    @Override
    public void putAll(Map<? extends String, ? extends List<String>> values2) {
        this.replaceAll(values2);
    }

    public FluentCaseInsensitiveStringsMap delete(String key) {
        String lcKey;
        String realKey;
        if (key != null && (realKey = this.keyLookup.remove(lcKey = key.toLowerCase(Locale.ENGLISH))) != null) {
            this.values.remove(realKey);
        }
        return this;
    }

    public FluentCaseInsensitiveStringsMap deleteAll(String ... keys2) {
        if (keys2 != null) {
            for (String key : keys2) {
                this.remove(key);
            }
        }
        return this;
    }

    public FluentCaseInsensitiveStringsMap deleteAll(Collection<String> keys2) {
        if (keys2 != null) {
            for (String key : keys2) {
                this.remove(key);
            }
        }
        return this;
    }

    @Override
    public List<String> remove(Object key) {
        if (key == null) {
            return null;
        }
        Object oldValues = this.get(key.toString());
        this.delete(key.toString());
        return oldValues;
    }

    @Override
    public void clear() {
        this.keyLookup.clear();
        this.values.clear();
    }

    @Override
    public Iterator<Map.Entry<String, List<String>>> iterator() {
        return Collections.unmodifiableSet(this.values.entrySet()).iterator();
    }

    @Override
    public Set<String> keySet() {
        return new LinkedHashSet<String>(this.keyLookup.values());
    }

    @Override
    public Set<Map.Entry<String, List<String>>> entrySet() {
        return this.values.entrySet();
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return key == null ? false : this.keyLookup.containsKey(key.toString().toLowerCase(Locale.ENGLISH));
    }

    @Override
    public boolean containsValue(Object value2) {
        return this.values.containsValue(value2);
    }

    public String getFirstValue(String key) {
        Object values2 = this.get(key);
        if (values2 == null) {
            return null;
        }
        if (values2.isEmpty()) {
            return "";
        }
        return (String)values2.get(0);
    }

    public String getJoinedValue(String key, String delimiter) {
        Object values2 = this.get(key);
        if (values2 == null) {
            return null;
        }
        if (values2.size() == 1) {
            return (String)values2.get(0);
        }
        StringBuilder result2 = new StringBuilder();
        Iterator i$ = values2.iterator();
        while (i$.hasNext()) {
            String value2 = (String)i$.next();
            if (result2.length() > 0) {
                result2.append(delimiter);
            }
            result2.append(value2);
        }
        return result2.toString();
    }

    @Override
    public List<String> get(Object key) {
        if (key == null) {
            return null;
        }
        String lcKey = key.toString().toLowerCase(Locale.ENGLISH);
        String realKey = this.keyLookup.get(lcKey);
        if (realKey == null) {
            return null;
        }
        return this.values.get(realKey);
    }

    @Override
    public Collection<List<String>> values() {
        return this.values.values();
    }

    @Override
    public boolean equals(Object obj2) {
        if (this == obj2) {
            return true;
        }
        if (obj2 == null) {
            return false;
        }
        if (this.getClass() != obj2.getClass()) {
            return false;
        }
        FluentCaseInsensitiveStringsMap other = (FluentCaseInsensitiveStringsMap)obj2;
        return !(this.values == null ? other.values != null : !this.values.equals(other.values));
    }

    @Override
    public int hashCode() {
        return this.values == null ? 0 : this.values.hashCode();
    }

    public String toString() {
        StringBuilder result2 = new StringBuilder();
        for (Map.Entry<String, List<String>> entry : this.values.entrySet()) {
            if (result2.length() > 0) {
                result2.append("; ");
            }
            result2.append("\"");
            result2.append(entry.getKey());
            result2.append("=");
            boolean needsComma = false;
            for (String value2 : entry.getValue()) {
                if (needsComma) {
                    result2.append(", ");
                } else {
                    needsComma = true;
                }
                result2.append(value2);
            }
            result2.append("\"");
        }
        return result2.toString();
    }
}

