/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client;

import com.ning.http.util.MiscUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FluentStringsMap
implements Map<String, List<String>>,
Iterable<Map.Entry<String, List<String>>> {
    private final Map<String, List<String>> values = new LinkedHashMap<String, List<String>>();

    public FluentStringsMap() {
    }

    public FluentStringsMap(FluentStringsMap src) {
        if (src != null) {
            for (Map.Entry<String, List<String>> header2 : src) {
                this.add(header2.getKey(), (Collection<String>)header2.getValue());
            }
        }
    }

    public FluentStringsMap(Map<String, Collection<String>> src) {
        if (src != null) {
            for (Map.Entry<String, Collection<String>> header2 : src.entrySet()) {
                this.add(header2.getKey(), header2.getValue());
            }
        }
    }

    public FluentStringsMap add(String key, String value2) {
        if (key != null) {
            List<String> curValues = this.values.get(key);
            if (curValues == null) {
                curValues = new ArrayList<String>(1);
                this.values.put(key, curValues);
            }
            curValues.add(value2);
        }
        return this;
    }

    public FluentStringsMap add(String key, String ... values2) {
        if (MiscUtil.isNonEmpty(values2)) {
            this.add(key, Arrays.asList(values2));
        }
        return this;
    }

    public FluentStringsMap add(String key, Collection<String> values2) {
        if (key != null && MiscUtil.isNonEmpty(values2)) {
            List<String> curValues = this.values.get(key);
            if (curValues == null) {
                this.values.put(key, new ArrayList<String>(values2));
            } else {
                curValues.addAll(values2);
            }
        }
        return this;
    }

    public FluentStringsMap addAll(FluentStringsMap src) {
        if (src != null) {
            for (Map.Entry<String, List<String>> header2 : src) {
                this.add(header2.getKey(), (Collection<String>)header2.getValue());
            }
        }
        return this;
    }

    public FluentStringsMap addAll(Map<String, Collection<String>> src) {
        if (src != null) {
            for (Map.Entry<String, Collection<String>> header2 : src.entrySet()) {
                this.add(header2.getKey(), header2.getValue());
            }
        }
        return this;
    }

    @Override
    public FluentStringsMap replace(String key, String ... values2) {
        return this.replace(key, (Collection<String>)Arrays.asList(values2));
    }

    @Override
    public FluentStringsMap replace(String key, Collection<String> values2) {
        if (key != null) {
            if (values2 == null) {
                this.values.remove(key);
            } else {
                this.values.put(key, new ArrayList<String>(values2));
            }
        }
        return this;
    }

    public FluentStringsMap replaceAll(FluentStringsMap src) {
        if (src != null) {
            for (Map.Entry<String, List<String>> header2 : src) {
                this.replace(header2.getKey(), (Collection<String>)header2.getValue());
            }
        }
        return this;
    }

    public FluentStringsMap replaceAll(Map<? extends String, ? extends Collection<String>> src) {
        if (src != null) {
            for (Map.Entry<? extends String, ? extends Collection<String>> header2 : src.entrySet()) {
                this.replace(header2.getKey(), header2.getValue());
            }
        }
        return this;
    }

    @Override
    public List<String> put(String key, List<String> value2) {
        if (key == null) {
            throw new NullPointerException("Null keys are not allowed");
        }
        Object oldValue = this.get(key);
        this.replace(key, (Collection<String>)value2);
        return oldValue;
    }

    @Override
    public void putAll(Map<? extends String, ? extends List<String>> values2) {
        this.replaceAll(values2);
    }

    public FluentStringsMap delete(String key) {
        this.values.remove(key);
        return this;
    }

    public FluentStringsMap deleteAll(String ... keys2) {
        if (keys2 != null) {
            for (String key : keys2) {
                this.remove(key);
            }
        }
        return this;
    }

    public FluentStringsMap deleteAll(Collection<String> keys2) {
        if (keys2 != null) {
            for (String key : keys2) {
                this.remove(key);
            }
        }
        return this;
    }

    @Override
    public List<String> remove(Object key) {
        if (key == null) {
            return null;
        }
        Object oldValues = this.get(key.toString());
        this.delete(key.toString());
        return oldValues;
    }

    @Override
    public void clear() {
        this.values.clear();
    }

    @Override
    public Iterator<Map.Entry<String, List<String>>> iterator() {
        return Collections.unmodifiableSet(this.values.entrySet()).iterator();
    }

    @Override
    public Set<String> keySet() {
        return Collections.unmodifiableSet(this.values.keySet());
    }

    @Override
    public Set<Map.Entry<String, List<String>>> entrySet() {
        return this.values.entrySet();
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return key == null ? false : this.values.containsKey(key.toString());
    }

    @Override
    public boolean containsValue(Object value2) {
        return this.values.containsValue(value2);
    }

    public String getFirstValue(String key) {
        Object values2 = this.get(key);
        if (values2 == null) {
            return null;
        }
        if (values2.isEmpty()) {
            return "";
        }
        return (String)values2.get(0);
    }

    public String getJoinedValue(String key, String delimiter) {
        Object values2 = this.get(key);
        if (values2 == null) {
            return null;
        }
        if (values2.size() == 1) {
            return (String)values2.get(0);
        }
        StringBuilder result2 = new StringBuilder();
        Iterator i$ = values2.iterator();
        while (i$.hasNext()) {
            String value2 = (String)i$.next();
            if (result2.length() > 0) {
                result2.append(delimiter);
            }
            result2.append(value2);
        }
        return result2.toString();
    }

    @Override
    public List<String> get(Object key) {
        if (key == null) {
            return null;
        }
        return this.values.get(key.toString());
    }

    @Override
    public Collection<List<String>> values() {
        return this.values.values();
    }

    @Override
    public boolean equals(Object obj2) {
        if (this == obj2) {
            return true;
        }
        if (obj2 == null) {
            return false;
        }
        if (this.getClass() != obj2.getClass()) {
            return false;
        }
        FluentStringsMap other = (FluentStringsMap)obj2;
        return !(this.values == null ? other.values != null : !this.values.equals(other.values));
    }

    @Override
    public int hashCode() {
        return this.values == null ? 0 : this.values.hashCode();
    }

    public String toString() {
        StringBuilder result2 = new StringBuilder();
        for (Map.Entry<String, List<String>> entry : this.values.entrySet()) {
            if (result2.length() > 0) {
                result2.append("; ");
            }
            result2.append("\"");
            result2.append(entry.getKey());
            result2.append("=");
            boolean needsComma = false;
            for (String value2 : entry.getValue()) {
                if (needsComma) {
                    result2.append(", ");
                } else {
                    needsComma = true;
                }
                result2.append(value2);
            }
            result2.append("\"");
        }
        return result2.toString();
    }
}

