/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.cookie;

public class Cookie {
    private final String name;
    private final String value;
    private final String rawValue;
    private final String domain;
    private final String path;
    private long expires;
    private final int maxAge;
    private final boolean secure;
    private final boolean httpOnly;

    public static Cookie newValidCookie(String name2, String value2, String domain2, String rawValue, String path2, long expires, int maxAge, boolean secure2, boolean httpOnly) {
        if (name2 == null) {
            throw new NullPointerException("name");
        }
        if ((name2 = name2.trim()).length() == 0) {
            throw new IllegalArgumentException("empty name");
        }
        for (int i = 0; i < name2.length(); ++i) {
            char c = name2.charAt(i);
            if (c > '\u007f') {
                throw new IllegalArgumentException("name contains non-ascii character: " + name2);
            }
            switch (c) {
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case ' ': 
                case ',': 
                case ';': 
                case '=': {
                    throw new IllegalArgumentException("name contains one of the following prohibited characters: =,; \\t\\r\\n\\v\\f: " + name2);
                }
            }
        }
        if (name2.charAt(0) == '$') {
            throw new IllegalArgumentException("name starting with '$' not allowed: " + name2);
        }
        if (value2 == null) {
            throw new NullPointerException("value");
        }
        domain2 = Cookie.validateValue("domain", domain2);
        path2 = Cookie.validateValue("path", path2);
        return new Cookie(name2, value2, rawValue, domain2, path2, expires, maxAge, secure2, httpOnly);
    }

    private static String validateValue(String name2, String value2) {
        if (value2 == null) {
            return null;
        }
        if ((value2 = value2.trim()).length() == 0) {
            return null;
        }
        for (int i = 0; i < value2.length(); ++i) {
            char c = value2.charAt(i);
            switch (c) {
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case ';': {
                    throw new IllegalArgumentException(name2 + " contains one of the following prohibited characters: " + ";\\r\\n\\f\\v (" + value2 + ')');
                }
            }
        }
        return value2;
    }

    public Cookie(String name2, String value2, String rawValue, String domain2, String path2, long expires, int maxAge, boolean secure2, boolean httpOnly) {
        this.name = name2;
        this.value = value2;
        this.rawValue = rawValue;
        this.domain = domain2;
        this.path = path2;
        this.expires = expires;
        this.maxAge = maxAge;
        this.secure = secure2;
        this.httpOnly = httpOnly;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getRawValue() {
        return this.rawValue;
    }

    public String getPath() {
        return this.path;
    }

    public long getExpires() {
        return this.expires;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.name);
        buf.append("=");
        buf.append(this.rawValue);
        if (this.domain != null) {
            buf.append("; domain=");
            buf.append(this.domain);
        }
        if (this.path != null) {
            buf.append("; path=");
            buf.append(this.path);
        }
        if (this.expires >= 0L) {
            buf.append("; expires=");
            buf.append(this.expires);
        }
        if (this.maxAge >= 0) {
            buf.append("; maxAge=");
            buf.append(this.maxAge);
            buf.append("s");
        }
        if (this.secure) {
            buf.append("; secure");
        }
        if (this.httpOnly) {
            buf.append("; HTTPOnly");
        }
        return buf.toString();
    }
}

