/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.cookie;

import com.ning.http.client.cookie.Cookie;
import com.ning.http.client.cookie.KeyValuePairsParser;
import com.ning.http.client.date.CalendarTimeConverter;
import com.ning.http.client.date.TimeConverter;

public class CookieDecoder {
    public static final TimeConverter DEFAULT_TIME_CONVERTER = new CalendarTimeConverter();

    public static Cookie decode(String header2) {
        return CookieDecoder.decode(header2, DEFAULT_TIME_CONVERTER);
    }

    public static Cookie decode(String header2, TimeConverter timeConverter) {
        char c;
        if (timeConverter == null) {
            timeConverter = DEFAULT_TIME_CONVERTER;
        }
        if (header2.length() == 0) {
            return null;
        }
        KeyValuePairsParser pairsParser = new KeyValuePairsParser(timeConverter);
        int headerLen = header2.length();
        int i = 0;
        while (i != headerLen && (c = header2.charAt(i)) != ',') {
            String value2;
            String rawValue;
            int newNameEnd;
            int newNameStart;
            block19: {
                if (c == '\t' || c == '\n' || c == '\u000b' || c == '\f' || c == '\r' || c == ' ' || c == ';') {
                    ++i;
                    continue;
                }
                newNameStart = i;
                newNameEnd = i;
                boolean first = true;
                if (i == headerLen) {
                    rawValue = null;
                    value2 = null;
                } else {
                    do {
                        char curChar;
                        if ((curChar = header2.charAt(i)) == ';') {
                            newNameEnd = i;
                            rawValue = null;
                            value2 = null;
                            first = false;
                            break block19;
                        }
                        if (curChar != '=') continue;
                        newNameEnd = i++;
                        if (i == headerLen) {
                            rawValue = "";
                            value2 = "";
                            first = false;
                            break block19;
                        }
                        int newValueStart = i;
                        char c2 = header2.charAt(i);
                        if (c2 == '\"' || c2 == '\'') {
                            StringBuilder newValueBuf = new StringBuilder(header2.length() - i);
                            int rawValueStart = i;
                            int rawValueEnd = i++;
                            char q = c2;
                            boolean hadBackslash = false;
                            block5: while (true) {
                                if (i == headerLen) {
                                    value2 = newValueBuf.toString();
                                    rawValue = first ? header2.substring(rawValueStart, rawValueEnd) : null;
                                    first = false;
                                    break block19;
                                }
                                if (hadBackslash) {
                                    hadBackslash = false;
                                    c2 = header2.charAt(i++);
                                    rawValueEnd = i;
                                    switch (c2) {
                                        case '\"': 
                                        case '\'': 
                                        case '\\': {
                                            newValueBuf.setCharAt(newValueBuf.length() - 1, c2);
                                            continue block5;
                                        }
                                    }
                                    newValueBuf.append(c2);
                                    continue;
                                }
                                c2 = header2.charAt(i++);
                                rawValueEnd = i;
                                if (c2 == q) {
                                    value2 = newValueBuf.toString();
                                    rawValue = first ? header2.substring(rawValueStart, rawValueEnd) : null;
                                    first = false;
                                    break block19;
                                }
                                newValueBuf.append(c2);
                                if (c2 != '\\') continue;
                                hadBackslash = true;
                            }
                        }
                        int semiPos = header2.indexOf(59, i);
                        if (semiPos > 0) {
                            value2 = rawValue = header2.substring(newValueStart, semiPos);
                            i = semiPos;
                        } else {
                            value2 = rawValue = header2.substring(newValueStart);
                            i = headerLen;
                        }
                        break block19;
                    } while (++i != headerLen);
                    newNameEnd = headerLen;
                    first = false;
                    rawValue = null;
                    value2 = null;
                }
            }
            pairsParser.parseKeyValuePair(header2, newNameStart, newNameEnd, value2, rawValue);
        }
        return pairsParser.cookie();
    }
}

